DROP DATABASE IF EXISTS cndb_sql_db;
CREATE DATABASE IF NOT EXISTS cndb_sql_db;
USE cndb_sql_db;

DROP TABLE IF EXISTS `cndb_ctgnme`;
CREATE TABLE `cndb_ctgnme` (
  `food_category_code` int NOT NULL,
  `category_description` varchar(100) DEFAULT NULL,
  `date_added` date NOT NULL,
  `last_modified` date NOT NULL,
  PRIMARY KEY (`food_category_code`),
  CONSTRAINT `food_category_code_length` CHECK ((`food_category_code` between 0 and 99))
);

DROP TABLE IF EXISTS `cndb_fdes`;
CREATE TABLE `cndb_fdes` (
  `food_category_code` int DEFAULT NULL,
  `descriptor` varchar(255) DEFAULT NULL,
  `descriptor_abbreviated` varchar(60) DEFAULT NULL,
  `cn_code` int NOT NULL,
  `product_code` varchar(15) DEFAULT NULL,
  `gtin` varchar(255) DEFAULT NULL,
  `brand_owner_name` varchar(80) DEFAULT NULL,
  `brand_name` varchar(80) DEFAULT NULL,
  `fns_material_number` varchar(6) DEFAULT NULL,
  `source_code` int DEFAULT NULL,
  `date_added` date DEFAULT NULL,
  `last_modified` date DEFAULT NULL,
  `discontinued_date` date DEFAULT NULL,
  `form_of_food` varchar(100) DEFAULT NULL,
  `fdc_id` int DEFAULT NULL,
  `gpc_product_code` varchar(8) DEFAULT NULL,
  PRIMARY KEY (`cn_code`),
  KEY `food_category_code` (`food_category_code`),
  KEY `gpc_product_code` (`gpc_product_code`),
  CONSTRAINT `cn_code_length2` CHECK ((`cn_code` between 0 and 999999)),
  CONSTRAINT `fdc_id_length` CHECK ((`fdc_id` between 0 and 99999999)),
  CONSTRAINT `food_category_code_length1` CHECK ((`food_category_code` between 0 and 99)),
  CONSTRAINT `source_code_length2` CHECK ((`source_code` between 0 and 9))
);

DROP TABLE IF EXISTS `cndb_gpcnme`;
CREATE TABLE `cndb_gpcnme` (
  `gpc_code` varchar(8) NOT NULL,
  `gpc_description` varchar(100) NOT NULL,
  `date_added` date NOT NULL,
  `last_modified` date NOT NULL,
  PRIMARY KEY (`gpc_code`)
);

DROP TABLE IF EXISTS `cndb_nutdes`;
CREATE TABLE `cndb_nutdes` (
  `nutrient_code` int NOT NULL,
  `nutrient_description` varchar(30) NOT NULL,
  `nutrient_description_abbreviated` varchar(9) NOT NULL,
  `nutrient_unit` varchar(5) NOT NULL,
  `date_added` date NOT NULL,
  `last_modified` date NOT NULL,
  PRIMARY KEY (`nutrient_code`),
  CONSTRAINT `nutrient_code_length` CHECK ((`nutrient_code` between 0 and 99999))
);

DROP TABLE IF EXISTS `cndb_nutval`;
CREATE TABLE `cndb_nutval` (
  `cn_code` int NOT NULL,
  `nutrient_code` int NOT NULL,
  `nutrient_value` decimal(13,3) DEFAULT NULL,
  `per_unit` varchar(5) DEFAULT NULL,
  `value_type_code` int DEFAULT NULL,
  `source_code` int DEFAULT NULL,
  `date_added` date DEFAULT NULL,
  `last_modified` date DEFAULT NULL,
  KEY (`cn_code`),
  KEY `nutrient_code` (`nutrient_code`),
  CONSTRAINT `cn_code_length1` CHECK ((`cn_code` between 0 and 999999)),
  CONSTRAINT `nutrient_code_length1` CHECK ((`nutrient_code` between 0 and 99999)),
  CONSTRAINT `source_code_length1` CHECK ((`source_code` between 0 and 9)),
  CONSTRAINT `value_type_code_length` CHECK ((`value_type_code` between 0 and 999))
);

DROP TABLE IF EXISTS `cndb_wght`;
CREATE TABLE `cndb_wght` (
  `cn_code` int NOT NULL,
  `weights_sequence_number` int NOT NULL,
  `amount` decimal(9,3) DEFAULT NULL,
  `measure_description` varchar(100) DEFAULT NULL,
  `unit_amount` decimal(10,2) DEFAULT NULL,
  `type_of_unit` varchar(2) DEFAULT NULL,
  `source_code` int DEFAULT NULL,
  `date_added` date DEFAULT NULL,
  `last_modified` date DEFAULT NULL,
  KEY (`cn_code`),
  KEY `weights_sequence_number` (`weights_sequence_number`),
  CONSTRAINT `cn_code_length` CHECK ((`cn_code` between 0 and 999999)),
  CONSTRAINT `source_code_length` CHECK ((`source_code` between 0 and 9)),
  CONSTRAINT `weights_sequence_number_length` CHECK ((`weights_sequence_number` between 0 and 99))
);
LOCK TABLES `cndb_ctgnme` WRITE;
/*!40000 ALTER TABLE `cndb_ctgnme` DISABLE KEYS */;
INSERT INTO `cndb_ctgnme` VALUES (1,'Dairy and Egg Products','1997-10-29','2012-04-09');
INSERT INTO `cndb_ctgnme` VALUES (2,'Spices and Herbs','1997-10-29','2012-04-09');
INSERT INTO `cndb_ctgnme` VALUES (3,'Baby Foods','1997-10-29','2012-04-09');
INSERT INTO `cndb_ctgnme` VALUES (4,'Fats and Oils','1997-10-29','2012-04-09');
INSERT INTO `cndb_ctgnme` VALUES (5,'Poultry Products','1997-10-29','2012-04-09');
INSERT INTO `cndb_ctgnme` VALUES (6,'Soups, Sauces, and Gravies','1997-10-29','2012-04-09');
INSERT INTO `cndb_ctgnme` VALUES (7,'Sausages and Luncheon Meats','1997-10-29','2012-04-09');
INSERT INTO `cndb_ctgnme` VALUES (8,'Breakfast Cereals','1997-10-29','2012-04-09');
INSERT INTO `cndb_ctgnme` VALUES (9,'Fruits and Fruit Juices','1997-10-29','2012-04-09');
INSERT INTO `cndb_ctgnme` VALUES (10,'Pork Products','1997-10-29','2012-04-09');
INSERT INTO `cndb_ctgnme` VALUES (11,'Vegetables and Vegetable Products','1997-10-29','2012-04-09');
INSERT INTO `cndb_ctgnme` VALUES (12,'Nut and Seed Products','1997-10-29','2012-04-09');
INSERT INTO `cndb_ctgnme` VALUES (13,'Beef Products','1997-10-29','2012-04-09');
INSERT INTO `cndb_ctgnme` VALUES (14,'Beverages','1997-10-29','2012-04-09');
INSERT INTO `cndb_ctgnme` VALUES (15,'Finfish and Shellfish Products','1997-10-29','2012-04-09');
INSERT INTO `cndb_ctgnme` VALUES (16,'Legumes and Legume Products','1997-10-29','2012-04-09');
INSERT INTO `cndb_ctgnme` VALUES (17,'Lamb, Veal, and Game Products','1997-10-29','2012-04-09');
INSERT INTO `cndb_ctgnme` VALUES (18,'Baked Products','1997-10-29','2012-04-09');
INSERT INTO `cndb_ctgnme` VALUES (19,'Sweets','1997-10-29','2012-04-09');
INSERT INTO `cndb_ctgnme` VALUES (20,'Cereal Grains and Pasta','1997-10-29','2012-04-09');
INSERT INTO `cndb_ctgnme` VALUES (21,'Fast Foods','1997-10-29','2012-04-09');
INSERT INTO `cndb_ctgnme` VALUES (22,'Meals, Entrees, and Side Dishes','1997-10-29','2012-12-26');
INSERT INTO `cndb_ctgnme` VALUES (25,'Snacks','1997-10-29','2012-04-09');
INSERT INTO `cndb_ctgnme` VALUES (35,'American Indian/Alaska Native Foods','1997-10-29','2016-03-22');
INSERT INTO `cndb_ctgnme` VALUES (36,'Restaurant Foods','1997-10-29','2012-04-09');
UNLOCK TABLES;
/*!40000 ALTER TABLE `cndb_ctgnme` ENABLE KEYS */;
LOCK TABLES `cndb_gpcnme` WRITE;
/*!40000 ALTER TABLE `cndb_gpcnme` DISABLE KEYS */;
INSERT INTO `cndb_gpcnme` VALUES ('50101800','Nuts/Seeds - Prepared/Processed','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50101900','Fruit/Nuts/Seeds Combination','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50102000','Fruit - Prepared/Processed','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50102100','Vegetables - Prepared/Processed','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50102200','Fruits/Vegetables/Nuts/Seeds Variety Packs','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50121500','Fish - Unprepared/Unprocessed','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50121700','Shellfish Unprepared/Unprocessed','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50121800','Aquatic Plants Unprepared/Unprocessed','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50121900','Fish - Prepared/Processed','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50122000','Aquatic Invertebrates - Prepared/Processed','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50122100','Shellfish Prepared/Processed','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50122200','Aquatic Plants Prepared/Processed','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50122300','Aquatic Invertebrates - Unprepared/Unprocessed','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50122400','Seafood Variety Packs','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50122500','Aquatic Invertebrates/Fish/Shellfish/Seafood Combination','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50131700','Milk/Milk Substitutes','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50131800','Cheese/Cheese Substitutes','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50131900','Butter/Butter Substitutes','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50132000','Cream/Cream Substitutes','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50132100','Yogurt/Yogurt Substitutes','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50132200','Milk/Butter/Cream/Yogurts/Cheese/Eggs/Substitutes Variety Packs','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50132300','Eggs/Eggs Extracts (Industrial Process)','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50132500','Eggs/Eggs Substitutes','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50132600','Dairy Derivatives/By Products','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50151500','Oils Edible','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50151600','Fats Edible','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50151700','Oils/Fats Edible Variety Packs','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50161500','Sugars/Sugar Substitute Products','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50161800','Confectionery Products','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50161900','Confectionery/Sugar Sweetening Products Variety Packs','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50171500','Herbs/Spices/Extracts','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50171700','Vinegars/Cooking Wines','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50171800','Sauces/Spreads/Dips/Condiments','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50171900','Pickles/Relishes/Chutneys/Olives','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50172000','Seasonings/Preservatives/Extracts Variety Packs','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50172100','Casings for Food Items','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50181700','Baking/Cooking Mixes/Supplies','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50181900','Bread','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50182000','Sweet Bakery Products','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50182100','Biscuits/Cookies','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50182200','Savoury Bakery Products','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50182300','Bread/Bakery Products Variety Packs','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50191500','Prepared Soups','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50192100','Snacks','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50192300','Desserts/Dessert Sauces/Toppings','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50192400','Sweet Spreads','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50192500','Sandwiches/Filled Rolls/Wraps','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50192900','Pasta/Noodles','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50193000','Baby/Infant - Foods/Beverages','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50193100','Vegetable Based Products / Meals','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50193200','Grain Based Products / Meals','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50193300','Dough Based Products / Meals','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50193400','Prepared/Preserved Foods Variety Packs','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50193500','Dairy/Egg Based Products / Meals','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50193800','Ready-Made Combination Meals','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50201700','Coffee/Tea/Substitutes','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50202200','Alcoholic Beverages (Includes De-Alcoholised Variants)','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50202300','Non Alcoholic Beverages - Ready to Drink','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50202400','Non Alcoholic Beverages - Not Ready to Drink','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50202500','Beverages Variety Packs','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50202600','Coffee/Coffee Substitutes','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50202700','Tea and Infusions/Tisanes','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50221000','Grains/Flour','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50221200','Processed Cereal Products','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50221300','Cereal/Grain/Pulse Products Variety Packs','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50230100','Food/Beverage/Tobacco Variety Packs','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50240100','Meat/Poultry/Other Animals - Prepared/Processed','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50240200','Meat/Poultry/Other Animals - Unprepared/Unprocessed','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50240300','Meat/Poultry/Other Animals Sausages - Prepared/Processed','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50250600','Citrus','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50250700','Bananas','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50250800','Pome Fruits','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50250900','Stone Fruit','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50251000','Berries/Small Fruit','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50251100','Pineapples','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50251200','Kiwifruits','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50251300','Annona','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50251400','Avocados','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50251500','Persimmon','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50251600','Passionfruits','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50251700','Papayas','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50251800','Pitayas','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50251900','Miscellaneous Fruit','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50252000','Fruits - Unprepared/Unprocessed (Fresh) Variety Packs','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50260100','Root/Tuber Vegetables','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50260200','Bulb Vegetables','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50260300','Tomatoes','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50260400','Peppers','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50260500','Solanacea/Others','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50260600','Cucumbers','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50260700','Cucurbits - Edible Peel','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50260800','Melons','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50260900','Cucurbits - Inedible Peel','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50261000','Other Vegetables','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50261100','Brassica Vegetables','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50261300','Herbs','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50261400','Beans (With Pods)','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50261500','Peas (With Pods)','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50261600','Stem Vegetables','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50261700','Fungi','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50261800','Vegetables - Unprepared/Unprocessed (Fresh) Variety Packs','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50261900','Micro Vegetables','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50262000','Edible Flowers','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50262100','Tidal Sea Vegetables','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50262200','Chickpeas','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50262300','Succulent','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50262400','Ferns','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50262500','Sapote','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50262600','Sugar Canes','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50262700','Sedges','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50270100','Fruits - Unprepared/Unprocessed (Frozen)','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50290100','Vegetables - Unprepared/Unprocessed (Frozen)','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50310100','Fruits - Unprepared/Unprocessed (Shelf Stable)','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50320100','Vegetables - Unprepared/Unprocessed (Shelf Stable)','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50330100','Nuts/Seeds - Unprepared/Unprocessed (Perishable)','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50340100','Nuts/Seeds - Unprepared/Unprocessed (In Shell)','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50350100','Chicory Leaves','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50350200','Head Lettuce','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50350300','Loose Leaf/Multileaf Salad Greens','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50350400','Single Leaf Salad Greens','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50350500','Spinach (Fresh)','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50350600','Leaf Vegetables - Unprepared/Unprocessed Variety Packs','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50350700','Stem Lettuce','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50360100','Fresh Garnish (Food)','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50370100','Fruits/Vegetables Variety Packs Unprepared/Unprocessed (Fresh)','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50370200','Vegetables/Fruits Variety Pack - Fresh Cut','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50380100','Fruits - Fresh Cut','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50380200','Vegetables - Fresh Cut','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50390100','Meat Substitutes','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50390200','Fish Substitutes','2022-04-01','2022-04-01');
INSERT INTO `cndb_gpcnme` VALUES ('50390300','Seafood Substitutes','2022-04-01','2022-04-01');
UNLOCK TABLES;
/*!40000 ALTER TABLE `cndb_gpcnme` ENABLE KEYS */;
LOCK TABLES `cndb_nutdes` WRITE;
/*!40000 ALTER TABLE `cndb_nutdes` DISABLE KEYS */;
INSERT INTO `cndb_nutdes` VALUES (203,'Protein','Pro','g','1997-10-29','1997-10-29');
INSERT INTO `cndb_nutdes` VALUES (204,'Total Fat','Fat','g','1997-10-29','1997-10-29');
INSERT INTO `cndb_nutdes` VALUES (205,'Carbohydrate','Carb','g','1997-10-29','1997-10-29');
INSERT INTO `cndb_nutdes` VALUES (207,'Ash','Ash','g','1997-10-29','1997-10-29');
INSERT INTO `cndb_nutdes` VALUES (208,'Food Energy','FE','kcal','1997-10-29','1997-10-29');
INSERT INTO `cndb_nutdes` VALUES (255,'Moisture','Mois','g','1997-10-29','1997-10-29');
INSERT INTO `cndb_nutdes` VALUES (269,'Total Sugars','Sug','g','2013-12-17','2013-12-17');
INSERT INTO `cndb_nutdes` VALUES (291,'Total Dietary Fiber','TDF','g','1997-10-29','1997-10-29');
INSERT INTO `cndb_nutdes` VALUES (301,'Calcium','Ca','mg','1997-10-29','1997-10-29');
INSERT INTO `cndb_nutdes` VALUES (303,'Iron','Fe','mg','1997-10-29','1997-10-29');
INSERT INTO `cndb_nutdes` VALUES (306,'Potassium','K','mg','2017-05-02','2017-05-02');
INSERT INTO `cndb_nutdes` VALUES (307,'Sodium','Na','mg','1997-10-29','1997-10-29');
INSERT INTO `cndb_nutdes` VALUES (320,'Vitamin A, RAE','VitA, RAE','mcg','2024-10-24','2024-10-24');
INSERT INTO `cndb_nutdes` VALUES (328,'Vitamin D (D2 + D3)','VitD','mcg','2017-05-02','2017-05-02');
INSERT INTO `cndb_nutdes` VALUES (401,'Vitamin C','VitC','mg','1997-10-29','1997-10-29');
INSERT INTO `cndb_nutdes` VALUES (539,'Added Sugars','SugA','g','2022-04-01','2022-04-01');
INSERT INTO `cndb_nutdes` VALUES (601,'Cholesterol','Chol','mg','1997-10-29','1997-10-29');
INSERT INTO `cndb_nutdes` VALUES (605,'Total Trans','Trans','g','2005-11-24','2005-11-24');
INSERT INTO `cndb_nutdes` VALUES (606,'Saturated Fat','Sfat','g','1997-10-29','1997-10-29');
UNLOCK TABLES;
/*!40000 ALTER TABLE `cndb_nutdes` ENABLE KEYS */;
LOCK TABLES `cndb_wght` WRITE;
/*!40000 ALTER TABLE `cndb_wght` DISABLE KEYS */;
INSERT INTO `cndb_wght` VALUES (1001,1,1,'pat (1" sq, 1/3" high)',5,'g',1,'1998-01-15','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1001,2,1,'TBSP',14.2,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1001,3,1,'cup',227,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1001,4,1,'stick',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1002,1,1,'pat (1" sq, 1/3" high)',3.8,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1002,2,1,'TBSP',9.4,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1002,3,1,'cup',151,'g',1,'1995-06-19','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1002,4,1,'stick',76,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1003,1,1,'tbsp',12.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1003,2,1,'cup',205,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1004,1,1,'oz',28.35,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1004,2,1,'cubic inch',17,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1004,3,1,'cup, crumbled, not packed',135,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1005,1,1,'cup, diced',132,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1005,2,1,'cup, shredded',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1005,3,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1005,4,1,'cubic inch',17,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1005,5,1,'slice (1 oz)',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1006,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1006,2,1,'cup, sliced',144,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1006,3,1,'cup, melted',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1006,4,1,'cubic inch',17,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1006,5,1,'package (4.5 oz)',128,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1007,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1007,2,1,'cup',246,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1007,3,1,'cubic inch',17,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1007,4,1,'wedge (1.33 oz)',38,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1008,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1009,1,1,'cup, diced',132,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1009,2,1,'cup, melted',244,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1009,3,1,'cup, shredded',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1009,4,1,'oz',28.35,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1009,5,1,'cubic inch',17,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1009,6,1,'slice (1 oz)',28,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1010,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1011,1,1,'cup, diced',132,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1011,2,1,'cup, shredded',113,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1011,3,1,'oz',28.35,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1011,4,1,'cubic inch',17,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1011,5,1,'slice (1 oz)',28,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1012,1,4,'oz',113,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1012,2,1,'cup, large curd (not packed)',210,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1012,3,1,'cup, small curd (not packed)',225,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1013,1,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1013,2,1,'cup (not packed)',226,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1014,1,1,'cup (not packed)',145,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1014,2,4,'oz',113,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1015,1,4,'oz',113,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1015,2,1,'cup (not packed)',226,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1016,1,4,'oz',113,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1016,2,1,'cup (not packed)',226,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1017,1,1,'tbsp',14.5,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1017,2,1,'cup',232,'g',1,'1995-06-19','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1017,3,1,'tbsp, whipped',10,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1017,4,1,'oz',28.35,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1017,5,1,'cubic inch',16,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1017,6,1,'package, small (3 oz)',85,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1018,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1018,2,1,'package (7 oz)',198,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1019,1,1,'cup, crumbled',150,'g',1,'2001-07-04','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1019,2,1,'oz',28.35,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1019,3,1,'cubic inch',17,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1019,4,1,'wedge (1.33 oz)',38,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1020,1,1,'cup, diced',132,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1020,2,1,'cup, shredded',108,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1020,3,1,'oz',28.35,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1020,4,1,'cubic inch',15,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1020,5,1,'slice (1 oz)',28,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1020,6,1,'package (8 oz)',227,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1021,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1021,2,1,'package (8 oz)',227,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1022,1,1,'oz',28.35,'g',1,'2001-07-04','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1022,2,1,'package (7 oz)',198,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1023,1,1,'oz',28.35,'g',1,'1997-08-29','2015-01-07');
INSERT INTO `cndb_wght` VALUES (1023,2,1,'slice (1 oz)',28,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (1023,3,1,'cubic inch',15,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (1023,4,1,'cup, diced',132,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (1023,5,1,'cup, shredded',108,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (1023,6,1,'package (6 oz)',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1024,1,1,'cup',134,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1024,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1024,3,1,'cubic inch',18,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1024,4,1,'box',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1024,5,1,'package (8 oz)',227,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1025,1,1,'cup, diced',132,'g',1,'1995-06-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1025,2,1,'cup, shredded',113,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1025,3,1,'oz',28.35,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1025,4,1,'cubic inch',17,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1025,5,1,'slice (1 oz)',28,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1025,6,1,'package (6 oz)',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1026,1,1,'cup, shredded',112,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1026,2,1,'oz',28.35,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1026,3,6,'slices',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1027,1,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1027,2,1,'cubic inch',18,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1028,1,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1029,1,1,'cup, diced',132,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1029,2,1,'cup, shredded',113,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1029,3,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1029,4,1,'cubic inch',18,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1029,5,1,'slice (1 oz)',28,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1030,1,1,'cup, diced',132,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1030,2,1,'cup, shredded',113,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1030,3,1,'oz',28.35,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1030,4,1,'cubic inch',18,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1030,5,1,'slice (1 oz)',28,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1030,6,1,'package (6 oz)',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1031,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1031,2,1,'package (3 oz)',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1032,1,1,'cup',100,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (1032,2,1,'TBSP',5,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1032,3,1,'oz',28.35,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1033,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1033,2,1,'cubic inch',10.3,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1033,3,5,'package (5 oz)',142,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1034,1,1,'cup, diced',132,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1034,2,1,'cup, shredded',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1034,3,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1034,4,1,'cubic inch',17,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1034,5,1,'slice (1 oz)',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1034,6,1,'package (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1035,1,1,'cup, diced',132,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1035,2,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1035,3,1,'cubic inch',17,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1035,4,1,'slice (1 oz)',28,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1035,5,1,'package (6 oz)',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1036,1,0.5,'cup',124,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1036,2,1,'cup',246,'g',1,'2007-11-27','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1037,1,0.5,'cup',124,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1037,2,1,'oz',28.35,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (1037,3,1,'cup',246,'g',1,'2007-11-28','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1038,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1038,2,5,'package (5 oz)',142,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1039,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1039,2,1,'package (3 oz)',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1040,1,1,'cup, diced',132,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1040,2,1,'cup, melted',244,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1040,3,1,'cup, shredded',108,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1040,4,1,'oz',28.35,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1040,5,1,'cubic inch',15,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1040,6,1,'slice (1 oz)',28,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1041,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1041,2,1,'package (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1042,1,1,'oz',28.35,'g',1,'1995-06-19','2015-01-07');
INSERT INTO `cndb_wght` VALUES (1042,2,1,'slice (1 oz)',28,'g',1,'1998-01-15','2015-01-07');
INSERT INTO `cndb_wght` VALUES (1042,3,1,'slice (3/4 oz)',21,'g',1,'1999-03-22','2015-01-07');
INSERT INTO `cndb_wght` VALUES (1042,4,1,'cubic inch',18,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (1042,5,1,'cup, shredded',113,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (1042,6,1,'cup, diced',140,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (1042,7,1,'cup, melted',244,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (1043,1,1,'cup, diced',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1043,2,1,'cup, melted',244,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1043,3,1,'cup, shredded',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1043,4,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1043,5,1,'cubic inch',18,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1043,6,1,'slice (3/4 oz)',21,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1044,1,1,'cup, diced',140,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1044,2,1,'cup, shredded',113,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1044,3,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1044,4,1,'cubic inch',18,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1044,5,1,'slice (3/4 oz)',21,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1045,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1045,2,1,'package (8 oz)',227,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1046,1,1,'CUP',113,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1046,2,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1046,3,1,'slice (3/4 oz)',21,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1046,4,1,'package (8 oz)',227,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1047,1,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1047,2,1,'package (8 oz)',227,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1048,1,1,'cup, diced',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1048,2,1,'cup',244,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1048,3,1,'jar (5 oz)',128,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1048,4,1,'cubic inch',18,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1048,5,1,'jar (5 oz)',142,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1048,6,1,'slice',34,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1048,7,1,'slice, thin',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1049,1,1,'fl oz',30.2,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1049,2,1,'TBSP',15,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1049,3,1,'cup',242,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1049,4,1,'container, individual (.5 fl oz)',15,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1050,1,1,'fl oz',30,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1050,2,1,'TBSP',15,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1050,3,1,'cup',240,'g',1,'1994-11-02','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1050,4,1,'container, individual',11.1,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1052,1,1,'cup, whipped',120,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1052,2,1,'cup, fluid (yields 2 cups whipped)',239,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1052,3,1,'TBSP',15,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1053,1,1,'cup, whipped',120,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1053,2,1,'cup, fluid (yields 2 cups whipped)',238,'g',1,'1995-06-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1053,3,1,'TBSP',15,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1053,4,1,'FL OZ',29.8,'g',1,'2002-09-06','2010-01-05');
INSERT INTO `cndb_wght` VALUES (1054,1,1,'CUP',60,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1054,2,1,'TBSP',3,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1055,1,1,'tbsp',15,'g',1,'1994-11-02','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1055,2,1,'cup',242,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1056,1,1,'tbsp',12,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1056,2,1,'cup',230,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1057,1,1,'CUP',254,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1057,2,1,'FL OZ',31.8,'g',1,'1994-01-31','2010-01-05');
INSERT INTO `cndb_wght` VALUES (1057,3,1,'quart',1016,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1058,1,1,'tbsp',12,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1058,2,1,'cup',235,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1059,1,1,'cup',244,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1059,2,1,'quart',976,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1060,1,1,'cup',244,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1060,2,1,'fl oz',30.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1060,3,1,'quart',976,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1061,1,1,'serving',19,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1067,1,1,'container, individual',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1067,2,1,'fl oz',30,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1067,3,1,'cup',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1067,4,0.5,'cup',120,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1068,1,1,'container, individual',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1068,2,0.5,'cup',120,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1069,1,1,'cup',94,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1069,2,1,'tsp',2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1069,3,1,'packet',3,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1070,1,1.5,'oz',43,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1070,2,1,'portion, amount to make 1 tbsp',1.3,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1071,1,1,'CUP',80,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1071,2,1,'TBSP',4,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1071,3,1,'package yields',160,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1072,1,1,'CUP',70,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1072,2,1,'TBSP',4,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1073,1,1,'CUP',75,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1073,2,1,'TBSP',4,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1074,1,1,'oz',28.35,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1074,2,1,'cup',230,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1076,1,1,'cup',244,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1076,2,1,'quart',976,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1077,1,1,'CUP',244,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1077,2,1,'fl oz',30.5,'g',1,'1998-01-15','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1077,3,1,'tbsp',15,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1077,4,1,'quart',976,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1078,1,1,'CUP',244,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1078,2,1,'quart',976,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1079,1,1,'CUP',244,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1079,2,1,'FL OZ',30.5,'g',1,'1998-01-15','2010-01-05');
INSERT INTO `cndb_wght` VALUES (1079,3,1,'quart',976,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1080,1,1,'cup',245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1080,2,1,'quart',980,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1081,1,1,'cup',246,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1081,2,1,'quart',984,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1082,1,1,'CUP',244,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1082,2,1,'FL OZ',30.5,'g',1,'1998-01-15','2010-01-05');
INSERT INTO `cndb_wght` VALUES (1082,3,1,'quart',976,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1083,1,1,'cup',245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1083,2,1,'quart',980,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1084,1,1,'CUP',246,'g',1,'2001-07-04','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1084,2,1,'quart',984,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1085,1,1,'CUP',245,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1085,2,1,'FL OZ',30.6,'g',1,'1998-01-15','2010-01-05');
INSERT INTO `cndb_wght` VALUES (1085,3,1,'quart',980,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1086,1,1,'cup',245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1086,2,1,'fl oz',30.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1086,3,1,'quart',980,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1087,1,1,'CUP',246,'g',1,'2001-07-04','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1087,2,1,'quart',984,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1088,1,1,'CUP',245,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1088,2,1,'FL OZ',30.6,'g',1,'1998-01-15','2010-01-05');
INSERT INTO `cndb_wght` VALUES (1088,3,1,'quart',980,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1089,1,1,'cup',244,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1089,2,1,'fl oz',30.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1089,3,1,'quart',976,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1090,1,0.25,'CUP',32,'g',1,'1994-01-31','2015-01-07');
INSERT INTO `cndb_wght` VALUES (1090,2,1,'CUP',128,'g',1,'2007-11-28','2015-01-07');
INSERT INTO `cndb_wght` VALUES (1091,1,0.25,'CUP',30,'g',1,'1994-01-31','2015-01-07');
INSERT INTO `cndb_wght` VALUES (1091,2,1,'CUP',120,'g',1,'2007-11-28','2015-01-07');
INSERT INTO `cndb_wght` VALUES (1091,3,5,'tbsp',23,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (1092,1,1,'CUP',68,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1092,2,1,'envelope (1-1/3 cup)',91,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1092,3,0.333,'cup (makes 1 cup reconstituted milk)',23,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1093,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1093,2,0.25,'lb',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1094,1,0.25,'cup',30,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (1094,2,1,'cup',120,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (1094,3,1,'tbsp',6.5,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (1095,1,1,'fl oz',38.2,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1095,2,1,'cup',306,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1096,1,1,'fl oz',31.5,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1096,2,1,'cup',252,'g',1,'2007-11-28','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1096,3,1,'can (13 oz)',369,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (1096,4,0.5,'CUP',126,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (1097,1,1,'fl oz',31.9,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1097,2,1,'cup',256,'g',1,'2007-11-28','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1097,3,0.5,'CUP',128,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (1102,1,1,'CUP',250,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1102,2,1,'FL OZ',31.2,'g',1,'1994-01-31','2010-01-05');
INSERT INTO `cndb_wght` VALUES (1102,3,1,'quart',1000,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1103,1,1,'CUP',250,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1103,2,1,'FL OZ',31.2,'g',1,'1994-01-31','2010-01-05');
INSERT INTO `cndb_wght` VALUES (1103,3,1,'quart',1000,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1104,1,1,'CUP',250,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1104,2,1,'quart',1000,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1105,1,1,'CUP',250,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1105,2,1,'FL OZ',31.2,'g',1,'2002-09-06','2010-01-05');
INSERT INTO `cndb_wght` VALUES (1106,1,1,'fl oz',30.5,'g',1,'1998-01-15','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1106,2,1,'cup',244,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1106,3,1,'quart',976,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1108,1,1,'cup',244,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1108,2,1,'quart',976,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1109,1,1,'cup',245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1109,2,1,'quart',980,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1110,1,1,'FL OZ',28.4,'g',1,'1999-03-22','2010-01-05');
INSERT INTO `cndb_wght` VALUES (1110,2,1,'container (10.6 oz)',300,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1111,1,1,'FL OZ',28.4,'g',1,'1999-03-22','2010-01-05');
INSERT INTO `cndb_wght` VALUES (1111,2,1,'container (11 oz)',313,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1112,1,1,'cup',246,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1112,2,1,'quart',984,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1113,1,1,'cup',57,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1113,2,1,'tbsp',2.9,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1114,1,1,'cup',246,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1114,2,1,'quart',984,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1115,1,1,'cup',145,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1115,2,1,'tbsp',7.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1116,1,1,'container (6 oz)',170,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1116,2,1,'container (8 oz)',227,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1116,3,0.5,'container (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1116,4,1,'cup (8 fl oz)',245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1117,1,1,'container (6 oz)',170,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1117,2,1,'container (8 oz)',227,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1117,3,0.5,'container (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1117,4,1,'cup (8 fl oz)',245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1118,1,1,'container (6 oz)',170,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1118,2,1,'container (8 oz)',227,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1118,3,1,'cup (8 fl oz)',245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1119,1,1,'container (6 oz)',170,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1119,2,1,'container (8 oz)',227,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1119,3,1,'cup (8 fl oz)',245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1120,1,1,'container (6 oz)',170,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1120,2,1,'container (4.4 oz)',125,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1120,3,1,'container (5 oz)',142,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1120,4,1,'cup (8 fl oz)',245,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1120,5,1,'container (8 oz)',227,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1120,6,0.5,'container (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1121,1,1,'container (6 oz)',170,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1121,2,1,'cup (8 fl oz)',245,'g',1,'1998-01-15','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1121,3,1,'container (8 oz)',227,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1121,5,1,'container, Dannon Sprinkl''ins (4.1 oz)',116,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1121,6,0.5,'container (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1122,1,1,'container (6 oz)',170,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1122,2,0.5,'container (4 oz)',113,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1122,3,1,'container (8 oz)',227,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1123,1,1,'large',50,'g',1,'2007-11-27','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1123,2,1,'extra large',56,'g',1,'2007-11-27','2007-11-27');
INSERT INTO `cndb_wght` VALUES (1123,3,1,'jumbo',63,'g',1,'2007-11-27','2007-11-27');
INSERT INTO `cndb_wght` VALUES (1123,5,1,'cup (4.86 large eggs)',243,'g',1,'2007-11-27','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1123,6,1,'medium',44,'g',1,'2007-11-27','2007-11-27');
INSERT INTO `cndb_wght` VALUES (1123,7,1,'small',38,'g',1,'2007-11-27','2007-11-27');
INSERT INTO `cndb_wght` VALUES (1124,1,1,'large',33,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1124,2,1,'cup',243,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1125,1,1,'large',17,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1125,2,1,'cup',243,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1126,1,1,'oz',28.35,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1126,2,0.5,'lb',227,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1127,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1127,2,0.5,'lb',227,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1128,1,1,'large',46,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1129,1,1,'cup, chopped',136,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1129,2,1,'TBSP',8.5,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1129,3,1,'large',50,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1130,1,1,'TBSP',15,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1130,2,1,'large',61,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1131,1,1,'large',50,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1132,1,1,'large',61,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1132,2,1,'TBSP',13.7,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1132,3,1,'cup',220,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1133,1,1,'cup, sifted',85,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1133,2,1,'TBSP',5,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1134,1,1,'cup, sifted',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1134,2,1,'tbsp',5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1135,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1135,2,0.5,'lb',227,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1136,1,1,'cup, sifted',107,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1136,2,1,'tbsp',7,'g',1,'1997-08-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (1137,1,1,'cup, sifted',67,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1137,2,1,'TBSP',4,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1138,1,1,'egg',70,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1139,1,1,'egg',144,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1140,1,1,'egg',9,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1141,1,1,'egg',79,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1144,1,0.35,'oz',9.9,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1144,2,0.7,'oz',20,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (1145,1,1,'pat (1" sq, 1/3" high)',5,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1145,2,1,'TBSP',14.2,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1145,3,1,'cup',227,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1145,4,1,'stick',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1146,1,1,'TBSP',5,'g',1,'1994-11-17','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1151,1,1,'CUP',245,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1151,2,1,'quart',980,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1152,1,1,'cup',245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1152,2,1,'quart',980,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1153,1,1,'FL OZ',31.5,'g',1,'1994-01-31','2010-01-05');
INSERT INTO `cndb_wght` VALUES (1153,2,0.5,'CUP',126,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1154,1,0.25,'CUP',30,'g',1,'1994-01-31','2015-01-07');
INSERT INTO `cndb_wght` VALUES (1154,2,1,'CUP',120,'g',1,'2007-11-28','2015-01-07');
INSERT INTO `cndb_wght` VALUES (1155,1,1,'CUP',68,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1155,2,1,'envelope (1-1/3 cup)',91,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1156,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1157,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1159,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1160,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1160,2,0.5,'lb',227,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1161,1,1,'cup, shredded',113,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (1161,2,1,'oz',28.35,'g',1,'1995-06-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1161,3,1,'cubic inch',18,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (1161,4,1,'slice',28,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (1161,5,3,'oz',85,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (1164,1,2,'tbsp',30,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1164,2,1,'cup',243,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1165,1,1,'cup, crumbled',132,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1165,2,1,'oz',28.35,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1166,1,1,'cup, diced',132,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1166,2,1,'cup, shredded',113,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1166,3,1,'oz',28.35,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1166,4,1,'cubic inch',18,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1166,5,1,'slice (1 oz)',28,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1167,1,1,'cup, diced',132,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1167,2,1,'cup, shredded',113,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1167,3,1,'oz',28.35,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1167,4,1,'cubic inch',17,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1167,5,1,'slice (1 oz)',28,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1168,1,1,'cup, diced',132,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1168,2,1,'cup, shredded',113,'g',1,'1995-05-23','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1168,3,1,'oz',28.35,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1168,4,1,'cubic inch',17,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1168,5,1,'slice (1 oz)',28,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1169,1,1,'cup, diced',132,'g',1,'2001-07-04','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1169,2,1,'cup, shredded',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1169,3,1,'oz',28.35,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1169,4,1,'cubic inch',17,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1169,5,1,'slice (1 oz)',28,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1171,1,1,'oz',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1172,1,1,'oz',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1173,1,1,'oz',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1174,1,1,'cup',246,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1174,2,1,'quart',984,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1175,1,1,'cup',244,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1175,2,1,'quart',976,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1178,1,1,'tablespoon',12,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1178,2,1,'cup',230,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1179,1,1,'tablespoon',12,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1179,2,1,'cup',230,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1180,1,1,'tablespoon',12,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1180,2,1,'cup',230,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1184,1,1,'container (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1185,1,1,'tablespoon',5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1186,1,1,'tbsp',18,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1187,1,1,'container (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1199,1,2,'tbsp',29,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1199,2,1,'pint',484,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1202,1,1,'CUP',250,'g',1,'2006-02-23','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1202,2,1,'FL OZ',31.2,'g',1,'2006-02-23','2010-01-05');
INSERT INTO `cndb_wght` VALUES (1202,3,1,'quart',1000,'g',1,'2006-02-23','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1203,1,1,'container (6 oz)',170,'g',1,'2006-02-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (1203,2,1,'cup (8 fl oz)',245,'g',1,'2006-02-23','2006-11-30');
INSERT INTO `cndb_wght` VALUES (1203,3,1,'container (8 oz)',227,'g',1,'2006-02-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (1204,1,1,'cup',100,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (1204,2,1,'tbsp',5,'g',1,'2007-12-03','2007-12-03');
INSERT INTO `cndb_wght` VALUES (1204,3,1,'oz',28.35,'g',1,'2007-12-03','2007-12-03');
INSERT INTO `cndb_wght` VALUES (1205,1,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1206,1,4,'tsp',12,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1208,1,1,'cup, diced',132,'g',1,'2007-12-03','2007-12-03');
INSERT INTO `cndb_wght` VALUES (1208,2,1,'oz',28.35,'g',1,'2007-12-03','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1208,3,1,'cup, shredded',113,'g',1,'2007-12-03','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1208,4,1,'cubic inch',14.3,'g',1,'2007-12-03','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1208,5,1,'slice (1 oz)',28,'g',1,'2007-12-03','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1208,6,1,'package (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1209,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1209,2,0.25,'cup',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1211,1,1,'cup',244,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (1211,2,1,'tbsp',15,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (1211,3,1,'fl oz',30.5,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (1211,4,1,'quart',976,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (1212,1,1,'cup',128,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (1212,2,0.25,'cup',32,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (1215,1,1,'slice 3/4 oz',21,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1215,2,1,'slice 2/3 oz',19,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1216,1,1,'container (6 oz)',170,'g',1,'2010-01-04','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1216,2,1,'container (4.4 oz)',125,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (1216,3,1,'container (5 oz)',142,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (1216,4,1,'cup (8 fl oz)',245,'g',1,'2010-01-04','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1216,5,1,'container (8 oz)',227,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (1216,6,0.5,'container (4 oz)',113,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (1217,1,1,'container (6 oz)',170,'g',1,'2010-01-04','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1217,2,1,'cup (8 fl oz)',245,'g',1,'2010-01-04','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1217,3,1,'container (8 oz)',227,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (1217,5,1,'container, Dannon Sprinkl''ins (4.1 oz)',116,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (1217,6,0.5,'container (4 oz)',113,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (1218,1,1,'container (6 oz)',170,'g',1,'2010-01-04','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1218,2,1,'container (4.4 oz)',125,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (1218,3,1,'cup (8 fl oz)',245,'g',1,'2010-01-04','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1218,4,1,'container (8 oz)',227,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (1219,1,1,'container (6 oz)',170,'g',1,'2010-01-04','2016-02-06');
INSERT INTO `cndb_wght` VALUES (1219,2,1,'cup (8 fl oz)',245,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (1219,3,1,'container (8 oz)',227,'g',1,'2010-01-04','2016-02-06');
INSERT INTO `cndb_wght` VALUES (1220,1,1,'container (6 oz)',170,'g',1,'2010-01-04','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1220,2,1,'container (8 oz)',227,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (1220,3,0.5,'container (4 oz)',113,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (1220,4,1,'cup (8 fl oz)',245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1221,1,1,'container (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1222,1,1,'container (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1225,1,1,'tbsp',19,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1226,1,0.25,'cup',60,'g',1,'2010-01-04','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1226,2,1,'cup',240,'g',1,'2010-01-04','2013-12-26');
INSERT INTO `cndb_wght` VALUES (1227,1,1,'cup grated',97,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1228,1,1,'cup, crumbled',122,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (1229,1,1,'cup, crumbled',118,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (1230,1,1,'cup',245,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (1231,1,1,'container',170,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (1235,1,0.5,'cup',68,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (1236,1,0.5,'cup',86,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (1237,1,1,'bar',50,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (1238,1,1,'serving',70,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1239,1,1,'serving',82,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (1240,1,1,'unit',96,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (1241,1,1,'serving',70,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (1242,1,1,'serving',70,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (1243,1,0.5,'cup',68,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (1244,1,1,'bar',68,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (1250,1,1,'can',227,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (1251,1,0.25,'cup shredded',28,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (1252,1,1,'slice (2/3 oz)',19,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (1252,2,1,'slice (3/4 oz)',21,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (1253,1,1,'oz',28.35,'g',1,'2012-03-02','2015-01-07');
INSERT INTO `cndb_wght` VALUES (1253,2,1,'slice (3/4 oz)',21,'g',1,'2012-03-02','2015-01-07');
INSERT INTO `cndb_wght` VALUES (1253,3,1,'slice (1 oz)',28,'g',1,'2012-03-02','2015-01-07');
INSERT INTO `cndb_wght` VALUES (1253,4,1,'cubic inch',18,'g',1,'2012-03-02','2015-01-07');
INSERT INTO `cndb_wght` VALUES (1253,5,1,'cup, diced',140,'g',1,'2012-03-02','2015-01-07');
INSERT INTO `cndb_wght` VALUES (1253,6,1,'cup, shredded',113,'g',1,'2012-03-02','2015-01-07');
INSERT INTO `cndb_wght` VALUES (1253,7,1,'cup, melted',244,'g',1,'2012-03-02','2015-01-07');
INSERT INTO `cndb_wght` VALUES (1254,1,1,'cup',113,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (1254,2,1,'oz',28.35,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (1254,3,1,'slice (3/4 oz)',21,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (1254,4,1,'package (8 oz)',227,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (1255,1,1,'oz',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1256,1,1,'container',170,'g',1,'2013-02-22','2013-02-22');
INSERT INTO `cndb_wght` VALUES (1258,1,1,'cup, sifted',107,'g',1,'2013-02-22','2013-02-22');
INSERT INTO `cndb_wght` VALUES (1258,2,1,'tbsp',7,'g',1,'2013-02-22','2013-02-22');
INSERT INTO `cndb_wght` VALUES (1259,1,1,'piece',21,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1259,2,1,'package',566,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1260,1,1,'slice',21,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1263,1,1,'medium',298,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1264,1,26,'pieces',95,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1265,1,1,'serving',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1266,1,1,'serving',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1267,1,2,'tsp',5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (1270,1,1,'slice (2/3 oz)',19,'g',1,'2015-01-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (1270,2,1,'slice (3/4 oz)',21,'g',1,'2015-01-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (1270,3,1,'slice (1 oz)',28,'g',1,'2015-01-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (1271,1,1,'cup',86,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (1284,1,1,'container (5.3 oz)',150,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (1284,2,1,'cup (8 fl oz)',245,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (1284,3,1,'container (6 oz)',170,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (1284,4,1,'container (8 oz)',227,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (1284,5,1,'container, Dannon Sprinkl''ins (4.1 oz)',116,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (1284,6,0,'container (4 oz)',113,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (1285,1,1,'container (5.3 oz)',150,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (1286,1,1,'container (5.3 oz)',150,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (1287,1,1,'container (7 oz)',200,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (1291,1,1,'cup',252,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (1291,2,1,'fl oz',31.5,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (1291,3,1,'can (13 oz)',369,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (1291,4,0.5,'cup',126,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (1292,1,1,'cup',250,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (1292,2,1,'fl oz',31.2,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (1292,3,1,'quart',1000,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (1295,1,1,'cup (8 fl oz)',245,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (1295,2,1,'container (8 oz)',227,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (1295,3,0.5,'container (4 oz)',113,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (2001,1,1,'tsp',1.9,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2001,2,1,'tbsp',6,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2002,1,1,'tsp, whole',2.1,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2002,2,1,'tbsp, whole',6.7,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2003,1,1,'tsp, leaves',0.7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (2003,2,1,'tbsp, leaves',2.1,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (2003,3,1,'tsp, ground',1.4,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (2003,4,1,'tbsp, ground',4.5,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (2004,1,1,'tsp, crumbled',0.6,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2004,2,1,'tbsp, crumbled',1.8,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2005,1,1,'tsp',2.1,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2005,2,1,'tbsp',6.7,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2006,1,1,'tsp, ground',2,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2006,2,1,'tbsp, ground',5.8,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2007,1,1,'tsp',2,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2007,2,1,'tbsp',6.5,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2008,1,1,'tsp',0.6,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2008,2,1,'tbsp',1.9,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2009,1,1,'tsp',2.7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (2009,2,1,'tbsp',8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (2010,1,1,'tsp',2.6,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2010,2,1,'tbsp',7.8,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2011,1,1,'tsp',2.1,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2011,2,1,'tbsp',6.5,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2012,1,1,'tsp',0.6,'g',1,'1994-11-02','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2012,2,1,'tbsp',1.8,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2013,1,1,'tsp',1.8,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2013,2,1,'tbsp',5,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2014,1,1,'tsp, whole',2.1,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2014,2,1,'tbsp, whole',6,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2015,1,1,'tsp',2,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2015,2,1,'tbsp',6.3,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2016,1,1,'tsp',2.1,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2016,2,1,'tbsp',6.6,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2017,1,1,'tsp',1,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2017,2,1,'tbsp',3.1,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2018,1,1,'tsp, whole',2,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2018,2,1,'tbsp, whole',5.8,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2019,1,1,'tsp',3.7,'g',1,'1994-11-17','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2019,2,1,'tbsp',11.1,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2020,1,1,'tsp',3.1,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (2020,2,1,'tbsp',9.7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (2021,1,1,'tsp',1.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (2021,2,1,'tbsp',5.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (2022,1,1,'tsp',1.7,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2022,2,1,'tbsp',5.3,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2023,1,1,'tsp',0.6,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2023,2,1,'tbsp',1.7,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2024,1,1,'tsp',2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (2024,2,1,'tbsp',6.3,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (2025,1,1,'tsp',2.2,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2025,2,1,'tbsp',7,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2026,1,1,'tsp',2.4,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2026,2,1,'tbsp',6.9,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2027,1,1,'tsp, leaves',1,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (2027,2,1,'tsp, ground',1.8,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (2028,1,1,'tsp',2.3,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (2028,2,1,'tbsp',6.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (2029,1,1,'tsp',0.5,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (2029,2,1,'TBSP',1.6,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (2030,1,1,'tsp, ground',2.3,'g',1,'2012-04-04','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2030,2,1,'tbsp, ground',6.9,'g',1,'2012-04-04','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2030,3,1,'tsp, whole',2.9,'g',1,'2002-09-06','2012-04-04');
INSERT INTO `cndb_wght` VALUES (2030,4,1,'dash',0.1,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (2031,1,1,'tsp',1.8,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2031,2,1,'tbsp',5.3,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2032,1,1,'tsp, ground',2.4,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2032,2,1,'tbsp, ground',7.1,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2033,1,1,'tsp',2.8,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2033,2,1,'tbsp',8.8,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2034,1,1,'tsp',1.5,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2034,2,1,'tbsp',4.4,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2035,1,1,'tsp',1.7,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2035,2,1,'tbsp',5.6,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2036,1,1,'tsp',1.2,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2036,2,1,'tbsp',3.3,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2037,1,1,'tsp',0.7,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2037,2,1,'tbsp',2.1,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2038,1,1,'tsp',0.7,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2038,2,1,'tbsp',2,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2039,1,1,'tsp',1.4,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2039,2,1,'tbsp',4.4,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2041,1,1,'tsp, leaves',0.6,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (2041,2,1,'tbsp, leaves',1.8,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (2041,3,1,'tsp, ground',1.6,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (2041,4,1,'tbsp, ground',4.8,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (2042,1,1,'tsp, leaves',1,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (2042,2,1,'tbsp, leaves',2.7,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (2042,3,1,'tsp, ground',1.4,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (2042,4,1,'tbsp, ground',4.3,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (2043,1,1,'tsp',3,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2043,2,1,'tbsp',9.4,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2044,1,5,'leaves',2.5,'g',1,'1994-11-17','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2044,2,2,'tbsp, chopped',5.3,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2044,3,0.25,'cup leaves, whole',6,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (2045,1,5,'sprigs',1,'g',1,'1994-11-17','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2045,2,1,'cup sprigs',8.9,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2046,1,1,'tsp or 1 packet',5,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (2046,2,1,'CUP',249,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (2047,1,1,'tsp',6,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2047,2,1,'TBSP',18,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (2047,3,1,'cup',292,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2047,4,1,'dash',0.4,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (2048,1,1,'tbsp',14.9,'g',1,'1994-11-02','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2048,2,1,'cup',239,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2048,3,1,'tsp',5,'g',1,'2005-12-28','2006-11-30');
INSERT INTO `cndb_wght` VALUES (2049,1,1,'tsp',0.8,'g',1,'2001-07-04','2006-11-30');
INSERT INTO `cndb_wght` VALUES (2049,2,0.5,'tsp',0.4,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (2050,1,1,'tsp',4.2,'g',1,'1994-11-17','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2050,2,1,'TBSP',13,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (2050,3,1,'cup',208,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2052,1,1,'tsp',4.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (2052,2,1,'tbsp',13,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (2053,1,1,'tbsp',14.9,'g',1,'2007-11-28','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2053,2,1,'cup',238,'g',1,'2007-11-28','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2053,3,1,'tsp',5,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (2054,1,1,'tbsp, drained',8.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (2055,1,1,'tsp',5,'g',1,'1994-11-02','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2055,2,1,'tbsp',15,'g',1,'1999-02-12','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2063,1,1,'tsp',0.7,'g',1,'2001-07-04','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2063,2,1,'tbsp',1.7,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2064,1,2,'leaves',0.1,'g',1,'2005-12-28','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2064,2,2,'tbsp',3.2,'g',1,'2005-12-28','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2065,1,2,'leaves',0.3,'g',1,'2005-12-28','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2065,2,2,'tbsp',11.4,'g',1,'2011-01-18','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2066,1,1,'tsp',0.5,'g',1,'2005-12-28','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2066,2,1,'tbsp',1.6,'g',1,'2005-12-28','2013-12-26');
INSERT INTO `cndb_wght` VALUES (2068,1,1,'tbsp',14.9,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (2068,2,1,'cup',239,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (2068,3,1,'tsp',5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (2069,1,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (2069,2,1,'cup',255,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (2069,3,1,'tsp',5.3,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (2074,1,0.25,'tsp',1,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (2075,1,2,'tsp',5.7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (2076,1,1.33,'tbsp',9,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3001,1,1,'packet',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3002,1,1,'tbsp',14.7,'g',1,'1994-09-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (3002,2,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3002,3,1,'jar',71,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3003,1,1,'oz',28.35,'g',1,'1994-09-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (3003,2,1,'tbsp',14.7,'g',1,'1999-03-22','2009-02-11');
INSERT INTO `cndb_wght` VALUES (3003,3,1,'jar',71,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3005,1,1,'tbsp',16,'g',1,'1994-09-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (3005,2,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3005,3,1,'jar',71,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3007,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3007,2,1,'jar',71,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3008,1,1,'TBSP',15,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3008,2,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3008,3,1,'jar',71,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3008,4,1,'jar Gerber Second Foods (2.5 oz)',71,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3009,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3009,2,1,'jar',71,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3010,1,1,'tbsp',22,'g',1,'1994-09-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (3010,2,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3010,3,1,'jar',71,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3010,4,1,'container',70,'g',1,'2002-09-06','2009-02-11');
INSERT INTO `cndb_wght` VALUES (3011,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3011,2,1,'jar',71,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3012,1,1,'TBSP',15,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3012,2,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3012,3,1,'jar',71,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3012,4,1,'jar Beech-Nut Stage 1 (2.5 oz)',71,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3012,5,1,'jar Gerber Second Foods (2.5 oz)',71,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3012,6,1,'jar Heinz Strained-2 (2.5 oz)',71,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3013,1,1,'TBSP',15,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3013,2,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3013,3,1,'jar',71,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3013,4,1,'jar Gerber Third Foods (2.5 oz)',71,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3013,5,1,'jar Heinz Junior-3 (2.5 oz)',71,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3014,1,1,'stick',10,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3014,2,1,'jar',71,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3014,3,1,'jar Gerber Graduate (2.5 oz)',71,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3015,1,1,'TBSP',15,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3015,2,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3015,3,1,'jar',71,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3015,4,1,'jar Beech-Nut Stage 1 (2.5 oz)',71,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3015,5,1,'jar Gerber Second Foods (2.5 oz)',71,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3015,6,1,'jar Heinz Strained-2 (2.5 oz)',71,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3016,1,1,'tbsp',19,'g',1,'1994-09-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (3016,2,1,'container',68,'g',1,'1999-03-22','2009-02-11');
INSERT INTO `cndb_wght` VALUES (3017,1,1,'stick',10,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3017,2,1,'jar',71,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3017,3,1,'jar Gerber Graduate (2.5 oz)',71,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3021,1,1,'stick',10,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3021,2,1,'jar',71,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3021,3,1,'jar Gerber Graduate (2.5 oz)',71,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3026,1,1,'serving',88,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (3044,1,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3044,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3044,3,1,'jar',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3044,4,1,'jar Gerber Second Food (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3044,5,1,'jar Beech-Nut Stage 2 (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3044,6,1,'jar Heinz Strained-2 (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3045,1,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3045,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3045,3,1,'jar',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3045,4,1,'jar Beech-Nut Stage 3 (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3045,5,1,'jar Gerber Third Foods (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3046,1,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3046,2,1,'piece',8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3047,1,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3047,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3047,3,1,'jar',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3047,4,1,'jar Gerber Second Food (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3047,5,1,'jar Beech-Nut Stage 2 (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3047,6,1,'jar Heinz Strained-2 (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3048,1,1,'container',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3050,1,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3050,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3050,3,1,'jar',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3050,4,1,'jar Beech-Nut Stage 3 (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3050,5,1,'jar Gerber Third Foods (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3050,6,1,'jar Heinz Junior-3 (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3053,1,1,'cup',256,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3053,2,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3053,3,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3053,4,1,'jar',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3053,5,1,'jar Earth''s Best (4.5 oz)',128,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3053,6,1,'jar Gerber Second Food (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3053,7,1,'jar Beech-Nut Stage 2 (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3053,8,1,'jar Heinz Strained-2 (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3054,1,1,'cup',256,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3054,2,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3054,3,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3054,4,1,'jar',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3054,5,1,'jar Beech-Nut Stage 3 (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3054,6,1,'jar Gerber Third Foods (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3054,7,1,'jar Heinz Junior-3 (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3055,1,1,'jar Beech-Nut Stage 2 (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3067,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3067,2,1,'jar',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3068,1,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3068,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3068,3,1,'jar',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3068,4,1,'jar Gerber Second Food (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3068,5,1,'jar Beech-Nut Stage 2 (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3068,6,1,'jar Heinz Strained-2 (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3069,1,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3069,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3069,3,1,'jar',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3069,4,1,'jar Beech-Nut Stage 3 (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3069,5,1,'jar Gerber Third Foods (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3069,6,1,'jar Heinz Junior-3 (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3070,1,1,'jar Beech-Nut Stage 2 (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3070,2,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3070,3,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3070,4,1,'jar',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3070,5,1,'jar Heinz Strained-2 (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3072,1,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3072,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3072,3,1,'jar',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3073,1,1,'cup',256,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3073,2,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3073,3,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3073,4,1,'jar',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3073,5,1,'jar Gerber Second Food (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3073,6,1,'jar Beech-Nut Stage 2 (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3073,7,1,'jar Heinz Strained-2 (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3077,1,1,'jar, Gerber (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3082,1,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3082,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3082,3,1,'jar',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3082,4,1,'jar Gerber Second Food (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3082,5,1,'jar Beech-Nut Stage 2 (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3082,6,1,'jar Heinz Strained-2 (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3083,1,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3083,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3083,3,1,'jar',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3083,4,1,'jar Beech-Nut Stage 3 (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3083,5,1,'jar Gerber Third Foods (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3083,6,1,'jar Heinz Junior-3 (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3084,1,1,'cup',256,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3084,2,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3084,3,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3084,4,1,'jar',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3084,5,1,'jar Earth''s Best (4.5 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3084,6,1,'jar Gerber Second Food (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3085,1,1,'cup',256,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3085,2,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3085,3,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3085,4,1,'jar',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3085,5,1,'jar Gerber Third Foods (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3089,1,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3089,2,1,'jar',113,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3090,1,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3090,2,1,'jar',170,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3091,1,1,'CUP',240,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3091,2,1,'TBSP',15,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3091,3,1,'oz',28.35,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3091,4,1,'jar',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3091,5,1,'jar Beech-Nut Stage I (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3091,6,1,'jar Gerber First Foods (2.5 oz)',71,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3091,7,1,'jar Gerber Second Food (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3091,8,1,'jar Heinz Strained-2 (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3091,9,1,'jar Heinz Beginner-1 (2.5 oz)',71,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3092,1,1,'CUP',240,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3092,2,1,'TBSP',15,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3092,3,1,'oz',28.35,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3092,4,1,'jar',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3092,5,1,'jar Beech-Nut Stage 3 (6 oz)',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3093,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3093,2,1,'jar',128,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3096,1,1,'jar, Gerber (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3098,1,1,'CUP',224,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3098,2,1,'TBSP',14,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3098,3,1,'oz',28.35,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3098,4,1,'jar',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3098,5,1,'jar Gerber Second Food (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3098,6,1,'jar Heinz Strained-2 (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3099,1,1,'CUP',224,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3099,2,1,'TBSP',14,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3099,3,1,'oz',28.35,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3099,4,1,'jar',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3099,5,1,'jar Beech-Nut Baby''s First (2.5 oz)',71,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3099,6,1,'jar Beech-Nut Stage I (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3099,7,1,'jar Gerber First Foods (2.5 oz)',71,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3099,8,1,'jar Earth''s Best (4.5 oz)',128,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3099,9,1,'jar Gerber Second Food (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3099,10,1,'jar Heinz Strained-2 (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3099,11,1,'jar Heinz Beginner-1 (2.5 oz)',71,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3100,1,1,'CUP',224,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3100,2,1,'TBSP',14,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3100,3,1,'oz',28.35,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3100,4,1,'jar',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3100,5,1,'jar Beech-Nut Stage 3 (6 oz)',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3100,6,1,'jar Gerber Third Foods (6 oz)',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3100,7,1,'jar Heinz Junior-3 (6 oz)',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3104,1,1,'tbsp',16,'g',1,'1994-09-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (3104,2,1,'oz',28.35,'g',1,'1999-03-22','2009-02-11');
INSERT INTO `cndb_wght` VALUES (3104,3,1,'jar',113,'g',1,'1998-01-15','2011-01-18');
INSERT INTO `cndb_wght` VALUES (3105,1,1,'tbsp',16,'g',1,'1994-09-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (3105,2,1,'oz',28.35,'g',1,'1999-03-22','2009-02-11');
INSERT INTO `cndb_wght` VALUES (3105,3,1,'jar',99,'g',1,'1998-01-15','2009-02-11');
INSERT INTO `cndb_wght` VALUES (3105,4,1,'container',67,'g',1,'2002-09-06','2009-02-11');
INSERT INTO `cndb_wght` VALUES (3108,1,1,'CUP',224,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3108,2,1,'TBSP',14,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3108,3,1,'oz',28.35,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3108,4,1,'jar',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3108,5,1,'jar Beech-Nut Baby''s First (2.5 oz)',71,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3108,6,1,'jar Beech-Nut Stage I (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3108,7,1,'jar Gerber First Foods (2.5 oz)',71,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3108,8,1,'jar Earth''s Best (4.5 oz)',128,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3108,9,1,'jar Gerber Second Food (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3108,10,1,'jar Heinz Strained-2 (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3108,11,1,'jar Heinz Beginner-1 (2.5 oz)',71,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3109,1,1,'CUP',224,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3109,2,1,'TBSP',14,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3109,3,1,'oz',28.35,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3109,4,1,'jar',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3109,5,1,'jar Beech-Nut Stage 3 (6 oz)',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3109,6,1,'jar Gerber Third Foods (6 oz)',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3109,7,1,'jar Heinz Junior-3 (6 oz)',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3112,1,1,'cup',163,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3112,2,1,'tbsp',10,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3112,3,1,'jar Gerber Graduate (4.5 oz)',71,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3114,1,1,'jar, Gerber (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3115,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3116,1,1,'TBSP',16,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3116,2,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3116,3,1,'jar',113,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3116,4,1,'jar Beech-Nut Baby''s First (2.5 oz)',71,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3116,5,1,'jar Beech-Nut Stage I (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3116,6,1,'jar Gerber First Foods (2.5 oz)',71,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3116,7,1,'jar Earth''s Best (4.5 oz)',128,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3116,8,1,'jar Gerber Second Food (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3116,9,1,'jar Heinz Strained-2 (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3116,10,1,'jar Heinz Beginner-1 (2.5 oz)',71,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3117,1,1,'TBSP',16,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3117,2,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3117,3,1,'jar',170,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3117,4,1,'jar Beech-Nut Stage 3 (6 oz)',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3117,5,1,'jar Gerber Third Foods (6 oz)',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3117,6,1,'jar Heinz Junior-3 (6 oz)',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3118,1,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3118,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3118,3,1,'jar',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3118,4,1,'jar Gerber Second Food (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3118,5,1,'jar Heinz Strained-2 (4.25 oz)',120,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3119,1,1,'jar',113,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (3119,2,1,'TBSP',15,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3119,3,1,'oz',28.35,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3119,4,1,'cup',240,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (3119,5,1,'jar Gerber Second Food (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3119,6,1,'jar Beech-Nut Stage 2 (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3119,7,1,'jar Heinz Strained-2 (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3120,1,1,'CUP',240,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3120,2,1,'TBSP',15,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3120,3,1,'oz',28.35,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3120,4,1,'jar',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3120,5,1,'jar Heinz Junior-3 (6 oz)',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3121,1,1,'tbsp',16,'g',1,'1994-09-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (3121,2,1,'oz',28.35,'g',1,'1999-03-22','2009-02-11');
INSERT INTO `cndb_wght` VALUES (3121,3,1,'jar',95,'g',1,'1998-01-15','2009-02-11');
INSERT INTO `cndb_wght` VALUES (3121,4,1,'CUP',240,'g',1,'2002-09-06','2009-02-11');
INSERT INTO `cndb_wght` VALUES (3121,5,1,'container',91,'g',1,'2002-09-06','2009-02-11');
INSERT INTO `cndb_wght` VALUES (3122,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3127,1,1,'CUP',240,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3127,2,1,'TBSP',15,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3127,3,1,'oz',28.35,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3127,4,1,'jar',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3127,5,1,'jar Gerber Second Food (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3128,1,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3128,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3128,3,1,'jar',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3128,4,1,'jar Gerber Third Foods (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3128,5,1,'jar Heinz Junior-3 (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3129,1,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3129,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3129,3,1,'jar',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3129,4,1,'jar Gerber Second Food (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3129,5,1,'jar Heinz Strained-2 (4.25 oz)',120,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3130,1,1,'tbsp',17,'g',1,'1994-09-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (3130,2,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3130,3,1,'jar',95,'g',1,'1998-01-15','2009-02-11');
INSERT INTO `cndb_wght` VALUES (3130,4,1,'container',67,'g',1,'2002-09-06','2009-02-11');
INSERT INTO `cndb_wght` VALUES (3131,1,1,'tbsp',17,'g',1,'1994-09-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (3131,2,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3131,3,1,'jar',95,'g',1,'1998-01-15','2009-02-11');
INSERT INTO `cndb_wght` VALUES (3131,4,1,'container',67,'g',1,'2002-09-06','2009-02-11');
INSERT INTO `cndb_wght` VALUES (3132,1,1,'TBSP',16,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3132,2,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3132,3,1,'jar',113,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3132,4,1,'jar Beech-Nut Baby''s First (2.5 oz)',71,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3132,5,1,'jar Beech-Nut Stage I (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3132,6,1,'jar Gerber First Foods (2.5 oz)',71,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3132,7,1,'jar Earth''s Best (4.5 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3132,8,1,'jar Gerber Second Food (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3132,9,1,'jar Heinz Strained-2 (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3132,10,1,'jar Heinz Beginner-1 (2.5 oz)',71,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3133,1,1,'TBSP',16,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3133,2,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3133,3,1,'jar',170,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3133,4,1,'jar Beech-Nut Stage 3 (6 oz)',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3133,5,1,'jar Gerber Third Foods (6 oz)',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3133,6,1,'jar Heinz Junior-3 (6 oz)',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3134,1,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3134,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3134,3,1,'jar',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3134,4,1,'jar Gerber Second Food (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3134,5,1,'jar Heinz Strained-2 (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3135,1,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3135,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3135,3,1,'jar',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3135,4,1,'jar Gerber Third Foods (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3136,1,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3136,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3136,3,1,'jar',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3136,4,1,'jar Gerber Second Food (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3136,5,1,'jar Heinz Strained-2 (4.25 oz)',120,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3137,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3137,2,1,'jar',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3139,1,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3139,2,1,'jar Gerber First Foods (2.5 oz)',71,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3140,1,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3140,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3140,3,1,'jar, Gerber (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3140,4,1,'jar',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3141,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3141,2,1,'jar Gerber',128,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3142,1,1,'TBSP',16,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3142,2,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3142,3,1,'jar',113,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3142,4,1,'jar Earth''s Best (4.5 oz)',128,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3142,5,1,'jar Gerber Second Food (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3142,6,1,'jar Beech-Nut Stage 2 (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3142,7,1,'jar Heinz Strained-2 (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3143,1,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3143,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3143,3,1,'jar',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3143,4,1,'jar Heinz Junior-3 (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3144,1,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3144,2,1,'jar',113,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3145,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3145,2,1,'jar',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3147,1,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3147,2,1,'jar NFS',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3147,3,1,'jar Beech-Nut Stage 3 (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3150,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3150,2,1,'jar',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3151,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3151,2,1,'jar',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3152,1,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3152,2,1,'jar',113,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3153,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3153,2,1,'jar',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3154,1,1,'jar, Gerber (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3156,1,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3156,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3156,3,1,'jar',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3156,4,1,'jar Gerber Third Foods (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3156,5,1,'jar Heinz Junior-3 (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3157,1,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3157,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3157,3,1,'jar',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3157,4,1,'jar Gerber Second Food (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3157,5,1,'jar Heinz Strained-2 (4.25 oz)',120,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3158,1,1,'TBSP',16,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3158,2,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3158,3,1,'jar',113,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3158,4,1,'jar Gerber Second Food (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3158,5,1,'jar Beech-Nut Stage 2 (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3158,6,1,'jar Heinz Strained-2 (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3159,1,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3159,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3159,3,1,'jar',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3159,4,1,'jar Gerber Third Foods (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3161,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3161,2,1,'jar Gerber',128,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3163,1,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3163,2,1,'jar NFS',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3163,3,1,'jar Gerber Second Food (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3164,1,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3164,2,1,'jar',113,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3165,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3165,2,1,'jar',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3166,1,1,'fl oz',31.7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3166,2,1,'jar',127,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3166,3,1,'bottle Earth''s Best (4.2 fl oz)',131,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3166,4,1,'bottle Heinz Strained (4 fl oz)',125,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3166,5,1,'bottle Gerber First Food (4 fl oz)',125,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3166,6,1,'bottle Beech-Nut Stage I (4 fl oz)',125,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3167,1,1,'fl oz',31.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3167,2,1,'bottle Earth''s Best (4.2 fl oz)',131,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3167,3,1,'bottle Heinz Strained (4 fl oz)',125,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3167,4,1,'bottle NFS',125,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3167,5,1,'bottle Beech-Nut Stage 2 (4 fl oz)',125,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3167,6,1,'bottle Gerber Second Foods (4 fl oz)',125,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3168,1,1,'fl oz',31.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3168,2,1,'jar',127,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3171,1,1,'fl oz',31.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3171,2,1,'jar',127,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3171,3,1,'bottle (4 fl oz)',125,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3172,1,1,'fl oz',31.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3172,2,1,'jar',127,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3172,3,1,'bottle Heinz Strained (4 fl oz)',125,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3172,4,1,'bottle Gerber Second Foods (4 fl oz)',125,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3172,5,1,'bottle Beech-Nut Stage 3 (4 fl oz)',125,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3174,1,1,'fl oz',31.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3174,2,1,'jar',127,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3174,3,1,'bottle Heinz Strained (4 fl oz)',125,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3175,1,1,'fl oz',31.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3175,2,1,'jar',127,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3177,1,1,'fl oz',31.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3177,2,1,'jar',127,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3179,1,1,'fl oz',31.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3179,2,1,'jar',127,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3179,3,1,'bottle (4 fl oz)',125,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3181,1,1,'tbsp',2.4,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3181,2,0.5,'oz',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3184,1,0.5,'oz',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3185,1,1,'TBSP',2.5,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3185,2,0.5,'oz',15,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3186,1,1,'tbsp',2.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3186,2,0.5,'oz',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3187,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3187,2,1,'jar',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3188,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3188,2,1,'jar',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3189,1,1,'tbsp',3.2,'g',1,'1994-01-31','2009-02-11');
INSERT INTO `cndb_wght` VALUES (3189,2,0.5,'oz',15,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3189,3,0.25,'CUP',12.2,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (3189,4,1,'box',223,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (3190,1,1,'serving',15,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (3190,2,0.5,'oz',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3190,3,1,'tbsp',2.5,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (3191,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3191,2,1,'jar',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3192,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3192,2,1,'jar',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3194,1,1,'TBSP',2.5,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3194,2,0.5,'oz',15,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3195,1,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3195,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3195,3,1,'jar',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3195,4,1,'jar Gerber Second Food (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3195,5,1,'jar Heinz Strained-2 (4.25 oz)',120,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3197,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3197,2,1,'jar',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3198,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3198,2,1,'jar',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3199,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3199,2,1,'jar',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3201,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3201,2,1,'jar',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3205,1,1,'tbsp',5.3,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3205,2,1,'packet (.75 oz)',21,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3206,1,1,'cookie',8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3209,1,1,'cracker',0.7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3211,1,1,'tbsp',2.4,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3211,2,0.5,'oz',14.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3212,1,1,'TBSP',2.5,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3212,2,0.5,'oz',15,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3213,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3213,2,1,'cookie',6.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3214,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3214,2,1,'cookie',5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3215,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3215,2,1,'pretzel',6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3220,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3220,2,1,'jar',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3221,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3221,2,1,'jar',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3222,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3224,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3224,2,1,'jar',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3225,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3225,2,1,'jar',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3226,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3226,2,1,'jar',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3227,1,1,'TBSP',15,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3227,2,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3227,3,1,'jar',113,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3227,4,1,'jar Gerber Second Food (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3227,5,1,'jar Heinz Strained-2 (4 oz)',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3228,1,1,'TBSP',15,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3228,2,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3228,3,1,'jar',220,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3228,4,1,'jar Gerber Third Foods (6 oz)',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3233,1,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3233,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3233,3,1,'jar',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3233,4,1,'jar Gerber Second Food (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3235,1,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3235,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3235,3,1,'jar',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3235,4,1,'jar Gerber Second Food (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3235,5,1,'jar Heinz Strained-2 (4.25 oz)',120,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3236,1,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3236,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3236,3,1,'jar',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3236,4,1,'jar Gerber Third Foods (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3236,5,1,'jar Heinz Junior-3 (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3245,1,1,'cup',229,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3245,2,1,'tbsp',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3245,3,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3245,4,1,'jar',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3245,5,1,'jar Gerber Second Food (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3245,6,1,'jar Beech-Nut Stage 2 (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3245,7,1,'jar Heinz Strained-2 (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3246,1,1,'CUP',229,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3246,2,1,'TBSP',14,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3246,3,1,'oz',28.35,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3246,4,1,'jar',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3246,5,1,'jar Beech-Nut Stage 3 (6 oz)',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3246,6,1,'jar Gerber Third Foods (6 oz)',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3246,7,1,'jar Heinz Junior-3 (6 oz)',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3265,1,1,'fl oz',31.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3265,2,1,'jar',127,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3265,3,1,'bottle Earth''s Best (4.2 fl oz)',131,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3265,4,1,'bottle Heinz Strained (4 fl oz)',125,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3265,5,1,'bottle Beech-Nut Stage 2 (4 fl oz)',125,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3265,6,1,'bottle Gerber Second Foods (4 fl oz)',125,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3267,1,1,'fl oz',31.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3269,1,1,'serving',189,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3274,1,1,'cup',256,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3274,2,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3274,3,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3274,4,1,'jar',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3274,5,1,'jar Beech-Nut Stage 3 (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3274,6,1,'jar Gerber Third Foods (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3279,1,1,'serving',99,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (3280,1,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3280,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3280,3,1,'jar',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3280,4,1,'jar Gerber Third Foods (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3280,5,1,'jar Heinz Junior-3 (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3282,1,1,'serving 3.5 oz serving',99,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (3282,2,1,'TBSP',15,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3282,3,1,'oz',28.35,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3282,4,1,'cup',240,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (3282,5,1,'package 7 oz',198,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (3283,1,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3283,2,1,'jar',113,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3286,1,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3286,2,1,'jar',113,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3287,1,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3287,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3287,3,1,'jar',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3287,4,1,'jar Beech-Nut Stage 3 (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3287,5,1,'jar Gerber Third Foods (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3287,6,1,'jar Heinz Junior-3 (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3289,1,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3289,2,1,'jar NFS',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3289,3,1,'jar Gerber Second Food (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3290,1,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3290,2,1,'jar NFS',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3290,3,1,'jar Gerber Second Food (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3293,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3293,2,1,'jar Earth''s Best',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3296,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3296,2,1,'jar Beech nut',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3297,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3297,2,1,'jar',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3297,3,1,'jar Gerber Second Food (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3297,4,1,'jar Beech-Nut Stage 2 (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3297,5,1,'jar Heinz Strained-2 (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3298,1,1,'tbsp',29,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3298,2,1,'container',162,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3303,1,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3303,2,1,'jar Beech-Nut Stage 2 (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3681,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3685,1,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3686,1,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3689,1,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3690,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3694,1,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3712,1,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (3934,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3956,1,1,'oz',31,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3956,2,1,'container',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3959,1,1,'container',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3964,1,1,'bar',19,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3965,1,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3965,2,1,'container',69,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3994,1,1,'bottle',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3995,1,1,'packet',99,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (3996,1,3,'tbsp',16,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (4001,1,1,'tbsp',12.8,'g',1,'1994-11-17','2013-12-26');
INSERT INTO `cndb_wght` VALUES (4001,2,1,'cup',205,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (4002,1,1,'tbsp',12.8,'g',1,'1994-11-02','2013-12-26');
INSERT INTO `cndb_wght` VALUES (4002,2,1,'cup',205,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (4015,1,1,'tbsp',15,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4015,2,1,'cup',245,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4015,3,1,'serving (2 tbsp)',30,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4016,1,1,'tablespoon',15,'g',1,'1994-11-17','2015-01-07');
INSERT INTO `cndb_wght` VALUES (4016,2,1,'CUP',245,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4017,1,1,'tbsp',16,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4017,2,1,'cup',250,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4017,3,1,'serving (2 tbsp)',30,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4018,1,1,'tbsp',14.7,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4018,2,1,'cup',235,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4020,1,1,'tablespoon',16,'g',1,'1994-01-31','2015-01-07');
INSERT INTO `cndb_wght` VALUES (4020,2,1,'CUP',260,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4020,3,1,'serving (2 tbsp)',30,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4021,1,1,'tablespoon',15,'g',1,'1994-01-31','2015-01-07');
INSERT INTO `cndb_wght` VALUES (4021,2,1,'CUP',240,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4022,1,1,'tablespoon',16,'g',1,'1994-01-31','2015-01-07');
INSERT INTO `cndb_wght` VALUES (4022,2,1,'CUP',260,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4023,1,1,'tablespoon',15,'g',1,'1994-01-31','2015-01-07');
INSERT INTO `cndb_wght` VALUES (4023,2,1,'CUP',245,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4023,3,1,'serving (2 tbsp)',15,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4025,1,1,'tbsp',13.8,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4025,2,1,'cup',220,'g',1,'1998-01-15','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4025,3,1,'packet',10,'g',1,'2004-07-15','2009-02-11');
INSERT INTO `cndb_wght` VALUES (4026,1,1,'tablespoon',13.8,'g',1,'1994-01-31','2015-01-07');
INSERT INTO `cndb_wght` VALUES (4026,2,1,'CUP',220,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4027,1,1,'tbsp',15,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (4027,2,1,'cup',240,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (4028,1,1,'tablespoon',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4028,2,1,'cup',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4029,1,1,'tablespoon',14.1,'g',1,'1994-01-31','2015-01-07');
INSERT INTO `cndb_wght` VALUES (4029,2,1,'CUP',225,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4030,1,1,'tablespoon',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4030,2,1,'cup',245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4031,1,1,'tbsp',12.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4031,2,1,'cup',205,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4034,1,1,'tbsp',13.6,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4034,2,1,'cup',218,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4034,3,1,'tsp',4.5,'g',1,'2002-09-06','2009-02-11');
INSERT INTO `cndb_wght` VALUES (4037,1,1,'tablespoon',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4037,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4037,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4038,1,1,'tsp',4.5,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (4038,2,1,'tablespoon',13.6,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (4038,3,1,'cup',218,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (4042,1,1,'tbsp',13.5,'g',1,'1994-11-02','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4042,2,1,'cup',216,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4042,3,1,'tsp',4.5,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4044,1,1,'tbsp',13.6,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4044,2,1,'cup',218,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4044,3,1,'tsp',4.5,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4047,1,1,'tbsp',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4047,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4047,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4053,1,1,'tablespoon',13.5,'g',1,'1994-01-31','2015-01-07');
INSERT INTO `cndb_wght` VALUES (4053,2,1,'CUP',216,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4053,3,1,'tsp',4.5,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4055,1,1,'tbsp',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4055,2,1,'cup',216,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4055,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4058,1,1,'tablespoon',13.6,'g',1,'1994-11-02','2015-01-07');
INSERT INTO `cndb_wght` VALUES (4058,2,1,'CUP',218,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4058,3,1,'tsp',4.5,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4060,1,1,'TBSP',13.6,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4060,2,1,'CUP',218,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4060,3,1,'tsp',4.5,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4073,1,1,'tsp',4.7,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4073,2,1,'stick',113,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4114,1,1,'tbsp',14.7,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4114,2,1,'cup',235,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4120,1,1,'cup',250,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (4120,2,1,'tbsp',16,'g',1,'2002-09-06','2019-02-13');
INSERT INTO `cndb_wght` VALUES (4120,3,1,'individual packet',12.3,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (4128,1,1,'cup',232,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (4128,2,1,'tsp',4.8,'g',1,'2002-09-06','2019-02-13');
INSERT INTO `cndb_wght` VALUES (4133,1,1,'tablespoon',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4133,2,1,'cup',220,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4135,1,1,'tablespoon',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4135,2,1,'cup',250,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4141,1,1,'tablespoon',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4142,1,1,'tablespoon',16,'g',1,'1994-01-31','2015-01-07');
INSERT INTO `cndb_wght` VALUES (4142,2,1,'CUP',260,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4143,1,1,'tablespoon',14.7,'g',1,'1994-01-31','2015-01-07');
INSERT INTO `cndb_wght` VALUES (4143,2,1,'CUP',235,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4144,1,1,'tablespoon',15,'g',1,'1994-01-31','2015-01-07');
INSERT INTO `cndb_wght` VALUES (4144,2,1,'CUP',240,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4145,1,1,'tablespoon',13.8,'g',1,'1994-01-31','2015-01-07');
INSERT INTO `cndb_wght` VALUES (4145,2,1,'CUP',220,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4146,1,1,'tablespoon',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4146,2,1,'cup',220,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4367,1,1,'tablespoon',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4367,2,1,'cup',256,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4501,1,1,'tablespoon',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4501,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4501,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4502,1,1,'tablespoon',13.6,'g',1,'1994-01-31','2015-01-07');
INSERT INTO `cndb_wght` VALUES (4502,2,1,'CUP',218,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4502,3,1,'tsp',4.5,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4506,1,1,'TBSP',13.6,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4506,2,1,'CUP',218,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4506,3,1,'tsp',4.5,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4510,1,1,'tbsp',13.6,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4510,2,1,'cup',218,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4510,3,1,'tsp',4.5,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4511,1,1,'tablespoon',13.6,'g',1,'1994-01-31','2015-01-07');
INSERT INTO `cndb_wght` VALUES (4511,2,1,'CUP',218,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4511,3,1,'tsp',4.5,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4513,1,1,'tablespoon',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4513,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4513,3,2,'tbsp (1/8 cup)',27,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4514,1,1,'tablespoon',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4514,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4514,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4515,1,1,'tablespoon',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4515,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4515,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4516,1,1,'tablespoon',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4516,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4516,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4517,1,1,'tablespoon',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4517,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4517,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4518,1,1,'TBSP',13.6,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4518,2,1,'CUP',218,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4518,3,1,'tsp',4.5,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4528,1,1,'tbsp',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4528,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4528,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4529,1,1,'tablespoon',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4529,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4529,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4530,1,1,'tablespoon',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4530,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4530,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4531,1,1,'tablespoon',13.6,'g',1,'1994-01-31','2015-01-07');
INSERT INTO `cndb_wght` VALUES (4531,2,1,'CUP',218,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4531,3,1,'tsp',4.5,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4532,1,1,'tablespoon',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4532,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4532,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4534,1,1,'tbsp',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4534,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4534,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4536,1,1,'tablespoon',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4536,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4536,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4539,1,1,'tbsp',15,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4539,2,1,'cup',245,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4541,1,1,'tablespoon',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4541,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4541,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4542,1,1,'tbsp',12.8,'g',1,'1994-11-17','2013-12-26');
INSERT INTO `cndb_wght` VALUES (4542,2,1,'cup',205,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (4543,1,1,'tablespoon',13.6,'g',1,'1994-01-31','2015-01-07');
INSERT INTO `cndb_wght` VALUES (4543,2,1,'CUP',218,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4543,3,1,'tsp',4.5,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4544,1,1,'tablespoon',12.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4544,2,1,'cup',205,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4545,1,1,'TBSP',13.6,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4545,2,1,'CUP',218,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4545,3,1,'tsp',4.5,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4546,1,1,'tablespoon',12.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4546,2,1,'cup',205,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4548,1,1,'tbsp',12.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4548,2,1,'cup',205,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4549,1,1,'TBSP',12.8,'g',1,'2001-07-04','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4549,2,1,'CUP',205,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4550,1,1,'TBSP',12.8,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4550,2,1,'CUP',205,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4551,1,1,'tbsp',12.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4551,2,1,'cup',205,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4554,1,1,'TBSP',12.8,'g',1,'2001-07-04','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4554,2,1,'CUP',205,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4556,1,1,'TBSP',12.8,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4556,2,1,'CUP',205,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4559,1,1,'tbsp',12.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4559,2,1,'cup',205,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4560,1,1,'TBSP',12.8,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4560,2,1,'CUP',205,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4570,1,1,'tbsp',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4570,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4572,1,1,'tbsp',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4572,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4572,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4573,1,1,'tbsp',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4573,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4573,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4575,1,1,'tbsp',12.8,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (4575,2,1,'tsp',4.3,'g',1,'1994-11-17','2013-12-26');
INSERT INTO `cndb_wght` VALUES (4575,3,1,'cup',205,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (4576,1,1,'tbsp',12.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4576,2,1,'cup',205,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4581,1,1,'tbsp',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4581,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4581,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4582,1,1,'tbsp',14,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4582,2,1,'cup',218,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4582,3,1,'tsp',4.5,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4583,1,1,'tbsp',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4583,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4583,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4584,1,1,'TBSP',14,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4584,2,1,'CUP',218,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4584,3,1,'tsp',4.5,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4585,1,1,'tbsp',14.1,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4585,2,1,'cup',227,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4585,3,1,'tsp',4.7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4585,4,1,'stick',111,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4586,1,1,'TBSP',12.8,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4586,2,1,'CUP',205,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4587,1,1,'TBSP',12.8,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4587,2,1,'CUP',205,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4588,1,1,'tbsp',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4588,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4588,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4589,1,1,'tsp',4.5,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (4589,2,1,'tbsp',13.6,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (4589,3,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4590,1,1,'tbsp',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4590,2,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4590,3,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4591,1,1,'tbsp',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4591,2,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4591,3,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4592,1,1,'tbsp',12.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4592,2,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4592,3,1,'cup',205,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4593,1,1,'tbsp',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4593,2,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4593,3,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4594,1,1,'tbsp',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4594,2,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4594,3,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4595,1,1,'TBSP',12.8,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4595,2,1,'CUP',205,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (4600,1,1,'tablespoon',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4601,1,1,'tablespoon',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4602,1,1,'tablespoon',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4609,1,1,'tsp',4.3,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4610,1,1,'tbsp',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4610,2,1,'cup',227,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4610,3,1,'tsp',4.7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4610,4,1,'pat (1" sq, 1/3" high)',5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4610,5,1,'stick',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4611,1,1,'tbsp',14.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4611,2,1,'cup',227,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4612,1,1,'tbsp',14.3,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4612,2,1,'cup',229,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4612,3,1,'tsp',4.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4613,1,1,'tbsp',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4613,2,1,'cup',229,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4613,3,1,'tsp',4.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4614,1,1,'tbsp',14.3,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4614,2,1,'cup',229,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4614,3,1,'tsp',4.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4615,1,1,'tbsp',12.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4615,2,1,'cup',205,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4617,1,1,'tbsp',14.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4617,2,1,'cup',227,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4617,3,1,'pat (1" sq, 1/3" high)',5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4617,4,1,'stick',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4618,1,1,'tbsp',14.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4618,2,1,'cup',227,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4620,1,1,'tbsp',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4624,1,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4626,1,1,'tablespoon',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4627,1,1,'tablespoon',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4628,1,1,'tbsp',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4629,1,1,'tbsp (1 NLEA serving)',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4631,1,1,'tbsp',14.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4631,2,1,'cup',233,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4633,1,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4633,2,1,'cup',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4634,1,1,'tbsp',12.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4634,2,1,'cup',205,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4635,1,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4635,2,1,'cup',256,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4636,1,1,'tbsp',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4636,2,1,'cup',231,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4638,1,1,'tablespoon',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4639,1,1,'tablespoon',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4639,2,1,'serving',30,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4640,1,1,'tablespoon',15,'g',1,'2005-02-05','2015-01-07');
INSERT INTO `cndb_wght` VALUES (4640,2,1,'serving (2 tbsp)',30,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4641,1,1,'tablespoon',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4642,1,1,'tablespoon',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4642,2,1,'teaspoon',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4642,3,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4643,1,1,'tablespoon',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4643,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4644,1,1,'tablespoon',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4644,2,1,'teaspoon',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4644,3,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4645,1,1,'tablespoon',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4645,2,1,'teaspoon',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4645,3,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4646,1,1,'tbsp',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4646,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4646,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4648,1,1,'tbsp',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4648,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4648,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4649,1,1,'tbsp',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4649,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4649,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4650,1,1,'tbsp',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4650,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4650,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4651,1,1,'tbsp',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4651,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4651,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4652,1,1,'tbsp',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4652,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4652,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4653,1,1,'tbsp',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4653,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4653,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4654,1,1,'tbsp',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4654,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4654,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4655,1,1,'tbsp',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4656,1,1,'tbsp',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4656,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4656,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4657,1,1,'tbsp',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4657,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4657,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4658,1,1,'tbsp',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4658,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4658,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4659,1,1,'tbsp',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4659,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4659,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4660,1,1,'tbsp',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4660,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4660,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4661,1,1,'tbsp',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4661,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4661,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4662,1,1,'tbsp',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4662,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4662,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4663,1,1,'tbsp',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4663,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4663,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4664,1,1,'tbsp',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4664,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4664,3,1,'tsp',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4665,1,1,'tbsp',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4666,1,1,'tbsp',12.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4666,2,1,'cup',205,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4667,1,1,'tbsp',12.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4667,2,1,'cup',205,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4668,1,1,'tbsp',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4668,2,1,'cup',227,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4668,3,1,'tsp',4.7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4669,1,1,'tablespoon',13.6,'g',1,'2006-02-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (4669,2,1,'CUP',218,'g',1,'2006-02-23','2007-03-25');
INSERT INTO `cndb_wght` VALUES (4669,3,1,'teaspoon',4.5,'g',1,'2006-02-23','2007-03-25');
INSERT INTO `cndb_wght` VALUES (4678,1,1,'tbsp',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4683,1,1,'tbsp (1 NLEA serving)',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4686,1,2,'tbsp (1 serving)',30,'g',1,'2007-12-03','2007-12-03');
INSERT INTO `cndb_wght` VALUES (4688,1,1,'serving (approximately 10 sprays)',8,'g',1,'2009-01-25','2009-01-25');
INSERT INTO `cndb_wght` VALUES (4690,1,1,'tbsp',14.9,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (4691,1,1,'tablespoon',14,'g',1,'2010-01-04','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4691,2,1,'cup',227,'g',1,'2010-01-04','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4691,3,1,'teaspoon',4,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (4692,1,1,'tbsp',14,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (4693,1,1,'tbsp',14,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (4694,1,1,'tbsp',14,'g',1,'2010-01-04','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4694,2,1,'cup',229,'g',1,'2010-01-04','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4694,3,1,'teaspoon',4.8,'g',1,'2010-01-04','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4695,1,1,'tbsp',14,'g',1,'2010-01-04','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4695,2,1,'cup',229,'g',1,'2010-01-04','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4695,3,1,'teaspoon',4.8,'g',1,'2010-01-04','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4696,1,1,'tbsp',14,'g',1,'2010-01-04','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4696,2,1,'cup',229,'g',1,'2010-01-04','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4696,3,1,'teaspoon',4.8,'g',1,'2010-01-04','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4697,1,1,'tbsp',14,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (4698,1,1,'tablespoon',14,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4698,2,1,'cup',218,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4698,3,1,'teaspoon',4.5,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4699,1,1,'tablespoon',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4699,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4699,3,1,'teaspoon',4.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4700,1,1,'tablespoon',13.6,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4700,2,1,'cup',218,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4700,3,1,'teaspoon',4.5,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4701,1,1,'tablespoon',13.6,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4701,2,1,'cup',218,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4701,3,1,'teaspoon',4.5,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (4702,1,1,'tablespoon',13.6,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (4702,2,1,'cup',218,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (4702,3,1,'teaspoon',4.5,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (4703,1,2,'tbsp',30,'g',1,'2012-03-02','2013-12-26');
INSERT INTO `cndb_wght` VALUES (4704,1,2,'tbsp',33,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4705,1,2,'tbsp (1 NLEA serving)',34,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (4706,1,2,'tbsp (1 NLEA serving)',30,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (4707,1,1,'tablespoon',13.7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4707,2,1,'cup',219,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4708,1,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (4708,2,1,'cup',232,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5000,1,3,'oz',85,'g',1,'2013-02-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5000,2,1,'breast',384,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5001,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5001,2,1,'chicken',1046,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5002,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5002,2,1,'unit (yield from 1 lb ready-to-cook chicken)',308,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5002,3,1,'chicken',1028,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5003,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5003,2,1,'unit (yield from 1 lb ready-to-cook chicken)',212,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5003,3,1,'chicken',708,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5004,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5004,2,1,'unit (yield from 1 lb ready-to-cook chicken)',205,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5004,3,1,'chicken',682,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5005,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5005,2,1,'unit (yield from 1 lb ready-to-cook chicken)',225,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5005,3,1,'chicken',751,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5006,1,4,'oz',113,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5006,2,1,'unit (yield from 1 lb ready-to-cook chicken)',276,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5006,3,0.5,'chicken, bone removed',460,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5007,1,3,'oz',85,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5007,2,1,'unit (yield from 1 lb ready-to-cook chicken)',280,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5007,3,0.5,'chicken, bone removed',466,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5008,1,3,'oz',85,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5008,2,1,'unit (yield from 1 lb ready-to-cook chicken)',188,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5008,3,0.5,'chicken, bone removed',314,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5009,1,3,'oz',85,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5009,2,1,'cup, chopped or diced',140,'g',1,'1997-08-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5009,3,0.5,'unit (yield from 1 lb ready-to-cook chicken)',178,'g',1,'2002-09-06','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5009,4,0,'chicken, bone removed',299,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5010,1,1,'cup, chopped or diced',140,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5010,2,1,'unit (yield from 1 lb ready-to-cook chicken)',200,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5010,3,0.5,'chicken, bone removed',334,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5011,1,4,'oz',113,'g',1,'1997-08-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5011,2,1,'unit (yield from 1 lb ready-to-cook chicken)',197,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5011,3,0.5,'chicken, bone and skin removed',329,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5012,1,1,'cup, chopped or diced',140,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5012,2,1,'unit (yield from 1 lb ready-to-cook chicken)',155,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5012,3,0.5,'chicken, bone and skin removed',258,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5013,1,1,'cup, chopped or diced',140,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5013,2,1,'TBSP',8.7,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5013,3,1,'unit (yield from 1 lb ready-to-cook chicken)',146,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5014,1,1,'cup, chopped or diced',140,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5014,2,1,'TBSP',8.7,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5014,3,1,'unit (yield from 1 lb ready-to-cook chicken)',157,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5015,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5015,2,0.5,'unit (yield from 1 lb ready-to-cook chicken)',47,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5015,3,0,'chicken, skin only',79,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5016,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5016,2,0.5,'unit (yield from 1 lb ready-to-cook chicken)',114,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5016,3,0,'chicken, skin only',190,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5017,1,1,'unit (yield from 1 lb ready-to-cook chicken)',33,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5017,2,0.5,'chicken, skin only',56,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5018,1,1,'unit (yield from 1 lb ready-to-cook chicken)',34,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5018,2,0.5,'chicken, skin only',56,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5019,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5019,2,0.5,'unit (yield from 1 lb ready-to-cook chicken)',44,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5019,3,0,'chicken, skin only',72,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5020,1,1,'unit (yield from 1 lb ready-to-cook chicken)',23,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5020,2,1,'giblets',75,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5021,1,1,'cup, chopped or diced',145,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5021,2,1,'unit (yield from 1 lb ready-to-cook chicken)',13,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5022,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5022,2,1,'cup chopped or dice',145,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5023,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5023,2,1,'lb',453,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5024,1,1,'cup chopped or dice',145,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5025,1,1,'heart',6.1,'g',1,'2001-07-04','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5025,2,1,'unit (yield from 1 lb ready-to-cook chicken)',1.8,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5026,1,1,'cup, chopped or diced',145,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5026,2,1,'unit (yield from 1 lb ready-to-cook chicken)',1,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5027,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5027,2,1,'liver',44,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5028,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5028,2,1,'liver',44,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5029,1,4,'oz',113,'g',1,'2001-07-04','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5029,2,0.5,'unit (yield from 1 lb ready-to-cook chicken)',116,'g',1,'2002-09-06','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5029,3,0,'chicken, bone removed',194,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5030,1,1,'unit (yield from 1 lb ready-to-cook chicken)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5030,2,0.5,'chicken, bone removed',188,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5031,1,1,'unit (yield from 1 lb ready-to-cook chicken)',78,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5031,2,0.5,'chicken, bone removed',130,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5032,1,1,'unit (yield from 1 lb ready-to-cook chicken)',79,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5032,2,0.5,'chicken, bone removed',132,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5033,1,1,'unit (yield from 1 lb ready-to-cook chicken)',90,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5033,2,0.5,'chicken, bone removed',150,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5034,1,4,'oz',113,'g',1,'1996-09-30','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5034,2,1,'unit (yield from 1 lb ready-to-cook chicken)',160,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5034,3,0.5,'chicken, bone removed',266,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5035,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5035,2,1,'unit (yield from 1 lb ready-to-cook chicken)',167,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5035,3,0.5,'chicken, bone removed',278,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5036,1,1,'unit (yield from 1 lb ready-to-cook chicken)',110,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5036,2,0.5,'chicken, bone removed',184,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5037,1,1,'unit (yield from 1 lb ready-to-cook chicken)',101,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5037,2,0.5,'chicken, bone removed',167,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5038,1,1,'unit (yield from 1 lb ready-to-cook chicken)',110,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5038,2,0.5,'chicken, bone removed',184,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5039,1,1,'unit (yield from 1 lb ready-to-cook chicken)',88,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5039,2,0.5,'chicken, bone and skin removed',147,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5040,1,1,'cup',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5040,2,1,'unit (yield from 1 lb ready-to-cook chicken)',64,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5041,1,1,'cup, chopped or diced',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5041,2,1,'unit (yield from 1 lb ready-to-cook chicken)',64,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5041,3,0.5,'chicken, bone and skin removed',107,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5042,1,1,'cup, chopped or diced',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5042,2,1,'unit (yield from 1 lb ready-to-cook chicken)',71,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5042,3,0.5,'chicken, bone and skin removed',119,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5043,1,1,'unit (yield from 1 lb ready-to-cook chicken)',109,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5043,2,0.5,'chicken, bone and skin removed',182,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5044,1,1,'cup',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5044,2,1,'unit (yield from 1 lb ready-to-cook chicken)',91,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5045,1,1,'cup, chopped or diced',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5045,2,1,'unit (yield from 1 lb ready-to-cook chicken)',81,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5045,3,0.5,'chicken, bone and skin removed',136,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5046,1,1,'cup, chopped or diced',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5046,2,1,'unit (yield from 1 lb ready-to-cook chicken)',86,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5046,3,0.5,'chicken, bone and skin removed',143,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5047,1,1,'tbsp',12.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5047,2,1,'unit (yield from 1 lb ready-to-cook chicken)',32,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5047,3,0.5,'chicken, separable fat',52,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5048,1,1,'unit (yield from 1 lb ready-to-cook chicken)',59,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5048,2,0.5,'back, bone removed',99,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5049,1,1,'unit (yield from 1 lb ready-to-cook chicken)',72,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5049,2,0.5,'back, bone removed',120,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5050,1,1,'unit (yield from 1 lb ready-to-cook chicken)',44,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5050,2,0.5,'back, bone removed',72,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5051,1,1,'unit (yield from 1 lb ready-to-cook chicken)',32,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5051,2,0.5,'back, bone removed',53,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5052,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5052,2,1,'unit (yield from 1 lb ready-to-cook chicken)',36,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5052,3,1,'cup, chopped or diced',160,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5053,1,4,'oz',113,'g',1,'1998-01-15','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5053,2,0.5,'unit (yield from 1 lb ready-to-cook chicken)',31,'g',1,'1996-09-30','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5053,3,0,'back, bone and skin removed',51,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5054,1,1,'unit (yield from 1 lb ready-to-cook chicken)',35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5054,2,0.5,'back, bone and skin removed',58,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5055,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5055,2,0.5,'unit (yield from 1 lb ready-to-cook chicken)',24,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5055,3,0,'back, bone and skin removed',40,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5056,1,1,'unit (yield from 1 lb ready-to-cook chicken)',26,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5056,2,0.5,'back, bone and skin removed',42,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5057,1,0.5,'breast, bone removed (yield from 1 lb ready-to-cook chicken)',87,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5057,2,0.5,'breast, bone removed',145,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5058,1,3,'oz',85,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5058,2,0.5,'unit (yield from 1 lb ready-to-cook chicken)',84,'g',1,'1997-08-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5058,3,0,'breast, bone removed',140,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5059,1,1,'unit (yield from 1 lb ready-to-cook chicken)',59,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5059,2,0.5,'breast, bone removed',98,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5060,1,1,'cup, chopped or diced',140,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5060,2,1,'unit (yield from 1 lb ready-to-cook chicken)',58,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5060,3,0.5,'breast, bone removed',98,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5061,1,1,'cup, chopped or diced',140,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5061,2,1,'unit (yield from 1 lb ready-to-cook chicken)',66,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5061,3,0.5,'breast, bone removed',110,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5062,1,4,'oz',113,'g',1,'1997-08-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5062,2,1,'piece',272,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5062,3,1,'package',926,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5063,1,1,'unit (yield from 1 lb ready-to-cook chicken)',52,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5063,2,0.5,'breast, bone and skin removed',86,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5064,1,1,'cup, chopped or diced',140,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5064,2,1,'unit (yield from 1 lb ready-to-cook chicken)',52,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5064,3,0.5,'breast, bone and skin removed',86,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5065,1,1,'cup, chopped or diced',140,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5065,2,1,'unit (yield from 1 lb ready-to-cook chicken)',57,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5065,3,0.5,'breast, bone and skin removed',95,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5066,1,4,'oz',113,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5066,2,1,'drumstick with skin',133,'g',1,'1997-08-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5066,3,1,'drumstick',130,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5067,1,1,'unit (yield from 1 lb ready-to-cook chicken)',43,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5067,2,1,'drumstick, bone removed',72,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5068,1,1,'unit (yield from 1 lb ready-to-cook chicken)',29,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5068,2,1,'drumstick, bone removed',49,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5069,1,3,'oz',85,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5069,2,1,'drumstick with skin (yield from 1 lb ready-to-cook chicken)',105,'g',1,'1997-08-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5069,3,1,'drumstick without skin',96,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5070,1,1,'cup, chopped or diced',140,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5070,2,1,'unit (yield from 1 lb ready-to-cook chicken)',34,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5070,3,1,'drumstick, bone removed',57,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5071,1,4,'oz',113,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5071,2,1,'drumstick  with skin',130,'g',1,'1997-08-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5071,3,1,'drumstick without skin',122,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5072,1,1,'unit (yield from 1 lb ready-to-cook chicken)',25,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5072,2,1,'drumstick, bone and skin removed',42,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5073,1,3,'oz',85,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5073,2,1,'drumstick without skin',96,'g',1,'1997-08-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5073,3,1,'drumstick with skin',105,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5074,1,3,'oz',85,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5074,2,1,'drumstick, bone and skin removed',46,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5074,3,1,'cup, chopped or diced',160,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5074,4,1,'unit (yield from 1 lb ready-to-cook chicken)',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5075,1,4,'oz',113,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5075,2,1,'leg, with skin (Sum of drumstick+thigh+back)',344,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5075,3,1,'drumstick with skin',111,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5075,4,1,'thigh with skin',185,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5075,5,1,'back with skin',49,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5076,1,1,'unit (yield from 1 lb ready-to-cook chicken)',95,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5076,2,1,'leg, bone removed',158,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5077,1,1,'unit (yield from 1 lb ready-to-cook chicken)',67,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5077,2,1,'leg, bone removed',112,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5078,1,3,'oz',85,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5078,2,1,'leg, with skin (Sum of drumstick+thigh+back)',258,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5078,3,1,'thigh with skin',133,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5078,4,1,'drumstick with skin',91,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5078,5,1,'back with skin',35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5079,1,1,'cup, chopped or diced',140,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5079,2,1,'unit (yield from 1 lb ready-to-cook chicken)',75,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5079,3,1,'leg, bone removed',125,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5080,1,4,'oz',113,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5080,2,1,'leg, bone and skin removed (Sum of drumstick+thigh+back meat only)',265,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5080,3,1,'thigh bone and skin removed',147,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5080,4,1,'drumstick bone and skin removed',88,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5080,5,1,'back bone and skin removed',30,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5081,1,1,'unit (yield from 1 lb ready-to-cook chicken)',56,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5081,2,1,'leg, bone and skin removed',94,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5082,1,3,'oz',85,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5082,2,1,'leg (Sum of drumstick+thigh+back meat only)',199,'g',1,'1997-08-29','2016-02-06');
INSERT INTO `cndb_wght` VALUES (5082,3,1,'drumstick bone and skin',105,'g',1,'2002-09-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (5082,4,1,'thigh bone and skin',72,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (5082,5,1,'back bone and skin',22,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (5083,1,3,'oz',85,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5083,2,1,'cup, chopped or diced',160,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5083,3,1,'unit (yield from 1 lb ready-to-cook chicken)',60,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5083,4,1,'leg, bone and skin removed',101,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5084,1,1,'unit (yield from 1 lb ready-to-cook chicken)',15,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5084,2,1,'neck, bone removed',50,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5085,1,1,'unit (yield from 1 lb ready-to-cook chicken)',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5085,2,1,'neck, bone removed',52,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5086,1,1,'unit (yield from 1 lb ready-to-cook chicken)',11,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5086,2,1,'neck, bone removed',36,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5087,1,1,'unit (yield from 1 lb ready-to-cook chicken)',11,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5087,2,1,'neck, bone removed',38,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5088,1,1,'unit (yield from 1 lb ready-to-cook chicken)',6,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5088,2,1,'neck, bone and skin removed',20,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5089,1,1,'unit (yield from 1 lb ready-to-cook chicken)',7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5089,2,1,'neck, bone and skin removed',22,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5090,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5090,2,1,'unit (yield from 1 lb ready-to-cook chicken)',5,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5090,3,1,'neck, bone and skin removed',18,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5091,1,4,'oz',113,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5091,2,1,'thigh with skin',193,'g',1,'1997-08-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5092,1,1,'unit (yield from 1 lb ready-to-cook chicken)',52,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5092,2,1,'thigh, bone removed',86,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5093,1,1,'unit (yield from 1 lb ready-to-cook chicken)',38,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5093,2,1,'thigh, bone removed',62,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5094,1,3,'oz',85,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5094,2,1,'thigh with skin',137,'g',1,'1997-08-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5094,3,1,'thigh without skin',116,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5095,1,1,'unit (yield from 1 lb ready-to-cook chicken)',41,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5095,2,1,'thigh, bone removed',68,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5096,1,4,'oz',113,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5096,2,1,'thigh without skin',149,'g',1,'1997-08-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5097,1,3,'oz',85,'g',1,'1997-08-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5097,2,1,'unit (yield from 1 lb ready-to-cook chicken)',31,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5097,3,1,'thigh, bone and skin removed',52,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5098,1,3,'oz',85,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5098,2,1,'thigh without skin',116,'g',1,'1997-08-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5098,3,1,'thigh with skin',137,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5099,1,1,'cup, chopped or diced',140,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5099,2,1,'unit (yield from 1 lb ready-to-cook chicken)',33,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5099,3,1,'thigh, bone and skin removed',55,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5100,1,4,'oz',113,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5100,2,1,'piece',107,'g',1,'1997-08-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5100,3,1,'package',1150,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5101,1,1,'unit (yield from 1 lb ready-to-cook chicken)',29,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5101,2,1,'wing, bone removed',49,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5102,1,1,'unit (yield from 1 lb ready-to-cook chicken)',19,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5102,2,1,'wing, bone removed',32,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5103,1,3,'oz',85,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5103,2,1,'piece',85,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5104,1,1,'cup, chopped or diced',140,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5104,2,1,'unit (yield from 1 lb ready-to-cook chicken)',24,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5104,3,1,'wing, bone removed',40,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5105,1,1,'wing, bone and skin removed (yield from 1 lb ready-to-cook chicken)',17,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5105,2,1,'wing, bone and skin removed',29,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5106,1,3,'oz',85,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5106,2,1,'unit (yield from 1 lb ready-to-cook chicken)',12,'g',1,'1997-08-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5106,3,1,'wing, bone and skin removed',20,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5107,1,1,'unit (yield from 1 lb ready-to-cook chicken)',13,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5107,2,1,'wing, bone and skin removed',21,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5108,1,3,'oz',85,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5108,2,1,'cup, chopped or diced',140,'g',1,'1997-08-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5108,3,1,'unit (yield from 1 lb ready-to-cook chicken)',14,'g',1,'2002-09-06','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5108,4,1,'wing, bone and skin removed',24,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5109,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5109,2,1,'chicken',1509,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5110,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5110,2,1,'unit (yield from 1 lb ready-to-cook chicken)',235,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5110,3,1,'chicken',1072,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5111,1,3,'oz',85,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (5111,2,1,'breast',635,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (5111,3,1,'bird',4405,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (5112,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5112,2,1,'unit (yield from 1 lb ready-to-cook chicken)',210,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5112,3,0.5,'chicken, bone removed',480,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5113,1,3,'oz',85,'g',1,'2001-07-04','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5113,2,1,'unit (yield from 1 lb ready-to-cook chicken)',209,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5113,3,0.5,'chicken, bone and skin removed',477,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5114,1,1,'cup, chopped or diced',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5114,2,1,'unit (yield from 1 lb ready-to-cook chicken)',171,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5115,1,1,'unit (yield from 1 lb ready-to-cook chicken)',25,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5115,2,1,'giblets',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5116,1,1,'cup, chopped or diced',145,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5116,2,1,'unit (yield from 1 lb ready-to-cook chicken)',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5117,1,1,'unit (yield from 1 lb ready-to-cook chicken)',99,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5117,2,0.5,'chicken, bone and skin removed',220,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5118,1,1,'cup, chopped or diced',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5118,2,1,'unit (yield from 1 lb ready-to-cook chicken)',78,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5119,1,1,'unit (yield from 1 lb ready-to-cook chicken)',113,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5119,2,0.5,'chicken, bone and skin removed',258,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5120,1,1,'cup, chopped or diced',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5120,2,1,'unit (yield from 1 lb ready-to-cook chicken)',94,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5121,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5121,2,1,'chicken',905,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5122,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5122,2,1,'cup, chopped or diced',160,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5122,3,1,'unit (yield from 1 lb ready-to-cook chicken)',202,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5122,4,1,'chicken, bone removed',593,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5123,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5123,2,1,'unit (yield from 1 lb ready-to-cook chicken)',271,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5123,3,0.5,'chicken, bone removed',398,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5124,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5124,2,1,'unit (yield from 1 lb ready-to-cook chicken)',178,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5124,3,0.5,'chicken, bone removed',261,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5125,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5125,2,1,'unit (yield from 1 lb ready-to-cook chicken)',194,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5125,3,0.5,'chicken, bone and skin removed',284,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5126,1,3,'oz',85,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5126,2,1,'cup, chopped or diced',140,'g',1,'1997-08-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5126,3,1,'unit (yield from 1 lb ready-to-cook chicken)',137,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5127,1,1,'unit (yield from 1 lb ready-to-cook chicken)',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5127,2,1,'giblets',81,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5128,1,1,'cup, chopped or diced',145,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5128,2,1,'unit (yield from 1 lb ready-to-cook chicken)',17,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5129,1,1,'unit (yield from 1 lb ready-to-cook chicken)',89,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5129,2,0.5,'chicken, bone and skin removed',130,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5130,1,1,'cup, chopped or diced',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5130,2,1,'unit (yield from 1 lb ready-to-cook chicken)',64,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5131,1,1,'unit (yield from 1 lb ready-to-cook chicken)',105,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5131,2,0.5,'chicken, bone and skin removed',154,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5132,1,1,'cup, chopped or diced',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5132,2,1,'unit (yield from 1 lb ready-to-cook chicken)',73,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5133,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5133,2,1,'capon',2152,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5134,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5134,2,1,'capon',1418,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5134,3,1,'unit (yield from 1 lb ready-to cook capon)',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5135,1,3,'oz',85,'g',1,'2001-07-04','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5135,2,1,'unit (yield from 1 lb ready-to cook capon)',297,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5135,3,0.5,'capon, bone removed',964,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5136,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5136,2,1,'unit (yield from 1 lb ready-to cook capon)',196,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5136,3,0.5,'capon, bone removed',637,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5137,1,1,'giblets',115,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5137,2,1,'unit (yield from 1 lb ready-to cook capon)',18,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5138,1,1,'cup, chopped or diced',145,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5138,2,1,'unit (yield from 1 lb ready-to cook capon)',11,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5139,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5139,2,1,'unit (yield from 1 lb ready-to-cook duck)',287,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5139,3,0.5,'duck',634,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5140,1,1,'cup, chopped or diced',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5140,2,1,'unit (yield from 1 lb ready-to-cook duck)',173,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5140,3,0.5,'duck',382,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5141,1,1,'unit (yield from 1 lb ready-to-cook duck)',137,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5141,2,0.5,'duck',303,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5142,1,1,'cup, chopped or diced',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5142,2,1,'unit (yield from 1 lb ready-to-cook duck)',100,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (5142,3,0.5,'duck',221,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5143,1,1,'liver',44,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5143,2,1,'unit (yield from 1 lb ready-to-cook duck)',10,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5144,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5144,2,1,'unit (yield from 1 lb ready-to-cook duck)',239,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5144,3,0.5,'duck',270,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5145,1,1,'unit (yield from 1 lb ready-to-cook duck)',73,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5145,2,0.5,'breast, bone and skin removed',83,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5146,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5146,2,1,'unit (yield from 1 lb ready-to-cook goose)',320,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5146,3,0.5,'goose',1319,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5147,1,1,'cup, chopped or diced',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5147,2,1,'unit (yield from 1 lb ready-to-cook goose)',188,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5147,3,0.5,'goose',774,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5148,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5148,2,1,'unit (yield from 1 lb ready-to-cook goose)',185,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5148,3,0.5,'goose',766,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5149,1,1,'unit (yield from 1 lb ready-to-cook goose)',143,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5149,2,0.5,'goose',591,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5150,1,1,'liver',94,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5150,2,1,'unit (yield from 1 lb ready-to-cook goose)',11,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5151,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5151,2,1,'unit (yield from 1 lb ready-to-cook guinea)',359,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5151,3,0.5,'guinea',345,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5152,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5152,2,1,'unit (yield from 1 lb ready-to-cook guinea)',275,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5152,3,0.5,'guinea',264,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5153,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5153,2,1,'unit (yield from 1 lb ready-to-eat pheasant)',371,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5153,3,0.5,'pheasant',400,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5154,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5154,2,1,'unit (yield from 1 lb ready-to-eat pheasant)',326,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5154,3,0.5,'pheasant',352,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5155,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5155,2,1,'unit (yield from 1 lb ready-to-eat pheasant)',169,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5155,3,0.5,'breast, bone and skin removed',182,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5156,1,1,'unit (yield from 1 lb ready-to-eat pheasant)',99,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5156,2,1,'leg, bone and skin removed',107,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5157,1,1,'quail',109,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5157,2,1,'unit (yield from 1 lb ready-to cook quail)',405,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5158,1,1,'quail',92,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5158,2,1,'unit (yield from 1 lb ready-to cook quail)',342,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5159,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5159,2,1,'unit (yield from 1 lb ready-to cook quail)',208,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5159,3,1,'breast',56,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5160,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5160,2,1,'unit (yield from 1 lb ready-to-cook squab)',297,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5160,3,1,'squab',199,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5161,1,1,'unit (yield from 1 lb ready-to-cook squab)',251,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5161,2,1,'squab',168,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5162,1,1,'breast, bone removed',101,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5162,2,1,'unit (yield from 1 lb ready-to-cook squab)',151,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5165,1,4,'oz',113,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5165,2,1,'bird',5002,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5166,1,3,'oz',85,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5166,2,1,'bird',3812,'g',1,'1998-01-15','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5167,1,4,'oz',113,'g',1,'1997-08-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5167,2,1,'bird',5002,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5168,1,3,'oz',85,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5168,2,1,'bird',3812,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5169,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5169,2,1,'lb',453,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5170,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5171,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5171,2,1,'giblets',157,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5172,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5172,2,1,'giblets',95,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5173,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5173,2,1,'raw gizzard',63,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5174,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5174,2,1,'gizzard cooked',45,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5175,1,4,'oz',113,'g',1,'2011-01-18','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5175,2,1,'piece',24,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5176,1,3,'oz',85,'g',1,'2011-01-18','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5176,2,1,'heart',20,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5177,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5177,2,1,'raw liver',78,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5178,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5178,2,1,'liver cooked',53,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5179,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5179,2,1,'lb',453,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5180,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5181,1,4,'oz',113,'g',1,'1997-08-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5181,2,1,'lb',453,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5182,1,3,'oz',85,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5183,1,4,'oz',113,'g',1,'1997-08-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5183,2,1,'lb',453,'g',1,'1994-01-31','2015-01-07');
INSERT INTO `cndb_wght` VALUES (5184,1,3,'oz',85,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5185,1,1,'serving',85,'g',1,'1997-08-29','2015-01-07');
INSERT INTO `cndb_wght` VALUES (5186,1,3,'oz',85,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5187,1,4,'oz',113,'g',1,'1997-08-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5187,2,1,'serving',85,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5188,1,3,'oz',85,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5190,1,1,'cup, chopped or diced',140,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5190,2,0.5,'back, bone removed',262,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5190,3,1,'unit (yield from 1 lb ready-to-cook turkey)',34,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5191,1,1,'unit (yield from 1 lb ready-to-cook turkey)',146,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5191,2,0.5,'breast, bone removed',1132,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5192,1,3,'oz',85,'g',1,'1997-08-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5192,2,0.5,'unit (yield from 1 lb ready-to-cook turkey)',112,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5192,3,0,'breast, bone removed',864,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5193,1,1,'unit (yield from 1 lb ready-to-cook turkey)',105,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5193,2,1,'leg, bone removed',816,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5194,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5194,2,1,'unit (yield from 1 lb ready-to-cook turkey)',71,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5194,3,1,'leg, bone removed',546,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5195,1,1,'unit (yield from 1 lb ready-to-cook turkey)',33,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5195,2,1,'wing, bone removed',256,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5196,1,3,'oz',85,'g',1,'1996-09-30','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5196,2,1,'unit (yield from 1 lb ready-to-cook turkey)',24,'g',1,'1998-01-15','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5196,3,1,'wing, bone removed',186,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5200,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5200,2,0.5,'turkey, bone removed',808,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5200,3,1,'unit (yield from 1 lb ready-to-cook turkey)',229,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5216,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5216,2,1,'back',911,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5219,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5219,2,1,'breast',1769,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5220,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5220,2,1,'breast',1413,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5227,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5227,2,1,'wing',346,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5228,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5228,2,1,'wing',213,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5236,1,1,'unit (yield from 1 lb ready-to-cook turkey)',31,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5236,2,0.5,'turkey, skin only',196,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5277,1,3,'oz',85,'g',1,'1997-08-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5277,2,1,'can (5 oz)',142,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5282,1,1,'tbsp',13,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5282,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5284,1,3,'oz',85,'g',1,'1994-09-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5284,2,1,'cup, drained',135,'g',1,'1997-08-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5284,3,1,'can (5 oz)',142,'g',1,'2002-09-06','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5284,4,1,'can (5 oz) yields',125,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5285,1,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5285,2,0.5,'lb',227,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5286,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5286,2,1,'package (net weight, 5 oz)',142,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5293,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5293,2,0.5,'breast, bone removed',864,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5294,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5294,2,1,'thigh, bone removed',314,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5295,1,3,'oz',85,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5295,2,1,'box (net weight, 2.5 lb)',1134,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5300,1,1,'stick (2.25 oz)',64,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5301,1,0.5,'lb',227,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5302,1,0.5,'lb',227,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (5303,1,0.5,'lb',227,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5304,1,0.5,'lb',227,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5305,1,4,'oz',113,'g',1,'1999-03-22','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5305,2,1,'lb',453.6,'g',1,'2002-09-06','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5305,3,1,'patty, 4 oz',114,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5306,1,3,'oz',85,'g',1,'1997-08-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5306,2,1,'patty (4 oz, raw) (yield after cooking)',82,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5306,3,1,'unit, yield from 1 lb raw',330,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5307,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5307,2,0.5,'bird',168,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5308,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5308,2,0.5,'bird',129,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5308,3,1,'bird whole',257,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5309,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5309,2,0.5,'bird',120,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5309,3,1,'bird whole',239,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5310,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5310,2,0.5,'bird',110,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5310,3,1,'bird whole',220,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5311,1,3,'oz',85,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5311,2,1,'cup',205,'g',1,'2004-07-15','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5311,3,1,'can (5 oz) yields',125,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5312,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5312,2,1,'piece',29,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5312,3,1,'serving',86,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5313,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5313,2,1,'serving',74,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5314,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5314,2,1,'piece',263,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5314,3,0.5,'breast',118,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (5315,1,1,'unit (yield from 1 lb ready-to-cook duck)',56,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5315,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5315,3,0.5,'breast, bone removed',120,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5316,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5316,2,0.5,'breast, bone and skin removed',95,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5316,3,1,'cup, chopped or diced',174,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5316,4,1,'unit (yield from 1 lb ready-to-cook duck)',44,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5317,1,1,'leg, bone removed (yield after cooking)',92,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5317,2,1,'unit (yield from 1 lb ready-to-cook duck)',43,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5317,3,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5318,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5318,2,1,'cup chopped or diced, cooked',174,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5318,3,1,'unit (yield from 1 lb ready-to-cook duck)',35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5318,4,1,'leg, bone and skin removed',75,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5319,1,3,'oz',85,'g',1,'2013-02-22','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5319,2,1,'drumstick',71,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5320,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5320,2,1,'serving',96,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5323,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5323,2,1,'patty',60,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5324,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5324,2,1,'patty',60,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5326,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5326,2,1,'piece',15,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5326,3,4,'pieces',62,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5327,1,3,'oz',85,'g',1,'2016-02-06','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5327,2,1,'piece',15,'g',1,'2016-02-06','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5327,3,4,'pieces',62,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5332,1,4,'oz crumbled',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5333,1,3,'oz crumbled',85,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (5334,1,3,'oz',85,'g',1,'2013-02-22','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5334,2,1,'thigh',95,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5335,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5335,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5339,1,3,'oz',85,'g',1,'2013-02-22','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5339,2,1,'wing',51,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5341,1,1,'serving (3 oz)',85,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (5341,2,1,'back',102,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (5341,3,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5342,1,3,'oz',85,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (5342,2,1,'breast breast with skin and bone',483,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (5342,3,1,'oz',28.35,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (5343,1,1,'drumstick',53,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5343,2,1,'serving (3oz)',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5343,3,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5344,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5345,1,1,'thigh',89,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5345,2,1,'serving (3 oz)',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5345,3,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5346,1,1,'wing',53,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5346,2,1,'serving (3 oz)',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5346,3,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5347,1,1,'back',102,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5347,2,1,'serving (3 oz)',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5347,3,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5348,1,1,'serving (3 oz)',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5348,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5348,3,1,'breast',343,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5349,1,1,'drumstick',53,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5349,2,1,'serving (3 oz)',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5349,3,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5351,1,1,'thigh',89,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5351,2,1,'serving',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5352,1,1,'wing',53,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5352,2,1,'serving (3 oz)',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5352,3,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5356,1,1,'serving',85,'g',1,'2013-02-22','2013-02-22');
INSERT INTO `cndb_wght` VALUES (5357,1,3,'oz',85,'g',1,'2013-02-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5357,2,1,'back',182,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5358,1,3,'oz',85,'g',1,'2013-02-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5358,2,1,'breast',384,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5359,1,3,'oz',85,'g',1,'2013-02-22','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5359,2,1,'drumstick',71,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5361,1,3,'oz',85,'g',1,'2013-02-22','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5361,2,1,'thigh',95,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5362,1,3,'oz',85,'g',1,'2013-02-22','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5362,2,1,'wing',51,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5363,1,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (5363,2,1,'breast',219,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (5363,3,1,'bird',627,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (5621,1,1,'patty',117,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5622,1,1,'patty (yield from 135.8 g raw meat)',109,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5622,2,1,'serving ( 3 oz )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5623,1,1,'serving ( 3 oz )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5623,2,1,'fan fillet',513,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5624,1,1,'serving ( 3 oz )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5624,2,1,'steak',394,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5625,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5625,2,1,'flat fillet',354,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5626,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5626,2,1,'full rump',695,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5627,1,1,'serving ( 3 oz )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5627,2,1,'full rump cooked ( yield from 695 g raw meat )',496,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5628,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5628,2,1,'inside drum',572,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5629,1,1,'serving ( 3 oz )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5629,2,1,'inside drum cooked ( yield from 572 g raw meat )',416,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5630,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5630,2,1,'outside drum',422,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5631,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5631,2,1,'steak',300,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5632,1,1,'serving ( 3 oz )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5632,2,1,'steak',244,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5641,1,1,'patty',109,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5641,2,4,'patty',435,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5642,1,1,'patty',93,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5642,2,1,'serving ( 3 oz )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5643,1,1,'serving ( cooked from 4oz raw)',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5643,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5644,1,1,'serving ( cooked from 4 oz raw )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5644,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5645,1,1,'serving ( 3 oz )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5646,1,1,'serving (cooked from 4 oz raw)',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5646,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5647,1,1,'serving ( 3 oz )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5648,1,1,'serving (cooked from 4 oz raw)',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5648,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5649,1,1,'serving (cooked from 4 oz raw)',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5649,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5650,1,1,'serving ( 3 oz )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5651,1,1,'serving ( cooked from 4 oz raw)',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5651,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5652,1,1,'serving ( 3 oz )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5653,1,1,'serving (cooked from 4 oz raw)',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5653,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5653,3,1,'lb',453,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5654,1,1,'serving (cooked from 4 oz raw)',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5654,2,1,'lb',456,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5654,3,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5655,1,1,'serving ( cooked from 4 oz raw)',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5655,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5655,3,1,'lb',453,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5656,1,1,'serving ( 3 oz )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5657,1,1,'serving (cooked from 4 oz raw)',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5657,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5657,3,1,'lb',453,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5658,1,1,'serving ( 3 oz )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5661,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5661,2,1,'liver',44,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5662,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5662,2,1,'patty (cooked from 4 oz raw)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5662,3,1,'lb',453,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5663,1,3,'oz',85,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (5664,1,3,'oz',85,'g',1,'2011-01-18','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5664,2,1,'patty',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5665,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5665,2,1,'lb',453,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5665,3,1,'serving (cooked from 4 oz)',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5666,1,3,'oz',85,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (5667,1,3,'oz',85,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (5668,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5668,2,1,'patty (cooked from 4 oz raw)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5668,3,1,'lb',453,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5669,1,3,'oz',85,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (5670,1,3,'oz',85,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (5671,1,3,'oz',85,'g',1,'2012-03-02','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5671,2,1,'drumstick without skin',95,'g',1,'2012-03-02','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5671,3,1,'drumstick with skin',105,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5672,1,3,'oz',85,'g',1,'2012-03-02','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5672,2,1,'thigh without skin',111,'g',1,'2012-03-02','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5672,3,1,'thigh with skin',129,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5673,1,3,'oz',85,'g',1,'2012-03-02','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5673,2,1,'lb',453,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (5674,1,4,'oz',113,'g',1,'2012-03-02','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5674,2,1,'lb',453,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (5675,1,3,'oz',85,'g',1,'2012-03-02','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5675,2,1,'lb',453,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (5676,1,3,'oz',85,'g',1,'2012-03-02','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5676,2,1,'drumstick without skin',95,'g',1,'2012-03-02','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5676,3,1,'drumstick with skin',105,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5677,1,3,'oz',85,'g',1,'2012-03-02','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5677,2,1,'thigh without skin',111,'g',1,'2012-03-02','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5677,3,1,'thigh with skin',129,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5678,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5678,2,1,'drumstick with skin',143,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5678,3,1,'drumstick without skin',136,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5679,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5679,2,1,'drumstick without skin',91,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5679,3,1,'drumstick with skin',129,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5680,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5680,2,1,'drumstick without skin',95,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5680,3,1,'drumstick with skin',106,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5681,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5681,2,1,'thigh without skin',132,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5681,3,1,'thigh with skin',158,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5682,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5682,2,1,'thigh without skin',148,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5682,3,1,'thigh with skin',191,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5683,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5683,2,1,'thigh with skin',130,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5683,3,1,'thigh without skin',112,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5684,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5685,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5686,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5687,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5687,2,1,'drumstick with skin',106,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5687,3,1,'drumstick without skin',95,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5688,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5688,2,1,'drumstick with skin',143,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5688,3,1,'drumstick without skin',130,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5689,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5689,2,1,'drumstick with skin',129,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5689,3,1,'drumstick without skin',91,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5690,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5690,2,1,'thigh without skin',132,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5690,3,1,'thigh with skin',158,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5691,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5691,2,1,'thigh without skin',148,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5691,3,1,'thigh',181,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5692,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5692,2,1,'thigh with skin',130,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5692,3,1,'thigh without skin',112,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5693,1,3,'oz',85,'g',1,'2013-02-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5693,2,1,'back',182,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5694,1,4,'oz',113,'g',1,'2013-02-22','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5695,1,3,'oz',85,'g',1,'2013-02-22','2016-02-06');
INSERT INTO `cndb_wght` VALUES (5696,1,4,'oz',113,'g',1,'2013-02-22','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5697,1,3,'oz',85,'g',1,'2013-02-22','2016-02-06');
INSERT INTO `cndb_wght` VALUES (5698,1,4,'oz',113,'g',1,'2013-02-22','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5699,1,1,'oz',28.35,'g',1,'2013-02-22','2016-02-06');
INSERT INTO `cndb_wght` VALUES (5700,1,4,'oz',113,'g',1,'2013-02-22','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5700,2,1,'lb',453,'g',1,'2013-02-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5701,1,3,'oz',85,'g',1,'2013-02-22','2016-02-06');
INSERT INTO `cndb_wght` VALUES (5702,1,4,'oz',113,'g',1,'2013-02-22','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5702,2,1,'lb',453,'g',1,'2013-02-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5703,1,3,'oz',85,'g',1,'2013-02-22','2016-02-06');
INSERT INTO `cndb_wght` VALUES (5703,2,1,'lb',453,'g',1,'2013-02-22','2013-02-22');
INSERT INTO `cndb_wght` VALUES (5704,1,4,'oz',113,'g',1,'2013-02-22','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5704,2,1,'bird',5717,'g',1,'2013-02-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5705,1,3,'oz',85,'g',1,'2013-02-22','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5705,2,1,'bird',4147,'g',1,'2013-02-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5706,1,4,'oz',113,'g',1,'2013-02-22','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5706,2,1,'bird',5717,'g',1,'2013-02-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5707,1,3,'oz',85,'g',1,'2013-02-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5707,2,1,'bird',4147,'g',1,'2013-02-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5707,3,1,'lb',453,'g',1,'2013-02-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (5708,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5708,2,1,'breast',1171,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5709,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5709,2,1,'breast',852,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5710,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5710,2,1,'breast',1150,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5711,1,1,'breast',863,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5711,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5712,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5712,2,1,'wing',518,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5713,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5713,2,1,'wing',375,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5714,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5715,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5716,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5716,2,1,'drumstick',356,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5717,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5717,2,1,'thigh',454,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5718,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5718,2,1,'breast',1654,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5719,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5719,2,1,'back',1245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5720,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5720,2,1,'back',949,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5721,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5721,2,1,'breast',2110,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5721,3,1,'lb',453,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5722,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5722,2,1,'thigh',348,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5723,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5723,2,1,'drumstick',275,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5724,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5724,2,1,'drumstick',359,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5725,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5725,2,1,'drumstick',217,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5726,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5726,2,1,'thigh',424,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5727,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5727,2,1,'breast',1171,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5728,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5728,2,1,'thigh',327,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5729,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5729,2,1,'wing',358,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5730,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5730,2,1,'wing',219,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5732,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5732,2,1,'breast',1150,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5733,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5733,2,1,'breast',863,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5734,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5734,2,1,'wing',518,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5735,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5735,2,1,'wing',375,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5736,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5736,2,1,'drumstick',356,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5737,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5737,2,1,'drumstick',275,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5738,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5738,2,1,'drumstick',337,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5739,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5739,2,1,'drumstick',206,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5740,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5740,2,1,'thigh',367,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5741,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5741,2,1,'thigh',319,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5742,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5742,2,1,'thigh',454,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5743,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5743,2,1,'thigh',348,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5744,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (5744,2,1,'back',1245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5745,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5745,2,1,'back',949,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5746,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5746,2,1,'piece',181,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5747,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5747,2,1,'piece',196,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5748,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5748,2,1,'piece',195,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5749,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (5749,2,1,'piece',192,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6001,1,0.5,'cup (4 fl oz)',126,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6001,2,1,'can (10.75 oz)',305,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6002,1,1,'cup (8 fl oz)',257,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6002,2,1,'can (11 oz), undiluted',312,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6004,1,0.5,'cup',130,'g',1,'1996-09-30','2013-12-26');
INSERT INTO `cndb_wght` VALUES (6004,2,1,'can 11.5 oz',326,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (6006,1,1,'cup (8 fl oz)',263,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6006,2,1,'can (11.25 oz)',319,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6007,1,1,'cup (8 fl oz)',243,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6007,2,1,'can (19.25 oz)',546,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6008,1,1,'cup',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6008,2,1,'can 14.5 oz',435,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6008,3,1,'container 32 oz',960,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6009,1,0.5,'CUP',125,'g',1,'1996-09-30','2009-02-11');
INSERT INTO `cndb_wght` VALUES (6009,2,1,'can (10.75 oz)',305,'g',1,'1998-01-15','2009-02-11');
INSERT INTO `cndb_wght` VALUES (6010,1,0.5,'cup',126,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6010,2,1,'can (10.75 oz)',305,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6011,1,0.5,'cup',124,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6013,1,0.5,'cup (4 fl oz)',126,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6013,2,1,'can (10.75 oz)',305,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6015,1,1,'cup',245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6016,1,0.5,'cup (4 fl oz)',126,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6016,2,1,'can (10.75 oz)',305,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6017,1,0.5,'cup (4 fl oz)',126,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6017,2,1,'can (10.75 oz)',305,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6018,1,1,'can',530,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6018,2,1,'cup',243,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6019,1,0.5,'cup',124,'g',1,'2013-12-23','2015-06-19');
INSERT INTO `cndb_wght` VALUES (6022,1,1,'cup',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6022,2,1,'can 19 oz',539,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6023,1,0.5,'cup',126,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6024,1,1,'cup',255,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6025,1,0.5,'cup',121,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6025,2,1,'can (10.7 oz)',303,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6026,1,1,'cup (8 fl oz)',263,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6026,2,1,'can (11.25 oz)',319,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6027,1,1,'cup (8 fl oz)',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6027,2,1,'can (19 oz)',539,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6028,1,0.5,'cup (4 fl oz)',126,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6028,2,1,'can (10.75 oz)',305,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6030,1,0.5,'cup',126,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6030,2,1,'can (10.7 oz)',303,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6032,1,0.5,'CUP',124,'g',1,'1994-01-31','2009-02-11');
INSERT INTO `cndb_wght` VALUES (6032,2,1,'can (10.5 oz)',310,'g',1,'1997-08-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (6037,1,1,'cup (8 fl oz)',248,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6037,2,1,'can (20 oz)',567,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6039,1,1,'cup',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6039,2,1,'can (19 oz)',539,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6040,1,0.5,'cup (4 fl oz)',123,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6040,2,1,'can (10.5 oz)',298,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6042,1,0.5,'cup (4 fl oz)',126,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6042,2,1,'can (10.75 oz)',305,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6043,1,0.5,'CUP',126,'g',1,'1994-09-29','2015-06-19');
INSERT INTO `cndb_wght` VALUES (6044,1,0.5,'cup (4 fl oz)',126,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6044,2,1,'can (10.75 oz)',305,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6045,1,0.5,'cup (4 fl oz)',123,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6045,2,1,'can (10.5 oz)',298,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6046,1,0.5,'cup',126,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6046,2,1,'can (10.75 oz)',305,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6048,1,0.5,'cup (4 fl oz)',123,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6048,2,1,'can (10.5 oz)',298,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6049,1,0.5,'cup',128,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6049,2,1,'can (11.2 oz)',319,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6050,1,1,'cup',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6050,2,1,'can (19 oz)',539,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6051,1,0.5,'cup (4 fl oz)',135,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6051,2,1,'can (11.5 oz)',326,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6053,1,0.5,'cup',124,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6056,1,0.5,'cup',126,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (6056,2,1,'can',305,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (6061,1,1,'cup (8 fl oz)',251,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6061,2,1,'can (10.75 oz)',305,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6063,1,0.5,'cup (4 fl oz)',129,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6063,2,1,'can (11 oz), undiluted',312,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6064,1,1,'cup (8 fl oz)',236,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6064,2,1,'can (18.75 oz)',532,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6067,1,1,'cup',230,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6068,1,0.5,'cup',126,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6068,2,1,'can (10.5 oz)',298,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6070,1,1,'cup',245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6070,2,1,'can (19 oz)',539,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6071,1,0.5,'cup',126,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6071,2,1,'can (10.75 oz)',305,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6072,1,0.5,'cup',123,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6072,2,1,'can (10.5 oz)',298,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6075,1,1,'cube',3.6,'g',1,'1997-08-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (6075,2,1,'packet',6,'g',1,'1994-09-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (6076,1,1,'cube',3.6,'g',1,'1994-01-31','2009-02-11');
INSERT INTO `cndb_wght` VALUES (6080,1,1,'cube',4,'g',1,'1997-08-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (6080,2,1,'teaspoon',2,'g',1,'1994-09-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (6081,1,1,'cube',4.8,'g',1,'1997-08-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (6094,1,1,'serving 1 tbsp',7.5,'g',1,'1994-09-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (6094,2,1,'packet',39,'g',1,'1997-08-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (6101,1,1,'packet',18,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6112,1,1,'tbsp',18,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (6112,2,1,'fl oz',36,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (6112,3,1,'cup',288,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (6114,1,0.25,'CUP',59,'g',1,'1994-01-31','2015-01-07');
INSERT INTO `cndb_wght` VALUES (6114,2,1,'can',298,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6115,1,1,'tsp',3,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6116,1,1,'CUP',233,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6116,2,1,'can',291,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6118,1,1,'tbsp',6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6119,1,0.25,'CUP',57,'g',1,'1994-01-31','2016-02-06');
INSERT INTO `cndb_wght` VALUES (6119,2,1,'cup',228,'g',1,'2002-09-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (6119,3,1,'jar 10.5 oz',273,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (6119,4,1,'jar 12 oz',324,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (6120,1,1,'tbsp',8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6120,2,1,'serving',8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6121,1,1,'cup',238,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6121,2,1,'can',298,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6122,1,1,'cup (8 fl oz)',21,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6123,1,1,'cup (8 fl oz)',24,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6124,1,1,'serving',6.7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6125,1,1,'CUP',238,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6125,2,1,'TBSP',14.9,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6125,3,1,'tsp',5,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6125,4,1,'can',298,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6126,1,1,'serving',7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6127,1,1,'cup (8 fl oz)',25,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6128,1,1,'packet',74,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6128,2,1,'packet (6 fl oz)',11.1,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6147,1,0.5,'cup (4 fl oz)',126,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6147,2,1,'can (10.75 oz)',305,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6149,1,0.5,'cup',124,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6150,1,1,'tbsp',17,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6150,2,0.5,'cup',143,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6150,3,1,'cup',279,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6151,1,1,'tbsp',19,'g',1,'1996-09-30','2013-12-26');
INSERT INTO `cndb_wght` VALUES (6151,2,1,'cup',305,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (6152,1,0.25,'cup',63,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6158,1,0.5,'cup (4 fl oz)',129,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6158,2,1,'can (11 oz), undiluted',312,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6159,1,1,'cup',148,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6159,2,1,'can',294,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6164,1,2,'tbsp',36,'g',1,'1994-11-02','2015-01-07');
INSERT INTO `cndb_wght` VALUES (6164,2,0.5,'cup',130,'g',1,'1997-08-29','2015-01-07');
INSERT INTO `cndb_wght` VALUES (6164,3,1,'cup',259,'g',1,'2007-11-28','2015-01-07');
INSERT INTO `cndb_wght` VALUES (6166,1,1,'cup',250,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6166,2,0.5,'cup',125,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6167,1,1,'cup',250,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6167,2,0.5,'cup',125,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6168,1,1,'tsp',4.7,'g',1,'1994-11-17','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6168,2,0.25,'tsp',1.2,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (6170,1,1,'cup',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6172,1,1,'CUP',240,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6174,1,1,'cup',233,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6175,1,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6176,1,1,'tbsp',18,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6177,1,1,'cup',245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6179,1,1,'tbsp',18,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6180,1,1,'cup',216,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6182,1,1,'cup',251,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6183,1,1,'cup',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6188,1,1,'cup',219,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (6188,2,1,'can (14.5 oz)',407,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (6188,3,1,'carton (32 oz)',923,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (6189,1,2,'Tbsp',36,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6190,1,1,'cup',245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6192,1,1,'CUP',253,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6193,1,1,'cup',245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6194,1,1,'cup',249,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6201,1,1,'cup (8 fl oz)',248,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6201,2,1,'can (10.75 oz), prepared',602,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6208,1,1,'cup',245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6210,1,1,'cup (8 fl oz)',248,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6210,2,1,'can (10.75 oz), prepared',602,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6211,1,1,'CUP',251,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6211,2,1,'can (11 oz), prepared',609,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6216,1,1,'cup (8 fl oz)',248,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6216,2,1,'FL OZ',31,'g',1,'1997-08-29','2010-01-05');
INSERT INTO `cndb_wght` VALUES (6216,3,1,'can (10.75 oz), prepared',602,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6217,1,0.5,'cup',126,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6230,1,1,'serving 1 cup',252,'g',1,'1994-09-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (6230,2,1,'FL OZ',31.5,'g',1,'1999-03-22','2010-01-05');
INSERT INTO `cndb_wght` VALUES (6243,1,1,'serving 1 cup',252,'g',1,'1994-01-31','2009-02-11');
INSERT INTO `cndb_wght` VALUES (6243,2,1,'FL OZ',31.5,'g',1,'1997-08-29','2010-01-05');
INSERT INTO `cndb_wght` VALUES (6246,1,1,'cup (8 fl oz)',248,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6246,2,1,'can (10.75 oz), prepared',602,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6248,1,1,'cup (8 fl oz)',245,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6248,2,1,'can (10.5 oz), prepared',595,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6249,1,1,'cup (8 fl oz)',254,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6249,2,1,'can (11.25 oz), prepared',616,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6253,1,1,'cup (8 fl oz)',248,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6253,2,1,'can (10.75 oz), prepared',602,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6256,1,1,'cup (8 fl oz)',253,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6256,2,1,'fl oz',31.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6358,1,1,'cup (8 fl oz)',251,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6358,2,1,'can (11 oz), prepared',609,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6359,1,1,'serving 1 cup',252,'g',1,'1994-01-31','2009-02-11');
INSERT INTO `cndb_wght` VALUES (6359,2,1,'FL OZ',31.5,'g',1,'1997-08-29','2010-01-05');
INSERT INTO `cndb_wght` VALUES (6401,1,1,'cup (8 fl oz)',244,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6401,2,1,'can (10.75 oz), prepared',593,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6402,1,1,'CUP',247,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6402,2,1,'can (11 oz), prepared',600,'g',1,'2002-09-06','2009-02-11');
INSERT INTO `cndb_wght` VALUES (6404,1,1,'serving 1 cup',266,'g',1,'1994-01-31','2009-02-11');
INSERT INTO `cndb_wght` VALUES (6404,2,1,'FL OZ',33.3,'g',1,'1997-08-29','2010-01-05');
INSERT INTO `cndb_wght` VALUES (6406,1,1,'cup (8 fl oz)',250,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6406,2,1,'can (11.25 oz), prepared',607,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6409,1,1,'cup (8 fl oz)',244,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6409,2,1,'can (10.75 oz), prepared',593,'g',1,'1997-08-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (6410,1,1,'cup',248,'g',1,'1994-09-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (6410,2,1,'can (10.75 oz), prepared',593,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6411,1,1,'cup (8 fl oz)',247,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6411,2,1,'can (11 oz), prepared',600,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6413,1,1,'cup (8 fl oz)',244,'g',1,'1994-09-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (6413,2,1,'can (10.75 oz), prepared',593,'g',1,'1999-03-22','2009-02-11');
INSERT INTO `cndb_wght` VALUES (6416,1,1,'CUP',244,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6416,2,1,'FL OZ',30.5,'g',1,'2002-09-06','2010-01-05');
INSERT INTO `cndb_wght` VALUES (6416,3,1,'can (10.75 oz), prepared',593,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6417,1,1,'CUP',244,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6417,2,1,'can (10.75 oz), prepared',593,'g',1,'2002-09-06','2009-02-11');
INSERT INTO `cndb_wght` VALUES (6419,1,1,'serving 1 cup',248,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (6423,1,1,'serving 1 cup',243,'g',1,'1994-01-31','2009-02-11');
INSERT INTO `cndb_wght` VALUES (6426,1,1,'CUP',261,'g',1,'1994-09-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (6426,2,1,'FL OZ',32.6,'g',1,'2002-09-06','2010-01-05');
INSERT INTO `cndb_wght` VALUES (6428,1,1,'serving 1 cup',249,'g',1,'1994-01-31','2009-02-11');
INSERT INTO `cndb_wght` VALUES (6428,2,1,'FL OZ',31.1,'g',1,'1997-08-29','2010-01-05');
INSERT INTO `cndb_wght` VALUES (6430,1,1,'serving 1 cup',248,'g',1,'1994-09-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (6430,2,1,'FL OZ',31,'g',1,'2002-09-06','2010-01-05');
INSERT INTO `cndb_wght` VALUES (6432,1,1,'cup (8 fl oz)',241,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6432,2,1,'can (10.5 oz), prepared',586,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6440,1,1,'cup (8 fl oz)',241,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6440,2,1,'can (10.5 oz), prepared',586,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6442,1,1,'cup (8 fl oz)',244,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6442,2,1,'can (10.75 oz), prepared',593,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6443,1,1,'serving 1 cup',248,'g',1,'1994-09-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (6443,2,1,'FL OZ',31,'g',1,'1997-08-29','2010-01-05');
INSERT INTO `cndb_wght` VALUES (6444,1,1,'cup (8 fl oz)',244,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6444,2,1,'can (10.75 oz), prepared',593,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6446,1,1,'cup (8 fl oz)',244,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6446,2,1,'can (10.75 oz), prepared',593,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6448,1,1,'cup (8 fl oz)',241,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6448,2,1,'can (10.5 oz), prepared',586,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6449,1,1,'serving 1 cup',259,'g',1,'1994-09-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (6449,2,1,'FL OZ',32.4,'g',1,'2002-09-06','2010-01-05');
INSERT INTO `cndb_wght` VALUES (6451,1,1,'cup (8 fl oz)',253,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6451,2,1,'can (11.5 oz), prepared',614,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6453,1,1,'cup (8 fl oz)',244,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6453,2,1,'can (10.75 oz), prepared',593,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6456,1,1,'cup',244,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6456,2,1,'can (10.75 oz), prepared',593,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6461,1,1,'CUP',244,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6461,2,1,'can (10.75 oz), prepared',593,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6463,1,1,'CUP',247,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6463,2,1,'can (11 oz), prepared',600,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6465,1,1,'CUP',244,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6465,2,1,'FL OZ',30.5,'g',1,'2002-09-06','2010-01-05');
INSERT INTO `cndb_wght` VALUES (6465,3,1,'can (10.75 oz), prepared',593,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6466,1,1,'cup (8 fl oz)',241,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6466,2,1,'FL OZ',30.1,'g',1,'1997-08-29','2010-01-05');
INSERT INTO `cndb_wght` VALUES (6466,3,1,'can (10.5 oz), prepared',586,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6468,1,1,'CUP',241,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6468,2,1,'can (10.5 oz), prepared',586,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6471,1,1,'cup (8 fl oz)',244,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6471,2,1,'can (10.75 oz), prepared',593,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6472,1,1,'cup (8 fl oz)',241,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6472,2,1,'can (10.5 oz), prepared',586,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6475,1,1,'serving 1 cup',240,'g',1,'1994-01-31','2009-02-11');
INSERT INTO `cndb_wght` VALUES (6475,2,1,'FL OZ',29.9,'g',1,'2002-09-06','2010-01-05');
INSERT INTO `cndb_wght` VALUES (6476,1,1,'serving 1 cup',240,'g',1,'1994-01-31','2009-02-11');
INSERT INTO `cndb_wght` VALUES (6476,2,1,'FL OZ',29.9,'g',1,'2002-09-06','2010-01-05');
INSERT INTO `cndb_wght` VALUES (6480,1,1,'cup 8 fl oz',241,'g',1,'1994-01-31','2016-02-06');
INSERT INTO `cndb_wght` VALUES (6480,2,1,'FL OZ',30.1,'g',1,'2002-09-06','2010-01-05');
INSERT INTO `cndb_wght` VALUES (6481,1,1,'cup (8 fl oz)',243,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6481,2,1,'cube (6 fl oz prepared)',182,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6483,1,1,'cup 8 fl oz',261,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (6483,2,1,'fl oz',32.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6494,1,1,'serving 1 cup',230,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6494,2,1,'fl oz',28.7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6498,1,1,'cup 8 fl oz',265,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (6528,1,1,'cup',245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6547,1,1,'cup (8 fl oz)',244,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6547,2,1,'can (10.75 oz), prepared',593,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6549,1,1,'cup (8 fl oz)',244,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6549,2,1,'can (10.75 oz), prepared',593,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6558,1,1,'cup (8 fl oz)',247,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6558,2,1,'can (11 oz), prepared',600,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6559,1,1,'serving 1 cup',248,'g',1,'1994-01-31','2009-02-11');
INSERT INTO `cndb_wght` VALUES (6559,2,1,'FL OZ',31,'g',1,'1997-08-29','2010-01-05');
INSERT INTO `cndb_wght` VALUES (6583,1,1,'package without flavor packet',81,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6583,2,1,'packet',5.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6584,1,1,'serving 1/2 cup',121,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6584,2,1,'can 10.7 oz (10.75 oz)',303,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6618,1,1,'tbsp',17,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6626,1,0.25,'cup',63,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (6627,1,0.25,'cup',61,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (6700,1,1,'cup',221,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (6700,2,1,'can',390,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (6700,3,1,'carton (32 oz)',926,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (6725,1,1,'serving',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6725,2,1,'package yields',539,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6731,1,1,'serving 1/2 cup',128,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6742,1,1,'serving',292,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6742,2,1,'package yields',292,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6749,1,1,'cup',250,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6749,2,1,'can',528,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6930,1,0.25,'CUP',63,'g',1,'2002-06-08','2006-11-30');
INSERT INTO `cndb_wght` VALUES (6931,1,1,'serving 1/2 cup',132,'g',1,'1996-09-30','2012-03-02');
INSERT INTO `cndb_wght` VALUES (6955,1,0.5,'cup',124,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6956,1,1,'serving 1/2 cup',121,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6956,2,1,'can 10.7 oz',303,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6957,1,1,'serving',6.7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6957,2,1,'package',454,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6958,1,1,'serving',6.7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6958,2,1,'package (16 oz)',454,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6959,1,1,'serving',6.7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6959,2,1,'package (16 oz)',454,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6961,1,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6961,2,1,'cup',245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6962,1,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6962,2,1,'cup',245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6963,1,1,'cup',244,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6963,2,1,'fl oz',30.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6964,1,1,'serving 1 cup',248,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6964,2,1,'fl oz',31,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6965,1,1,'cup',259,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6965,2,1,'fl oz',32.4,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6966,1,1,'serving 1 cup',248,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6966,2,1,'fl oz',31,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6967,1,1,'cup',253,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6968,1,1,'cup',244,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6968,2,1,'can (10.75 oz)',305,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6969,1,1,'serving 1/3 cup',39,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6970,1,1,'cup',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6971,1,1,'tbsp',17,'g',1,'2007-12-03','2013-12-26');
INSERT INTO `cndb_wght` VALUES (6971,2,1,'cup',275,'g',1,'2007-12-03','2013-12-26');
INSERT INTO `cndb_wght` VALUES (6972,1,1,'packet',6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6972,2,1,'cup',273,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6974,1,1,'cup',241,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6976,1,1,'serving 1/2 cup',128,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6976,2,1,'cup',257,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6977,1,1,'cup',236,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6978,1,1,'cup',251,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6980,1,1,'cup',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6981,1,1,'tsp',2.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6981,2,1,'cube',3.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6982,1,1,'package without flavor packet',82,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6982,2,1,'packet',5.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6983,1,1,'package without flavor packet',81,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (6983,2,1,'packet',6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7001,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7001,2,1,'slice (5-7/8" x 3-1/2" x 1/16")',23,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7002,1,2,'oz',56,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7003,1,1,'slice (4" dia x 1/8" thick)',23,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7003,2,1,'slice (2-3/4" dia x 1/16")',6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7004,1,1,'slice',23,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7004,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7005,1,4,'slices',100,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (7006,1,1,'sausage',91,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7007,1,1,'slice',30,'g',1,'1994-09-29','2015-01-07');
INSERT INTO `cndb_wght` VALUES (7007,2,1,'serving',28,'g',1,'2007-11-28','2015-01-07');
INSERT INTO `cndb_wght` VALUES (7008,1,3.527,'oz',100,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (7010,1,1,'slice, medium (4-1/2" dia x 1/8" thick) (1 oz)',28,'g',1,'1995-06-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (7010,2,1,'slice (4" dia x 1/8" thick)',23,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (7011,1,0.99,'oz 1 serving',28,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (7011,2,1,'serving',28,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (7011,3,1,'package',454,'g',1,'2007-11-28','2009-02-11');
INSERT INTO `cndb_wght` VALUES (7013,1,1,'link cooked',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7014,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7014,2,1,'slice (2-1/2" dia x 1/4" thick)',18,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7015,1,1,'link',70,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7016,1,2.33,'links',100,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (7018,1,1,'serving (1 serving)',56,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7019,1,1,'oz',28.35,'g',1,'1996-09-30','2009-02-11');
INSERT INTO `cndb_wght` VALUES (7019,2,1,'link (4" long)',60,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (7020,1,1,'slice (1 oz) (4" x 4" x 3/32" thick)',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7020,2,2,'slices',57,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7021,1,1,'slice',38,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (7022,1,1,'hot dog',49,'g',1,'1994-09-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (7022,2,1,'package',446,'g',1,'1997-08-29','2012-03-02');
INSERT INTO `cndb_wght` VALUES (7024,1,3,'oz',85,'g',1,'1997-08-29','2016-02-06');
INSERT INTO `cndb_wght` VALUES (7024,2,1,'link',45,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (7025,1,1,'oz',28.35,'g',1,'1997-08-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (7025,2,1,'frankfurter',45,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (7026,1,1,'oz',28.35,'g',1,'1996-09-30','2009-02-11');
INSERT INTO `cndb_wght` VALUES (7026,2,1,'slice (4-1/4" x 4-1/4" x 1/16")',21,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (7027,1,1,'slice (1 oz) (4" x 4" x 3/32" thick)',28,'g',1,'1997-08-29','2015-01-07');
INSERT INTO `cndb_wght` VALUES (7027,2,1,'slice (4-1/4" x 4-1/4" x 1/16")',21,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (7028,1,1,'slice',13,'g',1,'1995-06-19','2019-02-13');
INSERT INTO `cndb_wght` VALUES (7029,1,56,'grams 1 serving',56,'g',1,'1995-06-19','2009-02-11');
INSERT INTO `cndb_wght` VALUES (7029,2,1,'slice',28,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (7030,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7030,2,1,'slice (4-1/4" x 4-1/4" x 1/16")',21,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7031,1,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7031,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7032,1,1,'slice (1 oz) (4" x 4" x 3/32" thick)',28,'g',1,'1996-09-30','2015-01-07');
INSERT INTO `cndb_wght` VALUES (7032,2,2,'slices',57,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (7033,1,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7033,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7034,1,1,'slice (1 oz) (4" x 4" x 3/32" thick)',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7034,2,45,'g',45,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7036,1,1,'link',101,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (7038,1,1,'link',72,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (7038,2,1,'oz',28.35,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (7039,1,1,'serving 2 slices',57,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (7039,2,1,'oz',28.35,'g',1,'1998-01-15','2009-02-11');
INSERT INTO `cndb_wght` VALUES (7039,3,2,'oz',57,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (7040,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7040,2,1,'slice',38,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7041,1,1,'slice (2-1/2" dia x 1/4" thick)',18,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7041,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7043,1,1,'slice oval',9.3,'g',1,'1999-03-22','2009-02-11');
INSERT INTO `cndb_wght` VALUES (7043,2,1,'slice rectangle',13.8,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (7045,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7045,2,1,'slice (4-1/4" x 4-1/4" x 1/16")',21,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7046,1,1,'slice',28,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (7046,2,1,'slice NFS',28,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (7046,3,1,'cup wafer slices or shaved',81,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (7046,4,1,'cubic inch',14,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (7046,5,2,'oz',57,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (7050,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7050,2,1,'slice (15 per 8 oz package)',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7051,1,1,'slice (1 oz) (4" x 4" x 3/32" thick)',28,'g',1,'1995-06-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (7051,2,2,'slices',57,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (7052,1,2,'slices',57,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (7052,2,1,'package (8 oz)',227,'g',1,'1998-01-15','2013-12-26');
INSERT INTO `cndb_wght` VALUES (7053,1,1,'tbsp',13,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7053,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7054,1,1,'tbsp',13,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7054,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7055,1,1,'tbsp',13,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7055,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7056,1,3.52,'slices',100,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (7057,1,3,'oz',85,'g',1,'2007-11-28','2016-02-06');
INSERT INTO `cndb_wght` VALUES (7057,2,1,'piece',2,'g',1,'1998-01-15','2016-02-06');
INSERT INTO `cndb_wght` VALUES (7057,3,1,'oz',28,'g',1,'2015-01-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (7058,1,1,'slice',38,'g',1,'1995-06-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (7058,2,2,'slices',57,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (7059,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7059,2,1,'sausage (10" long x 1-1/4" dia)',227,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7060,1,1,'slice (1 oz) (4" x 4" x 3/32" thick)',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7060,2,2,'slices',57,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7061,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7061,2,1,'slice (4-1/4" x 4-1/4" x 1/16")',21,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7062,1,1,'slice (1 oz) (4" x 4" x 3/32" thick)',28,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (7062,2,2,'slices',57,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (7063,1,1,'link',25,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7064,1,1,'patty',27,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7064,2,1,'link',23,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7064,3,1,'serving',48,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7065,1,1,'link (raw dimensions: 4" long x 7/8" dia), cooked',13,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7065,2,1,'patty, cooked (raw dimensions: 3-7/8" dia x 1/4" thick)',27,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7066,1,1,'cup',128,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7067,1,1,'tbsp',13,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7067,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7068,1,1,'slice',26,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (7068,2,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (7069,1,1,'slice round',12.3,'g',1,'1994-01-31','2009-02-11');
INSERT INTO `cndb_wght` VALUES (7070,1,1,'serving',28,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (7071,1,1,'package (4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7071,2,1,'slice (3-1/8" dia x 1/16" thick)',10,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7072,1,1,'slice',9.8,'g',1,'1998-01-15','2015-01-07');
INSERT INTO `cndb_wght` VALUES (7072,2,1,'oz',28,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (7072,3,3,'slices 1 serving',27,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7073,1,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7073,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7074,1,1,'link (4" long x 1-1/8" dia)',68,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (7074,2,1,'link, little (2" long x 3/4" dia)',16,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (7075,1,3,'oz',85,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (7077,1,1,'link (4" long x 1-1/8" dia)',68,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (7077,2,1,'link,  little (2" long x 3/4" dia)',16,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (7078,1,2,'oz 1 serving',56,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7081,1,1,'slice',16,'g',1,'1995-06-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (7083,1,1,'sausage (7/8" dia x 2" long)',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7083,2,7,'sausages (drained contents from can, net wt 4 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7088,1,1,'slice (4" dia x 1/8" thick)',23,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7088,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7089,1,1,'link',87,'g',1,'1999-03-22','2019-02-13');
INSERT INTO `cndb_wght` VALUES (7090,1,1,'slice (4" dia x 1/8" thick)',23,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7090,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7254,1,1,'serving',14,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (7254,2,1,'slice 12 oz pkg',16,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (7254,3,1,'slice 6 oz pkg',9.8,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (7900,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7900,2,1,'lb 16 oz',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7905,1,1,'frank 1 NLEA serving',57,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7906,1,2,'oz 1 NLEA serving',56,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7908,1,2,'oz 1 NLEA serving',56,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7909,1,2,'oz (1 serving)',56,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7910,1,1,'serving 2.96 oz',84,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7911,1,0.25,'cup',55,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7912,1,1,'serving .25 cup',57,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7913,1,3.527,'oz',100,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (7914,1,1,'link 3 oz',84,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7915,1,1,'serving 5 pieces',55,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7915,2,5,'pieces',55,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7916,1,1,'serving 2.67 oz',76,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7917,1,12,'oz serving 2.7 oz',77,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7918,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7919,1,1,'link',28,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (7919,2,1,'package',450,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (7921,1,1,'oz',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7922,1,1,'serving 2.33 oz',66,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7925,1,1,'serving 6 slices',57,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7926,1,1,'oz',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7927,1,1,'serving 2 oz',56,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7928,1,1,'link',84,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7929,1,2,'oz',56,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7930,1,1,'serving 2 oz',56,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7931,1,1,'serving 2 oz',56,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7932,1,1,'serving 2 slices',42,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7933,1,1,'serving 2 slices',42,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7934,1,1,'serving 2 oz',56,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7935,1,1,'serving 2 oz',56,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7936,1,1,'serving 2 oz',56,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7937,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7938,1,1.94,'oz (1 serving)',55,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7939,1,1,'link',76,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7940,1,1,'slice',38,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7941,1,1,'serving 5 slices',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7942,1,1,'serving 2 oz',56,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7943,1,1,'slice',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7944,1,1.69,'oz (1 serving)',48,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7945,1,1,'frankfurter',48,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7945,2,1,'package',451,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7949,1,1,'serving (1 hot dog)',52,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7950,1,1,'serving (1 hot dog)',52,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7951,1,1,'cubic inch',17,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7951,2,1,'oz cooked',25,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (7951,3,2,'oz',56,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7952,1,1,'serving',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7952,2,1,'slice',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7953,1,1,'patty',30,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7953,2,1,'link',21,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7953,3,1,'serving',48,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7954,1,1,'link',19,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (7955,1,1,'serving',57,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7956,1,1,'serving',43,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7957,1,1,'serving',57,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7958,1,1,'serving',57,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7959,1,1,'serving',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7959,2,1,'slice',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7960,1,1,'serving',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7960,2,1,'slice',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7961,1,1,'slice',12,'g',1,'2013-02-22','2013-02-22');
INSERT INTO `cndb_wght` VALUES (7962,1,1,'frankfurter',51,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (7963,1,1,'frankfurter',50,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (7964,1,1,'frankfurter',48,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (7965,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7965,2,1,'package',343,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7966,1,3,'oz',85,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (7966,2,1,'package',343,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7967,1,1,'link',23,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7967,2,1,'patty',37,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7968,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7968,2,1,'link',367,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7969,1,1,'link',370,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7970,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7970,2,1,'link',396,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7971,1,1,'slice',33,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (7972,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (7972,2,3,'pieces',56,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (7973,1,1,'slice',8.1,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (7974,1,1,'serving',15,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (7978,1,3,'oz',85,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (7979,1,3,'oz',85,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (7979,2,1,'serving',56,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (8037,1,1,'CUP',122,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (8037,2,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (8084,1,1,'oz',28.35,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (8084,2,1,'cup',113,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (8090,1,1,'tbsp',9.7,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (8090,2,1,'cup',156,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (8091,1,1,'cup',257,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (8091,2,1,'TBSP',16,'g',1,'2007-11-28','2010-01-04');
INSERT INTO `cndb_wght` VALUES (8120,1,1,'CUP',81,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (8120,2,0.333,'CUP',27,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (8121,1,1,'CUP',234,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (8121,2,1,'tbsp',14.6,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (8121,3,0.75,'CUP',175,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (8122,1,1,'packet',28,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (8123,1,1,'cup, cooked',234,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (8123,2,1,'cup, dry, yields',501,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (8123,3,1,'oz, dry, yields',177,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (8123,4,1,'packet, dry, yields',177,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (8128,1,1,'packet',45,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (8129,1,1,'CUP',240,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (8129,2,1,'TBSP',15,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (8129,3,1,'packet, prepared',161,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (8133,1,1,'CUP',240,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (8133,2,1,'TBSP',15,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (8133,3,1,'packet, prepared',158,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (8144,1,1,'CUP',94,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (8144,2,0.333,'CUP',31,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (8145,1,1,'CUP',242,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (8145,2,0.75,'CUP',182,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (8156,1,1,'CUP',14,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (8156,2,0.5,'oz',14.2,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (8157,1,1,'CUP',12,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (8157,2,0.5,'oz',14.2,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (8160,1,1,'tbsp',9.7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (8160,2,1,'cup',156,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (8161,1,1,'CUP',257,'g',1,'1994-01-31','2010-01-04');
INSERT INTO `cndb_wght` VALUES (8161,2,1,'tablespoon',16,'g',1,'2007-11-28','2015-01-07');
INSERT INTO `cndb_wght` VALUES (8164,1,1,'cup',233,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (8165,1,1,'CUP',233,'g',1,'1994-01-31','2010-01-04');
INSERT INTO `cndb_wght` VALUES (8172,1,1,'tbsp',10.9,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (8172,2,1,'cup',176,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (8173,1,1,'CUP',233,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (8180,1,1,'cup',234,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (8180,2,0.75,'cup',175,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (8183,1,1,'CUP',242,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (8183,2,0.75,'CUP',182,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (8204,1,1,'cup',30,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (8510,1,1,'bar',25,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (8546,1,1,'bar',22,'g',1,'2007-12-03','2007-12-03');
INSERT INTO `cndb_wght` VALUES (8680,1,1,'packet',43,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (9001,1,1,'CUP',98,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9001,2,1,'fruit without refuse',4.8,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9002,1,1,'CUP',242,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9002,2,1,'FL OZ',30.2,'g',1,'2002-09-06','2010-01-05');
INSERT INTO `cndb_wght` VALUES (9003,1,1,'cup, quartered or chopped',125,'g',1,'1994-09-29','2007-03-25');
INSERT INTO `cndb_wght` VALUES (9003,2,1,'cup slices',109,'g',1,'1999-03-22','2009-02-11');
INSERT INTO `cndb_wght` VALUES (9003,3,1,'large (3-1/4" dia)',223,'g',1,'1998-01-15','2015-01-07');
INSERT INTO `cndb_wght` VALUES (9003,4,1,'medium (3" dia)',182,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (9003,5,1,'small (2-3/4" dia)',149,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (9003,6,1,'extra small (2-1/2" dia)',101,'g',1,'2004-07-15','2015-01-07');
INSERT INTO `cndb_wght` VALUES (9003,7,1,'NLEA serving',242,'g',1,'2007-11-28','2009-02-11');
INSERT INTO `cndb_wght` VALUES (9004,1,1,'cup slices',110,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9004,2,1,'large (3-1/4" dia)',216,'g',1,'1999-03-22','2015-01-07');
INSERT INTO `cndb_wght` VALUES (9004,3,1,'medium (3" dia)',161,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (9004,4,1,'small (2-3/4" dia)',132,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (9005,1,1,'cup slices',171,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9006,1,1,'cup slices',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9008,1,1,'cup slices',204,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9009,1,1,'CUP',60,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9010,1,1,'CUP',193,'g',1,'1994-11-17','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9011,1,1,'CUP',86,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9011,2,1,'ring',6.4,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9012,1,1,'CUP',255,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9013,1,1,'CUP',280,'g',1,'1994-11-17','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9014,1,1,'cup slices',173,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9015,1,1,'cup slices',206,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9016,1,1,'CUP',248,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9016,2,1,'FL OZ',31,'g',1,'2002-09-06','2010-01-05');
INSERT INTO `cndb_wght` VALUES (9016,3,1,'drink box (8.45 fl oz)',262,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9017,1,1,'can (6 fl oz)',211,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9018,1,1,'CUP',239,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9018,2,1,'FL OZ',29.9,'g',1,'2002-09-06','2010-01-05');
INSERT INTO `cndb_wght` VALUES (9019,1,1,'cup',244,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9020,1,1,'CUP',246,'g',1,'1999-03-22','2009-02-11');
INSERT INTO `cndb_wght` VALUES (9021,1,1,'cup, halves',155,'g',1,'1994-01-31','2007-03-25');
INSERT INTO `cndb_wght` VALUES (9021,2,1,'cup, sliced',165,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (9021,3,1,'apricot',35,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (9022,1,1,'cup, halves',243,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9022,2,1,'apricot half with liquid',36,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9023,1,1,'cup, whole, without pits',227,'g',1,'1994-11-17','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9024,1,1,'cup, halves',244,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9024,2,1,'apricot half with liquid',36,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9025,1,1,'cup, halves',247,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9026,1,1,'cup, halves',253,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9026,2,1,'apricot half with liquid',40,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9027,1,1,'cup, halves',258,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9027,2,1,'cup, whole',240,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9027,3,1,'apricot half with liquid',40,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9028,1,1,'cup, whole, without pits',258,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9029,1,1,'cup, whole, without pits',246,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9030,1,1,'cup',119,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9031,1,1,'cup',249,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9032,1,1,'cup, halves',130,'g',1,'1994-10-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9032,2,1,'half',3.5,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9033,1,1,'cup, halves',250,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9034,1,1,'cup, halves',270,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9035,1,1,'CUP',242,'g',1,'1994-11-17','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9036,1,1,'cup',266,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (9036,2,1,'fl oz',30.4,'g',1,'2002-09-06','2019-02-13');
INSERT INTO `cndb_wght` VALUES (9037,1,1,'cup, cubes',150,'g',1,'1995-06-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9037,2,1,'cup, pureed',230,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9037,3,1,'cup, sliced',146,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9037,4,1,'avocado, NS as to Florida or California',201,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9037,5,1,'NLEA Serving',50,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (9038,1,1,'cup, pureed',230,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9038,2,1,'fruit, without skin and seed',136,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9038,3,1,'NLEA serving',50,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (9039,1,1,'cup, pureed',230,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9039,2,1,'fruit without skin and seeds',304,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9039,3,1,'NLEA Serving',50,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (9040,1,1,'cup, mashed',225,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9040,2,1,'cup, sliced',150,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9040,3,1,'extra small (less than 6" long)',81,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9040,4,1,'small (6" to 6-7/8" long)',101,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9040,5,1,'medium (7" to 7-7/8" long)',118,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9040,6,1,'large (8" to 8-7/8" long)',136,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9040,7,1,'extra large (9" or longer)',152,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9040,8,1,'NLEA serving',126,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9041,1,1,'cup',100,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (9041,2,1,'tbsp',6.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9042,1,1,'CUP',144,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9043,1,1,'cup',250,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9044,1,0.25,'cup',40,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9046,1,1,'CUP',256,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9048,1,1,'cup, unthawed',151,'g',1,'1995-06-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9048,2,1,'package (18 oz)',510,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9050,1,1,'CUP',148,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9050,2,50,'berries',68,'g',1,'1994-01-31','2009-02-11');
INSERT INTO `cndb_wght` VALUES (9052,1,1,'CUP',256,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9053,1,1,'cup, frozen',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9054,1,1,'cup, unthawed',155,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9054,2,1,'package (20 oz)',567,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9055,1,1,'cup, thawed',230,'g',1,'1994-10-18','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9055,2,1,'package (10 oz)',284,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9056,1,1,'cup',256,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9057,1,1,'cup, unthawed',132,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9057,2,1,'package (10 oz)',284,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9059,1,1,'CUP',220,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9059,2,0.25,'fruit, small',96,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9060,1,1,'cup, cubes',132,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9060,2,1,'cup, sliced',108,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9060,3,1,'large (4-1/2" long)',124,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9060,4,1,'medium (3-5/8" long)',91,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9060,5,1,'small (3-1/8" long)',70,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9062,1,1,'cup, pieces',160,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9062,2,1,'fruit without skin and seeds',235,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9063,1,1,'cup, without pits',155,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9063,2,1,'cup, with pits, yields',103,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9064,1,1,'CUP',244,'g',1,'1999-03-22','2007-03-25');
INSERT INTO `cndb_wght` VALUES (9065,1,1,'cup',252,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9066,1,1,'cup',256,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9067,1,1,'cup',261,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9068,1,1,'cup, unthawed',155,'g',1,'1994-11-17','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9068,2,1,'package (18 oz)',510,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9070,1,1,'cup, with pits, yields',138,'g',1,'1997-08-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (9070,2,1,'cup, without pits',154,'g',1,'1994-09-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (9070,3,1,'cherry',8.2,'g',1,'1998-01-15','2009-02-11');
INSERT INTO `cndb_wght` VALUES (9070,4,1,'NLEA serving',140,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9071,1,1,'cup, pitted',248,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9072,1,1,'cup, pitted',250,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9073,1,1,'cup, pitted',252,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9074,1,1,'CUP',253,'g',1,'1995-06-19','2009-02-11');
INSERT INTO `cndb_wght` VALUES (9075,1,1,'cup, pitted',261,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9077,1,1,'cup slices',110,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9078,1,1,'cup, chopped',110,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9078,2,1,'cup, whole',100,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (9079,1,0.25,'cup',40,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (9081,1,1,'CUP',277,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9081,2,1,'slice (1/2" thick, approx 8 slices per can)',57,'g',1,'1994-10-18','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9082,1,1,'CUP',275,'g',1,'1994-11-17','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9083,1,1,'cup',112,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9084,1,1,'CUP',112,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9085,1,1,'cup',144,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9087,1,1,'cup, chopped',147,'g',1,'1994-09-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (9087,2,1,'date, pitted',7.1,'g',1,'2002-09-06','2009-02-11');
INSERT INTO `cndb_wght` VALUES (9088,1,1,'cup',145,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9089,1,1,'large (2-1/2" dia)',64,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9089,2,1,'medium (2-1/4" dia)',50,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9089,3,1,'small (1-1/2" dia)',40,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9090,1,1,'CUP',248,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9090,2,1,'fig with liquid',27,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9091,1,1,'CUP',252,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9091,2,1,'fig with liquid',28,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9092,1,1,'CUP',259,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9092,2,1,'fig with liquid',28,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9093,1,1,'cup',261,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9094,1,1,'CUP',149,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9094,2,1,'fig',8.4,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9095,1,1,'CUP',259,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9096,1,1,'CUP',237,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9097,1,1,'CUP',237,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9098,1,0.5,'CUP',123,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9099,1,1,'CUP',242,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9100,1,1,'CUP',248,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9101,1,0.5,'cup',130,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (9101,2,1,'cup',260,'g',1,'2007-11-28','2013-12-26');
INSERT INTO `cndb_wght` VALUES (9102,1,1,'CUP',245,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9103,1,1,'CUP',249,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9104,1,1,'CUP',252,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9106,1,1,'CUP',259,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9107,1,1,'cup',150,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9109,1,1,'cup',252,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9110,1,5,'tbsp',28,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (9111,1,1,'cup sections, with juice',230,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9111,2,0.5,'large (approx 4-1/2" dia)',166,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9111,3,0.5,'medium (approx 4" dia)',128,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9111,4,0.5,'small (approx 3-1/2" dia)',100,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (9112,1,1,'cup sections, with juice',230,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9112,2,0.5,'fruit (3-3/4" dia)',123,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9112,3,1,'NLEA serving',154,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9113,1,1,'cup sections, with juice',230,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9113,2,0.5,'fruit (3-3/4" dia)',123,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9114,1,1,'cup sections, with juice',230,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9114,2,0.5,'fruit (3-3/4" dia)',123,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9116,1,1,'cup sections, with juice',230,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9116,2,0.5,'fruit (3-3/4" dia)',118,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9117,1,1,'cup sections, with juice',230,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9117,2,0.5,'fruit (3-3/4" dia)',118,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9118,1,1,'cup sections, with juice',230,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9118,2,0.5,'fruit (3-3/4" dia)',118,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9119,1,1,'CUP',244,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9120,1,1,'CUP',249,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9121,1,1,'CUP',254,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9123,1,1,'cup',257,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (9123,2,8,'fl oz',246,'g',1,'2002-09-06','2019-02-13');
INSERT INTO `cndb_wght` VALUES (9124,1,1,'CUP',250,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9124,2,1,'FL OZ',31.2,'g',1,'2002-09-06','2010-01-05');
INSERT INTO `cndb_wght` VALUES (9125,1,1,'can (6 fl oz)',207,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9126,1,1,'CUP',247,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9126,2,1,'FL OZ',30.9,'g',1,'1997-08-29','2010-01-05');
INSERT INTO `cndb_wght` VALUES (9127,1,8,'fl oz',240,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (9127,2,1,'cup',252,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (9128,1,1,'cup',247,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9128,2,1,'fl oz',30.9,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9128,3,1,'fruit yields',196,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9130,1,1,'CUP',253,'g',1,'2009-01-25','2009-01-25');
INSERT INTO `cndb_wght` VALUES (9130,2,1,'FL OZ',31.6,'g',1,'2009-01-25','2010-01-05');
INSERT INTO `cndb_wght` VALUES (9131,1,1,'CUP',92,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9131,2,1,'grape',2.4,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9132,1,1,'cup',151,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9132,2,10,'grapes',49,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9132,3,1,'NLEA serving',126,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9133,1,1,'cup',245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9134,1,1,'cup',256,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9135,1,1,'CUP',253,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9135,2,1,'FL OZ',31.6,'g',1,'2002-09-06','2010-01-05');
INSERT INTO `cndb_wght` VALUES (9139,1,1,'CUP',165,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9139,2,1,'fruit, without refuse',55,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9140,1,1,'cup',244,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9140,2,1,'fruit without refuse',6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9143,1,1,'CUP',238,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9144,1,1,'cup, sliced',165,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9144,2,1,'cup 1" pieces',151,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9148,1,1,'cup, sliced',180,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9148,2,1,'fruit (2" dia)',69,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9148,3,1,'NLEA serving',148,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9149,1,1,'fruit without refuse',19,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9150,1,1,'cup, sections',212,'g',1,'1994-09-29','2007-03-25');
INSERT INTO `cndb_wght` VALUES (9150,2,1,'fruit (2-1/8" dia)',58,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (9150,3,1,'fruit (2-3/8" dia)',84,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (9150,4,1,'wedge or slice (1/8 of one 2-1/8" dia lemon)',7,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (9150,5,1,'NLEA serving',58,'g',1,'2004-07-15','2007-03-25');
INSERT INTO `cndb_wght` VALUES (9152,1,1,'CUP',244,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9152,2,1,'FL OZ',30.5,'g',1,'1998-01-15','2010-01-05');
INSERT INTO `cndb_wght` VALUES (9152,3,1,'lemon yields',48,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9152,4,1,'wedge yields',5.9,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9153,1,1,'tbsp',15,'g',1,'1994-01-31','2016-02-06');
INSERT INTO `cndb_wght` VALUES (9153,2,1,'tsp',5,'g',1,'1999-03-22','2016-02-06');
INSERT INTO `cndb_wght` VALUES (9153,3,1,'FL OZ',30.5,'g',1,'1998-01-15','2010-01-05');
INSERT INTO `cndb_wght` VALUES (9153,4,1,'cup',244,'g',1,'2002-09-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (9156,1,1,'TBSP',6,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9156,2,1,'tsp',2,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9159,1,1,'fruit (2" dia)',67,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9159,2,1,'NLEA serving',67,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9160,1,1,'CUP',242,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9160,2,1,'FL OZ',30.8,'g',1,'2002-09-06','2010-01-05');
INSERT INTO `cndb_wght` VALUES (9160,3,1,'lime yields',44,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9161,1,1,'CUP',246,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9161,2,1,'FL OZ',30.8,'g',1,'2002-09-06','2010-01-05');
INSERT INTO `cndb_wght` VALUES (9163,1,0.25,'cup',40,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9164,1,1,'CUP',190,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9164,2,1,'fruit without refuse',9.6,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9165,1,1,'fruit',2.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9167,1,1,'cup, unthawed',147,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9174,1,1,'cup, cubed',149,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9174,2,1,'large',20,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9174,3,1,'medium',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9174,4,1,'small',13.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9175,1,1,'fruit without refuse',846,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9176,1,1,'cup pieces',165,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9176,2,1,'fruit without refuse',336,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9181,1,1,'cup, balls',177,'g',1,'1994-09-29','2007-03-25');
INSERT INTO `cndb_wght` VALUES (9181,2,1,'cup, cubes',160,'g',1,'1998-01-15','2007-03-25');
INSERT INTO `cndb_wght` VALUES (9181,3,1,'cup, diced',156,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (9181,4,1,'melon, large (about 6-1/2" dia)',814,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (9181,5,1,'wedge, large (1/8 of large melon)',102,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (9181,6,1,'melon, medium (about 5" dia)',552,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (9181,7,1,'wedge, medium (1/8 of medium melon)',69,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (9181,8,1,'melon, small (about 4-1/4" dia)',441,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (9181,9,1,'wedge, small (1/8 of small melon)',55,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (9181,10,10,'cantaloupe balls',138,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (9181,11,1,'NLEA serving',134,'g',1,'2004-07-15','2007-03-25');
INSERT INTO `cndb_wght` VALUES (9183,1,1,'cup, cubes',170,'g',1,'1994-10-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9183,2,1,'melon',1640,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9183,3,0.1,'fruit',164,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9184,1,1,'cup, diced (approx 20 pieces per cup)',170,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (9184,2,1,'cup, balls',177,'g',1,'1998-01-15','2013-12-26');
INSERT INTO `cndb_wght` VALUES (9184,3,1,'melon (5-1/4" dia)',1000,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9184,4,1,'melon (6" - 7" dia)',1280,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9184,5,1,'wedge (1/8 of 5-1/4" dia melon)',125,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9184,6,1,'wedge (1/8 of 6" to 7" dia melon)',160,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9184,7,10,'honeydew balls',138,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9184,8,1,'NLEA serving',134,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9185,1,1,'cup, unthawed',173,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9190,1,1,'cup',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9190,2,10,'fruit',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9191,1,1,'cup slices',143,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9191,2,1,'small (2-1/3" dia)',129,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9191,3,1,'medium (2-1/2" dia)',142,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9191,4,1,'large (2-3/4" dia)',156,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (9191,5,1,'NLEA serving',140,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (9193,1,1,'TBSP',8.4,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9193,2,1,'large',4.4,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9193,3,1,'small',3.2,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9194,1,1,'super colossal',15,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (9194,2,1,'jumbo',8.3,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (9195,1,1,'olive',2.7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9200,1,1,'cup, sections',180,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9200,2,1,'large (3-1/16" dia)',184,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9200,3,1,'small (2-3/8" dia)',96,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9200,4,1,'fruit (2-5/8" dia)',131,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9201,1,1,'cup sections, without membranes',180,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9201,2,1,'fruit (2-5/8" dia)',121,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9202,1,1,'cup sections, without membranes',165,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9202,2,1,'fruit (2-7/8" dia)',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9202,3,1,'NLEA serving',154,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9203,1,1,'cup sections, without membranes',185,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9203,2,1,'fruit (2-5/8" dia)',141,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9203,3,1,'fruit (2-11/16" dia)',151,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9205,1,1,'cup',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9205,2,1,'fruit without seeds',159,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9206,1,1,'CUP',248,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9206,2,1,'FL OZ',31,'g',1,'1999-03-22','2010-01-05');
INSERT INTO `cndb_wght` VALUES (9206,3,1,'fruit yields',86,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9207,1,1,'CUP',249,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9207,2,1,'FL OZ',31.1,'g',1,'2002-09-06','2010-01-05');
INSERT INTO `cndb_wght` VALUES (9207,3,1,'drink box (8.45 fl oz)',263,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9209,1,1,'CUP',249,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9209,2,1,'FL OZ',31.1,'g',1,'2002-09-06','2010-01-05');
INSERT INTO `cndb_wght` VALUES (9210,1,1,'cup',249,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9210,2,1,'fl oz',31.1,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9211,1,1,'cup',249,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (9211,2,1,'fl oz',31.1,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (9212,1,1,'cup',249,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (9212,2,1,'fl oz',31.1,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (9213,1,1,'cup',262,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (9213,2,1,'fl oz',33,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (9214,1,1,'CUP',262,'g',1,'1994-09-29','2015-01-07');
INSERT INTO `cndb_wght` VALUES (9214,2,1,'FL OZ',33,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (9215,1,1,'CUP',249,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9215,2,1,'FL OZ',31.1,'g',1,'2002-09-06','2010-01-05');
INSERT INTO `cndb_wght` VALUES (9216,1,1,'TBSP',6,'g',1,'1995-06-27','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9216,2,1,'tsp',2,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9217,1,1,'CUP',247,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9217,2,1,'FL OZ',30.9,'g',1,'2002-09-06','2010-01-05');
INSERT INTO `cndb_wght` VALUES (9218,1,1,'cup, sections',195,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9218,2,1,'small (2-1/4" dia)',76,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9218,3,1,'medium (2-1/2" dia)',88,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9218,4,1,'large (2-3/4" dia)',120,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9218,5,1,'NLEA serving',109,'g',1,'2004-07-15','2009-02-11');
INSERT INTO `cndb_wght` VALUES (9219,1,1,'CUP',249,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9220,1,1,'CUP',252,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9221,1,1,'cup',247,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9221,2,1,'fl oz',30.9,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9226,1,1,'cup 1" pieces',145,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9226,2,1,'cup, mashed',230,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9226,3,1,'fruit, small',157,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9226,4,1,'fruit, large',781,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9228,1,1,'piece',39,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9229,1,1,'CUP',250,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9229,2,1,'FL OZ',31.2,'g',1,'2002-09-06','2010-01-05');
INSERT INTO `cndb_wght` VALUES (9231,1,1,'cup',236,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9231,2,1,'fruit without refuse',18,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9232,1,1,'cup',247,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9232,2,1,'fl oz',30.9,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9233,1,1,'cup',247,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9233,2,1,'fl oz',30.9,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9236,1,1,'cup slices',154,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9236,2,1,'small (2-1/2" dia)',130,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9236,3,1,'medium (2-2/3" dia)',150,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9236,4,1,'large (2-3/4" dia)',175,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9236,5,1,'extra large (3" dia)',224,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9236,6,1,'NLEA serving',147,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (9237,1,1,'cup, halves or slices',244,'g',1,'1995-06-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9237,2,1,'half, with liquid',98,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9238,1,1,'CUP',250,'g',1,'1995-06-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9238,2,1,'cup, halves or slices',248,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9238,3,1,'half, with liquid',98,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9239,1,1,'cup, halves or slices',247,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9240,1,1,'cup, halves or slices',251,'g',1,'1995-06-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9240,2,1,'half, with liquid',98,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9241,1,1,'CUP',262,'g',1,'1995-06-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9241,2,1,'half, with liquid',98,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9242,1,1,'cup, halves or slices',262,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9243,1,1,'cup, whole',242,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9244,1,1,'cup',116,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9245,1,1,'cup',242,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9246,1,1,'cup, halves',160,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9246,2,1,'half',13,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9247,1,1,'CUP',258,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9248,1,1,'CUP',270,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9250,1,1,'cup, thawed',250,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9250,2,10,'slices',155,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9250,3,1,'package (10 oz)',284,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9251,1,1,'cup',258,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (9252,1,1,'cup, slices',140,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (9252,2,1,'cup, cubes',161,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (9252,3,1,'small',148,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (9252,4,1,'medium',178,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (9252,5,1,'large',230,'g',1,'2004-07-15','2013-12-26');
INSERT INTO `cndb_wght` VALUES (9252,6,1,'NLEA serving',166,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (9253,1,1,'cup, halves',244,'g',1,'1995-06-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9253,2,1,'half, with liquid',76,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9254,1,1,'cup, halves',248,'g',1,'1995-06-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9254,2,1,'half, with liquid',76,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9255,1,1,'cup, halves',247,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9255,2,1,'half, with liquid',76,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9256,1,1,'cup, halves',251,'g',1,'1995-06-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9256,2,1,'half, with liquid',76,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9257,1,1,'CUP',266,'g',1,'1995-06-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9257,2,1,'half, with liquid',76,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9258,1,1,'cup, halves',266,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9258,2,1,'half, with liquid',79,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9259,1,1,'cup, halves',180,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9259,2,1,'half',18,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9259,3,10,'halves',175,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9260,1,1,'cup, halves',255,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9261,1,1,'cup, halves',280,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9262,1,1,'CUP',250,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9262,2,1,'FL OZ',31.2,'g',1,'2002-09-06','2010-01-05');
INSERT INTO `cndb_wght` VALUES (9263,1,1,'fruit (2-1/2" dia)',168,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9266,1,1,'cup, chunks',165,'g',1,'1994-09-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (9266,2,1,'fruit',905,'g',1,'2002-09-06','2009-02-11');
INSERT INTO `cndb_wght` VALUES (9266,3,1,'slice (4-2/3" dia x 3/4" thick)',166,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (9266,4,1,'slice (3-1/2" dia x 3/4" thick)',84,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (9266,5,1,'slice, thin (3-1/2" dia x 1/2" thick)',56,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (9267,1,1,'cup, crushed, sliced, or chunks',246,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9267,2,1,'slice or ring (3" dia) with liquid',47,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9268,1,1,'cup, crushed, sliced, or chunks',249,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9268,2,1,'slice or ring (3" dia) with liquid',47,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9269,1,1,'cup, crushed, sliced, or chunks',252,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9269,2,1,'slice or ring (3" dia) with liquid',48,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9270,1,1,'cup, crushed, sliced, or chunks',254,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9270,2,1,'slice or ring (3" dia) with liquid',49,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9271,1,1,'cup, crushed, sliced, or chunks',260,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9272,1,1,'cup, chunks',245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9273,1,1,'CUP',250,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9273,2,1,'FL OZ',31.3,'g',1,'2002-09-06','2010-01-05');
INSERT INTO `cndb_wght` VALUES (9274,1,1,'can (6 fl oz)',216,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9275,1,1,'CUP',250,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9275,2,1,'FL OZ',31.2,'g',1,'2002-09-06','2010-01-05');
INSERT INTO `cndb_wght` VALUES (9277,1,1,'plantain',270,'g',1,'1994-09-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (9277,2,1,'cup, sliced',148,'g',1,'2002-09-06','2019-02-13');
INSERT INTO `cndb_wght` VALUES (9278,1,1,'cup',139,'g',1,'1994-09-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (9278,2,10,'slice',105,'g',1,'1999-03-22','2019-02-13');
INSERT INTO `cndb_wght` VALUES (9279,1,1,'cup, sliced',165,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9279,2,1,'fruit (2-1/8" dia)',66,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9279,3,1,'NLEA serving',151,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9281,1,1,'cup, pitted',249,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9281,2,1,'plum with liquid',46,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9282,1,1,'cup, pitted',252,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9282,2,1,'plum with liquid',46,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9283,1,1,'cup, pitted',252,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9283,2,1,'plum with liquid',46,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9284,1,1,'cup, pitted',258,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9284,2,1,'plum with liquid',46,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9285,1,1,'cup, pitted',261,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9286,1,0.5,'cup arils (seed/juice sacs)',87,'g',1,'1996-09-30','2013-12-26');
INSERT INTO `cndb_wght` VALUES (9286,2,1,'pomegranate (4" dia)',282,'g',1,'2011-01-18','2013-12-26');
INSERT INTO `cndb_wght` VALUES (9287,1,1,'cup',149,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9287,2,1,'fruit without refuse',103,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9288,1,1,'CUP',234,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9288,2,5,'prunes with liquid',86,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (9289,1,1,'cup',132,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9290,1,1,'cup',280,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9291,1,1,'cup, pitted',174,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9291,2,1,'prune, pitted',9.5,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9292,1,1,'cup, pitted',248,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9293,1,1,'cup, pitted',248,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9294,1,1,'cup',256,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9294,2,1,'fl oz',32,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9296,1,1,'fruit without refuse',92,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9297,1,1,'cup, packed',165,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9297,2,1,'cup (not packed)',145,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9298,1,1,'cup, packed',165,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9298,2,1,'cup (not packed)',145,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9298,3,1,'miniature box (.5 oz)',14,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9298,4,1,'small box (1.5 oz)',43,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9298,5,50,'raisins',26,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9298,6,1,'oz (60 raisins)',28.35,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (9299,1,1,'cup, packed',165,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9299,2,1,'cup (not packed)',145,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9302,1,1,'CUP',123,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9302,2,1,'pint as purchased, yields',312,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9302,3,10,'raspberries',19,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9304,1,1,'CUP',256,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9306,1,1,'cup, thawed',250,'g',1,'1994-01-31','2015-01-07');
INSERT INTO `cndb_wght` VALUES (9306,2,1,'package (10 oz)',284,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9307,1,1,'cup, diced',122,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9307,2,1,'stalk',51,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9309,1,1,'cup, diced',137,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9310,1,1,'cup',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9313,1,1,'cup, pulp',241,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9313,2,1,'sapodilla',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9314,1,1,'cup 1" pieces',175,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9314,2,1,'fruit without refuse',558,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9315,1,1,'cup, pulp',225,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9315,2,1,'fruit (7" x 5-1/4" dia)',625,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9316,1,1,'cup, halves',152,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9316,2,1,'cup, pureed',232,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9316,3,1,'cup, sliced',166,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9316,4,1,'cup, whole',144,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9316,5,1,'extra large (1-5/8" dia)',27,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9316,6,1,'large (1-3/8" dia)',18,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9316,7,1,'medium (1-1/4" dia)',12,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9316,8,1,'pint as purchased, yields',357,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9316,9,1,'small (1" dia)',7,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9316,10,1,'NLEA serving',147,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9317,1,1,'CUP',254,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9318,1,1,'cup, thawed',221,'g',1,'1995-06-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9318,2,1,'cup, unthawed',149,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9318,3,1,'berry',10.6,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9318,4,1,'package (20 oz)',567,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9320,1,1,'cup, thawed',255,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9320,2,1,'package (10 oz)',284,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9321,1,1,'cup, pulp',250,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9321,2,1,'fruit (2-7/8" dia)',155,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9322,1,1,'cup, pulp',120,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9322,2,1,'fruit (3" x 1")',2,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9325,1,1,'CUP',257,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9326,1,1,'cup, balls',154,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9326,2,1,'cup, diced',152,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9326,3,1,'melon (15" long x 7-1/2" dia)',4518,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9326,4,1,'wedge (approx 1/16 of melon)',286,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9326,5,10,'watermelon balls',122,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9326,6,1,'NLEA serving',280,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9328,1,1,'cherry (NLEA serving)',5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9334,1,1,'cup, pureed',243,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9334,2,1,'fruit without peel',42,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9334,3,1,'cup 1/2" chunks',205,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9340,1,1,'fruit 2-1/4" high x 2-1/2" dia',122,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9340,2,1,'fruit 3-3/8" high x 3" diameter',275,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9351,1,1,'CUP',214,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9352,1,1,'cup',244,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9354,1,1,'cup, chunks',181,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9354,2,1,'cup, crushed',195,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9354,3,1,'cup, sliced',162,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9354,5,1,'spear',26,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9357,1,1,'cup, halves',219,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9357,2,1,'cup, whole',182,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9367,1,1,'CUP',179,'g',1,'1994-11-02','2009-02-11');
INSERT INTO `cndb_wght` VALUES (9370,1,1,'CUP',222,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9370,2,1,'half',73,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9370,3,1,'slice',12.7,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9374,1,1,'CUP',201,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9374,2,1,'half',48,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9379,1,1,'cup, with pits, yields',183,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9383,1,1,'CUP',189,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9400,1,1,'CUP',248,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9400,2,1,'FL OZ',31,'g',1,'2002-09-06','2010-01-05');
INSERT INTO `cndb_wght` VALUES (9401,1,1,'cup',244,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9402,1,1,'cup',255,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9404,1,1,'cup',247,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9404,2,1,'fruit yields',196,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9407,1,1,'cup',220,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (9408,1,1,'CUP',250,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9408,2,1,'FL OZ',31.2,'g',1,'2002-09-06','2010-01-05');
INSERT INTO `cndb_wght` VALUES (9409,1,1,'CUP',250,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9409,2,1,'FL OZ',31.3,'g',1,'2002-09-06','2010-01-05');
INSERT INTO `cndb_wght` VALUES (9410,1,1,'can (6 fl oz)',211,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9411,1,1,'CUP',239,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (9411,2,1,'FL OZ',29.9,'g',1,'2002-09-06','2010-01-05');
INSERT INTO `cndb_wght` VALUES (9423,1,2,'tbsp',36,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (9427,1,0.5,'cup',114,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9428,1,0.5,'cup',114,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9434,1,1,'cup',251,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9435,1,1,'cup',251,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (9436,1,1,'cup',251,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9442,1,1,'CUP',249,'g',1,'2009-01-25','2009-01-25');
INSERT INTO `cndb_wght` VALUES (9442,2,1,'FL OZ',31.4,'g',1,'2009-01-25','2010-01-05');
INSERT INTO `cndb_wght` VALUES (9443,1,8,'fl oz',250,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9444,1,8,'fl oz',250,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9446,1,1,'cup',118,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9446,2,10,'slices (1/4" thick)',53,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9447,1,1,'cup',169,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (9452,1,8,'fl oz',246,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (9506,1,1,'cup',249,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (9506,2,1,'fl oz',31.1,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (9512,1,1,'cup',253,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (9512,2,1,'fl oz',31.6,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (9517,1,6,'fl oz',177,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (9517,2,10,'fl oz',295,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (9518,1,1,'cup, unthawed',140,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (9519,1,11.3,'fl oz',335,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (9522,1,6.75,'fl oz',200,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (9522,2,8,'fl oz',240,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (9542,1,1,'plantain',267,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (9543,1,1,'cup',137,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10000,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10001,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10001,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10002,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10002,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10003,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10003,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10004,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10004,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10005,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10005,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10006,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10006,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10007,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10007,2,1,'oz',28.35,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10008,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10008,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10009,1,1,'cup, diced',135,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10009,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10010,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10010,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10011,1,1,'cup, diced',135,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10011,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10012,1,4,'oz',113,'g',1,'2001-07-04','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10012,2,1,'lb',453.6,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (10013,1,1,'cup, diced',135,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (10013,2,3,'oz',85,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (10014,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10014,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10014,3,1,'roast',3952,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10015,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10015,2,1,'roast',3027,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10016,1,4,'oz',113,'g',1,'2001-07-04','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10016,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10016,3,1,'roast',3868,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10017,1,3,'oz',85,'g',1,'1996-09-30','2013-12-26');
INSERT INTO `cndb_wght` VALUES (10017,2,1,'roast',2900,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10018,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10018,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10018,3,1,'roast',3868,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10019,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10019,2,1,'roast',2900,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10020,1,4,'oz',113,'g',1,'1997-08-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10020,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 151 g)',117,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (10021,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10021,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 151 g)',89,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10022,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10022,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 151 g)',87,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10023,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10023,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 151 g)',89,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10024,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10024,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 151 g)',106,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10025,1,3,'oz',85,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (10025,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 151 g)',80,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (10026,1,3,'oz',85,'g',1,'1994-11-17','2006-11-30');
INSERT INTO `cndb_wght` VALUES (10026,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 151 g)',79,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (10027,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10027,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 151 g)',81,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10028,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10028,2,1,'chop',263,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10029,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10029,2,1,'chop',206,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10030,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10030,2,1,'chop',219,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10031,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10031,2,1,'roast',830,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10032,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10032,2,1,'chop',263,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10033,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10033,2,1,'chop',206,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10034,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10034,2,1,'chop',219,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10035,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10035,2,1,'roast',830,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10036,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10036,2,1,'chop without refuse (Yield from 1 raw chop, with refuse, weighing 259g)',199,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10037,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10037,2,1,'chop',187,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10038,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10038,2,1,'chop without refuse (Yield from 1 cooked chop, with refuse, weighing 209g)',157,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10039,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10039,2,1,'roast',900,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10040,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10040,2,1,'chop without refuse (Yield from 1 raw chop, with refuse, weighing 259g)',178,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10041,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10041,2,1,'chop',187,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10042,1,1,'chop without refuse (Yield from 1 cooked chop, with refuse, weighing 209g)',146,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10042,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10043,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10043,2,1,'roast',900,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10044,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10044,2,1,'chop without refuse (Yield from 1 raw chop, with refuse, weighing 201g)',133,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10044,3,1,'lb',453.6,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10045,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10045,2,1,'chop',187,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10046,1,1,'chop without refuse (Yield from 1 cooked chop, with refuse, weighing 172g)',112,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10046,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10047,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10047,2,1,'roast',783,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10048,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10048,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 151 g)',86,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10049,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10049,2,1,'chop',187,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10050,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10050,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 151 g)',67,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10051,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10051,2,1,'roast',783,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10052,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10052,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10052,3,1,'roast without refuse (Yield from 1 raw roast, with refuse, weighing 1817g)',1327,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10053,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10053,2,1,'chop',180,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10054,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10054,2,1,'chop',195,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10055,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10055,2,1,'roast without refuse (Yield from 1 cooked roast, with refuse, weighing 1515g)',1046,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10057,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10057,2,1,'chop',180,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10058,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10058,2,1,'chop',195,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10059,1,3,'oz (Yield from 1 cooked roast, with refuse, weighing 1515g)',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10059,2,1,'roast without refuse',985,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10060,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10060,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10060,3,1,'roast',505,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10061,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10061,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',333,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10061,3,1,'roast',402,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10062,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10062,2,1,'chop',185,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10063,1,1,'chop',135,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10064,1,1,'chop',145,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10064,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10065,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10065,2,1,'roast',848,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10066,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10066,2,1,'chop',185,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10066,3,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10067,1,1,'chop',135,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10068,1,1,'chop',145,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10069,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10070,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10070,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10071,1,1,'cup, diced',135,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10071,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10072,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10072,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10073,1,1,'cup, diced',135,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10073,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10074,1,4,'oz',113,'g',1,'1996-09-30','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10074,2,1,'roast',2745,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10075,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10075,2,1,'roast',2252,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10076,1,1,'cup, diced',135,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (10076,2,3,'oz',85,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (10077,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10077,2,1,'roast',2745,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10078,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10078,2,1,'roast',2252,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10079,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10079,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',191,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10080,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10080,2,1,'steak without refuse (Yield from 1 raw steak, with refuse, weighing 380g)',288,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10080,3,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10081,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10081,2,1,'steak without refuse (Yield from 1 cooked steak, with refuse, weighing 249g)',185,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10082,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10082,2,1,'steak, excluding refuse (yield from 1 raw steak, with refuse, weighing 300 g)',169,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10083,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10083,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',262,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10084,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10084,2,1,'steak without refuse (Yield from 1 raw steak, with refuse, weighing 379g)',258,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10085,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10085,2,1,'steak',249,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10086,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10086,2,1,'steak, excluding refuse (yield from 1 raw steak, with refuse, weighing 300 g)',147,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10087,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10087,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',238,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10088,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10089,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10089,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',177,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10093,1,3,'oz',85,'g',1,'2004-07-15','2013-12-26');
INSERT INTO `cndb_wght` VALUES (10093,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',231,'g',1,'2004-07-15','2013-12-26');
INSERT INTO `cndb_wght` VALUES (10094,1,4,'oz',113,'g',1,'2015-01-06','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10094,2,1,'chop',170,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (10096,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10096,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10097,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10098,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10099,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10100,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10100,2,1,'ear',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10101,1,1,'ear (yield after cooking)',111,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10101,2,1,'unit, cooked (yield from 1 lb raw meat)',422,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10102,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10103,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10103,2,1,'heart',226,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10104,1,1,'cup',145,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10104,2,1,'heart',129,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10105,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10105,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10106,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10106,2,1,'kidney',233,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10107,1,1,'cup',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10107,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10109,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10109,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10110,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10110,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10111,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10112,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10112,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10113,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10114,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10114,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10115,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10115,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10116,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10117,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10117,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10118,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10119,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10119,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10120,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10120,2,1,'chop',215,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10121,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10121,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10122,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10122,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',231,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10123,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10123,2,1,'slice raw',28,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10123,3,1,'package',442,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10128,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10128,2,3,'slices',68,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10128,3,1,'package (12 oz)',340,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10130,1,3,'oz',85,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (10130,2,2,'slices (6 per 6-oz pkg.)',57,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (10130,3,1,'package (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10132,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10132,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10134,1,1,'CUP',140,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (10134,2,3,'oz',85,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (10136,1,1,'CUP',140,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (10136,2,3,'oz',85,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (10137,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10137,2,1,'cup',140,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10138,1,1,'cup',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10138,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10140,1,1,'cup',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10140,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10141,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10141,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10142,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10142,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10146,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10146,2,1,'patty',65,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10149,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10149,2,1,'slice',57,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10150,1,1,'cup',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10150,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10152,1,3,'oz',85,'g',1,'1996-09-30','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10152,2,1,'cup',140,'g',1,'1998-01-15','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10153,1,1,'CUP',140,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (10153,2,3,'oz',85,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (10163,1,3,'oz',85,'g',1,'2015-01-06','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10163,2,1,'chop',137,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (10164,1,4,'oz',113,'g',1,'2015-01-06','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10164,2,1,'chop',170,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (10165,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10165,2,8,'oz',227,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10166,1,1,'oz',28.35,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (10166,2,3,'oz',85,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (10167,1,1,'oz',28.35,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (10167,2,3,'oz',85,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (10168,1,1,'CUP',140,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (10168,2,3,'oz',85,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (10169,1,1,'CUP',140,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (10169,2,3,'oz',85,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (10170,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10170,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10171,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10171,2,1,'piece, cooked (yield from 1 lb unheated product)',376,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10173,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10174,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10174,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10175,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10175,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',275,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10176,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10176,2,1,'chop',172,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10177,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10177,2,1,'chop',169,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10178,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10178,2,1,'chop',215,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10179,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10179,2,1,'chop',172,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10180,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10180,2,1,'chop',169,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10181,1,1,'chop',142,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10181,2,3,'oz',85,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (10182,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10182,2,1,'cup',140,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10182,3,1,'slice (6-1/4" x 4" x 1/16") (1 oz)',28,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10183,1,1,'cup',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10183,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10184,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10184,2,1,'cup',140,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10185,1,1,'cup',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10185,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10186,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10186,2,1,'chop',142,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10187,1,1,'oz',28.35,'g',1,'2001-07-04','2006-11-30');
INSERT INTO `cndb_wght` VALUES (10187,2,1,'lb',453.6,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (10188,1,3,'oz',85,'g',1,'1998-01-15','2013-12-26');
INSERT INTO `cndb_wght` VALUES (10188,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',247,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (10189,1,3,'oz',85,'g',1,'2015-01-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (10189,2,1,'chop',137,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (10192,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10193,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10194,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10194,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 113 g)',101,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10195,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10195,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 113 g)',81,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10196,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10196,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 113 g)',80,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10197,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10197,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 113 g)',75,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10198,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10198,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',317,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10199,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10199,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 113 g)',88,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10200,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10200,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 113 g)',72,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10201,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10201,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 113 g)',71,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10202,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10202,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 113 g)',66,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10203,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10203,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',283,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10204,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10204,2,1,'rib without refuse (Yield from 1 raw rib, with refuse, weighing 196g)',128,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10205,1,1,'rib without refuse (Yield from 1 cooked rib, with refuse, weighing 140g)',86,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10205,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10206,1,1,'rack',138,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10207,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10207,2,1,'rib',197,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10208,1,1,'rib without refuse (yield from 1 cooked rib, with refuse, weighing 141g)',80,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10208,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10209,1,1,'rack',138,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10210,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10210,2,1,'chop',210,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10211,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10211,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 113 g)',82,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10212,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10212,2,1,'chop',159,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10213,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10213,2,1,'roast',638,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10214,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10214,2,1,'chop',210,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10215,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10215,2,1,'chop',161,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10216,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10216,2,1,'chop',159,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10217,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10217,2,1,'roast',638,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10218,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10218,2,1,'roast (Yield from 1 raw roast, with refuse, weighing 504g)',505,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10219,1,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (10219,2,4,'oz',113,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (10220,1,3,'oz',85,'g',1,'1996-09-30','2013-12-26');
INSERT INTO `cndb_wght` VALUES (10221,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10221,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 113 g)',76,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10222,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10222,2,1,'roast',402,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10223,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10223,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 113 g)',73,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10224,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10224,2,1,'roast',2195,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10225,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10225,2,1,'roast',2195,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10226,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10226,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10227,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10227,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',261,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10228,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10228,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10229,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10229,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',236,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10858,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10858,2,1,'chop boneless',150,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10859,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10859,2,1,'chop boneless (yield from 189g raw meat)',150,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10860,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10860,2,1,'slice cooked',8.1,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10861,1,1,'slice cooked',9.1,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10862,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10862,2,1,'slice',11.5,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10863,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10864,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10865,1,3,'serving (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10865,2,1,'roast rump',2970,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10866,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10867,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10867,2,1,'roast shank',3054,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10868,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10868,2,1,'slice',436,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10869,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10869,2,1,'slice',446,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10870,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10870,2,1,'slice',138,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10871,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10871,2,1,'serving (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10871,3,1,'roast',1995,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10872,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10873,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10873,2,1,'roast rump',2673,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10874,1,1,'serving (3 oz)',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10874,2,1,'roast shank',3170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10875,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10875,2,1,'slice',445,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10876,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10876,2,1,'slice',145,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10876,3,1,'roast',920,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10876,4,1,'serving (3 oz)',85,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10877,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10877,2,1,'roast rump',2533,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10878,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10878,2,1,'slice',189,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10879,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10879,2,1,'roast whole',1867,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10880,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10881,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10881,2,1,'roast shank',3204,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10882,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10882,2,1,'slice',277,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10883,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10883,2,1,'roast',1497,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10884,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10884,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10885,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10886,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10887,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10887,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10888,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10889,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10890,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10891,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10892,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10892,2,1,'slice',430,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10893,1,3,'oz spiral slice',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10893,2,1,'lb spiral slice',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10894,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10895,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10898,1,3,'oz',117,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10899,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10899,2,1,'slice',366,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10900,1,3,'oz whole',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10900,2,1,'lb whole',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10901,1,3,'oz spiral slice',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10901,2,1,'lb spiral slice',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10902,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10903,1,3,'oz shank',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10903,2,1,'lb shank',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10904,1,3,'oz rump',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10904,2,1,'lb rump',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10905,1,3,'oz whole',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10905,2,1,'lb whole',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10906,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10906,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10907,1,3,'oz shank',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10907,2,1,'lb shank',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10908,1,3,'oz rump',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10908,2,1,'lb rump',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10909,1,3,'oz whole',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10909,2,1,'lb whole',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10910,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10910,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10911,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10911,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10912,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10912,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10913,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10913,2,1,'roast rump',2970,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10914,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10914,2,1,'roast shank',3054,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10915,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10915,2,1,'slice',436,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10916,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10916,2,1,'slice',189,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10917,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10917,2,1,'roast',1867,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10918,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10918,2,1,'roast rump',2533,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10919,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10919,2,1,'roast shank',3204,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10920,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10920,2,1,'slice',446,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10921,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10921,2,1,'slice',136,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10922,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10922,2,1,'roast',1995,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10923,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10923,2,1,'roast rump',2673,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10924,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10924,2,1,'roast shank',3170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10925,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10925,2,1,'slice',445,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10926,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10926,2,1,'slice',277,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10927,1,1,'slice',145,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10927,2,1,'roast',920,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10927,3,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10928,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10928,2,1,'roast',1497,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10929,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10929,2,1,'roast rump',2874,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10931,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10931,2,1,'roast rump',2874,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10932,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10932,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10933,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10933,2,1,'roast shank',2800,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10934,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10934,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10935,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10935,2,1,'roast shank',2800,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10936,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10936,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10937,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10937,2,1,'slice',366,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10938,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10938,2,1,'slice',425,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10939,1,3,'oz (3 oz)',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10939,2,1,'slice',425,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10940,1,3,'oz',85,'g',1,'2007-12-03','2013-12-26');
INSERT INTO `cndb_wght` VALUES (10942,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10942,2,1,'lb',453,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10943,1,3,'oz',85,'g',1,'2007-12-03','2013-12-26');
INSERT INTO `cndb_wght` VALUES (10944,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10945,1,3,'oz',85,'g',1,'2007-12-03','2013-12-26');
INSERT INTO `cndb_wght` VALUES (10946,1,4,'oz',113,'g',1,'2007-12-03','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10947,1,3,'oz',85,'g',1,'2007-12-03','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10947,2,1,'chop',107,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10948,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10948,2,1,'chop',146,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (10949,1,1,'chop',146,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (10950,1,3,'oz',85,'g',1,'2007-12-03','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10950,2,1,'chop',107,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10951,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10951,2,1,'roast',537,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10952,1,3,'oz',85,'g',1,'2007-12-03','2013-12-26');
INSERT INTO `cndb_wght` VALUES (10952,2,1,'roast',508,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10953,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10953,2,1,'steak',393,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10954,1,3,'oz',85,'g',1,'2007-12-03','2013-12-26');
INSERT INTO `cndb_wght` VALUES (10954,2,1,'steak',264,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10955,1,3,'oz',85,'g',1,'2007-12-03','2013-12-26');
INSERT INTO `cndb_wght` VALUES (10956,1,3,'oz',85,'g',1,'2009-01-25','2013-12-26');
INSERT INTO `cndb_wght` VALUES (10956,2,1,'piece',194,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10957,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10957,2,1,'piece',231,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10958,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10958,2,1,'piece',430,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10959,1,3,'oz',85,'g',1,'2009-01-25','2013-12-26');
INSERT INTO `cndb_wght` VALUES (10959,2,1,'piece',373,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10960,1,1,'piece',92,'g',1,'2009-01-25','2009-01-25');
INSERT INTO `cndb_wght` VALUES (10961,1,1,'piece',105,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10962,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10962,2,1,'piece',609,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10963,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10963,2,1,'piece',765,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10972,1,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10973,1,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10974,1,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10975,1,3,'oz grilled patties',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10976,1,3,'oz grilled patties',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10977,1,3,'oz grilled patties',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10978,1,3,'oz grilled patties',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10979,1,3,'oz grilled patties',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10980,1,4,'oz',113,'g',1,'2015-01-06','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10980,2,1,'ribs',1071,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (10981,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (10981,2,1,'ribs',878,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (10982,1,4,'oz',113,'g',1,'2012-03-02','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10982,2,1,'chop',176,'g',1,'2012-03-02','2013-12-26');
INSERT INTO `cndb_wght` VALUES (10983,1,3,'oz',85,'g',1,'2012-03-02','2013-12-26');
INSERT INTO `cndb_wght` VALUES (10983,2,1,'roast',848,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (10984,1,3,'oz',85,'g',1,'2012-03-02','2013-12-26');
INSERT INTO `cndb_wght` VALUES (10984,2,1,'chop',131,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (10985,1,3,'oz',85,'g',1,'2012-03-02','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10985,2,1,'rack',122,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10986,1,3,'oz',85,'g',1,'2012-03-02','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10986,2,1,'rack',122,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10987,1,3,'oz',85,'g',1,'2012-03-02','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10987,2,1,'rack',138,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10988,1,3,'oz',85,'g',1,'2012-03-02','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10988,2,1,'chop',131,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10989,1,4,'oz',113,'g',1,'2012-03-02','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10989,2,1,'chop',176,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10990,1,3,'oz',85,'g',1,'2012-03-02','2013-12-26');
INSERT INTO `cndb_wght` VALUES (10990,2,1,'roast',848,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (10991,1,3,'oz',85,'g',1,'2012-03-02','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10991,2,1,'rack',122,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10992,1,3,'oz',85,'g',1,'2012-03-02','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10992,2,1,'rack',122,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10993,1,3,'oz',85,'g',1,'2012-03-02','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10993,2,1,'rack',138,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (10998,1,1,'slice',13.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11001,1,1,'CUP',33,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11001,2,1,'TBSP',3,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11003,1,1,'cup',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11003,2,1,'leaf',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11004,1,1,'cup',132,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11007,1,1,'artichoke, medium',128,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11007,2,1,'artichoke, large',162,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11008,1,1,'artichoke, medium',120,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11008,2,0.5,'cup hearts',84,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11009,1,0.33,'package',84,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11009,2,1,'package (9 oz)',255,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11010,1,1,'cup',168,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11010,2,1,'package (9 oz), yields',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11010,3,0.333,'package (9 oz) yields',80,'g',1,'2013-12-23','2016-03-09');
INSERT INTO `cndb_wght` VALUES (11011,1,1,'CUP',134,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11011,2,1,'spear, small (5" long or less)',12,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11011,3,1,'spear, medium (5-1/4" to 7" long)',16,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11011,4,1,'spear, large (7-1/4" to 8-1/2")',20,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11011,5,1,'spear, extra large (8-3/4" to 10" long)',24,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11011,6,1,'spear tip (2" long or less)',3.5,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11012,1,0.5,'CUP',90,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11012,2,4,'spears (1/2" base)',60,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11013,1,0.5,'CUP',122,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11013,2,1,'can (300 x 407)',411,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11015,1,1,'CUP',242,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11015,2,1,'spear (about 5" long)',18,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11015,3,1,'can (300 x 407)',248,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11018,1,4,'spears',58,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11018,2,1,'package (10 oz)',284,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11019,1,1,'CUP',180,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11019,2,1,'package (10 oz) yields',293,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11019,3,4,'spears',60,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11023,1,1,'cup',58,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11025,1,1,'cup (1/2" pieces)',124,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11025,2,0.5,'cup (1/2" pieces)',62,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11026,1,1,'cup (1/2" slices)',151,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11026,2,0.5,'cup (1/2" pieces)',76,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11027,1,1,'cup (1/2" slices)',120,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11027,2,1,'shoot',144,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11028,1,1,'cup (1/8" slices)',131,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11028,2,1,'can (303 x 406)',262,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11029,1,1,'cup',184,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11031,1,1,'cup',156,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11032,1,1,'CUP',170,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11033,1,0.5,'CUP',124,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11033,2,1,'can (303 x 406)',454,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11037,1,1,'cup',160,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11037,2,1,'package (10 oz)',284,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11038,1,1,'cup',170,'g',1,'1997-08-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11038,2,1,'package (10 oz) yields',311,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11039,1,1,'cup',164,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11039,2,1,'package (10 oz)',284,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11040,1,1,'cup',180,'g',1,'1999-03-22','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11040,2,1,'package (10 oz) yields',311,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11043,1,1,'cup',104,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11043,2,1,'package (12 oz)',340,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11044,1,1,'cup',124,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11045,1,1,'cup',124,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11046,1,1,'cup',104,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11048,1,0.333,'package (10 oz)',94,'g',1,'2013-12-23','2016-03-09');
INSERT INTO `cndb_wght` VALUES (11048,2,1,'package (10 oz)',284,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11049,1,0.333,'package (10 oz) yields',94,'g',1,'1997-08-29','2016-03-09');
INSERT INTO `cndb_wght` VALUES (11049,2,1,'package (10 oz) yields',284,'g',1,'2007-11-28','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11050,1,1,'cup',245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11052,1,1,'cup 1/2" pieces',100,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (11052,2,10,'beans (4" long)',55,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11053,1,1,'CUP',125,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11054,1,1,'cup',240,'g',1,'1994-01-31','2012-03-02');
INSERT INTO `cndb_wght` VALUES (11054,2,1,'can total can contents',423,'g',1,'2002-09-06','2012-03-02');
INSERT INTO `cndb_wght` VALUES (11056,1,1,'cup',135,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (11056,2,10,'beans',62,'g',1,'1994-09-29','2007-03-25');
INSERT INTO `cndb_wght` VALUES (11056,3,1,'can (303 x 406)',262,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (11058,1,0.5,'CUP',114,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11058,2,1,'can (303 x 406)',439,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11060,1,1,'CUP',121,'g',1,'1996-09-30','2009-02-11');
INSERT INTO `cndb_wght` VALUES (11060,2,1,'package (10 oz)',284,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11061,1,1,'CUP',135,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11062,1,1,'cup',111,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11080,1,1,'cup',136,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11080,2,1,'beet (2" dia)',82,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11081,1,0.5,'cup slices',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11081,2,2,'beets (2" dia, sphere)',100,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (11082,1,1,'CUP',246,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11084,1,1,'cup, diced',157,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11084,2,1,'cup, shredded',195,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11084,3,1,'cup slices',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11084,4,1,'cup, whole',163,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11084,5,1,'slice',8,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11084,6,1,'beet',24,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11084,7,1,'can (303 x 406)',294,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11086,1,1,'CUP',38,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11086,2,1,'leaf',32,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11086,3,0.5,'cup (1" pieces)',19,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11087,1,1,'cup (1" pieces)',144,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11087,2,0.5,'cup (1" pieces)',72,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (11088,1,1,'cup',109,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11088,2,1,'broadbean',8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11090,1,1,'cup chopped',91,'g',1,'2009-02-11','2009-02-11');
INSERT INTO `cndb_wght` VALUES (11090,2,1,'bunch',608,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11090,3,1,'spear (about 5" long)',31,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11090,4,1,'stalk',151,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11090,5,0.5,'cup, chopped or diced',44,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11090,6,1,'NLEA serving',148,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (11091,1,0.5,'cup, chopped',78,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11091,2,1,'stalk, large (11"-12" long)',280,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11091,3,1,'stalk, medium (7-1/2" - 8" long)',180,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11091,4,1,'stalk, small (5" long)',140,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11091,5,1,'spear (about 5" long)',37,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11092,1,1,'CUP',156,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11092,2,1,'package (10 oz)',284,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11093,1,1,'CUP',184,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11094,1,0.33,'package (10 oz)',95,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11094,2,1,'package (10 oz)',284,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11094,3,1,'package (2 lb)',907,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11095,1,0.5,'cup',92,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11095,2,1,'package (10 oz) yields',250,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11096,1,1,'cup chopped',40,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11096,2,1,'stalk',19,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11097,1,1,'NLEA serving',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11097,2,1,'bunch cooked',437,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11098,1,1,'cup',88,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11098,2,1,'sprout',19,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11099,1,1,'sprout',21,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11099,2,0.5,'CUP',78,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11100,1,0.33,'package (10 oz)',95,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11100,2,1,'package (10 oz)',284,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11100,3,1,'package (2 lb)',907,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11101,1,1,'CUP',155,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11104,1,1,'cup (1" pieces)',118,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11104,2,1,'root',156,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11105,1,1,'cup (1" pieces)',125,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11105,2,1,'root',166,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11109,1,1,'cup, chopped',89,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11109,2,1,'cup, shredded',70,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11109,3,1,'head, large (about 7" dia)',1248,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11109,4,1,'leaf, large',33,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11109,5,1,'head, medium (about 5-3/4" dia)',908,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11109,6,1,'leaf, medium',23,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11109,7,1,'head, small (about 4-1/2" dia)',714,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11109,8,1,'leaf',15,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11110,1,0.5,'cup, shredded',75,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11110,2,1,'head',1262,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11112,1,1,'cup, chopped',89,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11112,2,1,'cup, shredded',70,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11112,3,1,'head, large (about 5-1/2" dia)',1134,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11112,4,1,'leaf',23,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11112,5,1,'head, medium (about 5" dia)',839,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11112,6,1,'head, small (4" dia)',567,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11113,1,1,'leaf',22,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11113,2,0.5,'cup, shredded',75,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11114,1,1,'cup, shredded',70,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11115,1,1,'cup, shredded',145,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11116,1,1,'cup, shredded',70,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11116,2,1,'head',840,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11116,3,1,'leaf',14,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11117,1,1,'cup, shredded',170,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11118,1,1,'cup',150,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (11119,1,1,'cup, shredded',76,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11120,1,1,'cup, shredded',119,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11120,2,1,'leaf',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11122,1,1,'cup, shredded',178,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11124,1,1,'cup chopped',128,'g',1,'1994-09-29','2007-03-25');
INSERT INTO `cndb_wght` VALUES (11124,2,1,'cup grated',110,'g',1,'1998-01-15','2007-03-25');
INSERT INTO `cndb_wght` VALUES (11124,3,1,'cup strips or slices',122,'g',1,'1999-03-22','2007-03-25');
INSERT INTO `cndb_wght` VALUES (11124,4,1,'large (7-1/4" to 8-/1/2" long)',72,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (11124,5,1,'medium',61,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (11124,6,1,'small (5-1/2" long)',50,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (11124,7,1,'slice',3,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (11124,8,1,'strip large (3" long)',7,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (11124,9,1,'strip medium',4,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (11125,1,1,'TBSP',9.7,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11125,2,0.5,'cup slices',78,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11125,3,1,'carrot',46,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11126,1,0.5,'cup slices',123,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11126,2,1,'can (303 x 406)',454,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11128,1,1,'cup, sliced',146,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11128,2,1,'cup, mashed',228,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11128,3,1,'slice',2.8,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11128,4,1,'can (303 x 406)',284,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11130,1,0.5,'cup slices',64,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11130,2,1,'package (10 oz)',284,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11131,1,1,'cup, sliced',146,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11134,1,1,'CUP',206,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11134,2,1,'root',408,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (11135,1,1,'cup chopped (1/2" pieces)',107,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11135,2,1,'floweret',13,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11135,3,1,'head large (6-7" dia.)',840,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11135,4,1,'head medium (5-6" dia.)',588,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11135,5,1,'head small (4" dia.)',265,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11136,1,0.5,'cup (1" pieces)',62,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11136,2,3,'flowerets',54,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11137,1,0.5,'cup (1" pieces)',66,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11137,2,1,'package (10 oz)',284,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11138,1,1,'cup (1" pieces)',180,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11141,1,1,'cup',156,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11143,1,1,'cup chopped',101,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11143,2,1,'NLEA serving',110,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11143,3,1,'TBSP',7.5,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11143,4,1,'stalk, large (11"-12" long)',64,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11143,5,1,'stalk, medium (7-1/2" - 8" long)',40,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11143,6,1,'stalk, small (5" long)',17,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11143,7,1,'strip (4" long)',4,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11144,1,1,'cup, diced',150,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11144,2,2,'stalks',75,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11147,1,1,'cup',36,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11147,2,1,'leaf',48,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11148,1,1,'cup, chopped',175,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11149,1,1,'cup (1" pieces)',132,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11149,2,1,'chayote (5-3/4")',203,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11150,1,1,'cup (1" pieces)',160,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11151,1,1,'head',53,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11151,2,0.5,'cup',45,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11152,1,1,'cup, chopped',29,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11154,1,1,'root',60,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11154,2,0.5,'cup (1" pieces)',45,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11156,1,1,'tbsp chopped',3,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11156,2,1,'tsp chopped',1,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11158,1,1,'cup (1" pieces)',100,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (11161,1,1,'cup, chopped',36,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11162,1,1,'cup, chopped',190,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11163,1,0.33,'package (10 oz)',95,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11163,2,1,'package (10 oz)',284,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11163,3,1,'package (3 lb)',1361,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11164,1,1,'cup, chopped',170,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11165,1,0.25,'cup',4,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11165,2,9,'sprigs',20,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11167,1,1,'cup',145,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11167,2,1,'ear, large (7-3/4" to 9" long) yields',143,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (11167,3,1,'ear, medium (6-3/4" to 7-1/2" long) yields',102,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11167,4,1,'ear, small (5-1/2" to 6-1/2" long)',73,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (11168,1,1,'ear small (5-1/2" to 6-1/2" long)',89,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11168,2,1,'ear medium (6-3/4" to 7-1/2" long)',103,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11168,3,1,'ear large (7-3/4" to 9" long)',118,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11168,4,1,'cup cut',149,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11168,5,1,'baby ear',8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11170,1,1,'cup',256,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11170,2,1,'can (303 x 406)',482,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11172,1,1,'CUP',164,'g',1,'1994-09-29','2007-03-25');
INSERT INTO `cndb_wght` VALUES (11172,2,1,'can (12 oz) yields',211,'g',1,'1997-08-29','2007-03-25');
INSERT INTO `cndb_wght` VALUES (11172,3,1,'can (303 x 406)',298,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (11174,1,1,'CUP',256,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11174,2,1,'can (303 x 406)',482,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11176,1,1,'cup',210,'g',1,'1997-08-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11176,2,1,'can, 15 oz (303 x 406)',425,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11176,3,1,'can (303 x 406)',340,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11177,1,1,'cup drained, rinsed',150,'g',1,'2012-03-02','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11177,2,1,'can drained, rinsed',266,'g',1,'2012-03-02','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11178,1,1,'CUP',136,'g',1,'1994-01-31','2009-02-11');
INSERT INTO `cndb_wght` VALUES (11178,2,1,'package',284,'g',1,'2002-09-06','2009-02-11');
INSERT INTO `cndb_wght` VALUES (11179,1,1,'cup',165,'g',1,'1997-08-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11179,2,1,'package (10 oz) yields',284,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11180,1,1,'cup kernels',165,'g',1,'1996-09-30','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11180,2,1,'ear, yields',125,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11181,1,1,'cup kernels',165,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11181,2,1,'ear, yields',63,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11182,1,1,'cup',141,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11184,1,1,'cup',227,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11191,1,1,'cup',145,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11192,1,1,'cup',165,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11195,1,1,'cup',160,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11195,2,1,'package (10 oz)',284,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11196,1,1,'cup',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11197,1,1,'cup',94,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11197,2,1,'pod',12,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11198,1,1,'cup',95,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11199,1,1,'cup slices',91,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11199,2,1,'pod',12,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11200,1,1,'cup slices',104,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11200,2,1,'pod',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11201,1,1,'cup, chopped',36,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11201,2,1,'leaf',3,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11202,1,1,'cup, chopped',53,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11203,1,1,'cup',50,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11203,2,1,'sprig',1,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11204,1,1,'cup',135,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11204,2,0.5,'cup',68,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11205,1,0.5,'cup slices',52,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11205,2,1,'cucumber (8-1/4")',301,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11206,1,1,'cup, pared, chopped',133,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11206,2,1,'cup, sliced',119,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11206,3,1,'large (8-1/4" long)',280,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11206,4,1,'medium',201,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11206,5,1,'slice',7,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11206,6,1,'small (6-3/8" long)',158,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11206,7,1,'stick (4" long)',9,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11207,1,1,'cup, chopped',55,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11208,1,1,'cup, chopped',105,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11209,1,1,'cup, cubes',82,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11209,2,1,'eggplant, peeled (yield from 1-1/4 lb)',458,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11209,3,1,'eggplant, unpeeled (approx 1-1/4 lb)',548,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11210,1,1,'cup (1" cubes)',99,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11212,1,1,'cup',155,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11213,1,0.5,'cup, chopped',25,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11213,2,1,'head',513,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11214,1,1,'cup',150,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (11215,1,1,'CUP',136,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11215,2,1,'tsp',2.8,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11215,3,1,'clove',3,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11215,4,3,'cloves',9,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11216,1,1,'tsp',2,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11216,2,0.25,'cup slices (1" dia)',24,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11216,3,5,'slices (1" dia)',11,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11218,1,0.5,'cup (1" pieces)',58,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11218,2,1,'gourd',771,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11219,1,1,'cup (1" cubes)',146,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11220,1,1,'cup (1" pieces)',95,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11220,2,1,'gourd',178,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11221,1,1,'cup (1" pieces)',178,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11221,2,0.5,'cup (1" slices)',89,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11223,1,1,'cup, chopped',42,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11224,1,1,'cup',80,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11225,1,1,'cup',87,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11226,1,1,'cup slices',150,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11231,1,1,'cup',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11232,1,1,'cup',87,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11233,1,1,'cup',21,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (11234,1,1,'cup',118,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (11235,1,0.333,'cup',67,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (11235,2,1,'package (10 oz)',284,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (11236,1,1,'cup',118,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (11237,1,1,'strip',6.3,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11237,2,0.5,'cup',27,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11240,1,1,'cup',66,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11240,2,1,'piece',12.9,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11241,1,1,'cup',135,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11241,2,1,'slice',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11242,1,1,'cup slices',165,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11243,1,1,'cup sliced',121,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11245,1,1,'cup, chopped',180,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11246,1,1,'CUP',89,'g',1,'1995-06-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11246,2,1,'leek',89,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11246,3,1,'slice',6,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11247,1,1,'leek',124,'g',1,'1998-03-27','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11247,2,0.25,'cup, chopped or diced',26,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11248,1,1,'cup',77,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11250,1,1,'cup, shredded or chopped',55,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11250,2,1,'head (5" dia)',163,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11250,3,1,'leaf, large',15,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11250,4,1,'leaf, medium',7.5,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11250,5,1,'leaf',5,'g',1,'2005-12-28','2009-02-11');
INSERT INTO `cndb_wght` VALUES (11251,1,1,'cup shredded',47,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11251,2,1,'leaf inner',6,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11251,3,1,'leaf outer',28,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11251,4,1,'head',626,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11251,5,1,'NLEA serving',85,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11252,1,1,'cup shredded',72,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11252,2,1,'cup, chopped (1/2" pieces, loosely packed)',57,'g',1,'1997-08-29','2010-03-24');
INSERT INTO `cndb_wght` VALUES (11252,3,1,'head, large',755,'g',1,'2002-09-06','2010-03-24');
INSERT INTO `cndb_wght` VALUES (11252,4,1,'head, medium (6" dia)',539,'g',1,'2002-09-06','2010-03-24');
INSERT INTO `cndb_wght` VALUES (11252,5,1,'head, small',324,'g',1,'2002-09-06','2010-03-24');
INSERT INTO `cndb_wght` VALUES (11252,6,1,'leaf, large',15,'g',1,'2002-09-06','2010-03-24');
INSERT INTO `cndb_wght` VALUES (11252,7,1,'leaf, medium',8,'g',1,'2005-12-28','2010-03-24');
INSERT INTO `cndb_wght` VALUES (11252,8,1,'leaf, small',5,'g',1,'2002-09-06','2010-03-24');
INSERT INTO `cndb_wght` VALUES (11252,9,1,'NLEA Serving',89,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11253,1,1,'cup shredded',36,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11253,2,1,'head',360,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11253,3,1,'leaf inner',4.8,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11253,4,1,'leaf outer',24,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11254,1,10,'slices (2-1/2" dia)',81,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11254,2,1,'root (9-1/2" long)',115,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11255,1,0.5,'cup',60,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11255,2,10,'slices (2-1/2" dia)',89,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11257,1,1,'cup shredded',28,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (11257,2,1,'leaf inner',2.6,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (11257,3,1,'leaf outer',17,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (11257,4,1,'head',309,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (11257,5,1,'NLEA serving',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (11258,1,0.5,'cup, cubes',68,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11258,2,1,'yam',420,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11259,1,1,'cup, cubes',145,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11260,1,1,'cup, pieces or slices',70,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11260,2,1,'cup, whole',96,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11260,3,1,'large',23,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11260,4,1,'medium',18,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11260,5,1,'slice',6,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11260,6,1,'small',10,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11260,7,0.5,'cup pieces',35,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11261,1,1,'cup pieces',156,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11261,2,1,'tbsp',9.8,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (11261,3,1,'mushroom',12,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (11263,1,1,'cup sliced',108,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11264,1,1,'CUP',156,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11264,2,1,'can',132,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11264,3,1,'large',16,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11264,4,1,'medium',12,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11264,5,1,'small',7,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11264,6,10,'slices',40,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11264,7,8,'caps',47,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11264,8,0.5,'cup pieces',78,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11265,1,1,'cup diced',86,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11265,2,1,'piece whole',84,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (11266,1,1,'cup whole',87,'g',1,'2002-06-08','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11266,2,1,'cup sliced',72,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (11266,3,1,'piece whole',20,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (11267,1,1,'cup whole',89,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11267,2,1,'cup sliced',97,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11267,3,1,'piece whole',19,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11268,1,1,'mushroom',3.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11268,2,4,'mushrooms',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11269,1,1,'cup pieces',145,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11269,2,4,'mushrooms',72,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11270,1,1,'cup, chopped',56,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11271,1,1,'cup, chopped',140,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11272,1,1,'cup, chopped',146,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11272,2,1,'package (10 oz)',284,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11273,1,1,'cup, chopped',150,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11273,2,1,'package (10 oz) yields',212,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11274,1,1,'cup, chopped',150,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11276,1,1,'cup, chopped',56,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11277,1,1,'cup, chopped',180,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11278,1,1,'cup',100,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (11278,2,8,'pods (3" long)',95,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11279,1,0.5,'cup slices',80,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11279,2,8,'pods (3" long)',85,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11280,1,0.33,'package (10 oz)',95,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11280,2,1,'package (10 oz)',284,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11280,3,1,'package (3 lb)',1361,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11281,1,0.5,'cup slices',92,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11281,2,1,'package (10 oz) yields',255,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11282,1,1,'cup, chopped',160,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11282,2,1,'cup, sliced',115,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11282,3,1,'tbsp chopped',10,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11282,4,1,'large',150,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11282,5,1,'slice, large (1/4" thick)',38,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11282,6,1,'medium (2-1/2" dia)',110,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11282,7,1,'slice, medium (1/8" thick)',14,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11282,8,1,'small',70,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11282,9,1,'slice, thin',9,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11282,10,10,'rings',60,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11283,1,1,'CUP',210,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11283,2,1,'tbsp chopped',15,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11283,3,1,'large',128,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11283,4,1,'slice, large (1/4" thick)',32,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11283,5,1,'medium',94,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11283,6,1,'slice, medium (1/8" thick)',12,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11283,7,1,'small',60,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11283,8,1,'slice, thin',8,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11284,1,1,'TBSP',5,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11284,2,0.25,'CUP',14,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11285,1,1,'onion',63,'g',1,'1994-11-17','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11285,2,0.5,'cup, chopped or diced',112,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11286,1,1,'cup chopped',87,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11287,1,0.33,'package (10 oz)',95,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11287,2,1,'package (10 oz)',284,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11288,1,1,'tbsp chopped',15,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11288,2,0.5,'cup, chopped or diced',105,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11289,1,0.33,'package (10 oz)',95,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11289,2,1,'package (10 oz)',284,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11290,1,1,'CUP',210,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11291,1,1,'cup, chopped',100,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (11291,2,1,'tbsp chopped',6,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11291,3,1,'large',25,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11291,4,1,'medium (4-1/8" long)',15,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11291,5,1,'small (3" long)',5,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11292,1,1,'tbsp',6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11292,2,1,'stalk',12,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11292,3,1,'cup chopped',71,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11295,1,6,'rings',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11295,2,1,'package (16 oz)',454,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11295,3,1,'package (9 oz)',255,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11296,1,1,'CUP',48,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11296,2,10,'rings, large (3-4" dia)',71,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11296,3,10,'rings, medium (2-3" dia)',60,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11296,4,10,'rings, small (1-2" dia)',48,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11297,1,1,'cup chopped',60,'g',1,'1994-09-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11297,2,1,'TBSP',3.8,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11297,3,10,'sprigs',10,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11298,1,1,'cup slices',133,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11299,1,0.5,'cup slices',78,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11299,2,1,'parsnip (9" long)',160,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11300,1,1,'cup, chopped',98,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11300,2,1,'cup, whole',63,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11300,3,10,'pea pods',34,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11301,1,1,'CUP',160,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11302,1,1,'cup',144,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11302,2,1,'package (10 oz)',284,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11303,1,1,'CUP',160,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11303,2,1,'package (10 oz) yields',253,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (11304,1,1,'cup',145,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11305,1,1,'CUP',160,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11306,1,0.5,'CUP',124,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11306,2,1,'can (303 x 406)',482,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11308,1,1,'CUP',175,'g',1,'1994-09-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (11308,2,1,'can (303 x 406)',313,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11310,1,1,'CUP',227,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11310,2,0.5,'CUP',114,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (11311,1,1,'can',257,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (11311,2,1,'cup',163,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (11312,1,1,'CUP',134,'g',1,'1994-01-31','2009-02-11');
INSERT INTO `cndb_wght` VALUES (11312,2,1,'package',284,'g',1,'2002-09-06','2009-02-11');
INSERT INTO `cndb_wght` VALUES (11313,1,0.5,'CUP',80,'g',1,'1997-08-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (11313,2,1,'package (10 oz) yields',253,'g',1,'1994-01-31','2009-02-11');
INSERT INTO `cndb_wght` VALUES (11316,1,1,'cup',120,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11318,1,1,'CUP',255,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11322,1,0.5,'CUP',70,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11322,2,1,'package (10 oz)',284,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11323,1,1,'package (10 oz) yields',278,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11323,2,0.5,'CUP',80,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11324,1,1,'CUP',120,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11326,1,0.5,'CUP',69,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11326,2,1,'package (10 oz)',284,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11327,1,1,'CUP',180,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11329,1,1,'pepper',73,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11329,2,0.5,'cup, chopped or diced',68,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11333,1,1,'cup, chopped',149,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11333,2,1,'cup, sliced',92,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11333,3,1,'TBSP',9.3,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11333,4,1,'large (2-1/4 per lb, approx 3-3/4" long, 3" dia)',164,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11333,5,1,'medium (approx 2-3/4" long, 2-1/2" dia)',119,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11333,6,1,'ring (3" dia, 1/4" thick)',10,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11333,7,1,'small',74,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11333,8,10,'strips',27,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11334,1,1,'cup, chopped or strips',135,'g',1,'1994-11-02','2009-02-11');
INSERT INTO `cndb_wght` VALUES (11334,2,1,'tablespoon, chopped',11.6,'g',1,'1997-08-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (11335,1,1,'cup, halves',140,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (11337,1,0.33,'package (10 oz)',95,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11337,2,1,'package (10 oz)',284,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11339,1,1,'cup chopped',115,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11344,1,1,'CUP',154,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11344,2,10,'seeds',4,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11345,1,1,'CUP',153,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11349,1,1,'cup',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11351,1,1,'cup',165,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11351,2,1,'tbsp',10,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11352,1,0.5,'cup, diced',75,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11352,2,1,'Potato large (3" to 4-1/4" dia)',369,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11352,3,1,'Potato medium (2-1/4" to 3-1/4" dia)',213,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11352,4,1,'Potato small (1-3/4" to 2-1/2" dia)',170,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11353,1,0.5,'cup, diced',75,'g',1,'2006-02-23','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11353,2,1,'potato large (3" to 4-1/4" dia)',369,'g',1,'2006-02-23','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11353,3,1,'Potato medium (2-1/4" to 3-1/4" dia)',213,'g',1,'2006-02-23','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11353,4,1,'Potato small (1-3/4" to 2-1/4" dia)',170,'g',1,'2006-02-23','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11354,1,0.5,'cup, diced',75,'g',1,'2006-02-23','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11354,2,1,'large (3" to 4-1/4" dia.)',369,'g',1,'2006-02-23','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11354,3,1,'medium (2+-1/4" to 3-1/4" dia.)',213,'g',1,'2006-02-23','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11354,4,1,'small (1-3/4" to 2-1/4" dia.)',92,'g',1,'2006-02-23','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11355,1,0.5,'cup, diced',75,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11355,2,1,'potato large (3" to 4-1/4" dia)',369,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11355,3,1,'potato medium (2-1/4" to 3-1/4" dia)',213,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11355,4,1,'potato small (1-3/4" to 2-1/4" dia)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11356,1,1,'potato large (3" to 4-1/4" dia.',299,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11356,2,1,'potato medium (2-1/4" to 3-1/4" dia.)',173,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11356,3,1,'potato small (1-3/4" to 2-1/2" dia.)',138,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11357,1,1,'potato large (3" to 4-1/4" dia)',299,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11357,2,1,'potato medium (2-1/4" to 3-1/4" dia)',173,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11357,3,1,'potato small (1-3/4" to 2-1/2" dia)',138,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11358,1,1,'potato large (3" to 4-1/4" dia.',299,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11358,2,1,'potato medium (2-1/4" to 3-1/4" dia.)',173,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11358,3,1,'potato small (1-3/4" to 2-1/2" dia.)',138,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11359,1,10,'strip',82,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11359,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11360,1,10,'strip',69,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11361,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11362,1,1,'skin',38,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11363,1,0.5,'cup',61,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11363,2,1,'potato (2-1/3" x 4-3/4")',156,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11364,1,1,'skin',58,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11365,1,0.5,'CUP',78,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11365,2,1,'potato (2-1/2" dia, sphere)',136,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11366,1,1,'skin',34,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11367,1,0.5,'cup',78,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11367,2,1,'large (3" to 4-1/4" dia.)',300,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11367,3,1,'medium (2-1/4" to 3-1/4" dia.)',167,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11367,4,1,'small (1-3/4" to 2-1/2" dia.)',125,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11368,1,0.5,'cup',78,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11368,2,1,'potato (2-1/3" x 4-3/4")',156,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11369,1,1,'skin',58,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11370,1,1,'cup',156,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11371,1,1,'cup',210,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11372,1,1,'cup',245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11373,1,1,'cup',245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11374,1,1,'cup, whole',300,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11374,2,1,'can (303 x 406)',454,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11376,1,1,'CUP',180,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11376,2,1,'potato',35,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11378,1,1,'CUP',60,'g',1,'1999-03-22','2007-03-25');
INSERT INTO `cndb_wght` VALUES (11379,1,1,'CUP',210,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11380,1,1,'CUP',200,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11381,1,1,'CUP',210,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11382,1,1,'cup',200,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11383,1,1,'CUP',210,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11384,1,0.167,'package (5.5 oz)',26,'g',1,'2013-12-23','2016-03-09');
INSERT INTO `cndb_wght` VALUES (11384,2,1,'package (5.5 oz)',156,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11385,1,0.167,'package (5.5 oz) yields',137,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11385,2,1,'package yield, 5.5 oz',822,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11386,1,0.167,'package (5.5 oz)',26,'g',1,'2013-12-23','2016-03-09');
INSERT INTO `cndb_wght` VALUES (11386,2,1,'package (5.5 oz)',156,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11387,1,1,'cup (unprepared)',245,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11387,2,0.167,'package (5.5 oz) yields',137,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11387,3,1,'package yield, 5.5 oz',822,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11390,1,0.5,'cup',105,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11390,2,1,'package (12 oz)',340,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11391,1,1,'cup prepared',150,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11391,2,1,'patty, oval (approx 3" x 1-1/2" x 1/2")',29,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11391,3,1,'package yield, 12 oz',205,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11392,1,1,'package (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11394,1,10,'strip',30,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11395,1,10,'strip',21,'g',1,'2006-02-23','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11398,1,1,'cup',120,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11398,2,10,'pieces',91,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11399,1,10,'puffs',79,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11399,2,10,'Crispy Crowns',60,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11399,3,1,'puff',7,'g',1,'1998-01-15','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11399,4,1,'cup',128,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11402,1,10,'strip',89,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11402,2,1,'package (9 oz)',255,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11403,1,10,'fries',76,'g',1,'1997-08-29','2015-01-07');
INSERT INTO `cndb_wght` VALUES (11403,2,1,'package (9 oz), yields',198,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11406,1,10,'strips',65,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11406,2,1,'package (9 oz)',255,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11407,1,10,'strips',50,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11407,2,1,'package (9 oz), yields',198,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11408,1,10,'strips',65,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11408,2,1,'package (9 oz)',255,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11409,1,10,'strips',50,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11409,2,1,'package (9 oz), yields',198,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11411,1,10,'strip',153,'g',1,'2006-02-23','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11412,1,10,'strip',133,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11413,1,1,'cup',160,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11414,1,1,'CUP',250,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11416,1,1,'cup',33,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11416,2,1,'flower',2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11417,1,1,'cup',134,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11418,1,1,'cup',39,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11419,1,1,'cup',71,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11422,1,1,'cup (1" cubes)',116,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11423,1,1,'cup, mashed',245,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11424,1,1,'CUP',245,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11426,1,1,'CUP',270,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11429,1,1,'cup slices',116,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11429,2,1,'large (1" to 1-1/4" dia)',9,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (11429,3,1,'medium (3/4" to 1" dia)',4.5,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (11429,4,1,'slice',1,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (11429,5,1,'small',2,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (11429,6,0.5,'cup slices',58,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (11430,1,1,'cup slices',116,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11430,2,1,'radish (7" long)',338,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11431,1,1,'cup, sliced',147,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11432,1,1,'cup',116,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11435,1,1,'cup, cubes',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11435,2,1,'large',772,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11435,3,1,'medium',386,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11435,4,1,'small',192,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11436,1,1,'cup, cubes',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11436,2,1,'cup, mashed',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11438,1,1,'cup, sliced',135,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11439,1,1,'CUP',142,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11439,2,1,'cup, undrained',236,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11442,1,2,'tbsp (1/8 cup)',10,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11444,1,2,'tbsp (1/8 cup)',10,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11445,1,2,'tbsp (1/8 cup)',10,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11446,1,10,'sheets',26,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11446,2,2,'tbsp (1/8 cup)',10,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11450,1,1,'cup',256,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11451,1,1,'cup',180,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11452,1,0.5,'CUP',35,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11452,2,10,'sprouts',10,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11453,1,1,'cup',94,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11457,1,1,'CUP',30,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11457,2,1,'bunch',340,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11457,3,1,'leaf',10,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11457,4,1,'package (10 oz)',284,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11458,1,1,'CUP',180,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11459,1,1,'CUP',234,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11461,1,1,'CUP',214,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11463,1,1,'CUP',156,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11463,2,1,'package (10 oz)',284,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11464,1,0.5,'cup',95,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11464,2,1,'package (10 oz) yields',220,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11467,1,1,'cup sliced',127,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11468,1,1,'cup, sliced',180,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11468,2,0.5,'cup slices',90,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11471,1,1,'cup, diced',210,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11471,2,1,'cup, mashed',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11471,3,1,'cup slices',216,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11471,4,1,'slice',8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11471,5,1,'can (303 x 406)',241,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11473,1,1,'cup slices',130,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11474,1,1,'cup slices',192,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11475,1,1,'cup slices',130,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11476,1,1,'cup, mashed',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11476,2,1,'cup, sliced',180,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11477,1,1,'cup, chopped',124,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11477,2,1,'cup, sliced',113,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11477,3,1,'large',323,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11477,4,1,'medium',196,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11477,5,1,'slice',9.9,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11477,6,1,'small',118,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11478,1,1,'cup, sliced',180,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11478,2,0.5,'cup, mashed',120,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11479,1,0.33,'package (10 oz)',95,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11479,2,1,'package (10 oz)',284,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11479,3,1,'package (3 lb)',1361,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11480,1,1,'CUP',223,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11481,1,1,'cup',227,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11482,1,1,'cup, cubes',140,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11482,2,1,'squash (4 inch dia)',431,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11483,1,1,'cup, cubes',205,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11484,1,1,'cup, mashed',245,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11485,1,1,'cup, cubes',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11486,1,1,'cup, cubes',205,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11487,1,0.33,'package (12 oz)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11487,2,1,'package (12 oz)',340,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11487,3,1,'package (4 lb)',1814,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11488,1,1,'cup, mashed',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11489,1,1,'cup, cubes',116,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11490,1,1,'cup, cubes',205,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11491,1,1,'cup, mashed',236,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11492,1,1,'cup, cubes',101,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11493,1,1,'cup',155,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11496,1,1,'cup',192,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11497,1,1,'CUP',266,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11499,1,1,'CUP',255,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11501,1,1,'CUP',156,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11501,2,1,'package (10 oz)',284,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11502,1,1,'CUP',170,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11504,1,1,'cup, chopped',98,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11505,1,1,'cup, chopped',35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11505,2,1,'leaf (12-1/4" long)',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11506,1,1,'cup',64,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11507,1,1,'cup, cubes',133,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11507,2,1,'sweetpotato, 5" long',130,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11508,1,1,'CUP',200,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11508,2,1,'large',180,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11508,3,1,'medium (2" dia, 5" long, raw)',114,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11508,4,1,'small',60,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11510,1,1,'cup, mashed',328,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11510,2,1,'medium',151,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11512,1,1,'cup, mashed',255,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11512,2,1,'cup pieces',200,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11514,1,1,'CUP',255,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11514,2,1,'can (404 x 307)',496,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11516,1,1,'cup, cubes',176,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11517,1,1,'cup, cubes',176,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11518,1,1,'cup, sliced',104,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11519,1,1,'cup, sliced',132,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11520,1,1,'cup',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11520,2,1,'leaf (11" x 6-1/2")',10,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11521,1,1,'cup',145,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11522,1,0.5,'cup slices',43,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11522,2,1,'shoot',83,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11523,1,1,'cup slices',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11525,1,1,'cup slices',125,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11526,1,1,'cup slices',137,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11527,1,1,'cup',180,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11527,2,1,'large',182,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11527,3,1,'medium',123,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11527,4,1,'slice or wedge',20,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11527,5,1,'small',91,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11529,1,1,'cup cherry tomatoes',149,'g',1,'1994-09-29','2007-03-25');
INSERT INTO `cndb_wght` VALUES (11529,2,1,'cup, chopped or sliced',180,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (11529,3,1,'Italian tomato',62,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (11529,4,1,'cherry',17,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (11529,5,1,'large whole (3" dia)',182,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (11529,6,1,'medium whole (2-3/5" dia)',123,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (11529,7,1,'slice, medium (1/4" thick)',20,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (11529,8,1,'plum tomato',62,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (11529,9,1,'small whole (2-2/5" dia)',91,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (11529,10,1,'slice, thick/large (1/2" thick)',27,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (11529,11,1,'wedge (1/4 of medium tomato)',31,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (11529,12,1,'slice, thin/small',15,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (11529,13,1,'NLEA serving',148,'g',1,'2004-07-15','2007-03-25');
INSERT INTO `cndb_wght` VALUES (11530,1,1,'CUP',240,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11530,2,2,'medium',246,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11531,1,1,'CUP',240,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11531,2,1,'TBSP',15,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11531,3,1,'can',190,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11531,4,1,'large',164,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11531,5,1,'medium',111,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11531,6,1,'small',82,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11533,1,1,'CUP',255,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11537,1,1,'cup',241,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11540,1,1,'CUP',243,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11540,2,6,'FL OZ',182,'g',1,'1999-03-22','2010-01-05');
INSERT INTO `cndb_wght` VALUES (11546,1,0.25,'cup',66,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11546,2,1,'cup',262,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11546,3,1,'tbsp',16,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11546,4,1,'can (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11547,1,1,'CUP',250,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11547,2,1,'can (29 oz) (401 x 411)',822,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11549,1,1,'CUP',245,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11551,1,1,'CUP',245,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11553,1,1,'CUP',245,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11555,1,0.5,'CUP',122,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11555,2,1,'can, 15 oz (303 x 406)',425,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11557,1,1,'CUP',250,'g',1,'1995-06-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11557,2,1,'can, 15 oz (303 x 406)',411,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11559,1,1,'CUP',244,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11559,2,1,'can, 15 oz (303 x 406)',425,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11563,1,0.5,'cup, chopped',71,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11563,2,1,'frond (6-1/2" long)',31,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11564,1,1,'cup, cubes',130,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11564,2,1,'large',183,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11564,3,1,'medium',122,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11564,4,1,'slice',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11564,5,1,'small',61,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11564,6,0.5,'cup, cubes',65,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11565,1,1,'cup, cubes',156,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11565,2,1,'cup, mashed',230,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11566,1,0.333,'package, mashed (10 oz)',94,'g',1,'2013-12-23','2016-03-09');
INSERT INTO `cndb_wght` VALUES (11566,2,1,'package, mashed (10 oz)',284,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11567,1,1,'cup',156,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11568,1,1,'cup, chopped',55,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11569,1,1,'cup, chopped',144,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11570,1,0.5,'CUP',117,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11570,2,1,'can, 15 oz (303 x 406)',425,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11574,1,0.5,'cup, chopped or diced',82,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11574,2,1,'package (10 oz)',284,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11575,1,1,'CUP',164,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11575,2,1,'package (10 oz) yields',220,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11576,1,0.33,'package (10 oz)',95,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11576,2,1,'package (10 oz)',284,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11576,3,1,'package (3 lb)',1361,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11577,1,1,'CUP',163,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11578,1,1,'cup',253,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11578,2,6,'FL OZ',182,'g',1,'1999-03-22','2010-01-05');
INSERT INTO `cndb_wght` VALUES (11579,1,1,'CUP',245,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11581,1,1,'CUP',163,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11583,1,0.33,'package (10 oz)',95,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11583,2,1,'package (10 oz)',284,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11583,3,1,'pack (2-1/2 lb)',1134,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11584,1,0.5,'cup',91,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11584,2,1,'package (10 oz) yields',275,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11585,1,1,'cup',254,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11585,2,6,'fl oz',182,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11588,1,0.5,'cup slices',62,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11588,2,4,'waterchestnuts',36,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11590,1,0.5,'cup slices',70,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11590,2,4,'waterchestnuts',28,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11591,1,1,'cup, chopped',34,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11591,2,1,'sprig',2.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11591,3,10,'sprigs',25,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11593,1,1,'cup, cubes',132,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11593,2,1,'waxgourd',5700,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11594,1,1,'cup, cubes',175,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11595,1,1,'cup slices',44,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11595,2,1,'pod',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11596,1,1,'cup',62,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11601,1,1,'cup, cubes',150,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11602,1,1,'cup, cubes',136,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11602,2,0.5,'cup, cubes',68,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (11603,1,1,'cup slices',120,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11603,2,1,'cup',130,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11603,3,1,'large',1200,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11603,4,1,'medium',659,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11603,5,1,'slice',6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11603,6,1,'small',365,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11605,1,1,'cup slices',246,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11609,1,1,'cup slices',227,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11613,1,1,'cup (1" pieces)',89,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11615,1,1,'TBSP',0.2,'g',1,'1994-11-17','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11615,2,0.25,'CUP',0.8,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11620,1,1,'cup slices',100,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (11620,2,1,'pod (15-1/3" long)',11,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11621,1,1,'cup slices',118,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11624,1,1,'tbsp',0.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11624,2,0.25,'cup',0.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11626,1,1,'CUP',125,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11632,1,1,'cup, chopped',136,'g',1,'1994-11-17','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11632,2,1,'cup, sliced',104,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11632,3,1,'pepper',22,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11637,1,0.5,'cup slices',50,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11637,2,1,'radish (7" long)',17,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11640,1,1,'tbsp',0.9,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11640,2,0.25,'cup',3.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11641,1,1,'cup, sliced',113,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11641,2,1,'large',323,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11641,3,1,'medium',196,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11641,4,1,'slice',9.9,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11641,5,1,'small',118,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11642,1,1,'cup, sliced',180,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11643,1,1,'cup, cubes',116,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11644,1,1,'cup, cubes',205,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11645,1,1,'CUP',228,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11645,2,1,'can (404 x 307)',638,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11647,1,1,'CUP',196,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11649,1,1,'CUP',244,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11649,2,1,'can, 15 oz (303 x 406)',425,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11655,1,1,'cup',236,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11655,2,1,'fl oz',29.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11656,1,1,'cup',250,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11656,2,0.667,'cup (#6 scoop)',167,'g',1,'2013-12-23','2016-03-09');
INSERT INTO `cndb_wght` VALUES (11657,1,1,'cup',210,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11658,1,1,'cup',136,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11658,2,1,'recipe yield',813,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11659,1,1,'piece (2-1/2" x 2" dia)',105,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11660,1,1,'cup',101,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11660,2,1,'recipe yield',604,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11667,1,1,'cup',112,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11667,2,1,'tablespoon',7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11669,1,2,'tbsp (1/8 cup)',10,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11670,1,1,'pepper',45,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11670,2,0.5,'cup, chopped or diced',75,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11671,1,1,'cup',194,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11671,2,1,'recipe yield',1162,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11672,1,1,'small 2-3/4 in. dia., 5/8 in. thick.',22,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11672,2,1,'medium 3-1/4 in. x 3-5/8 in., 5/8 in. thick.',37,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11674,1,1,'NLEA serving',148,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11674,2,1,'potato large',299,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11674,3,1,'potato medium',173,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11674,4,1,'potato small',138,'g',1,'2004-07-15','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11675,1,1,'potato (2-3/4" dia by 4-3/4" long)',202,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11676,1,1,'cup',38,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11677,1,1,'tbsp chopped',10,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11683,1,1,'cup',74,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11693,1,0.5,'cup',121,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11695,1,1,'cup, chopped',158,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11695,2,1,'tomato',111,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11696,1,1,'cup, chopped',139,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11696,2,1,'tomato',212,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11697,1,1,'cup, sliced',120,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11697,2,1,'root',33,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11700,1,1,'cup',132,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11702,1,1,'artichoke, medium',120,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11702,2,0.5,'cup hearts',84,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11703,1,1,'cup',168,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11703,2,1,'package (9 oz), yields',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11703,3,0.333,'package (9 oz) yields',80,'g',1,'2013-12-23','2016-03-09');
INSERT INTO `cndb_wght` VALUES (11705,1,0.5,'CUP',90,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11705,2,4,'spears (1/2" base)',60,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11707,1,0.5,'cup',122,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11707,2,1,'can (300 x 407)',411,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11709,1,1,'CUP',180,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11709,2,1,'package (10 oz) yields',293,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11709,3,4,'spears',60,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11712,1,1,'cup (1/2" slices)',120,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11712,2,1,'shoot',144,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11714,1,1,'CUP',170,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11715,1,1,'cup',248,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11715,2,1,'can (303 x 406)',454,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11716,1,1,'cup',180,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11716,2,1,'package (10 oz) yields',311,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11717,1,1,'cup',170,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11717,2,1,'package (10 oz) yields',311,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11718,1,1,'CUP',124,'g',1,'1994-11-17','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11720,1,0.333,'package (10 oz) yields',94,'g',1,'1997-08-29','2016-03-09');
INSERT INTO `cndb_wght` VALUES (11720,2,1,'package (10 oz) yields',284,'g',1,'2007-11-28','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11722,1,1,'cup 1/2" pieces',100,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (11722,2,10,'beans (4" long)',55,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11723,1,1,'CUP',125,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11724,1,1,'cup',125,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11725,1,1,'cup',125,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11726,1,0.5,'cup',120,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11726,2,1,'can (303 x 406)',439,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11727,1,0.5,'CUP',120,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11727,2,1,'can (303 x 406)',439,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11728,1,0.5,'cup',120,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11728,2,1,'can (303 x 406)',439,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11729,1,1,'cup',153,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11729,2,10,'beans',62,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11729,3,1,'can (303 x 406)',262,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11730,1,1,'CUP',121,'g',1,'1996-09-30','2010-01-04');
INSERT INTO `cndb_wght` VALUES (11730,2,1,'package (10 oz)',284,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11731,1,1,'CUP',135,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11732,1,1,'cup',135,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11733,1,1,'cup',135,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11734,1,0.5,'cup slices',85,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11734,2,2,'beets (2" dia, sphere)',100,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (11735,1,1,'cup',246,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11736,1,1,'cup (1" pieces)',144,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11740,1,1,'cup flowerets',71,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11740,2,1,'floweret',11,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11741,1,1,'stalk',114,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11742,1,0.5,'cup, chopped',78,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11742,2,1,'stalk, large (11"-12" long)',280,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11742,3,1,'stalk, medium (7-1/2" - 8" long)',180,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11742,4,1,'stalk, small (5" long)',140,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11742,5,1,'spear (about 5" long)',37,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11743,1,1,'CUP',184,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11744,1,0.5,'cup',92,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11744,2,1,'package (10 oz) yields',250,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11745,1,1,'sprout',21,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11745,2,0.5,'CUP',78,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11746,1,1,'CUP',155,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11749,1,0.5,'cup, shredded',35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11749,2,1,'head',908,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11750,1,0.5,'cup, shredded',35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11750,2,1,'head',908,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11751,1,0.5,'cup, shredded',75,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11751,2,1,'head',1262,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11752,1,1,'leaf',22,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11752,2,0.5,'cup, shredded',75,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11753,1,1,'cup, shredded',145,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11754,1,1,'cup, shredded',170,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11755,1,1,'cup, shredded',119,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11755,2,1,'leaf',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11757,1,1,'TBSP',9.7,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11757,2,0.5,'cup slices',78,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11757,3,1,'carrot',46,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11758,1,0.5,'cup slices',123,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11758,2,1,'can (303 x 406)',454,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11759,1,1,'cup, sliced',146,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11759,2,1,'cup, mashed',228,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11759,3,1,'slice',2.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11759,4,1,'can (303 x 406)',284,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11760,1,1,'cup slices',146,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11761,1,0.5,'cup (1" pieces)',62,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11761,2,3,'flowerets',54,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11762,1,1,'cup (1" pieces)',180,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11764,1,1,'cup, diced',150,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11764,2,2,'stalks',75,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11766,1,1,'cup (1" pieces)',160,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11768,1,1,'cup, chopped',190,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11769,1,1,'cup, chopped',170,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11770,1,1,'ear small (5-1/2" to 6-1/2" long)',89,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11770,2,1,'ear medium (6-3/4" to 7-1/2" long)',103,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11770,3,1,'ear large (7-3/4" to 9" long)',118,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11770,4,1,'cup',149,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11770,5,1,'baby ear',8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11770,6,1,'ear, yields',77,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11771,1,1,'cup',256,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11771,2,1,'can (303 x 406)',482,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11772,1,1,'cup',256,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11772,2,1,'can (303 x 406)',482,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11773,1,1,'cup',210,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11773,2,1,'can (303 x 406)',340,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11774,1,1,'cup',165,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11774,2,1,'package (10 oz) yields',284,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11775,1,1,'cup kernels',165,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11775,2,1,'ear, yields',63,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11777,1,1,'cup',165,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11778,1,1,'cup',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11779,1,1,'cup',95,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11780,1,1,'cup, chopped',53,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11781,1,1,'cup',135,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11783,1,1,'cup (1" cubes)',99,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11784,1,1,'cup (1" cubes)',146,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11785,1,1,'cup (1" pieces)',178,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11785,2,0.5,'cup (1" slices)',89,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11788,1,1,'cup',87,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11789,1,1,'cup',87,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11790,1,1,'cup',118,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (11791,1,1,'cup',118,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (11793,1,1,'cup slices',165,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11794,1,1,'cup, chopped',180,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11795,1,1,'leek',124,'g',1,'1998-03-27','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11795,2,0.25,'cup, chopped',26,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11796,1,0.5,'cup',60,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11796,2,10,'slices (2-1/2" dia)',89,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11797,1,1,'cup pieces',156,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11797,2,1,'tbsp',9.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11797,3,1,'mushroom',12,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11798,1,1,'cup pieces',145,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11798,2,4,'mushrooms',72,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11799,1,1,'cup, chopped',140,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11800,1,1,'cup, chopped or diced',150,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11800,2,1,'package (10 oz) yields',212,'g',1,'1997-08-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11802,1,1,'cup, chopped',180,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11803,1,0.5,'cup slices',80,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11803,2,8,'pods (3" long)',85,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11804,1,0.5,'cup slices',92,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11804,2,1,'package (10 oz) yields',255,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11805,1,1,'CUP',210,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11805,2,1,'tbsp chopped',15,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11805,3,1,'large',128,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11805,4,1,'slice large (1/4" thick)',32,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (11805,5,1,'medium',94,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11805,6,1,'slice medium (1/8" thick)',12,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11805,7,1,'small',60,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11805,8,1,'slice thin',8,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11806,1,1,'tbsp chopped',15,'g',1,'1994-11-17','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11806,2,0.5,'cup, chopped or diced',105,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11807,1,1,'CUP',210,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11808,1,0.5,'cup slices',78,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11808,2,1,'parsnip (9" long)',160,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11809,1,1,'CUP',160,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11810,1,1,'CUP',160,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11810,2,1,'package (10 oz) yields',253,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11811,1,1,'cup',160,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11812,1,0.5,'cup',124,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11812,2,1,'can (303 x 406)',482,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11813,1,0.5,'cup',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11813,2,1,'can (303 x 406)',313,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11814,1,0.5,'CUP',80,'g',1,'1994-01-31','2009-02-11');
INSERT INTO `cndb_wght` VALUES (11814,2,1,'package (10 oz) yields',253,'g',1,'2002-09-06','2009-02-11');
INSERT INTO `cndb_wght` VALUES (11816,1,1,'cup',255,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11817,1,0.5,'cup',80,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11817,2,1,'package (10 oz) yields',278,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11818,1,1,'CUP',180,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11819,1,1,'pepper',45,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11819,2,0.5,'cup, chopped or diced',75,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11820,1,1,'pepper',73,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11820,2,0.5,'cup, chopped or diced',68,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11821,1,1,'cup, chopped',149,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11821,2,1,'cup, sliced',92,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11821,3,1,'tablespoon',9.3,'g',1,'1998-01-15','2015-01-07');
INSERT INTO `cndb_wght` VALUES (11821,4,1,'large (2-1/4 per pound, approx 3-3/4" long, 3" dia.)',164,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11821,5,1,'medium (approx 2-3/4" long, 2-1/2 dia.)',119,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11821,6,1,'small',74,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11821,7,1,'ring (3" dia., 1/4" thick)',10,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11822,1,1,'tbsp',11.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11822,2,1,'pepper',73,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11822,3,0.5,'cup, chopped',92,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11823,1,1,'cup, strips',135,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11823,2,1,'tbsp',11.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11823,3,0.5,'cup, chopped',68,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11824,1,1,'tbsp',12,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11824,2,1,'pepper',73,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11824,3,0.5,'cup, chopped',92,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11825,1,1,'cup, chopped or strips',135,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11825,2,1,'tablespoon, chopped',11.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11826,1,1,'CUP',153,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11828,1,0.5,'cup',61,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11828,2,1,'potato large (3" to 4-1/4" dia)',299,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11828,3,1,'potato medium (2-1/4" to 3-1/4" dia)',173,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11828,4,1,'potato small (1-3/4" to 2-1/2" dia)',138,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11828,5,1,'NLEA serving',148,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11829,1,0.5,'cup',61,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11829,2,1,'potato (2-1/3" x 4-3/4")',156,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11830,1,1,'skin',58,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11831,1,0.5,'CUP',78,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11831,2,1,'potato (2-1/2" dia, sphere)',136,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11832,1,1,'skin',34,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11833,1,0.5,'cup',78,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11833,2,1,'large (3" to 4-1/4" dia.)',300,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11833,3,1,'medium (2-1/4" to 2-1/4" dia.)',167,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11833,4,1,'small (1-3/4" to 2-1/2" dia.)',125,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11834,1,1,'potato (2-1/3" x 4-3/4")',202,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11835,1,0.5,'cup',78,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11835,2,1,'potato (2-1/3" x 4-3/4")',156,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11836,1,1,'skin',58,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11840,1,10,'strips',50,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11840,2,1,'package (9 oz) yields',198,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11841,1,10,'strip',74,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11842,1,10,'strips',65,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11842,2,1,'package (9 oz)',255,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11843,1,1,'cup',245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11844,1,1,'cup',245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11845,1,1,'cup, mashed',245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11846,1,1,'CUP',245,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11847,1,1,'cup',134,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11848,1,1,'cup',71,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11850,1,1,'cup slices',147,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11851,1,0.5,'cup, mashed',120,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11853,1,1,'cup',180,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11854,1,1,'CUP',180,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11855,1,1,'cup',234,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11856,1,0.5,'cup',95,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11856,2,1,'package (10 oz) yields',220,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11857,1,1,'cup slices',180,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11858,1,1,'cup slices',180,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11859,1,1,'cup slices',192,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11860,1,0.5,'cup slices',90,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11860,2,0.5,'cup, mashed',120,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11861,1,0.5,'cup slices',90,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11861,2,0.5,'cup, mashed',120,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11862,1,1,'CUP',223,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11863,1,1,'cup, cubes',205,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11864,1,1,'cup, cubes',205,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11865,1,1,'cup, mashed',245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11866,1,1,'cup, cubes',205,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11867,1,1,'cup, mashed',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11868,1,1,'cup, cubes',205,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11869,1,1,'cup, mashed',236,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11870,1,1,'cup',155,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11871,1,1,'cup',192,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11872,1,1,'CUP',170,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11874,1,1,'cup',64,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11875,1,1,'medium (2" dia, 5" long, raw)',114,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11875,2,0.5,'cup, mashed',100,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (11876,1,1,'cup, mashed',328,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11876,2,1,'medium',151,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11877,1,1,'cup, cubes',176,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11878,1,1,'cup slices',132,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11879,1,1,'cup',145,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11880,1,1,'cup slices',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11881,1,1,'cup slices',137,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11884,1,1,'cup',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11884,2,0.5,'cup',120,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11884,3,1,'NLEA serving',121,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11885,1,1,'cup',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11885,2,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11885,3,1,'can',190,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11885,4,1,'large',164,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11885,5,1,'medium',111,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11885,6,1,'small',82,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11885,7,0.5,'cup',120,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11886,1,1,'CUP',243,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (11886,2,1,'FL OZ',30.4,'g',1,'1997-08-29','2010-01-05');
INSERT INTO `cndb_wght` VALUES (11886,3,6,'FL OZ',182,'g',1,'2007-11-28','2010-01-05');
INSERT INTO `cndb_wght` VALUES (11888,1,1,'CUP',250,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11888,2,1,'can (29 oz) (401 x 411)',822,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11889,1,1,'cup, cubes',156,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11889,2,1,'cup, mashed',230,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11890,1,1,'cup',156,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11891,1,1,'cup, chopped',144,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11892,1,0.5,'cup',82,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11892,2,1,'package (10 oz) yields',220,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11893,1,1,'CUP',163,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11893,2,0.5,'CUP',86,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (11894,1,0.5,'cup',91,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11894,2,1,'package (10 oz) yields',275,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11895,1,1,'cup, cubes',175,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11896,1,1,'cup',62,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11896,2,0.5,'cup',31,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11897,1,1,'cup, cubes',136,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11897,2,0.5,'cup, cubes',68,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (11899,1,1,'cup slices',104,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11899,2,1,'pod',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11900,1,1,'ear, small (5-1/2" to 6-1/2" long)',73,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11900,2,1,'ear, medium (6-3/4" to 7-1/2" long)',90,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11900,3,1,'ear, large (7-3/4" to 9" long)',143,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11900,4,1,'cup kernels',154,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11901,1,1,'ear, small (5-1/2" to 6-1/2" long)',89,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11901,2,1,'ear, medium (6-3/4" to 7-1/2" long)',103,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11901,3,1,'ear, large (7-3/4" to 9" long)',116,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11901,4,1,'cup cut',157,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11901,5,1,'ear, yields',77,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11902,1,1,'ear, small (5-1/2" to 6-1/2" long)',89,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11902,2,1,'ear, medium (6-3/4" to 7-1/2" long)',103,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11902,3,1,'ear, large (7-3/4" to 9" long)',118,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11902,4,1,'cup cut',157,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11902,5,1,'ear, yields',77,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11903,1,1,'cup',256,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11903,2,1,'can (303 x 406)',482,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11904,1,1,'cup',256,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11904,2,1,'can (303 x 406)',482,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11905,1,1,'CUP',164,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11905,2,1,'can (303 x 406)',298,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11906,1,1,'CUP',256,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11906,2,1,'can (303 x 406)',482,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11907,1,1,'cup',256,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11907,2,1,'can (303 x 406)',482,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11908,1,1,'cup',210,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11908,2,1,'can (303 x 406)',340,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11909,1,1,'cup',210,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11909,2,1,'can (303 x 406)',340,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11910,1,1,'cup',165,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11910,2,1,'package (10 oz)',284,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11911,1,1,'cup',165,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11911,2,1,'package (10 oz) yields',284,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11912,1,1,'cup',165,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11912,2,1,'package (10 oz) yields',284,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11913,1,1,'cup kernels',165,'g',1,'1996-09-30','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11913,2,1,'ear, yields',125,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11914,1,1,'cup kernels',165,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11914,2,1,'ear, yields',63,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11915,1,1,'cup kernels',165,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11915,2,1,'ear, yields',63,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (11916,1,1,'cup, halves',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11916,2,0.5,'cup, halves',70,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11917,1,0.33,'package (10 oz)',95,'g',1,'1996-09-30','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11917,2,1,'package (10 oz)',284,'g',1,'2007-11-28','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11918,1,1,'cup, chopped or strips',135,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11918,2,1,'tablespoon, chopped',11.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11919,1,1,'cup, chopped or strips',135,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11919,2,1,'tablespoon, chopped',11.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11921,1,1,'cup chopped',106,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11923,1,1,'cup',94,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11927,1,1,'cup, cubes',145,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11929,1,1,'CUP',210,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11930,1,1,'CUP',210,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11931,1,1,'tbsp',0.4,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11931,2,0.25,'cup',1.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11932,1,1,'cup',153,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11932,2,10,'beans',62,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11932,3,1,'can (303 x 406)',262,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11933,1,1,'cup',153,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11933,2,10,'beans',62,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11933,3,1,'can (303 x 406)',262,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11934,1,1,'cup',210,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11935,1,1,'tbsp',17,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11935,2,1,'packet',9,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11935,3,1,'cup',240,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11936,1,1,'cup whole',87,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (11936,2,1,'cup sliced',72,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (11936,3,1,'piece whole',20,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (11937,1,1,'spear, small',35,'g',1,'1994-09-29','2015-01-07');
INSERT INTO `cndb_wght` VALUES (11937,2,1,'slice',7,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (11937,3,1,'large (4" long)',135,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11937,4,1,'cup, chopped or diced',143,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (11937,5,1,'cup (about 23 slices)',155,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (11938,1,1,'cup pieces or slices',70,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (11938,2,1,'cup whole',96,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (11938,3,1,'large',23,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (11938,4,1,'slice',6,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (11938,5,1,'medium',18,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (11938,6,1,'small',10,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (11939,1,1,'cup sliced',121,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11940,1,1,'cup, chopped',160,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11940,2,1,'cup sliced or chips',153,'g',1,'1998-01-15','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11940,3,1,'large Gherkin (3" long)',35,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11940,4,1,'Gherkin (2-3/4" long)',25,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11940,5,1,'midget Gherkin (2-1/8" long)',6,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11940,6,1,'chip',7.5,'g',1,'2002-09-06','2009-02-11');
INSERT INTO `cndb_wght` VALUES (11940,7,1,'small Gherkin (2-1/2" long)',15,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11940,8,1,'spear Gherkin',20,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11941,1,1,'CUP',155,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11941,2,1,'large (4" long)',135,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11941,3,1,'medium (3-3/4" long)',65,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11941,4,1,'slice',7,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11941,5,1,'small',37,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11941,6,1,'spear',30,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11943,1,1,'tbsp',12,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11943,2,1,'cup',192,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11943,3,1,'slice',1,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11943,4,1,'pimiento, whole',66,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11944,1,1,'TBSP',15,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11944,2,0.5,'CUP',122,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11945,1,1,'tbsp',15,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11945,2,1,'packet (2/3 tbsp)',10,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11945,3,1,'cup',245,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11946,1,1,'cup, chopped or diced',143,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11946,2,1,'cup (about 23 slices)',155,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11946,3,1,'large (4" long)',135,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11946,4,1,'medium (3-3/4" long)',65,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11946,5,1,'slice',6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11946,6,1,'small',37,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11946,7,1,'spear',30,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11947,1,1,'spear, small',35,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (11947,2,1,'slice',7,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (11947,3,1,'large (4" long)',135,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (11947,4,1,'cup, chopped or diced',143,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (11947,5,1,'cup, (about 23 slices)',155,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (11948,1,1,'slice',6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11948,2,1,'medium',35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11948,3,1,'small',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11948,4,1,'large',35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11948,5,1,'cup, sliced',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11948,6,1,'cup, chopped or diced',160,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11949,1,1,'tbsp',17,'g',1,'1994-11-02','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11949,2,1,'packet',9,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11949,3,1,'cup',240,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (11950,1,1,'large',5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11950,2,1,'medium',3,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11950,3,1,'cup whole',64,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11950,4,1,'cup sliced',65,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11951,1,1,'pepper, large (3-3/4" long, 3" dia)',186,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11951,2,10,'strips',52,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11952,1,1,'cup, shredded',40,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11952,2,1,'leaf',8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11953,1,1,'large',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11953,2,1,'medium',11,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11954,1,1,'medium',34,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11954,2,0.5,'cup, chopped or diced',66,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11955,1,1,'CUP',54,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11955,2,1,'piece',2,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11956,1,1,'cup',110,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11956,2,1,'piece',3,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11957,1,1,'cup, sliced',87,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11957,2,1,'bulb',234,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11958,1,1,'TBSP',15,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11958,2,0.5,'CUP',122,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11959,1,1,'leaf',2,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11959,2,0.5,'CUP',10,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11960,1,1,'large',15,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11960,2,1,'medium',10,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11960,3,1,'NLEA serving',85,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11961,1,1,'cup',146,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11961,2,1,'piece',33,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11962,1,1,'cup',37,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11962,2,1,'pepper',0.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11963,1,1,'cup, sliced',86,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11964,1,1,'cup',149,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11964,2,1,'pad',29,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11965,1,1,'cup',64,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11965,2,1,'floweret',25,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11965,3,1,'head, large (6-7" dia)',511,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11965,4,1,'head, medium (5-6" dia)',431,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11965,5,1,'head, small (4" dia)',325,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11967,1,0.2,'head',90,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11968,1,0.5,'cup (1" pieces)',62,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11969,1,1,'CUP',88,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11972,1,1,'cup',67,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11972,2,1,'tbsp',4.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11973,1,1,'cup',126,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11973,2,1,'pod',6.1,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11974,1,1,'CUP',14,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11974,2,1,'leaf',3,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11975,1,1,'leaf',4,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11976,1,1,'cup',124,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11976,2,1,'small (4" long)',33,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11976,3,1,'medium (4-1/2" long)',46,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11976,4,1,'large (5" long)',75,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11977,1,1,'cup, chopped',105,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11977,2,1,'pepper',6.1,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11978,1,1,'pepper',17,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11979,1,1,'cup, sliced',90,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11979,2,1,'pepper',14,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11980,1,1,'CUP',139,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11981,1,1,'pepper',27,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11983,1,1,'cup',245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11987,1,1,'large',148,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11987,2,1,'small',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11987,3,1,'cup sliced',86,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11989,1,1,'CUP',182,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11989,2,1,'piece',5.5,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11991,1,1,'cup, sliced',135,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11991,2,1,'root',305,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (11993,1,1,'cup diced',70,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11993,2,1,'piece whole',1.1,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11998,1,1,'cup diced',86,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (11998,2,1,'piece whole',84,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12001,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12003,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12004,1,1,'oz (8-14 seeds)',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12005,1,1,'cup',160,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12005,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12006,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12007,1,1,'cup',94,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12007,2,1,'tbsp',5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12008,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12011,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12012,1,3,'tbsp',30,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (12013,1,1,'cup',32,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12013,2,1,'oz (42 medium seeds)',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12014,1,1,'cup',129,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12014,2,1,'OZ',28.35,'g',1,'2002-09-06','2010-01-04');
INSERT INTO `cndb_wght` VALUES (12016,1,1,'cup',118,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12016,2,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12021,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12022,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12023,1,1,'CUP',144,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12023,2,1,'TBSP',9,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12024,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12029,1,1,'CUP',128,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12029,2,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12032,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12033,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12034,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12036,1,1,'cup, with hulls, edible yield',46,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12036,2,1,'CUP',140,'g',1,'1994-09-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (12037,1,1,'cup',128,'g',1,'1999-03-22','2011-01-18');
INSERT INTO `cndb_wght` VALUES (12037,2,1,'oz',28.35,'g',1,'1994-10-18','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12038,1,1,'CUP',135,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12038,2,1,'oz',28.35,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12039,1,1,'CUP',134,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12039,2,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12040,1,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12040,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12041,1,1,'cup',64,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12041,2,1,'tbsp',4,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12058,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12059,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12060,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12061,1,1,'cup, whole',143,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (12061,2,1,'cup, sliced',92,'g',1,'1994-09-29','2007-03-25');
INSERT INTO `cndb_wght` VALUES (12061,3,1,'cup, slivered',108,'g',1,'1998-01-15','2007-03-25');
INSERT INTO `cndb_wght` VALUES (12061,4,1,'cup, ground',95,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (12061,5,1,'oz (23 whole kernels)',28.35,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (12061,6,1,'almond',1.2,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (12062,1,1,'cup whole kernels',145,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12062,2,1,'TBSP',9.1,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12062,3,1,'oz',28.35,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12063,1,1,'cup whole kernels',138,'g',1,'1994-10-19','2007-03-25');
INSERT INTO `cndb_wght` VALUES (12063,2,1,'oz (22 whole kernels)',28.35,'g',1,'1999-03-22','2007-03-25');
INSERT INTO `cndb_wght` VALUES (12065,1,1,'cup whole kernels',157,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12065,2,1,'oz (22 whole kernels)',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12071,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12071,2,1,'cup, firmly packed',227,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12077,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12078,1,1,'cup, whole',133,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12078,2,1,'kernel',5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12078,3,1,'oz (6 kernels)',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12084,1,1,'cup',120,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12084,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12084,3,1,'nutmeat',3,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12085,1,1,'cup, halves and whole',137,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12085,2,1,'TBSP',8.6,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12085,3,1,'oz',28.35,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12086,1,1,'cup, whole',129,'g',1,'1994-10-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12086,2,1,'cup, halves and pieces',129,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12086,3,1,'oz (18 kernels)',28.35,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12087,1,1,'oz',28.35,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (12088,1,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12088,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12093,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12094,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12095,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12096,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12097,1,1,'cup',145,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12097,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12098,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12099,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12100,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12101,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12104,1,1,'cup, shredded',80,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12104,2,1,'medium',397,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12104,3,1,'piece (2" x 2" x 1/2")',45,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12108,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12109,1,1,'CUP',85,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12109,2,1,'oz',28.35,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12110,1,1,'CUP',77,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12110,2,4,'oz',114,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12114,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12115,1,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12115,2,1,'cup',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12116,1,1,'tbsp',19,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12116,2,1,'cup',296,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12117,1,1,'cup',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12117,2,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12118,1,1,'cup',226,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12118,2,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12119,1,1,'cup',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12119,2,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12119,3,1,'coconut yields',206,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12120,1,1,'cup, chopped',115,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12120,2,1,'cup, ground',75,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12120,3,1,'cup, whole',135,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12120,4,1,'oz (21 whole kernels)',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12120,5,10,'nuts',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12121,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12122,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12127,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12128,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12129,1,1,'cup (78 kernels)',155,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12129,2,1,'oz (14 kernels)',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12130,1,1,'cup',120,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12130,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12130,3,1,'nut',3,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12131,1,1,'cup, whole or halves',134,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12131,2,1,'oz (10-12 kernels)',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12132,1,1,'cup, whole or halves',132,'g',1,'2002-06-08','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12132,2,1,'oz (10-12 kernels)',28.35,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12135,1,1,'cup',131,'g',1,'2013-12-23','2016-03-09');
INSERT INTO `cndb_wght` VALUES (12135,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12137,1,1,'cup',134,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12137,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12138,1,1,'cup',144,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12138,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12140,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12142,1,1,'cup, chopped',109,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12142,2,1,'cup, halves',99,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12142,3,1,'oz (19 halves)',28.35,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12143,1,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12144,1,1,'CUP',110,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12144,2,1,'oz (15 halves)',28.35,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12145,1,1,'cup',120,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12145,2,1,'oz (15 kernels)',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12147,1,1,'cup',135,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12147,2,1,'oz (167 kernels)',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12147,3,10,'nuts',1.7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12149,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12149,2,10,'nuts',1,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12151,1,1,'cup',123,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12151,2,1,'oz (49 kernels)',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12151,3,1,'kernel',0.7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12152,1,1,'cup',123,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12152,2,1,'oz (49 kernels)',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12152,3,1,'kernel',0.7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12154,1,1,'cup, chopped',125,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12154,2,1,'TBSP',7.8,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12154,3,1,'oz',28.35,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12155,1,1,'cup, chopped',117,'g',1,'1999-03-22','2007-03-25');
INSERT INTO `cndb_wght` VALUES (12155,2,1,'cup, ground',80,'g',1,'1995-06-19','2007-03-25');
INSERT INTO `cndb_wght` VALUES (12155,3,1,'cup, in shell, edible yield (7 nuts)',28,'g',1,'1998-01-15','2007-03-25');
INSERT INTO `cndb_wght` VALUES (12155,4,1,'cup shelled (50 halves)',100,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (12155,5,1,'cup pieces or chips',120,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (12155,6,1,'oz (14 halves)',28.35,'g',1,'2002-09-06','2007-03-25');
INSERT INTO `cndb_wght` VALUES (12156,1,1,'oz',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12157,1,1,'oz',28,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (12158,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12160,1,1,'cup',149,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12160,2,1,'tbsp',10,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12163,1,1,'cup',64,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12163,2,1,'oz (85 seeds)',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12166,1,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12166,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12167,1,1,'cup',143,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12167,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12167,3,10,'kernels',84,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12169,1,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12170,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12171,1,1,'tbsp',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12171,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12174,1,1,'cup',108,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12174,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12175,1,1,'cup',155,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12175,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12176,1,1,'cup',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12176,2,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12177,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12179,1,1,'cup, shredded',93,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12179,2,1,'package (7 oz)',199,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12193,1,1,'cup',74,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12193,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12195,1,1,'tbsp',16,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (12195,2,1,'cup',250,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (12198,1,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12198,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12200,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12201,1,1,'CUP',150,'g',1,'1995-06-13','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12201,2,1,'TBSP',8,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12201,3,1,'tsp',2.7,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12202,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12203,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12204,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12205,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12206,1,1,'cup whole kernels',144,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12206,2,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12220,1,1,'tbsp, whole',10.3,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12220,2,1,'cup, whole',168,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12220,3,1,'tbsp, ground',7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12220,4,1,'tsp, whole',3.4,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12220,5,1,'tsp, ground',2.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12516,1,1,'cup',118,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12516,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12529,1,1,'cup',128,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12529,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12536,1,1,'cup',128,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (12536,2,1,'oz',28.35,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (12536,3,1,'package (1.875 oz) yields',27,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (12537,1,1,'CUP',128,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12537,2,1,'oz',28.35,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12538,1,1,'CUP',135,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12538,2,1,'oz',28.35,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12539,1,1,'CUP',134,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12539,2,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12540,1,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12540,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12563,1,1,'cup whole kernels',138,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12563,2,1,'oz (22 whole kernels)',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12565,1,1,'cup whole kernels',157,'g',1,'1995-06-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12565,2,1,'oz (22 whole kernels)',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12567,1,1,'oz (28 almonds)',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12585,1,1,'cup, halves and whole',137,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12585,2,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12586,1,1,'cup, whole',129,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12586,2,1,'cup, halves and pieces',129,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12586,3,1,'oz (18 kernels)',28.35,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12588,1,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12588,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12632,1,1,'cup, whole or halves',132,'g',1,'2002-06-08','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12632,2,1,'oz (10-12 kernels)',28.35,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12635,1,1,'CUP',137,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12635,2,1,'oz',28.35,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12637,1,1,'cup',134,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12637,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12637,3,10,'nuts, assorted',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12638,1,1,'cup',144,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12638,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12643,1,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12644,1,1,'CUP',110,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12644,2,1,'oz (15 halves)',28.35,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12652,1,1,'cup',123,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12652,2,1,'oz (49 kernels)',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12652,3,1,'kernel',0.7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12663,1,1,'cup',64,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12663,2,1,'oz (85 seeds)',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (12665,1,1,'cup whole kernels',157,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (12665,2,1,'oz (22 whole kernels)',28.35,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (12695,1,1,'tbsp',16,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (12695,2,1,'cup',250,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (12698,1,1,'TBSP',15,'g',1,'2002-06-08','2006-11-30');
INSERT INTO `cndb_wght` VALUES (12737,1,1,'oz',28.35,'g',1,'2013-02-22','2013-02-22');
INSERT INTO `cndb_wght` VALUES (12738,1,1,'oz',28.35,'g',1,'2013-02-22','2013-02-22');
INSERT INTO `cndb_wght` VALUES (13000,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13000,2,1,'steak',214,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13001,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13001,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13002,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13002,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13019,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13019,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13020,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13020,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13023,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13023,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13047,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13047,2,1,'serving',85,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13055,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13055,2,1,'steak',350,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13065,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13065,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13065,3,1,'steak',202,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13066,1,3,'oz',85,'g',1,'2011-01-18','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13066,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',262,'g',1,'2011-01-18','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13067,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13067,2,1,'steak (yield from 483 g raw meat)',387,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13068,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13068,2,1,'steak',202,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13069,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13069,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',246,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13070,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13070,2,1,'steak',387,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13095,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13095,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13096,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13096,2,1,'steak (yield from 297 g raw meat)',236,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13097,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13097,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13098,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13098,2,1,'steak (yield from 297g raw meat)',236,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13147,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13147,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13148,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13148,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',225,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13149,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13149,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13150,1,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',121,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13150,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13156,1,3,'oz',85,'g',1,'2010-01-04','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13156,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',285,'g',1,'2010-01-04','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13158,1,3,'oz',85,'g',1,'2010-01-04','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13158,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',282,'g',1,'2010-01-04','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13165,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13165,2,1,'steak (Yield from 448 g raw meat)',293,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13227,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13227,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13228,1,3,'oz',85,'g',1,'2010-01-04','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13228,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',170,'g',1,'2010-01-04','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13231,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13231,2,1,'steak',539,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13232,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13232,2,1,'steak',417,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13235,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13235,2,1,'steak',461,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13236,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13236,2,1,'steak',360,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13284,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13285,1,3,'oz',85,'g',1,'2011-01-18','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13285,2,1,'roast',647,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13293,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13293,2,1,'steak',679,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13293,3,1,'roast',960,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13294,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13294,2,1,'steak',648,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13294,3,1,'roast',949,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13317,1,3,'oz',85,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13317,2,1,'unit, cooked (yield from 1 lb raw meat)',313,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13318,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13318,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13319,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13319,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',351,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13320,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13320,2,1,'piece, cooked, excluding refuse',391,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13321,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13321,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13322,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13323,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13323,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13324,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13325,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13326,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13326,2,1,'slice',68,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13327,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13327,2,1,'slice',81,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13328,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13328,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13329,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13329,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',303,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13330,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13330,2,8,'oz',227,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13331,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13331,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13332,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13332,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',222,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13333,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13333,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13334,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13334,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',308,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13335,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13335,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13337,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13337,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13338,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13338,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',381,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13339,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13339,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13340,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13341,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13341,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13342,1,4,'oz',113,'g',1,'2002-06-08','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13342,2,1,'steak',56,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13342,3,1,'package',396,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13343,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13343,2,1,'steak',293,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13344,1,3,'slices',68,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13344,2,1,'package (net weight, 12 oz)',340,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13345,1,3,'slices',34,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (13345,2,1,'package, cooked (yield from 12 oz raw product)',170,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (13346,1,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (13346,2,1,'lb',453.6,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (13347,1,3,'oz',85,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13347,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',320,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13348,1,1,'oz',28.35,'g',1,'1999-03-22','2009-02-11');
INSERT INTO `cndb_wght` VALUES (13348,2,1,'slice (3/4 oz)',21,'g',1,'1995-06-19','2009-02-11');
INSERT INTO `cndb_wght` VALUES (13349,1,4,'oz',113,'g',1,'2016-02-06','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13349,2,1,'steak',732,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (13349,3,1,'roast',977,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (13350,1,10,'slices',28,'g',1,'1994-09-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (13351,1,3,'oz',85,'g',1,'2011-01-18','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13351,2,1,'steak',353,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13352,1,3,'oz',85,'g',1,'2011-01-18','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13352,2,1,'steak',356,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13353,1,1,'slice (1 oz) (4" x 4" x 3/32" thick)',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13354,1,3,'oz',85,'g',1,'2011-01-18','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13354,2,1,'steak',349,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13355,1,1,'package, 2.5 oz',71,'g',1,'1999-03-22','2009-02-11');
INSERT INTO `cndb_wght` VALUES (13355,2,1,'slice (1 oz)',28,'g',1,'1994-09-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (13356,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13356,2,1,'steak',473,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13357,1,1,'sausage',43,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13357,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13358,1,1,'slice (1 oz)',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13359,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13359,2,1,'steak',483,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13361,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13362,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13363,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13364,1,3,'oz',85,'g',1,'2004-07-15','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13365,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13366,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13367,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13367,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',314,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13368,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13368,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',264,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13369,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13369,2,1,'steak (Yield from 418 g raw meat)',270,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13370,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13370,2,1,'steak (yield from 418g raw meat)',270,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13371,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13371,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',314,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13372,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13372,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',232,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13373,1,3,'oz',85,'g',1,'2006-02-23','2011-01-18');
INSERT INTO `cndb_wght` VALUES (13373,2,1,'roast (yield from 1601 g raw meat)',1166,'g',1,'2006-02-23','2011-01-18');
INSERT INTO `cndb_wght` VALUES (13375,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13375,2,1,'roast (yield from 1675 g raw meat)',1236,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13377,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13377,2,1,'roast (yield from 1528g raw meat)',1095,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13378,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13378,2,1,'roast (yield from 1675 g raw meat)',1236,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13379,1,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',235,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (13379,2,3,'oz',85,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (13380,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13380,2,1,'roast',658,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13381,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13381,2,1,'roast',629,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13382,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13382,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',191,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13383,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13383,2,1,'roast',658,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13384,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13384,2,1,'roast',629,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13386,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13386,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',290,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13387,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13387,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',286,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13388,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13388,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',214,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13389,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13389,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',207,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13390,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13390,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',217,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13391,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13391,2,1,'steak (yield from 233 g raw meat)',233,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13392,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13392,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',272,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13393,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13393,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',265,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13394,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13394,2,1,'steak (yield from 296 g raw meat)',233,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13395,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13395,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',220,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13396,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13396,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',220,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13398,1,3,'oz',85,'g',1,'2006-02-23','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13398,2,1,'steak (yield from 290 g raw meat)',185,'g',1,'2006-02-23','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13399,1,3,'oz',85,'g',1,'2006-02-23','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13399,2,1,'roast (yield from 600 g raw meat)',489,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13401,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13401,2,1,'steak (yield from 299 g raw meat)',191,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13402,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13402,2,1,'roast (yield from 627 g raw meat)',515,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13404,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13404,2,1,'steak (yield from 281 g raw meat)',179,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13405,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13405,2,1,'roast (yield from 572 g raw meat)',464,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13407,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13407,2,1,'steak (yield from 290 g raw meat)',185,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13408,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13408,2,1,'roast (yield from 600 g raw meat)',489,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13410,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13410,2,1,'steak (yield from 299 g raw meat)',191,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13411,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13411,2,1,'roast (yield from 627 g raw meat)',515,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13413,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13413,2,1,'steak (yield from 281 g raw meat)',179,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13414,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13414,2,1,'roast (yield from 572 g raw meat)',464,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13415,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13415,2,1,'roast (yield from 436 g raw meat)',346,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13415,3,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',333,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13416,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13416,2,1,'roast (yield from 445 g raw meat)',355,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13417,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13417,2,1,'roast (yield from 426 g raw meat)',337,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13418,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13418,2,1,'roast (yield from 436 g raw meat)',346,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13418,3,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',330,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13419,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13419,2,1,'roast (yield from 445 g raw meat)',355,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13419,3,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',331,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13420,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13420,2,1,'roast (yield from 426 g raw meat)',337,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13420,3,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',296,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13421,1,3,'oz',85,'g',1,'2006-02-23','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13421,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',330,'g',1,'2006-02-23','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13422,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13422,2,1,'roast (yield from 1405 g raw meat)',1138,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13423,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13423,2,1,'roast (yield from 1388 g raw meat)',1141,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13424,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13424,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',320,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13425,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13425,2,1,'roast (yield from 1405 g raw meat)',1138,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13426,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13426,2,1,'roast (yield from 1388 g raw meat)',1141,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13428,1,3,'oz',85,'g',1,'1996-09-30','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13428,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',267,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13430,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13430,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',267,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13432,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13432,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',267,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13436,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13436,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',261,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13438,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13438,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',261,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13439,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13439,2,1,'steak',117,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13440,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13440,2,1,'steak (yield from 161 g raw meat)',126,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13441,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13441,2,1,'steak (yield from 136 g raw meat)',108,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13442,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13442,2,1,'steak',119,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13443,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13443,2,1,'steak',121,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13444,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13444,2,1,'steak',117,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13445,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13445,2,1,'steak',119,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13446,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13446,2,1,'steak (yield from 203 g raw meat)',164,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13447,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13447,2,1,'steak (yield from 186 g raw meat)',150,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13448,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13448,2,1,'steak, excluding refuse (yield from 1 raw steak, with refuse, weighing 223 g)',150,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13449,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13449,2,1,'steak (yield from 203 g raw meat)',164,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13450,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13450,2,1,'steak (yield from 186 g raw meat)',150,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13451,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13451,2,1,'steak (yield from 518 g raw meat)',384,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13452,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13452,2,1,'steak (yield from 532 g raw meat)',393,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13453,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13453,2,1,'steak (yield from 505 g raw meat)',375,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13454,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13454,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',292,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13455,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13455,2,1,'steak (yield from 532 g raw meat)',393,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13456,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13456,2,1,'steak (yield from 505 g raw meat)',375,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13459,1,3,'oz',85,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (13459,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13460,1,3,'oz',85,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (13460,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13463,1,3,'oz ( 1serving )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13463,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13464,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13464,2,1,'steak',534,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13465,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13465,2,1,'steak',421,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13466,1,3,'oz',85,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (13466,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13467,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13467,2,1,'serving',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13467,3,1,'piece, cooked, excluding refuse',266,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13468,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13468,2,1,'steak',526,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13469,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13469,2,1,'steak',426,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13470,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13470,2,1,'serving',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13470,3,1,'piece, cooked, excluding refuse',256,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13473,1,3,'oz',85,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (13473,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13474,1,3,'oz',85,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (13474,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13477,1,3,'oz',85,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (13477,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13478,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13478,2,1,'steak',460,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13479,1,3,'oz',85,'g',1,'2010-01-04','2016-02-06');
INSERT INTO `cndb_wght` VALUES (13479,2,1,'steak',363,'g',1,'2010-01-04','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13481,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13481,2,1,'serving',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13481,3,1,'piece, cooked, excluding refuse',271,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13482,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13482,2,1,'steak',458,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13483,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13483,2,1,'steak',368,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13484,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13484,2,1,'serving',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13484,3,1,'piece, cooked, excluding refuse',264,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13485,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13485,2,1,'steak',247,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13486,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13486,2,1,'roast',1289,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13487,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13487,2,1,'roast',1392,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13488,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13488,2,1,'roast',1187,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13490,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13490,2,1,'steak',231,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13491,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13491,2,1,'steak',277,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13492,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13492,2,1,'steak',284,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13493,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (13493,2,1,'steak',269,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (13494,1,3,'oz',85,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (13494,2,1,'portion (yield from 1/2 lb raw meat )',139,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13495,1,3,'oz',85,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (13495,2,1,'loaf ( yield from 1 lb raw meat )',284,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13496,1,3,'oz',85,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (13496,2,1,'patty',77,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13497,1,3,'oz',85,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (13497,2,1,'patty',70,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13498,1,4,'oz',113,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (13498,2,1,'oz',28.35,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (13499,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13499,2,1,'steak',458,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13500,1,3,'oz',85,'g',1,'2011-01-18','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13500,2,1,'steak',186,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13501,1,3,'oz',85,'g',1,'2011-01-18','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13501,2,1,'steak',177,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13502,1,3,'oz',85,'g',1,'2011-01-18','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13502,2,1,'steak',199,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13519,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13519,2,1,'steak',1438,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13520,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13520,2,1,'steak',1432,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13523,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13523,2,1,'steak',1446,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13595,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13595,2,1,'piece',1855,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13596,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13596,2,1,'piece',1780,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13597,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13597,2,1,'piece',1967,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13598,1,3,'oz',85,'g',1,'2011-01-18','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13598,2,1,'steak',186,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13647,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13647,2,1,'steak',1027,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13647,3,1,'roast',1316,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13648,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13649,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13649,2,1,'steak',1106,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13649,3,1,'roast',1320,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13650,1,3,'oz',85,'g',1,'2011-01-18','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13650,2,1,'steak',177,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13786,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13786,2,1,'roast',723,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13788,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13788,2,1,'roast',698,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13791,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13791,2,1,'roast',761,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13795,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13796,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13797,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13798,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13799,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13800,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13803,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13803,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13804,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13804,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',329,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13805,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13805,2,1,'steak',452,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13806,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13806,2,1,'steak (yield from raw steak weighing 550 g)',380,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13807,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13807,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13808,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13808,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',332,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13809,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13809,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13810,1,3,'oz',85,'g',1,'2006-02-23','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13810,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',258,'g',1,'2006-02-23','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13811,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13811,2,1,'roast',1801,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13811,3,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13812,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13812,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',258,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13813,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13813,2,1,'roast',1783,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13813,3,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13814,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13814,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',257,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13815,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13815,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13816,1,3,'oz',85,'g',1,'2006-02-23','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13816,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',247,'g',1,'2006-02-23','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13817,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13817,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13818,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13818,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',247,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13819,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13819,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13820,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13820,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',247,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13821,1,3,'oz',85,'g',1,'2011-01-18','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13821,2,1,'roast',609,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13822,1,3,'oz',85,'g',1,'2011-01-18','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13822,2,1,'roast',586,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13823,1,3,'oz',85,'g',1,'2011-01-18','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13823,2,1,'roast',645,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13824,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13824,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13825,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13825,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',267,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13826,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13826,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',289,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13827,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13827,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13828,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13828,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',267,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13829,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13829,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',289,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13830,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13830,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13831,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13831,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',264,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13832,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13832,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',289,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13833,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13833,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13834,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13834,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',274,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13835,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13835,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',278,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13838,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13838,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13839,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13839,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',267,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13840,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13840,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',292,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13841,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13841,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13842,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13842,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',267,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13843,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13843,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',296,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13844,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13844,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13845,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13845,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',267,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13846,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13846,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',292,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13847,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13847,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13848,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13848,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',278,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13849,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13849,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',281,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13850,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13850,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13851,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13851,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',268,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13852,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13852,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',282,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13853,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13853,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13854,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13854,2,1,'steak (yield from 320 g raw meat)',256,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13855,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13855,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',278,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13856,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13856,2,1,'steak',335,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13857,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13857,2,1,'steak (yield from 1 raw steak weighing 321g)',245,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13858,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13858,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',285,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13859,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13859,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13860,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13860,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',268,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13861,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13861,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',276,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13862,1,3,'oz',85,'g',1,'2011-01-18','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13862,2,1,'steak',199,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13863,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13863,2,1,'steak',239,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13864,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13864,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13865,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13865,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',313,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13866,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13866,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13867,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13867,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',313,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13868,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13868,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13869,1,3,'oz',85,'g',1,'2006-02-23','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13869,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',281,'g',1,'2006-02-23','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13870,1,3,'oz',85,'g',1,'2006-02-23','2011-01-18');
INSERT INTO `cndb_wght` VALUES (13870,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',338,'g',1,'2006-02-23','2006-11-30');
INSERT INTO `cndb_wght` VALUES (13870,3,1,'roast (yield from 1 raw roast weighing 776g)',632,'g',1,'2006-02-23','2011-01-18');
INSERT INTO `cndb_wght` VALUES (13871,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13871,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13872,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13872,2,1,'steak (yield from 341 g raw meat)',227,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13873,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13873,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',338,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13873,3,1,'roast (yield from raw roast weighing 766g)',627,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13874,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13874,2,1,'steak',312,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13875,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13875,2,1,'steak (yield from raw steak weighing 340g)',226,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13876,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13876,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',338,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13876,3,1,'roast (yield from 1 raw roast weighing 786g)',636,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13877,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13877,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13878,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13878,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',333,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13879,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13879,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13880,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13880,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',333,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13881,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13881,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13882,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13882,2,1,'roast (yield from 530 g raw meat)',417,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13883,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13883,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13884,1,3,'oz',85,'g',1,'2006-02-23','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13884,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',326,'g',1,'2006-02-23','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13885,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13885,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13886,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13886,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',325,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13887,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13887,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13888,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13888,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',327,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13889,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13889,2,1,'steak',231,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13890,1,3,'oz',85,'g',1,'2007-12-03','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13890,2,1,'piece cooked, excluding refuse (yield from 1 lb raw meat with refuse)',283,'g',1,'2007-12-03','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13891,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13891,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13892,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13892,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',286,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13893,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13893,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',326,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13894,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13894,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13895,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13895,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',289,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13896,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13896,2,1,'steak (yield from raw steak weighing 492 g)',347,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13896,3,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',326,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13897,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13897,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',283,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13898,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13898,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13899,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13899,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',286,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13900,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13900,2,1,'steak (yield from raw steak weighing 491g)',359,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13900,3,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',329,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13901,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13901,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13902,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13902,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',332,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13903,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13903,2,1,'steak',252,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13904,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13904,2,1,'piece',1855,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13905,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13905,2,1,'steak',539,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13906,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13906,2,1,'steak',417,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13907,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13907,2,1,'steak',461,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13908,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13908,2,1,'steak',360,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13909,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13910,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13910,2,1,'steak',213,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13911,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13911,2,1,'steak',301,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13912,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13912,2,1,'steak (yield from 270 g raw meat)',221,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (13913,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13914,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13915,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13915,2,1,'steak, excluding refuse (yield from 1 raw steak, with refuse, weighing 242 g)',227,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13916,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13916,2,1,'steak, excluding refuse (yield from 1 raw steak, with refuse, weighing 242 g)',167,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13917,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13917,2,1,'steak',164,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13918,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13918,2,1,'steak, excluding refuse (yield from 1 raw steak, with refuse, weighing 154 g)',104,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13919,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13919,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',330,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13920,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13920,2,1,'steak',177,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13921,1,1,'steak (yield from 181 g raw meat)',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13921,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13922,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13922,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',329,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13923,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13923,2,1,'steak (yield from 1 raw steak weighing149g)',149,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13923,3,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13924,1,1,'steak (yield from 1 raw steak weighing 151g)',119,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13924,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13924,3,1,'steak, excluding refuse (yield from 1 raw steak, with refuse, weighing 154 g)',104,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13925,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13925,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',329,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13926,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13926,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13927,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13927,2,1,'steak, excluding refuse (yield from 1 raw steak, with refuse, weighing 154 g)',106,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13928,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13928,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',326,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13929,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13929,2,1,'steak',608,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13930,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13930,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',306,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13931,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13931,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13932,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13932,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',306,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13933,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13933,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',307,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13934,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13934,2,1,'steak',594,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13935,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13935,2,1,'steak (yield from 1 raw steak weighing 624g)',485,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13937,1,3,'oz',85,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (13940,1,3,'oz',85,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (13943,1,3,'oz ( 1 serving )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13946,1,3,'oz',85,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (13948,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13948,2,1,'steak (yield from 475 g raw meat)',383,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13949,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13949,2,1,'steak (yield from 467 g raw meat)',379,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13950,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13950,2,1,'steak (yield from 388 g raw meat)',247,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13951,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13951,2,1,'steak (yield from 294 g raw meat)',231,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13952,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13952,2,1,'steak (yield from 295 g raw meat)',233,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13954,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13954,2,1,'roast',261,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13955,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13955,2,1,'roast (yield from 714 g raw meat)',591,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13956,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13956,2,1,'roast',271,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13957,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13957,2,1,'roast (yield from 666 g raw meat)',547,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13958,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13958,2,1,'roast',252,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13959,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13959,2,1,'steak (yield from 381 g raw meat)',277,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13961,1,3,'oz (1 serving)',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13963,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13965,1,3,'oz',85,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (13967,1,3,'oz',85,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (13968,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13968,2,1,'steak (yield from 396 g raw meat)',284,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13969,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13969,2,1,'steak (yield from 368 g meat)',269,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13970,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13970,2,1,'steak',188,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13971,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13971,2,1,'steak',173,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13972,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13972,2,1,'roast',1289,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13973,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13973,2,1,'roast',1263,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13974,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13974,2,1,'roast',1327,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13975,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13975,2,1,'piece',1780,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13977,1,3,'oz',85,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (13979,1,3,'oz',85,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (13980,1,3,'oz',85,'g',1,'2011-01-18','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13980,2,1,'piece',272,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13981,1,3,'oz',85,'g',1,'2011-01-18','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13981,2,1,'piece',315,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13982,1,3,'oz',85,'g',1,'2011-01-18','2013-12-26');
INSERT INTO `cndb_wght` VALUES (13982,2,1,'piece',289,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13983,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13983,2,1,'piece',514,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (13985,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13985,2,1,'serving',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (13985,3,1,'roast',569,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (14021,1,8,'fl oz',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14031,1,8,'fl oz',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14054,1,8,'fl oz',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14054,2,1,'cup',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14056,1,8,'fl oz',266,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14056,2,2,'fl oz',60,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14058,1,3,'scoop',86,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14060,1,8,'fl oz',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14061,1,8,'fl oz',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14063,1,2,'tbsp',11,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14064,1,8,'fl oz',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14066,1,0.33,'cup',32,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14067,1,1,'scoop',45,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14079,1,16,'fl oz',473,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14083,1,1,'serving',256,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (14090,1,1,'cup',245,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (14091,1,1,'cup',262,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14092,1,1,'cup',240,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14119,1,8,'fl oz',247,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14121,1,1,'fl oz',29.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14121,2,1,'can or bottle (16 fl oz)',474,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14121,3,1,'can or bottle (12 fl oz)',355,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14130,1,1,'fl oz',30.9,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14130,2,1,'can or bottle (16 fl oz)',494,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14130,3,1,'can or bottle (12 fl oz)',371,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14136,1,1,'fl oz',30.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14136,2,1,'can or bottle (16 fl oz)',488,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14136,3,1,'can or bottle (12 fl oz)',366,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14142,1,1,'fl oz',31,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14142,2,1,'can or bottle (12 fl oz)',372,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14143,1,1,'fl oz',29.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14143,2,1,'can (12 fl oz)',355,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14144,1,1,'fl oz',30.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14144,4,1,'drink (12 fl oz)',368,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14144,5,1,'drink, small (16 fl oz)',491,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14144,6,1,'drink, medium (22 fl oz)',675,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14144,7,1,'drink, large (32 fl oz)',982,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14144,8,1,'drink, extra large (44 fl oz)',1351,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14146,1,1,'fl oz',29.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14146,2,1,'can or bottle (16 fl oz)',474,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14146,3,1,'can (12 fl oz)',355,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14146,4,1,'drink, small (16 fl oz)',474,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14146,5,1,'drink, medium (22 fl oz)',651,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14146,6,1,'drink, large (32 fl oz)',947,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14146,7,1,'drink, extra large (44 fl oz)',1302,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14147,1,1,'fl oz',30.7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14147,2,1,'serving 12 fl oz',368,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14147,3,1,'serving 16 fl oz',491,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14148,1,1,'fl oz',30.7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14148,2,1,'can or bottle (12 fl oz)',370,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14148,3,1,'can or bottle (16 fl oz)',492,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14148,4,1,'drink, small (16 fl oz)',492,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14148,5,1,'drink, medium (22 fl oz)',676,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14148,6,1,'drink, large (32 fl oz)',984,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14148,7,1,'drink, extra large (44 fl oz)',1353,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14149,1,1,'fl oz',29.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14149,2,1,'can (8 fl oz)',355,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14150,1,1,'fl oz',31,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14150,2,1,'can or bottle (16 fl oz)',496,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14150,3,1,'can or bottle (12 fl oz)',372,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14151,1,1,'fl oz',29.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14151,2,1,'can (12 fl oz)',355,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14153,1,1,'fl oz',30.7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14153,2,1,'can or bottle (16 fl oz)',491,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14153,3,1,'can or bottle (12 fl oz)',368,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14155,1,1,'fl oz',30.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14155,2,1,'bottle (11 fl oz)',336,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14155,3,1,'can or bottle (16 fl oz)',488,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14155,4,1,'can or bottle (12 fl oz)',366,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14157,1,1,'fl oz',30.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14157,2,1,'can or bottle (16 fl oz)',493,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14157,3,1,'can or bottle (12 fl oz)',370,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14161,1,16,'fl oz',473,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14163,1,8,'fl oz',237,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14164,1,1,'cup dry mix',98,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14164,2,1,'cup prepared',251,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14165,1,1,'cup',253,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14166,1,1,'fl oz',29.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14166,2,1,'bottle (16 fl oz)',474,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14166,3,1,'can (12 fl oz)',355,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14168,1,1,'tbsp',12,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14169,1,1,'cup (8 fl oz)',256,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14171,1,1,'cup',240,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14173,1,9.5,'fl oz',281,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14174,1,8,'fl oz',240,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14177,1,1,'cup (8 fl oz)',266,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (14179,1,1,'cup',262,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14180,1,1,'cup',248,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14181,1,1,'serving 2 tbsp',39,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14181,2,1,'cup',300,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14182,1,1,'cup (8 fl oz)',282,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14183,1,1,'cup',265,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14187,1,1,'fl oz',30.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14187,2,1,'can (5.5 oz)',166,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14188,1,1,'cup',260,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14190,1,1,'cup',269,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14191,1,1,'cup',265,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14192,1,1,'serving (3 heaping tsp or 1 envelope)',28,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (14194,1,1,'fl oz',34.3,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14194,2,1,'serving 6 fl oz',206,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14196,1,1,'envelope Alba (.675 oz)',19,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14196,2,1,'envelope  Swiss Miss (.53 oz)',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14199,1,1,'cup',271,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14201,1,1,'fl oz',29.6,'g',1,'2007-11-28','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14201,2,6,'fl oz',178,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14201,3,1,'cup (8 fl oz)',237,'g',1,'2007-11-28','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14202,1,1,'fl oz',29.6,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14203,1,1,'tsp',1,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14203,2,1,'packet',2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14204,1,1,'tsp dry',6.4,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14206,1,1,'cup',270,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14207,1,1,'cup',266,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14207,2,16,'fl oz',473,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14209,1,1,'fl oz',29.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14209,2,6,'fl oz',178,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14209,3,1,'cup (8 fl oz)',237,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14210,1,1,'fl oz',29.6,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14211,1,1,'cup',265,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14214,1,1,'tsp',1,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14214,2,1,'packet',2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14215,1,1,'fl oz',29.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14215,2,1,'serving 6 fl oz',179,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14216,1,8,'fl oz',240,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14218,1,1,'tsp rounded',1.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14219,1,1,'fl oz',29.9,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14219,2,1,'serving 6 fl oz',179,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14222,1,1,'tsp, rounded',1.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14223,1,1,'fl oz',29.9,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14223,2,1,'serving 6 fl oz',179,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14224,1,1,'serving 2 tbsp',13,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14236,1,1,'tsp (1 serving)',3,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14237,1,1,'fl oz',30.1,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14237,2,1,'serving 6 fl oz',180,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14238,1,1,'fl oz',30.6,'g',1,'1995-06-19','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14238,2,1,'cup (8 fl oz)',245,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14240,1,1,'fl oz',30.6,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14240,2,1,'cup (8 fl oz)',245,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14241,1,1,'fl oz',30.6,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14241,2,1,'cup (8 fl oz)',245,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14242,1,1,'fl oz',31.6,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14242,2,1,'cup (8 fl oz)',253,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14243,1,1,'fl oz',29.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14243,2,1,'cup (8 fl oz)',237,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14245,1,1,'cup (8 fl oz)',272,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14246,1,2,'tbsp',4.5,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14260,1,240,'ml',240,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14261,1,16,'fl oz',473,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14262,1,1,'fl oz',35.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14262,2,1,'can (12 fl oz)',423,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14263,1,1,'fl oz',31,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14263,2,1,'serving 8 fl oz',248,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14264,1,6.75,'fl oz',210,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14264,2,1,'cup (8 fl oz)',248,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14267,1,1,'fl oz',31,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14267,2,1,'cup (8 fl oz)',248,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14268,1,1,'fl oz',34.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14268,2,1,'can (12 fl oz)',418,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14269,1,1,'fl oz',30.9,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14269,2,1,'cup',247,'g',1,'1997-08-29','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14270,1,1,'serving',15,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14277,1,1,'fl oz',31.3,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14277,2,1,'cup (8 fl oz)',250,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14278,1,1,'cup',245,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14278,2,1,'fl oz',29.6,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14279,1,1,'cup',268,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14280,1,1,'cup',240,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14281,1,1,'cup',240,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14282,1,1,'fl oz',31.3,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14282,2,6,'fl oz',188,'g',1,'1997-08-29','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14282,3,8,'fl oz',250,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14282,4,1,'serving',227,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14287,1,1,'serving',18,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14287,2,1,'cup',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14288,1,1,'fl oz',33,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14288,2,1,'cup 8 fl oz',264,'g',1,'1994-01-31','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14292,1,1,'fl oz',36.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14292,2,1,'can (12 fl oz)',438,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14292,3,1,'can (6 fl oz)',219,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14293,1,1,'fl oz',30.9,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14293,2,1,'cup 8 fl oz',247,'g',1,'1997-08-29','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14296,1,1,'serving',18,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14296,2,0.5,'scoop (2 tbsp)',29,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14297,1,1,'fl oz',31.8,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14297,2,1,'cup 8 fl oz',255,'g',1,'1994-01-31','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14303,1,1,'fl oz',30.9,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14303,2,1,'cup 8 fl oz',247,'g',1,'1997-08-29','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14305,1,1,'fl oz',29.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14305,2,1,'cup',237,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14310,1,1,'cup (8 fl oz)',265,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14311,1,1,'serving (3 heaping tsp or 1 envelope)',21,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14312,1,1,'cup (8 fl oz)',265,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14316,1,1,'cup (8 fl oz)',265,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14317,1,1,'serving (3 heaping tsp or 1 envelope)',21,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14318,1,1,'cup (8 fl oz)',265,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14323,1,1,'fl oz',31,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14323,2,1,'cup (8 fl oz)',248,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14327,1,1,'fl oz',31.2,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14327,2,1,'cup (8 fl oz)',250,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14334,1,1,'fl oz',31.3,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14334,2,1,'cup (8 fl oz)',250,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14341,1,1,'fl oz',31.3,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14341,2,1,'cup (8 fl oz)',250,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14350,1,1,'serving (2-3 heaping tsp)',22,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14351,1,1,'cup (8 fl oz)',266,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (14352,1,1,'FL OZ',29.6,'g',1,'2002-09-06','2010-01-05');
INSERT INTO `cndb_wght` VALUES (14352,2,6,'FL OZ',178,'g',1,'2007-11-28','2010-01-05');
INSERT INTO `cndb_wght` VALUES (14352,3,1,'cup (8 fl oz)',237,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (14353,1,1,'serving 2 tsp',0.7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14355,1,1,'fl oz',29.6,'g',1,'1998-01-15','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14355,2,6,'fl oz',178,'g',1,'2007-11-28','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14355,3,1,'cup (8 fl oz)',237,'g',1,'2007-11-28','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14356,1,2,'tsp',1.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14357,1,1,'serving (3 heaping tsp)',23,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14357,2,1,'cup',182,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14366,1,1,'serving 1 tsp',0.7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14367,1,1,'fl oz',29.7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14367,2,1,'serving 6 fl oz',178,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14367,3,1,'serving 8 fl oz',238,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14368,1,1,'tsp, rounded',1.4,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14368,2,2,'tbsp, rounded',11.3,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14370,1,1,'serving (3 heaping tsp)',23,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14370,2,1,'cup',182,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14371,1,1,'cup (8 fl oz)',259,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14375,1,2,'tsp',1.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14375,2,4,'tbsp (1/4 cup)',14.4,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14376,1,1,'fl oz',29.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14376,2,1,'serving 6 fl oz',179,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14376,3,1,'serving 8 fl oz',238,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14381,1,1,'fl oz',29.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14381,2,6,'fl oz',178,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14381,3,1,'cup (8 fl oz)',237,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14390,1,1,'fl oz',32.1,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14390,2,1,'serving dry mix with 6 fl oz water',192,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14400,1,1,'serving child 12 fl oz, without ice',258,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14400,2,1,'serving small 16 fl oz, without ice',347,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14400,3,1,'serving medium 21 fl oz,  without ice',486,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14400,4,1,'serving large 32 fl oz,  without ice',722,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14405,1,1,'fl oz',35.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14405,2,1,'can (12 fl oz)',423,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14406,1,1,'fl oz',29.3,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14406,2,8,'fl oz',234,'g',1,'1997-08-29','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14407,1,1,'serving 2 tbsp',26,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14408,1,1,'fl oz',33.9,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14408,2,6,'fl oz',203,'g',1,'1994-01-31','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14409,1,1,'portion, amount of dry mix to make 8 fl oz prepared',2.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14411,1,1,'fl oz',29.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14411,2,1,'serving 8 fl oz',237,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14411,3,1,'liter',1000,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14416,1,1,'fl oz',29.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14416,2,1,'can can 12 fl oz',355,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14416,3,1,'bottle bottle 16 fl oz',473,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14416,4,1,'serving child 12 fl oz',258,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14416,5,1,'serving small 16 fl oz',347,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14416,6,1,'serving medium 21 fl oz',486,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14416,7,1,'serving large 32 fl oz',722,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14421,1,6,'fl oz',185,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14422,1,1,'packet (.75 oz)',21,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14422,2,1,'envelope',21,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14423,1,1,'serving',243,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14424,1,1,'fl oz',35.3,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14424,2,1,'can',424,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14425,1,1,'fl oz',31,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14425,2,8,'fl oz',248,'g',1,'1994-01-31','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14426,1,1,'fl oz',36.3,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14426,2,1,'can',436,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14427,1,1,'fl oz',31.3,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14427,2,8,'fl oz',250,'g',1,'1994-01-31','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14429,1,1,'FL OZ',29.6,'g',1,'1994-01-31','2010-01-05');
INSERT INTO `cndb_wght` VALUES (14429,2,1,'bottle 8 fl oz',237,'g',1,'1997-08-29','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14429,3,1,'liter',1000,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (14429,4,3,'ice cube (3/4 fl oz)',64,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (14430,1,1,'fl oz',36.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14430,2,1,'can (12 fl oz)',435,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14431,1,1,'fl oz',29.6,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14431,2,8,'fl oz',237,'g',1,'1994-01-31','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14436,1,1,'fl oz',31.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14436,2,1,'cup (8 fl oz)',253,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14537,1,1,'fl oz',29.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14537,2,1,'can (12 fl oz)',355,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14538,1,1,'envelope  Swiss Miss (.53 oz)',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14538,2,1,'packet (0.675 oz)',19,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14541,1,1,'fl oz',32.7,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14541,2,8,'fl oz',262,'g',1,'1994-01-31','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14542,1,1,'fl oz',36.4,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14542,2,1,'can (12 fl oz)',437,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14542,3,1,'can (6 fl oz)',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14543,1,1,'fl oz',30.9,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (14543,2,1,'bottle 8 fl oz',247,'g',1,'1997-08-29','2016-02-06');
INSERT INTO `cndb_wght` VALUES (14544,1,1,'fl oz',29.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14544,2,6,'fl oz',178,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14545,1,1,'fl oz',29.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14545,2,6,'fl oz',178,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14545,3,1,'cup (8 fl oz)',237,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14548,1,1,'serving (3 heaping tsp)',23,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14548,2,1,'cup',182,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14552,1,1,'fl oz',31,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14552,2,1,'can or bottle (16 fl oz)',492,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14552,3,1,'can (12 fl oz)',369,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14555,1,1,'fl oz',29.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14555,2,1,'cup',237,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14555,3,1,'ml',1,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14557,1,1,'serving',22,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14558,1,1,'serving',266,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14604,1,1,'fl oz',29.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14604,2,1,'serving (8 fl oz)',237,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14604,3,1,'ml',1.1,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14605,1,8,'fl oz (1 NLEA serving)',237,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14605,2,1,'serving',237,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14632,1,1,'cup',158,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14632,2,1,'can',391,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14633,1,1,'serving',238,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14634,1,1,'cup',244,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (14635,1,1,'serving 8 oz',246,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (14636,1,1,'container',209,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (14636,2,1,'ml',1,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (14637,1,1,'pouch',200,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (14639,1,8,'fl oz (approximate weight, 1 serving)',240,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (14645,1,1,'cup (8 fl oz)',238,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (14646,1,1,'cup (8 fl oz)',238,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (14647,1,8,'fl oz',240,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (14647,2,1,'fl oz',31.1,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (14648,1,8,'fl oz',237,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (14649,1,8,'fl oz',237,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (14651,1,1,'cup (8 fl oz)',238,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (14654,1,1,'tbsp',10,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (14654,2,1,'serving',20,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15001,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15002,1,1,'oz, boneless',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15002,2,1,'anchovy',4,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15002,3,1,'can (2 oz)',45,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15002,4,5,'anchovies',20,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15003,1,1,'fillet',79,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15003,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15004,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15004,2,1,'fillet',159,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15005,1,1,'fillet',150,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15005,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15006,1,1,'fillet',116,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15006,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15007,1,1,'fillet',32,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15007,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15008,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15008,2,1,'fillet',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15009,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15009,2,1,'fillet',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15010,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15010,2,1,'fillet',159,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15011,1,1,'fillet',87,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15011,2,3,'oz',85,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15012,1,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15012,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15013,1,1,'fillet',79,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15013,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15014,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15014,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15015,1,3,'oz',85,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15015,2,1,'fillet',231,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15016,1,3,'oz',85,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15016,2,1,'fillet',180,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15017,1,3,'oz',85,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15017,2,1,'can',312,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15018,1,1,'oz',28.35,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15018,2,1,'piece (5-1/2" x 1-1/2" x 1/2")',80,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (15018,3,3,'oz',85,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (15019,1,1,'fillet',116,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15019,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15020,1,1,'fillet',79,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15020,2,3,'oz',85,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15021,1,1,'fillet',87,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15021,2,3,'oz',85,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15022,1,1,'fillet',122,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15022,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15023,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15023,2,1,'fillet',204,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15024,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15024,2,1,'fillet',198,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15025,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15025,2,1,'fillet',204,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15026,1,1,'oz, boneless',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15026,2,1,'oz with bone (yield after bone removed)',22,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15026,3,1,'cubic inch, boneless',17,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15026,4,1,'fillet',159,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15026,5,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15027,1,1,'piece (4" x 2" x 1/2")',57,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15027,2,1,'stick (4" x 1" x 1/2")',28,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15028,1,1,'oz, boneless',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15028,2,1,'fillet',163,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15028,3,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15029,1,1,'fillet',127,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15029,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15030,1,1,'piece',42,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15031,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15031,2,1,'fillet',259,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15032,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15032,2,1,'fillet',202,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15033,1,3,'oz',85,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15033,2,1,'fillet',193,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15034,1,1,'fillet',150,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15034,2,3,'oz',85,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15035,1,1,'oz, boneless',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15035,2,1,'cubic inch, boneless',17,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15035,3,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15036,1,3,'oz',85,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15036,2,0.5,'fillet',204,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15037,1,3,'oz',85,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15037,2,0.5,'fillet',159,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15038,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15038,2,0.5,'fillet',204,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15039,1,1,'oz, boneless',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15039,2,1,'fillet',184,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15039,3,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15040,1,1,'fillet',143,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15040,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15041,1,1,'cup',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15041,2,1,'oz, boneless',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15041,3,1,'cubic inch',20,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15041,4,1,'piece (1-3/4" x 7/8" x 1/2")',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15042,1,1,'oz, boneless',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15042,2,1,'cubic inch, boneless',17,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15042,3,1,'fillet, large (7" x 2-1/4" x 1/4")',65,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15042,4,1,'fillet, medium (5" x 1-3/4" x 1/4")',40,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15042,5,1,'fillet, small (2-3/8" x 1-3/8" x 1/4")',20,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15043,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15043,2,1,'fillet',184,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15044,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15044,2,1,'fillet',193,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15045,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15045,2,0.5,'fillet',193,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15046,1,1,'fillet',112,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15046,2,3,'oz',85,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15047,1,1,'fillet',88,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15047,2,3,'oz',85,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15048,1,1,'oz, boneless',28.35,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15048,2,1,'cup',190,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15048,3,1,'cubic inch',16,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15048,4,1,'can (15 oz)',361,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15049,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15049,2,0.5,'fillet',198,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15050,1,3,'oz',85,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15050,2,1,'fillet',225,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15051,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15051,2,1,'fillet',187,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15052,1,1,'fillet',146,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15052,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15053,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15054,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15055,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15055,2,1,'fillet',119,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15055,3,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15056,1,1,'fillet',93,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15056,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15057,1,1,'oz, boneless',28.35,'g',1,'1995-06-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15057,2,1,'fillet',64,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15057,3,3,'oz',85,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15058,1,1,'fillet',50,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15058,2,3,'oz',85,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15059,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15059,2,0.5,'fillet',176,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15060,1,1,'fillet',60,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15060,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15061,1,1,'fillet',46,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15061,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15062,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15062,2,0.5,'fillet',198,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15063,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15063,2,0.5,'fillet',155,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15064,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15064,2,1,'fillet',159,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15065,1,3,'oz',85,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15065,2,0.5,'fillet',193,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15066,1,1,'fillet',77,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15066,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15067,1,1,'fillet',60,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15067,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15068,1,1,'oz, boneless',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15068,2,1,'fillet',112,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15068,3,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15069,1,1,'fillet',88,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15069,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15070,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15070,2,1,'fillet',191,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15071,1,1,'fillet',149,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15071,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15072,1,1,'tbsp',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15072,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15072,3,1,'can (8 oz), solids and liquid',227,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15072,4,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15073,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15074,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15074,2,0.5,'fillet',193,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15075,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15075,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15076,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15076,2,0.5,'fillet',198,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15077,1,1,'oz, boneless',28.35,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (15077,2,3,'oz',85,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (15077,3,1,'cubic inch, boneless',17,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15077,4,1,'cup, cooked',136,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (15078,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15078,2,0.5,'fillet',198,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15079,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15079,2,0.5,'fillet',198,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15080,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15080,2,1,'can',369,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15081,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15081,2,0.5,'fillet',198,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15082,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15082,2,0.5,'fillet',155,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15083,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15083,2,0.5,'fillet',159,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15084,1,3,'oz',85,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15084,2,1,'can',411,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15085,1,1,'oz, boneless',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15085,2,0.5,'fillet',198,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15085,3,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15086,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15086,2,0.5,'fillet',155,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15087,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15087,2,1,'can',337,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15088,1,1,'cup, drained',149,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15088,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15088,3,1,'cubic inch',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15088,4,1,'can (3.75 oz)',92,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15088,5,1,'small (2-2/3" x 1/2" x 1/4")',12,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15088,6,2,'sardines',24,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15089,1,1,'cup',89,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15089,2,1,'can',370,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15089,3,1,'sardine',38,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15090,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15090,2,1,'oz, boneless',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15090,3,1,'fillet',64,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15090,4,1,'cup',166,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15091,1,1,'fillet',129,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15091,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15092,1,1,'fillet',101,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15092,2,3,'oz',85,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15093,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15093,2,1,'fillet',238,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15094,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15094,2,1,'fillet',184,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15095,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15096,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15097,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15097,2,1,'fillet',238,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15098,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15098,2,1,'fillet',186,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15099,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15100,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15101,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15101,2,1,'fillet',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15102,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15102,2,1,'fillet',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15103,1,1,'fillet',64,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15103,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15104,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15105,1,3,'oz',85,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (15105,2,1,'cup, cooked',136,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (15105,3,1,'piece (4-1/2" x 2-1/8" x 7/8")',145,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (15105,4,1,'oz, boneless',28.35,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (15105,5,1,'cubic inch, boneless',17,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (15106,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15106,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15107,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15107,2,1,'fillet',159,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15108,1,1,'fillet',48,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15108,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15109,1,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15109,2,3,'oz',85,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (15110,1,3,'oz',85,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (15110,2,1,'piece (4-1/2" x 2-1/8" x 7/8")',136,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (15111,1,3,'oz',85,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (15111,2,1,'piece',106,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (15112,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15112,2,0.5,'fillet',193,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15113,1,0.5,'fillet',150,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15113,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15114,1,1,'fillet',79,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15114,2,3,'oz',85,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15115,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15115,2,1,'fillet',159,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15116,1,1,'fillet',143,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15116,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15117,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15118,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15119,1,1,'cup, solid or chunks',146,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (15119,2,1,'oz',28.35,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15119,3,1,'can',171,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (15119,4,3,'oz',85,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (15119,5,1,'can (12.5 oz), drained',321,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (15121,1,1,'oz',28.35,'g',1,'2007-11-28','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15121,2,3,'oz',85,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15121,3,1,'can',165,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (15121,4,1,'cup, solid or chunks',154,'g',1,'2007-11-28','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15121,5,1,'can (12.5 oz), drained',315,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (15123,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15123,2,0.5,'fillet',198,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15124,1,3,'oz',85,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15124,2,1,'can',178,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15126,1,3,'oz',85,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15126,2,1,'can',172,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15127,1,1,'oz, boneless',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15127,2,1,'cubic inch, boneless',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15127,3,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15128,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15128,2,1,'cup',205,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15129,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15129,2,0.5,'fillet',204,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15130,1,3,'oz',85,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15130,2,1,'fillet',198,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15131,1,1,'cup, cooked',136,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15131,2,1,'oz, boneless',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15131,3,1,'cubic inch, boneless',17,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15131,4,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15132,1,1,'fillet',92,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15132,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15133,1,1,'fillet',72,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15133,2,3,'oz',85,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15134,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15134,2,0.5,'fillet',153,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15135,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15135,2,0.5,'fillet',187,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15136,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15136,2,1,'leg',172,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15137,1,1,'leg',134,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15137,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15138,1,3,'oz',85,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15139,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15139,2,1,'crab',21,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15140,1,1,'cup, flaked and pieces',118,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15140,2,1,'cup (not packed)',135,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15140,3,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15140,4,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15141,1,1,'cup',135,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15141,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15141,3,1,'can (6.5 oz), drained',125,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15141,4,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15142,1,1,'cake',60,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15143,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15143,2,1,'crab',163,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15144,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15145,1,3,'oz',85,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15145,2,8,'crayfish',27,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15146,1,3,'oz',85,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15147,1,1,'lobster',150,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15147,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15148,1,1,'cup',145,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15148,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15149,1,1,'medium',6,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15149,2,1,'small',5,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15149,3,3,'oz',85,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15149,4,4,'large',28,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15150,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15150,2,4,'large',30,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15151,1,3,'oz',85,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15151,2,4,'large',22,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15152,1,1,'CUP',128,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (15152,2,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15152,3,1,'can (4.5 oz), drained',128,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (15152,4,10,'shrimp',32,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (15152,5,3,'oz',85,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (15153,1,3,'oz',85,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15154,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15154,2,1,'lobster',209,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15155,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15156,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15157,1,3,'oz',85,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15157,2,1,'large',20,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15157,3,1,'lb (with shell), yield after shell removed',68,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15157,4,1,'medium',14.5,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15157,5,1,'small',9,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15157,6,1,'cup (with liquid and clams)',227,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15158,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15158,2,20,'small',188,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15159,1,3,'oz',85,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15159,2,20,'small',190,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15160,1,3,'oz',85,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15160,2,1,'cup',160,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15162,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15162,2,1,'cup',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15163,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15164,1,1,'cup',150,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15164,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15164,3,1,'large',20,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15164,4,1,'medium',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15164,5,1,'small',10,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15164,6,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15165,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15166,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15167,1,6,'medium',84,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15167,2,1,'cup',248,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15168,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15168,2,6,'medium',88,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15169,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15169,2,6,'medium',42,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15170,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15170,2,1,'cup, undrained',248,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15170,3,1,'oz, drained',23,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15170,4,1,'can (12 oz), oysters and liquid',272,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15170,5,1,'oyster',8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15170,6,1,'cup, drained',162,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15171,1,1,'medium',50,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15171,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15172,1,1,'unit 2 large or 5 small',30,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15172,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15173,1,2,'large',31,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15174,1,3,'oz',85,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15175,1,1,'oz, boneless',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15175,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15176,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15177,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15178,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15179,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15179,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15180,1,3,'oz',85,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15180,2,1,'can',369,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15181,1,3,'oz',85,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15181,2,1,'can',454,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15182,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15182,2,1,'can',369,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15183,1,3,'oz',85,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15183,2,1,'can',171,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15184,1,3,'oz',85,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15184,2,1,'can',165,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15185,1,3,'oz',85,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15185,2,1,'can',178,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15186,1,3,'oz',85,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15186,2,1,'can',172,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15187,1,1,'fillet',62,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15187,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15188,1,1,'fillet',124,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15188,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15189,1,1,'fillet',117,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15189,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15190,1,1,'fillet',90,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15190,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15192,1,1,'fillet',90,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15192,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15194,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15194,2,1,'fillet',159,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15195,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15195,2,1,'fillet',154,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15196,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15196,2,0.5,'fillet',159,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15197,1,1,'fillet',144,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15197,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15199,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15199,2,0.5,'fillet',151,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15200,1,3,'oz',85,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15200,2,0.5,'fillet',154,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15201,1,1,'oz, boneless',28.35,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15201,2,1,'cubic inch, boneless',17,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15201,3,1,'fillet',176,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15201,4,3,'oz',85,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15204,1,1,'fillet',124,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15204,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15205,1,3,'oz',85,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15205,2,0.5,'fillet',151,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15206,1,0.5,'fillet',137,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15206,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15207,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15207,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15208,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15208,2,0.5,'fillet',151,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15209,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15209,2,0.5,'fillet',154,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15210,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15210,2,0.5,'fillet',154,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15211,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15211,2,0.5,'fillet',154,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15212,1,3,'oz',85,'g',1,'1994-01-31','2015-01-07');
INSERT INTO `cndb_wght` VALUES (15212,2,0.5,'fillet',124,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (15214,1,3,'oz',85,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15214,2,1,'fillet',186,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15216,1,1,'fillet',50,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15216,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15217,1,1,'fillet',124,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15217,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15218,1,1,'fillet',37,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15218,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15219,1,1,'fillet',62,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15219,2,3,'oz',85,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15220,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15220,2,0.5,'fillet',154,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15221,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15223,1,3,'oz',85,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15223,2,1,'fillet',154,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15224,1,0.5,'fillet',119,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15224,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15226,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15226,2,1,'crab',127,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15227,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15228,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15228,2,1,'lobster',163,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15229,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15230,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15231,1,1,'medium',25,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15231,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15232,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15233,1,1,'fillet',143,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15233,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15234,1,3,'oz',85,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15234,2,1,'fillet',159,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15235,1,1,'fillet',143,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15235,2,3,'oz',85,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15236,1,3,'oz',85,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15236,2,0.5,'fillet',198,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15237,1,3,'oz',85,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15237,2,0.5,'fillet',178,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15238,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15238,2,1,'fillet',159,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15239,1,1,'fillet',143,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15239,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15240,1,1,'fillet',79,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15240,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15241,1,1,'fillet',71,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15241,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15242,1,3,'oz',85,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15242,2,8,'crayfish',27,'g',1,'1994-11-17','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15243,1,3,'oz',85,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15244,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15244,2,6,'medium',59,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15245,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15245,2,6,'medium',84,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15246,1,3,'oz',85,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15246,2,6,'medium',59,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (15247,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15247,2,0.5,'fillet',178,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15250,1,1,'cup, sliced',127,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15250,2,1,'oz cooked, yield',17,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15251,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15252,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15253,1,3,'oz',85,'g',1,'2012-03-02','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15253,2,1,'can total can contents',417,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15260,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15260,2,1,'can drained solids (total)',315,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15261,1,1,'fillet',116,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15262,1,1,'fillet',87,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15264,1,3,'oz',85,'g',1,'2012-03-02','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15264,2,1,'can drained solids, bone and skin removed',247,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15265,1,3,'oz',85,'g',1,'2012-03-02','2013-12-26');
INSERT INTO `cndb_wght` VALUES (15265,2,1,'can drained solids, bone and skin removed',242,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15266,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (15267,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (15269,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (15270,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (15271,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (15274,1,1,'filet',149,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (15274,2,1,'fish',332,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16001,1,1,'cup',197,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16002,1,1,'cup',230,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16003,1,1,'cup',296,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16004,1,1,'slice',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16005,1,1,'cup',253,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16006,1,1,'CUP',254,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16007,1,1,'cup',266,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16008,1,1,'cup',259,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16009,1,1,'CUP',253,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16010,1,1,'CUP',249,'g',1,'1994-01-31','2015-06-19');
INSERT INTO `cndb_wght` VALUES (16011,1,1,'CUP',246,'g',1,'1994-01-31','2009-02-11');
INSERT INTO `cndb_wght` VALUES (16014,1,1,'cup',194,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16014,2,1,'tbsp',12.1,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16015,1,1,'CUP',172,'g',1,'1994-11-17','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16016,1,1,'cup',184,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16017,1,1,'cup',185,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16018,1,1,'cup',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16019,1,1,'cup',195,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16020,1,1,'cup',177,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16021,1,1,'cup',260,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16022,1,1,'cup',184,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16023,1,1,'cup',177,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16024,1,1,'CUP',183,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16025,1,1,'CUP',177,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16026,1,1,'CUP',262,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16027,1,1,'CUP',184,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16028,1,1,'CUP',177,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16028,2,1,'TBSP',11,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16029,1,1,'CUP',256,'g',1,'1994-01-31','2007-03-25');
INSERT INTO `cndb_wght` VALUES (16030,1,1,'cup',184,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16031,1,1,'cup',177,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16032,1,1,'cup',184,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16032,2,1,'tbsp',12.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16033,1,1,'CUP',177,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16033,2,1,'TBSP',11,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16034,1,1,'CUP',256,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16034,2,1,'TBSP',16,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16034,3,1,'can',436,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16035,1,1,'cup',184,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16036,1,1,'cup',177,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16037,1,1,'cup',208,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16038,1,1,'cup',182,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16039,1,1,'CUP',262,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16040,1,1,'cup',210,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16041,1,1,'CUP',169,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16042,1,1,'CUP',193,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16042,2,1,'TBSP',12,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16043,1,1,'CUP',171,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16043,2,1,'TBSP',10.6,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16044,1,1,'CUP',240,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16044,2,1,'can',442,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16045,1,1,'cup',215,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16046,1,1,'cup',179,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16047,1,1,'cup',196,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16048,1,1,'cup',177,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16049,1,1,'cup',202,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16049,2,1,'tbsp',12.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16050,1,1,'CUP',179,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16050,2,1,'TBSP',11.2,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16051,1,1,'cup',262,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16052,1,1,'cup',150,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16052,2,1,'tbsp',9.4,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16053,1,1,'cup',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16054,1,1,'cup',256,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16055,1,1,'cup',103,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16055,2,1,'tbsp',6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16056,1,1,'cup',200,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16056,2,1,'tbsp',12.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16057,1,1,'cup',164,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16058,1,1,'CUP',240,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16058,2,1,'can (total can contents)',448,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16059,1,1,'cup',256,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16059,2,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16060,1,1,'cup',167,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16061,1,1,'cup',171,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16062,1,1,'CUP',167,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16062,2,1,'TBSP',10.5,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16063,1,1,'cup',171,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (16064,1,1,'CUP',240,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16065,1,1,'CUP',240,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16067,1,1,'cup',210,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16068,1,1,'cup',194,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16069,1,1,'CUP',192,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16069,2,1,'tablespoon',12,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (16070,1,1,'CUP',198,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16070,2,1,'TBSP',12.3,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16071,1,1,'CUP',178,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16071,2,1,'TBSP',11.1,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16072,1,1,'CUP',188,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16072,2,1,'TBSP',11.7,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16073,1,1,'CUP',241,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16074,1,1,'CUP',202,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16075,1,1,'CUP',182,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16076,1,1,'cup',180,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16077,1,1,'cup',166,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16078,1,1,'cup',196,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16079,1,1,'cup',177,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16080,1,1,'cup',207,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16080,2,1,'tbsp',13,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16081,1,1,'CUP',202,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16082,1,1,'cup',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16083,1,1,'cup',207,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16084,1,1,'cup',180,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16084,2,1,'oz dry, yield after cooking',69,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16085,1,1,'cup',196,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (16086,1,1,'CUP',196,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16086,2,1,'TBSP',12.2,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16087,1,1,'oz',28.35,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (16087,2,1,'cup',146,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (16088,1,1,'cup in shell, edible yield',63,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16088,2,1,'cup, shelled',180,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16088,3,1,'oz shelled',28.35,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16088,4,33,'nuts',28,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16089,1,1,'cup, chopped',144,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16089,2,1,'oz shelled (32 nuts)',28.35,'g',1,'1998-01-15','2015-01-07');
INSERT INTO `cndb_wght` VALUES (16090,1,1,'oz',28.35,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16090,2,1,'peanut',1,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16091,1,1,'cup',146,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16091,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16092,1,1,'cup',147,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16092,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16093,1,1,'cup',146,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16093,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16094,1,1,'cup',144,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16094,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16095,1,1,'cup',146,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16095,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16096,1,1,'cup',143,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16096,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16097,1,2,'tbsp',32,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (16097,2,1,'cup',258,'g',1,'1998-01-15','2013-12-26');
INSERT INTO `cndb_wght` VALUES (16098,1,2,'tbsp',32,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (16098,2,1,'cup',258,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (16099,1,1,'cup',60,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16099,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16100,1,1,'cup',60,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16100,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16101,1,1,'CUP',205,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16102,1,1,'CUP',168,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16103,1,1,'CUP',238,'g',1,'1994-01-31','2009-02-11');
INSERT INTO `cndb_wght` VALUES (16103,2,1,'can',442,'g',1,'2002-09-06','2015-06-19');
INSERT INTO `cndb_wght` VALUES (16104,1,1,'cup',144,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16104,2,1,'oz cooked, yield',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16104,3,1,'strip',5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16106,1,1,'CUP',88,'g',1,'1994-11-17','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16106,2,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16107,1,1,'link',25,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16107,2,1,'patty',38,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16107,3,1,'slice',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16108,1,1,'cup',186,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16109,1,1,'cup',172,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16109,2,1,'tbsp',10.7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16110,1,1,'cup',172,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16111,1,1,'cup',93,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16112,1,1,'tbsp',17,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16112,2,1,'cup',275,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16113,1,1,'cup',175,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16114,1,1,'cup',166,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16115,1,1,'cup, stirred',84,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16115,2,1,'tbsp',5.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16116,1,1,'cup, stirred',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16117,1,1,'cup',105,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16117,2,1,'tbsp',6.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16118,1,1,'cup, stirred',88,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16118,2,1,'tbsp',5.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16119,1,1,'cup',122,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16120,1,1,'cup',243,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16120,2,1,'fl oz',30.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16121,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16122,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16123,1,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16123,2,1,'tsp',5.3,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16123,3,1,'cup',255,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16123,4,1,'individual packet',8.9,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16124,1,1,'tbsp',18,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16124,2,1,'tsp',6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16125,1,1,'tbsp',18,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16125,2,1,'tsp',6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16125,3,0.25,'cup',58,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16126,1,0.5,'CUP',126,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (16126,2,0.25,'block',81,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (16126,3,0.2,'block',91,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (16127,1,1,'piece (2-1/2" x 2-3/4" x 1")',120,'g',1,'2007-11-28','2013-12-26');
INSERT INTO `cndb_wght` VALUES (16127,2,1,'cup (1/2" cubes)',248,'g',1,'2007-11-28','2013-12-26');
INSERT INTO `cndb_wght` VALUES (16127,3,1,'cubic inch',18,'g',1,'2007-11-28','2013-12-26');
INSERT INTO `cndb_wght` VALUES (16127,4,0.25,'block',116,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16127,5,0.2,'block',90,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (16128,1,1,'piece',17,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16129,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16129,2,1,'piece',13,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16130,1,1,'cup',122,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16132,1,1,'block',11,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16133,1,1,'cup',167,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16134,1,1,'cup',171,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16135,1,1,'cup',182,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16136,1,1,'cup',172,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16137,1,1,'tablespoon',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16137,2,1,'cup',246,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16138,1,1,'patty (approx 2-1/4" dia)',17,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16139,1,1,'cup',243,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16139,2,1,'fl oz',30.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16144,1,1,'CUP',192,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16145,1,1,'can drained solids',266,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (16146,1,1,'can drained solids',277,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (16147,1,1,'pattie',70,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16149,1,2,'tbsp',31,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16150,1,2,'tablespoon',36,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16155,1,2,'tbsp',32,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16155,2,1,'cup',258,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16156,1,2,'tbsp',32,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16156,2,1,'cup',258,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16157,1,1,'CUP',92,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16158,1,1,'tbsp',15,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (16158,2,1,'cup',246,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (16159,1,0.2,'block',91,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16160,1,0.25,'block',122,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16166,1,1,'cup',243,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16166,2,1,'fl oz',30.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16167,1,2,'tbsp',32,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (16167,2,1,'CUP',258,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (16168,1,1,'CUP',243,'g',1,'2007-12-03','2007-12-03');
INSERT INTO `cndb_wght` VALUES (16168,2,1,'FL OZ',30.6,'g',1,'2007-12-03','2010-01-05');
INSERT INTO `cndb_wght` VALUES (16171,1,1,'cup',242,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16171,2,1,'can',444,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16172,1,1,'cup',231,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16172,2,1,'can',445,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16173,1,1,'cup',233,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16173,2,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16222,1,1,'cup',243,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (16223,1,1,'CUP',243,'g',1,'2007-12-03','2007-12-03');
INSERT INTO `cndb_wght` VALUES (16225,1,1,'CUP',243,'g',1,'2007-12-03','2007-12-03');
INSERT INTO `cndb_wght` VALUES (16227,1,1,'CUP',243,'g',1,'2007-12-03','2007-12-03');
INSERT INTO `cndb_wght` VALUES (16228,1,1,'CUP',243,'g',1,'2007-12-03','2007-12-03');
INSERT INTO `cndb_wght` VALUES (16229,1,1,'CUP',243,'g',1,'2007-12-03','2007-12-03');
INSERT INTO `cndb_wght` VALUES (16230,1,1,'cup',243,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (16231,1,1,'cup',243,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (16302,1,1,'cup',230,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16315,1,1,'CUP',172,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16316,1,1,'cup',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16317,1,1,'cup',185,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16320,1,1,'cup',177,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16323,1,1,'cup',177,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16325,1,1,'CUP',177,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16326,1,1,'cup',262,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16328,1,1,'CUP',177,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16331,1,1,'cup',177,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16333,1,1,'cup',177,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16335,1,1,'cup cup rinsed solids',158,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (16336,1,1,'cup',177,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16337,1,1,'cup',256,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16337,2,1,'can total can contents',436,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16338,1,1,'cup',182,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16341,1,1,'CUP',169,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16343,1,1,'CUP',171,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16346,1,1,'cup',179,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16347,1,1,'cup',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16347,2,1,'can total can contents',442,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16348,1,1,'cup',177,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16350,1,1,'cup',179,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16353,1,1,'cup',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16357,1,1,'cup',164,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16358,1,1,'can drained',253,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (16359,1,1,'can drained, rinsed',254,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (16359,2,1,'cup drained, rinsed',152,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (16360,1,1,'cup',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16360,2,1,'can total can contents',448,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16361,1,1,'cup',171,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16363,1,1,'CUP',171,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16368,1,1,'cup',194,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16370,1,1,'CUP',198,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16372,1,1,'CUP',188,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16375,1,1,'CUP',182,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16377,1,1,'cup',166,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16379,1,1,'cup',177,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16381,1,1,'CUP',202,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16384,1,1,'cup',180,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16386,1,1,'CUP',196,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16389,1,1,'cup,',144,'g',1,'1994-09-29','2015-01-07');
INSERT INTO `cndb_wght` VALUES (16389,2,1,'oz shelled (32 nuts)',28.35,'g',1,'1998-01-15','2015-01-07');
INSERT INTO `cndb_wght` VALUES (16390,1,1,'CUP',146,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16390,2,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16390,3,1,'peanut',1,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16392,1,1,'cup',147,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16392,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16394,1,1,'cup',144,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16394,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16396,1,1,'cup',143,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16396,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16397,1,2,'tbsp',32,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (16397,2,1,'cup',258,'g',1,'1998-01-15','2013-12-26');
INSERT INTO `cndb_wght` VALUES (16398,1,2,'tbsp',32,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (16398,2,1,'cup',258,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (16399,1,1,'tbsp',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16402,1,1,'CUP',168,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16403,1,1,'cup',238,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16403,2,1,'tablespoon',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16409,1,1,'cup',172,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16410,1,1,'cup',172,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16420,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16422,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16424,1,1,'tbsp',14.2,'g',1,'1994-11-02','2013-12-26');
INSERT INTO `cndb_wght` VALUES (16424,2,1,'tsp',4.5,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (16424,3,1,'cup',255,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (16425,1,1,'tbsp',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16425,2,1,'tsp',4.9,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16425,3,0.25,'cup',58,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16426,1,0.5,'CUP',126,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16426,2,0.25,'block',81,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16427,1,0.5,'CUP',124,'g',1,'1994-11-17','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16427,2,0.25,'block',116,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (16428,1,1,'piece',17,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16429,1,1,'piece',13,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16432,1,1,'block',11,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16434,1,1,'cup',171,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (16436,1,1,'cup',172,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17000,1,4,'oz',113,'g',1,'2013-02-22','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17000,2,1,'roast with bone',325,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17001,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17001,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17002,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17002,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',242,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17003,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17003,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17004,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17004,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',187,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17005,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17005,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17006,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17006,2,1,'unit, cooked (yield from 1 lb raw meat)',286,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17007,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17007,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17008,1,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',148,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17008,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17009,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17009,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17010,1,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',128,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17010,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17011,1,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (17011,2,1,'lb',453.6,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (17012,1,3,'oz',85,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (17012,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',265,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (17013,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17013,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17014,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17014,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17015,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17015,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17016,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17016,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',269,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17017,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17017,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17018,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17018,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',238,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17019,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17019,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17020,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17020,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',262,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17021,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17021,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17022,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17022,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',201,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17023,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17023,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 120 g)',95,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17024,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17024,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 120 g)',64,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17025,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17025,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',269,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17026,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17026,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 120 g)',65,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17027,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17027,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 120 g)',46,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17028,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17028,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',193,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17029,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17029,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17030,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17030,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',229,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17031,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17031,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',255,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17032,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17032,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17033,1,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',147,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17033,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17034,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17034,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',159,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17035,1,4,'oz',113,'g',1,'1999-03-22','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17035,2,1,'lb',453.6,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (17036,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17036,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17037,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17037,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',248,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17038,1,3,'oz',85,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (17038,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',269,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (17039,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17039,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17040,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17040,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',174,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17041,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17041,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',202,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17042,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17042,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',217,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17043,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17043,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 160 g)',133,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17044,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17044,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 160 g)',70,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17045,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17045,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 160 g)',93,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17046,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17046,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',286,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17047,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17047,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 160 g)',101,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17048,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17048,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 160 g)',55,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17049,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17049,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 160 g)',74,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17050,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17050,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',224,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17051,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17051,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17052,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17052,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',209,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17053,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17053,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',252,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17054,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17054,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',258,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17055,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17055,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17056,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17056,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',168,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17057,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17057,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',207,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17058,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17058,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',210,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17059,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (17059,2,1,'lb',453.6,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (17060,1,3,'oz',85,'g',1,'1994-11-17','2013-12-26');
INSERT INTO `cndb_wght` VALUES (17060,2,1,'unit, cooked (yield from 1 lb raw meat)',272,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (17061,1,3,'oz',85,'g',1,'1994-11-17','2013-12-26');
INSERT INTO `cndb_wght` VALUES (17061,2,1,'unit, cooked (yield from 1 lb raw meat)',327,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (17062,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17062,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17063,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17063,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',222,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17064,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17064,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17065,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17065,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',164,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17066,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17066,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17067,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17067,2,1,'unit, cooked (yield from 1 lb raw meat)',286,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17068,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17068,2,1,'serving',115,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17069,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17069,2,1,'serving',85,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17070,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17070,2,1,'serving',115,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17071,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17071,2,1,'serving',85,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17072,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17072,2,1,'serving',115,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17073,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17073,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',258,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17074,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17074,2,1,'serving',115,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17075,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17075,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',218,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17076,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17076,2,1,'serving',115,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17077,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17077,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 85 g)',43,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17078,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17078,2,1,'serving',115,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17079,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17079,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 85 g)',30,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17080,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17080,2,1,'serving',115,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17081,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17081,2,1,'serving',85,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17082,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17082,2,1,'serving',115,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17083,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17083,2,1,'serving',85,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17084,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17084,2,1,'serving',115,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17085,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17085,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',206,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17086,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17086,2,1,'serving',115,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17087,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17087,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',157,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17088,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17088,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17089,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17089,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',209,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17090,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17090,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17091,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17091,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',192,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17092,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17092,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17093,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17093,2,1,'unit, cooked (yield from 1 lb raw meat)',290,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17094,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17094,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17095,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17095,2,1,'unit, cooked (yield from 1 lb raw meat)',272,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17096,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17096,2,1,'unit, cooked (yield from 1 lb raw meat)',295,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17097,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17097,3,1,'unit, cooked (yield from 1 lb raw meat)',304,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17098,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17098,2,1,'unit, cooked (yield from 1 lb raw meat)',358,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17099,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17099,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17100,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17100,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',267,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17101,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17101,2,1,'unit, cooked (yield from 1 lb raw meat)',295,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17102,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17102,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',289,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17103,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17103,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',351,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17104,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17104,2,1,'roast',1495,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (17105,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17105,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 195 g)',80,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17106,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17106,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',229,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17107,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17107,2,1,'roast',1495,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (17107,3,1,'oz',28.35,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17108,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17108,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 195 g)',69,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17109,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17109,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',208,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17110,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17110,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17111,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17111,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',177,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17112,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17112,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17113,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17113,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17114,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17114,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',163,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17115,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17115,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',215,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17116,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17116,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17117,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17117,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',191,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17118,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17118,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',258,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17119,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17119,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17120,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17120,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',182,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17121,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17121,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',251,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17122,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17122,2,1,'steak, excluding refuse (yield from 1 raw steak, with refuse, weighing 385 g)',304,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17123,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17123,2,1,'steak, excluding refuse (yield from 1 raw steak, with refuse, weighing 385 g)',173,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17124,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17124,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',283,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17125,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17125,2,1,'steak, excluding refuse (yield from 1 raw steak, with refuse, weighing 385 g)',289,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17126,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17126,2,1,'steak, excluding refuse (yield from 1 raw steak, with refuse, weighing 385 g)',160,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17127,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17127,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',272,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17128,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17128,2,1,'chop',450,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (17129,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17129,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',186,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17130,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17130,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',244,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17131,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17131,2,1,'chop',450,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (17131,3,1,'oz',28.35,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17132,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17132,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',174,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17133,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17133,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',236,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17134,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17134,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17135,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17135,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',205,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17136,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17136,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',269,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17137,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17137,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17138,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17138,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',183,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17139,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17139,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',251,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17140,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17140,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17141,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17141,2,1,'unit, cooked (yield from 1 lb raw meat)',263,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17142,1,3,'oz',85,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (17142,2,1,'oz',28.35,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (17142,3,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17143,1,3,'oz',85,'g',1,'1998-01-15','2013-12-26');
INSERT INTO `cndb_wght` VALUES (17143,2,1,'unit, cooked (yield from 1 lb raw meat)',299,'g',1,'1996-09-30','2013-12-26');
INSERT INTO `cndb_wght` VALUES (17144,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17144,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17145,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17145,2,1,'piece, cooked (yield from 1 lb raw meat, boneless)',340,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17147,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17147,2,1,'piece, cooked (yield from 1 lb raw meat, boneless)',277,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17148,1,3,'oz',85,'g',1,'2009-01-25','2009-01-25');
INSERT INTO `cndb_wght` VALUES (17149,1,1,'patty (cooked from 4 oz raw)',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17149,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17151,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17151,2,1,'piece, cooked (yield from 1 lb raw meat, boneless)',313,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17152,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17152,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17153,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17153,2,1,'piece, cooked (yield from 1 lb raw meat, boneless)',340,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17154,1,4,'oz',113,'g',1,'2013-02-22','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17155,1,4,'oz',113,'g',1,'2013-02-22','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17155,2,1,'roast with bone',325,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17156,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17156,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17157,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17157,2,1,'piece, cooked (yield from 1 lb raw meat, boneless)',340,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17159,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17159,2,1,'piece, cooked (yield from 1 lb raw meat, boneless)',340,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17160,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17160,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17161,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17161,2,1,'piece, cooked (yield from 1 lb raw meat, boneless)',340,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17162,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17162,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17163,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17163,2,1,'piece, cooked (yield from 1 lb raw meat, boneless)',340,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17164,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17164,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17165,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17165,2,1,'piece, cooked (yield from 1 lb raw meat, boneless)',340,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17166,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17166,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17167,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17167,2,1,'piece, cooked (yield from 1 lb raw meat, boneless)',340,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17168,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (17168,2,1,'lb',453.6,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (17169,1,3,'oz',85,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (17169,2,1,'piece, cooked (yield from 1 lb raw meat, boneless)',340,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (17170,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17170,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17171,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17171,2,1,'piece, cooked (yield from 1 lb raw meat, boneless)',340,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17172,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17172,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17173,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17173,2,1,'piece, cooked (yield from 1 lb raw meat, boneless)',340,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17176,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17176,2,1,'piece, cooked (yield from 1 lb raw meat, boneless)',399,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17177,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17177,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17178,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17178,2,1,'piece, cooked (yield from 1 lb raw meat, boneless)',313,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17179,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17179,2,1,'piece, cooked (yield from 1 lb raw meat, boneless)',299,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17180,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17180,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17181,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17181,2,1,'piece, cooked (yield from 1 lb raw meat, boneless)',299,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17182,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17182,2,1,'piece, cooked (yield from 1 lb raw meat, boneless)',399,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17183,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17183,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17184,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17184,2,1,'piece, cooked (yield from 1 lb raw meat, boneless)',313,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17185,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17185,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17186,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17186,2,1,'unit, cooked (yield from 1 lb raw meat)',347,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17187,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17187,2,1,'unit, cooked (yield from 1 lb raw meat)',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17188,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17188,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17189,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17189,2,1,'unit, cooked (yield from 1 lb raw meat)',339,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17190,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17190,2,1,'unit, cooked (yield from 1 lb raw meat)',330,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17191,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17191,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17192,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17192,2,1,'unit, cooked (yield from 1 lb raw meat)',191,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17193,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17193,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17194,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17194,2,1,'unit, cooked (yield from 1 lb raw meat)',198,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17195,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17195,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17196,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17196,2,1,'unit, cooked (yield from 1 lb raw meat)',255,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17197,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17197,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17198,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17198,2,1,'unit, cooked (yield from 1 lb raw meat)',184,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17199,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17199,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17200,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17200,2,1,'unit, cooked (yield from 1 lb raw meat)',336,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17201,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17201,2,1,'unit, cooked (yield from 1 lb raw meat)',322,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17202,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17202,2,1,'lb',453,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17203,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17203,2,1,'slice',80,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17204,1,3,'oz',85,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17204,2,1,'slice',67,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17205,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17205,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17206,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17206,2,1,'unit, cooked (yield from 1 lb raw meat)',381,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17207,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17207,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17208,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17208,2,1,'unit, cooked (yield from 1 lb raw meat)',300,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17209,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17209,2,8,'oz',227,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17210,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17210,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17211,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17211,2,1,'unit, cooked (yield from 1 lb raw meat)',231,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17212,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17212,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17213,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17213,2,1,'unit, cooked (yield from 1 lb raw meat)',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17214,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17214,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17215,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17215,2,1,'unit, cooked (yield from 1 lb raw meat)',295,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17216,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17216,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17217,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17217,2,1,'unit, cooked (yield from 1 lb raw meat)',345,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17218,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17218,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17219,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17220,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17220,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17221,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17221,2,1,'unit, cooked (yield from 1 lb raw meat)',255,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17222,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17222,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17223,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17223,2,1,'unit, cooked (yield from 1 lb raw meat)',255,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17224,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17224,2,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17225,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17225,2,1,'unit, cooked (yield from 1 lb raw meat)',313,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17226,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17226,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17227,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17227,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',250,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17228,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17228,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17229,1,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',148,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17229,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17230,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17230,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17231,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17231,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',260,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17232,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17232,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17233,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17233,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',267,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17234,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17234,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17235,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17235,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',260,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17236,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17236,2,1,'steak, excluding refuse (yield from 1 raw steak, with refuse, weighing 102 g)',79,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17237,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17237,2,1,'steak, excluding refuse (yield from 1 raw steak, with refuse, weighing 102 g)',53,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17238,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17238,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',265,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17239,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17239,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17240,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17240,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',222,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17241,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17241,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',248,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17242,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17242,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17243,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17243,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',213,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17244,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17244,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',242,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17245,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17245,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',263,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17246,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17246,2,1,'steak, excluding refuse (yield from 1 raw steak, with refuse, weighing 102 g)',84,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17247,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17247,2,1,'steak, excluding refuse (yield from 1 raw steak, with refuse, weighing 102 g)',45,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17248,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17248,2,1,'steak, excluding refuse (yield from 1 raw steak, with refuse, weighing 102 g)',59,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17249,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17249,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',284,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17250,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17250,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17251,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17251,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',207,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17252,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17252,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',250,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17253,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17253,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',256,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17254,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17254,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17255,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17255,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',242,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17256,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17256,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17257,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17257,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',168,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17258,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17258,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17259,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17259,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',253,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17260,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17260,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 85 g)',63,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17261,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17261,2,1,'chop, excluding refuse (yield from 1 raw chop, with refuse, weighing 85 g)',42,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17262,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17262,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17263,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17263,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',233,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17264,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17264,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17265,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17265,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',233,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17267,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17267,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17267,3,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17268,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17268,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17268,3,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17269,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17269,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17269,3,4,'oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17270,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17271,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17271,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17272,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17272,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',283,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17273,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17273,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',291,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17274,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17274,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',274,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17275,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17275,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',237,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17276,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17276,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17277,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17277,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',194,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17278,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17278,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17279,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17279,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',223,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17280,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17280,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17280,3,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17281,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17281,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',270,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17282,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17282,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17282,3,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17283,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17283,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',236,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17284,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17284,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17284,3,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17285,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17285,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',248,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17286,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17286,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17286,3,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17287,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17287,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',211,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17288,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17288,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17288,3,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17289,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17289,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',180,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17290,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17290,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17290,3,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17291,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17291,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',284,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17292,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17292,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17292,3,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17293,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17293,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',251,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17294,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17294,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17294,3,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17295,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17295,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',277,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17296,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17296,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17296,3,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17297,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17297,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',246,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17298,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17298,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17298,3,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17299,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17299,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',306,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17300,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17300,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17300,3,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17301,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17301,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',259,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17302,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17303,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17304,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17305,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17306,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17307,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17308,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17309,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17310,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17310,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17311,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17312,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17312,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17313,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17314,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17314,2,1,'chop',63,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17315,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17315,2,1,'chop',54,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17316,1,4,'oz',113,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17316,2,1,'chop',63,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17316,3,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17317,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17317,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',241,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17317,3,1,'chop',54,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17318,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17318,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17318,3,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17319,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17319,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',262,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17320,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17320,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17320,3,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17321,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17321,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',222,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17322,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17322,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17323,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17324,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17324,2,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17325,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17326,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17326,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17326,3,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17327,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17327,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',273,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17328,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17328,2,1,'lb',453.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17328,3,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17329,1,3,'oz',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17329,2,1,'piece, cooked, excluding refuse (yield from 1 lb raw meat with refuse)',233,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17330,1,1,'serving ( 3 oz )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17330,2,1,'patty',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17331,1,1,'patty ( yield from 112.7 g raw meat )',87,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17331,2,1,'serving ( 3 oz )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17332,1,1,'serving ( 3 oz )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17332,2,1,'steak ( yield from 309.7 g raw meat )',194,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17333,1,1,'serving ( 3 oz )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17333,2,1,'roast ( yield from 1247 g raw meat ) ( 3 to 5 lb roast)',774,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17334,1,1,'serving ( 3 oz )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17334,2,1,'roast (3 to 5 lb roast)',1237,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17335,1,1,'serving ( 3 oz )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17335,2,1,'steak ( yield from 232.8 g raw meat )',179,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17336,1,1,'serving ( 3 oz )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17336,2,1,'steak',180,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17337,1,1,'serving ( 3 oz )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17337,2,1,'steak',489,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17338,1,1,'patty ( yield from 102.2 g raw meat )',102,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17339,1,1,'patty ( yield from 104.1 g raw meat )',95,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17339,2,1,'serving ( 3 oz )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17340,1,1,'steak ( yield from 148.1 g raw meat )',114,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17340,2,1,'serving ( 3 oz )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17341,1,1,'serving ( 3 oz )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17341,2,1,'steak ( yield from 233.1 g raw meat )',176,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17342,1,1,'steak ( yield from 123.5 g raw meat )',92,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17342,2,1,'serving ( 3 oz )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17343,1,1,'patty (cooked from 4 oz raw)',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17343,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17344,1,1,'patty',93,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17344,2,1,'serving ( 3 oz )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17345,1,1,'steak',54,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17345,2,1,'serving ( 3 oz )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17346,1,1,'serving ( 3 oz )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17346,2,1,'roast (3 to 5 lb roast)',293,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17347,1,1,'serving ( 3 oz )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17347,2,1,'roast ( yield from 271.8 g raw meat ) (0.5 to 1 lb roast)',202,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17348,1,1,'steak ( yield from 134.9 g raw meat )',102,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17348,2,1,'serving ( 3 oz )',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17349,1,4,'oz',113,'g',1,'2013-02-22','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17349,2,1,'roast with bone',235,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17350,1,4,'oz',113,'g',1,'2013-02-22','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17350,2,1,'roast with bone',235,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17351,1,4,'oz',113,'g',1,'2013-02-22','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17351,2,1,'roast with bone',330,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17352,1,3,'oz',85,'g',1,'2013-02-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (17352,2,1,'roast with bone',330,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (17353,1,1,'serving (4 oz)',113,'g',1,'2013-02-22','2013-02-22');
INSERT INTO `cndb_wght` VALUES (17354,1,3,'oz',85,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17357,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17358,1,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17359,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17360,1,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17361,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17362,1,3,'oz',85,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17363,1,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17364,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17365,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17366,1,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17367,1,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17368,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17369,1,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17370,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17371,1,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17372,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17373,1,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17374,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17375,1,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17376,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17377,1,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17378,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17379,1,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17380,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17381,1,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17382,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17383,1,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17384,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17385,1,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17386,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17387,1,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17388,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17389,1,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17390,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17391,1,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17392,1,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17393,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17394,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17395,1,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17396,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17397,1,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17398,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17399,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17400,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17401,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17402,1,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17403,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17404,1,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17405,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17406,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17407,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17408,1,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17409,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17410,1,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17411,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17412,1,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17413,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17414,1,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17415,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17416,1,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17417,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17418,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17419,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17420,1,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17421,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17422,1,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17423,1,4,'oz',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17424,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17425,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17425,2,1,'cutlet',44,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17426,1,4,'oz',113,'g',1,'2015-01-06','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17426,2,1,'cutlet',55,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17426,3,1,'serving',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17427,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17427,2,1,'chop',153,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17428,1,4,'oz',113,'g',1,'2015-01-06','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17428,2,1,'serving',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17428,3,1,'shank whole',1270,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17429,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17429,2,1,'shank cross cut',187,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17430,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17430,2,1,'chop',352,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17431,1,4,'oz',113,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17432,1,3,'oz',85,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17433,1,4,'oz',113,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17434,1,3,'oz',85,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17435,1,4,'oz',113,'g',1,'2015-01-06','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17435,2,1,'serving',113,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17435,3,1,'shank whole',1270,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17436,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17436,2,1,'shank cross cut',187,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17437,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17437,2,1,'chop',153,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17438,1,3,'oz',85,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17438,2,1,'chop',352,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (17439,1,3,'oz',85,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17439,2,1,'leg bottom, boneless',723,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17440,1,3,'oz',85,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17440,2,1,'leg hindshank, heel on',418,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17441,1,4,'oz',113,'g',1,'2016-02-06','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17441,2,1,'leg hindshank, heel on',530,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17442,1,3,'oz',85,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17442,2,1,'roast',121,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17443,1,4,'oz',113,'g',1,'2016-02-06','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17443,2,1,'roast',146,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17444,1,4,'oz',113,'g',1,'2016-02-06','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17444,2,1,'leg bottom, boneless',989,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17445,1,3,'oz',85,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17445,2,1,'leg trotter off',1808,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17446,1,4,'oz',113,'g',1,'2016-02-06','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17446,2,1,'leg trotter off',2674,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17447,1,3,'oz',85,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17447,2,1,'roast',329,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17448,1,3,'oz',85,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17448,2,1,'roast',447,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17449,1,3,'oz',85,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17450,1,4,'oz',113,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17452,1,4,'oz',113,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17453,1,3,'oz',85,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17453,2,1,'leg bottom, boneless',723,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17454,1,4,'oz',113,'g',1,'2016-02-06','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17454,2,1,'leg bottom, boneless',989,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17455,1,3,'oz',85,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17455,2,1,'leg hindshank, heel on',418,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17456,1,4,'oz',113,'g',1,'2016-02-06','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17456,2,1,'leg hindshank, heel on',530,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17457,1,3,'oz',85,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17457,2,1,'leg trotter off',1808,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17458,1,4,'oz',113,'g',1,'2016-02-06','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17458,2,1,'leg trotter off',2674,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17459,1,3,'oz',85,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17459,2,1,'roast',121,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17460,1,4,'oz',113,'g',1,'2016-02-06','2019-02-13');
INSERT INTO `cndb_wght` VALUES (17460,2,1,'roast',146,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17461,1,3,'oz',85,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17461,2,1,'chop',43,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17462,1,3,'oz',85,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17462,2,1,'roast',329,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17463,1,3,'oz',85,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17463,2,1,'roast',447,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17464,1,3,'oz',85,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (17464,2,1,'chop',43,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (18001,1,1,'bagel',99,'g',1,'1997-08-29','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18001,2,1,'mini bagel (2-1/2" dia)',26,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18001,3,1,'small bagel (3" dia)',69,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18001,4,1,'medium bagel (3-1/2" to 4" dia)',105,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18001,5,1,'large bagel (4-1/2")',131,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18001,6,1,'oz',28.35,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (18002,1,1,'mini bagel (2-1/2" dia)',24,'g',1,'1997-08-29','2010-03-24');
INSERT INTO `cndb_wght` VALUES (18002,2,1,'small bagel (3" dia)',65,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18002,3,1,'medium bagel (3-1/2" to 4" dia)',99,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18002,4,1,'large bagel (4-1/2")',123,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18002,5,1,'OZ',28.35,'g',1,'2002-09-06','2010-01-04');
INSERT INTO `cndb_wght` VALUES (18003,1,1,'oz',28.35,'g',1,'1997-08-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18003,2,1,'mini bagel (2-1/2" dia)',26,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18003,3,1,'small bagel (3" dia)',69,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18003,4,1,'medium bagel (3-1/2" to 4" dia)',105,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18003,5,1,'large bagel (4-1/2" dia)',131,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18005,1,1,'mini bagel (2-1/2" dia)',26,'g',1,'1997-08-29','2010-03-24');
INSERT INTO `cndb_wght` VALUES (18005,2,1,'small bagel (3" dia)',69,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18005,3,1,'medium bagel (3-1/2" to 4" dia)',105,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18005,4,1,'large bagel (4-1/2" dia)',131,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18005,5,1,'OZ',28.35,'g',1,'2002-09-06','2010-01-04');
INSERT INTO `cndb_wght` VALUES (18006,1,1,'mini bagel (2-1/2" dia)',24,'g',1,'1997-08-29','2010-03-24');
INSERT INTO `cndb_wght` VALUES (18006,2,1,'small bagel (3-1/2" to 4"dia)',65,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18006,3,1,'medium bagel (4" dia)',99,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18006,4,1,'large bagel (4-1/2" dia)',123,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18006,5,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18007,1,1,'mini bagel (2-1/2" dia)',26,'g',1,'1997-08-29','2010-03-24');
INSERT INTO `cndb_wght` VALUES (18007,2,1,'small bagel (3" dia)',69,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18007,3,1,'medium bagel (3-1/2" to 4" dia)',105,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18007,4,1,'large bagel (4-1/2" dia)',131,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18007,5,1,'OZ',28.35,'g',1,'2002-09-06','2010-01-04');
INSERT INTO `cndb_wght` VALUES (18009,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18009,2,1,'large',77,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18009,3,1,'medium',51,'g',1,'1998-01-15','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18009,4,1,'small',35,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18009,5,1,'biscuit (2-1/2" dia)',35,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18010,1,1,'cup, purchased',120,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18010,2,1,'cup, homemade',114,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18010,3,1,'cup, poured from box',128,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18010,4,1,'cup, spooned into cup',120,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18010,5,0.33,'cup (NLEA serving size)',40,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18010,6,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18011,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18012,1,1,'serving 1 biscuit',58,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18012,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18013,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18013,2,1,'biscuit (2-1/4" dia)',21,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18014,1,1,'biscuit',58,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18014,2,1,'biscuit',43,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18014,3,1,'package',398,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18014,4,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18015,1,1,'biscuit',51,'g',1,'1997-08-29','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18015,2,1,'biscuit (2-1/2" dia)',27,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18015,3,1,'oz',28.35,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (18016,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18016,2,1,'biscuit (4" dia)',101,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18016,3,1,'small (1-1/2" dia)',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18016,4,1,'biscuit (2-1/2" dia)',60,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18017,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18017,2,1,'biscuit (2-1/2" dia)',44,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18019,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18019,2,1,'individual loaf (include Keebler Elfin Loaves)',57,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18019,3,1,'slice',60,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18021,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18021,2,1,'slice',45,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18022,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18022,2,1,'package (8.5 oz)',241,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18023,1,1,'muffin',51,'g',1,'1994-01-31','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18023,2,1,'piece',60,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18023,3,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18024,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18024,2,1,'piece',65,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18025,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18025,2,1,'cubic inch',3.2,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18025,3,1,'slice, large or thick',30,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18025,4,1,'slice, regular',25,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18025,5,1,'slice regular, crust not eaten',12.2,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18025,6,1,'slice',25,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18025,7,1,'slice, thin',20,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18025,8,1,'slice thin, crust not eaten',9.4,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18027,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18027,2,1,'slice (5" x 3" x 1/2")',40,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18028,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18028,2,1,'slice (5" x 3" x 1/2")',37,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18029,1,1,'oz',28.35,'g',1,'1997-08-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18029,2,1,'slice',139,'g',1,'1994-09-29','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18030,1,1,'oz',28.35,'g',1,'1997-08-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18030,2,1,'slice, small',29,'g',1,'1994-09-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18030,3,1,'slice, medium',59,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18030,4,1,'slice, large',88,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18032,1,1,'oz',28.35,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18033,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18033,2,1,'slice',29,'g',1,'1994-09-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (18036,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18036,2,1,'slice regular',24,'g',1,'1994-01-31','2009-02-11');
INSERT INTO `cndb_wght` VALUES (18036,3,1,'slice large',38,'g',1,'2002-09-06','2009-02-11');
INSERT INTO `cndb_wght` VALUES (18037,1,1,'oz',28.35,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18037,2,1,'slice',30,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18038,1,1,'oz',28.35,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18038,2,1,'slice',27,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18039,1,1,'oz',28.35,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18039,2,1,'slice',27,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18040,1,1,'oz',28.35,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18040,2,1,'slice',25,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18041,1,1,'pita, large (6-1/2" dia)',60,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18041,2,1,'pita, small  (4" dia)',28,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18042,1,1,'pita, large (6-1/2" dia)',64,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18042,2,1,'pita, small  (4" dia)',28,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18043,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18043,2,1,'slice',19,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18044,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18044,2,1,'slice, regular',26,'g',1,'1994-10-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18044,3,1,'slice, snack-size',7,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18044,4,1,'slice, thin',20,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18044,5,1,'slice (5" x 4" x 3/8")',32,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18047,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18047,2,1,'slice, large',32,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18047,3,1,'slice',26,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18047,4,1,'slice, thin',23,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18048,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18048,2,1,'slice, large',29,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18048,3,1,'slice',24,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18048,4,1,'slice, thin',21,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18049,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18049,2,1,'slice',23,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18050,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18050,2,1,'slice',19,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18051,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18051,2,1,'slice',23,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18053,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18053,2,1,'slice',23,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18053,3,1,'slice, thick',32,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18053,4,1,'slice, thin',20,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18055,1,1,'oz',28.35,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18055,2,1,'slice',21,'g',1,'1998-01-15','2012-03-02');
INSERT INTO `cndb_wght` VALUES (18057,1,1,'oz',28.35,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18057,2,1,'slice',23,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18059,1,1,'oz',28.35,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18059,2,1,'slice',27,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18060,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18060,2,1,'slice, regular',32,'g',1,'1994-09-29','2010-03-24');
INSERT INTO `cndb_wght` VALUES (18060,3,1,'slice, snack-size',7,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18060,4,1,'slice, thin',25,'g',1,'2002-09-06','2010-03-24');
INSERT INTO `cndb_wght` VALUES (18061,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18061,2,1,'slice, large',29,'g',1,'1994-10-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18061,3,1,'slice, regular',24,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18061,4,1,'slice, thin',18,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18064,1,1,'slice',29,'g',1,'1994-01-31','2019-02-13');
INSERT INTO `cndb_wght` VALUES (18065,1,1,'oz',28.35,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18065,2,1,'slice',24,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18069,1,1,'slice',29,'g',1,'1997-08-29','2015-06-19');
INSERT INTO `cndb_wght` VALUES (18069,2,1,'oz',28.35,'g',1,'1994-01-31','2012-03-02');
INSERT INTO `cndb_wght` VALUES (18069,3,1,'cup, crumbs',45,'g',1,'2002-09-06','2012-03-02');
INSERT INTO `cndb_wght` VALUES (18069,4,1,'cup, cubes',35,'g',1,'2002-09-06','2012-03-02');
INSERT INTO `cndb_wght` VALUES (18069,5,1,'slice, large',30,'g',1,'2002-09-06','2012-03-02');
INSERT INTO `cndb_wght` VALUES (18069,6,1,'slice',25,'g',1,'2002-09-06','2012-03-02');
INSERT INTO `cndb_wght` VALUES (18069,7,1,'slice crust not eaten',12,'g',1,'2002-09-06','2012-03-02');
INSERT INTO `cndb_wght` VALUES (18069,8,1,'slice, thin',20,'g',1,'2002-09-06','2012-03-02');
INSERT INTO `cndb_wght` VALUES (18069,9,1,'slice thin, crust not eaten',9,'g',1,'2002-09-06','2012-03-02');
INSERT INTO `cndb_wght` VALUES (18069,10,1,'slice, very thin',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18070,1,1,'oz',28.35,'g',1,'1997-08-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18070,2,1,'cup, crumbs',45,'g',1,'1994-09-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18070,3,1,'cup, cubes',42,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18070,4,1,'slice, large',27,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18070,5,1,'slice crust not eaten',11,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18070,6,1,'slice, thin',17,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18070,7,1,'slice thin, crust not eaten',8,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18070,8,1,'slice, very thin',13,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18070,9,1,'slice',22,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18071,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18071,2,1,'slice',44,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18073,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18073,2,1,'slice',42,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18073,3,1,'slice, thin (3-3/4" x 5" x 3/8")',33,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18075,1,1,'slice',32,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18075,2,1,'oz',28.35,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18076,1,1,'oz',28.35,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18076,2,1,'slice',25,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18077,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18077,2,1,'slice, regular (4" x 5" x 3/4")',46,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18077,3,1,'slice, thin (3-3/4" x 5" x 3/8")',33,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18078,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18078,2,1,'slice',42,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18078,3,1,'slice, thin (3-3/4" x 5" x 3/8")',30,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18079,1,1,'oz',28.35,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18079,2,1,'cup',108,'g',1,'1997-08-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18080,1,1,'cup, small pieces',46,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18080,2,1,'stick, small (approx 4-1/4" long)',5,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18080,3,1,'stick (7-5/8" x 5/8")',10,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18080,4,1,'stick (9-1/4" x 3/8")',6,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18081,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18081,2,1,'package (6 oz)',170,'g',1,'1994-11-17','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18082,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18082,2,0.5,'cup',100,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (18084,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18084,2,1,'package (6 oz)',170,'g',1,'1994-11-17','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18085,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18085,2,0.5,'cup',100,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (18086,1,1,'piece (1/12 of 12 oz cake)',28,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18086,2,1,'cake (9" dia x 4")',340,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18088,1,1,'piece (1/12 of 10" dia)',50,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18088,2,1,'tube cake (10" dia, 4-3/8" high)',596,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18090,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18090,2,1,'piece (1/6 of pie)',92,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18092,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18092,2,1,'package (18 oz)',510,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18095,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18095,2,1,'piece (1/8 cake)',71,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18096,1,1,'piece (1/12 of a cake)',138,'g',1,'1997-08-29','2012-03-02');
INSERT INTO `cndb_wght` VALUES (18096,2,1,'cake',1660,'g',1,'1994-01-31','2012-03-02');
INSERT INTO `cndb_wght` VALUES (18096,3,1,'piece (1/8 of 18 oz cake)',64,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18096,4,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18097,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18097,2,1,'package (18.25 oz)',517,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18101,1,1,'piece (1/12 of 9" dia)',95,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18101,2,1,'cake, 2-layer (8" or 9" dia)',1137,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18102,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18102,2,1,'piece (1/12 of 9" dia)',112,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18103,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18103,2,1,'piece (1/6 of 16 oz cake)',76,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18104,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18104,2,1,'individual cake',57,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18104,3,1,'piece (1/9 of 20 oz cake)',63,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18105,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18105,2,1,'piece (1/6 of 19 oz cake)',90,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18106,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18106,2,1,'piece (1/8 cake)',50,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18108,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18108,2,1,'piece (1/8 of 8" x 5-3/4" cake)',56,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18110,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18110,2,1,'piece',43,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18114,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18114,2,1,'package (14.5 oz)',411,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18116,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18116,2,1,'piece (1/9 of 8" square)',74,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18119,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18119,2,1,'piece (1/9 of 8" square)',115,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18120,1,0.167,'loaf 1/6 of the loaf',61,'g',1,'1997-08-29','2016-03-09');
INSERT INTO `cndb_wght` VALUES (18120,2,1,'piece individually wrapped cake',49,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18121,1,1,'piece (1/10 of 10.6 oz cake)',30,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18121,2,1,'piece (1/12 of 12 oz cake)',28,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18121,3,1,'snack cake (2.5 oz)',71,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18126,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18127,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18127,2,1,'cupcake',50,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18128,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18128,2,1,'cake',42,'g',1,'1994-01-31','2009-02-11');
INSERT INTO `cndb_wght` VALUES (18131,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18131,2,1,'package (8 oz)',227,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18133,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18133,2,1,'piece (1/12 of 16 oz cake)',38,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18134,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18134,2,1,'piece (1/12 of 10 inch cake)',63,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18135,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18135,2,1,'package (18.50 oz)',524,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18139,1,1,'piece (1/12 of 9" dia)',74,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18139,2,1,'cake, 2-layer (8" or 9" dia)',887,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18140,1,1,'piece (1/12 of a cake)',144,'g',1,'1997-08-29','2012-03-02');
INSERT INTO `cndb_wght` VALUES (18140,2,1,'cake',1729,'g',1,'1994-01-31','2012-03-02');
INSERT INTO `cndb_wght` VALUES (18140,3,1,'piece (1/8 of 18 oz cake)',64,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18140,4,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18141,1,1,'serving',67,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18141,2,1,'oz',28.35,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18142,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18142,2,1,'package (18.50 oz)',524,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18144,1,1,'serving',43,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18144,2,1,'package (18.50 oz)',524,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18144,3,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18146,1,1,'piece (1/12 of 8" dia)',68,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18146,2,1,'cake, 2-layer (8" dia)',817,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18147,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18147,2,1,'piece (1/6 of 17 oz cake)',80,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18147,3,1,'piece (1 NLEA serving)',125,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18148,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18148,2,1,'piece (1/12 of 9" dia)',99,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18151,1,1,'oz',28.35,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18151,2,1,'square, large (2-3/4" sq x 7/8")',56,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18151,3,1,'package, Little Debbie (twin wrapped)',61,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18152,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18152,2,1,'package (21.5 oz)',610,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18154,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18154,2,1,'brownie (2" square)',24,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18155,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18155,2,1,'cookie',5,'g',1,'1994-10-20','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18156,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18156,2,1,'cookie',21,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18157,1,1,'oz',28.35,'g',1,'1997-08-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18157,2,1,'cup, crumbs',112,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18157,3,1,'wafer',6,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18158,1,1,'serving 3 cookies',34,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18158,2,1,'oz',28.35,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18159,1,1,'cookie',12.9,'g',1,'1998-01-15','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18159,2,1,'cookie Pepperidge Farm Chocolate Chunk Pecan',12,'g',1,'1997-08-29','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18159,3,1,'oz',28.35,'g',1,'1994-09-29','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18159,4,1,'cookie (average weight of 1 cookie, variety of brands)',12.2,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18159,6,1,'cookie, big (3-1/2" - 4" dia) (include Grandma brand)',40,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18159,7,1,'cookie, medium (2-1/4" dia)',10,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18159,8,1,'cookie, large (include Keebler Rich ''n Chips, Pecan Chips Delux)',14,'g',1,'2013-12-23','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18159,9,1,'cookie, bite size (include Mini Chips Ahoy!)',2.2,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (18160,1,1,'cookie',14.2,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18160,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18160,3,1,'cookie',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18160,4,1,'cookie (average weight of 1 cookie)',12.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18161,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18161,2,1,'package (17.5 oz)',496,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18163,1,1,'serving',33,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18163,2,1,'portion, dough spoon from roll',29,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18163,3,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18164,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18164,2,1,'cookie, medium (2-1/4" dia)',12,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18165,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18165,2,1,'bar (2" square)',32,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18165,3,1,'cookie, medium (2-1/4" dia)',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18166,1,3,'cookie',36,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18166,2,1,'oz',28.35,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18167,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18167,2,1,'cookie',17,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18168,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18168,2,1,'cookie',13,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18170,1,1,'oz',28.35,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18170,2,1,'Figaroo (2 square halves)',43,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18170,3,1,'cookie',16,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18170,4,1,'individual package (2 oz package containing 2 3" bars)',57,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18171,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18171,2,1,'cookie',8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18172,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18172,2,1,'cookie',7,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18172,3,1,'large (approx 3-1/2" to 4" dia)',32,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18173,1,1,'oz',28.35,'g',1,'1997-08-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18173,2,1,'cracker',15,'g',1,'1994-09-29','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18173,3,1,'cup, crushed',84,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18173,4,1,'large rectangular piece or 2 squares or 4 small rectangular pieces',14,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18174,1,3,'pieces',27,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18174,2,1,'oz',28.35,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18175,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18175,2,1,'anisette sponge (4" x 1-1/8" x 7/8")',13,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18175,3,1,'breakfast treat (approx 4" x 2" x 7/8")',24,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18175,4,1,'ladyfinger',11,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18176,1,1,'oz',28.35,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18176,2,1,'Fudge Marshmallow',28,'g',1,'1997-08-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (18176,3,1,'pie, marshmallow (3" dia x 3/4")',39,'g',1,'1995-06-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18176,4,1,'cookie, small (1-3/4" dia x 3/4")',13,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18177,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18177,2,1,'large (3-1/2" to 4" dia) (include Archway brand)',32,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18177,3,1,'medium',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18177,4,1,'cookie, Little Debbie',20,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18178,1,1,'oz',28.35,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18178,2,1,'cookie, big (3-1/2" - 4" dia) (include Archway brand, Grandma brand)',25,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18178,3,1,'large',18,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18179,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18179,2,1,'cookie',15,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18180,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18180,2,1,'package (17.5 oz)',496,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18182,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18182,2,1,'portion, dough for 1 cookie',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18183,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18183,2,1,'cookie',12,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18184,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18184,2,1,'cookie',24,'g',1,'2013-12-23','2019-02-13');
INSERT INTO `cndb_wght` VALUES (18185,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18185,2,1,'cookie',31,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18186,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18186,2,1,'cookie',15,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18187,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18187,2,1,'portion, dough for 1 cookie',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18188,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18188,2,1,'cookie',12,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18189,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18189,2,1,'cookie (3" dia)',20,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18190,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18190,2,1,'cookie',14,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18191,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18191,2,1,'cookie',15,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18192,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18192,2,1,'cookie',11.8,'g',1,'1994-09-29','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18193,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18193,2,1,'cookie (2" dia)',14,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18196,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18196,2,1,'package (8.5 oz)',241,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18198,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18198,2,1,'cookie, medium (1-5/8" dia)',7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18199,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18199,2,1,'cookie',10,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18200,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18200,2,1,'cookie, medium (1-5/8" dia)',7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18201,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18201,2,1,'cookie',10,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18202,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18202,2,1,'wafer',4,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18204,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18204,2,1,'cookie',17,'g',1,'1994-01-31','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18205,1,1,'serving',33,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18205,2,1,'cookie dough for 1rolled cookie',17,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18205,3,1,'cookie 1 pre-sliced cookie dough',26,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18205,4,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18206,1,1,'oz',28.35,'g',1,'1997-08-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18206,2,1,'cookie 1 rolled cookie dough',15,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18206,3,1,'cookie 1 pre-sliced cookie dough',23,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18209,1,3,'cookies',36,'g',1,'1997-08-29','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18209,2,1,'cookie',10.1,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18209,3,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18210,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18210,2,1,'cookie, oval (3-1/8" x 1-1/4" x 3/8")',15,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18210,3,1,'cookie, round (1-3/4" dia)',10,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18211,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18211,2,1,'sheet',245,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18211,3,1,'shell',40,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18212,1,1,'oz',28.35,'g',1,'1997-08-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18212,2,1,'cup, crumbs',80,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18212,3,1,'large',6,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18212,4,1,'medium',4,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18212,5,1,'small',3,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18213,1,8,'wafers',30,'g',1,'1997-08-29','2016-02-06');
INSERT INTO `cndb_wght` VALUES (18213,2,8,'wafers mini wafers',11.6,'g',1,'1994-01-31','2016-02-06');
INSERT INTO `cndb_wght` VALUES (18214,1,0.5,'oz',14.2,'g',1,'1998-01-15','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18214,2,1,'cup, bite size',62,'g',1,'1995-06-19','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18214,3,1,'cup, crushed',72,'g',1,'1999-03-22','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18214,4,1,'gold fish',0.6,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18214,5,1,'bag, single serving',28,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18214,6,1,'snack stick',2,'g',1,'2002-09-06','2012-03-02');
INSERT INTO `cndb_wght` VALUES (18214,7,1,'cracker (1" square)',1,'g',1,'2002-09-06','2012-03-02');
INSERT INTO `cndb_wght` VALUES (18215,1,0.5,'oz',14.2,'g',1,'1994-10-20','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18215,2,1,'cup, crushed',83,'g',1,'1998-01-15','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18215,3,6,'cracker',39,'g',1,'1997-08-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18215,4,1,'sandwich',6.5,'g',1,'2004-07-15','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18216,1,0.5,'oz',14.2,'g',1,'1994-09-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18216,2,1,'cup, crushed',55,'g',1,'1999-03-22','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18216,3,1,'crispbread',10,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18216,4,1,'wafer, thin',2,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18216,5,1,'wafer',10,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18216,6,1,'cracker, Norwegian flatbread (4-3/4" x 2-3/4" x 1/16")',5.8,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18216,7,1,'wafer, Rye Krisp (triple cracker)',25,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18216,8,1,'crispbread, Wasa rye',10,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18217,1,0.5,'oz',14.2,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18217,2,1,'matzo',28,'g',1,'1997-08-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18218,1,0.5,'oz',14.2,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18218,2,1,'matzo',28,'g',1,'1997-08-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18219,1,0.5,'oz',14.2,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18219,2,1,'matzo',28,'g',1,'1997-08-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18220,1,0.5,'oz',14.2,'g',1,'1994-09-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18220,2,1,'cup pieces',30,'g',1,'1997-08-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18220,3,1,'cup, rounds',33,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18220,4,1,'melba round',3,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18220,5,1,'piece (3-3/4" x 1-3/4" x 1/8")',5,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18221,1,0.5,'oz',14.2,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18221,2,1,'toast',5,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18222,1,0.5,'oz',14.2,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18222,2,1,'toast',5,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18223,1,0.5,'oz',14.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18223,2,1,'cracker',11,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18224,1,0.5,'oz',14.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18224,2,1,'rusk',10,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18225,1,0.5,'oz',14.2,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18225,2,1,'cracker, sandwich',7,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18226,1,0.5,'oz',14.2,'g',1,'1994-10-20','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18226,2,1,'cup, crushed',61,'g',1,'1997-08-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18226,3,1,'cracker (4-1/2" x 2-1/2" x 1/8")',11,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18226,4,1,'cracker, triple',25,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18227,1,0.5,'oz',14.2,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18227,2,1,'cracker, triple',22,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18228,1,5,'crackers',14.9,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18228,2,0.5,'oz',14.2,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18228,3,1,'cup, crushed',70,'g',1,'1998-01-15','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18228,4,5,'crackers square (1 serving)',15,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18228,5,1,'cracker square',3,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18228,6,1,'cracker, round large',10,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18228,7,1,'cracker, oyster',1,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18228,8,1,'cracker, rectangle',6,'g',1,'2011-01-18','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18228,9,1,'cup oyster crackers',45,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18229,1,5,'crackers',16,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18229,2,5,'crackers, regular size, round (1 serving)',16,'g',1,'1998-01-15','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18229,3,1,'cracker, round',3.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18229,4,1,'cracker, rectangular',4,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18229,5,1,'cup crushed',52,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18230,1,0.5,'oz',14.2,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18230,2,1,'cracker, sandwich',7,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18231,1,0.5,'oz',14.2,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18231,2,1,'cracker, sandwich',7,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18232,1,16,'crackers 1 serving',34,'g',1,'1998-01-15','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18232,2,2,'crackers 1 serving',14.5,'g',1,'2011-01-18','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18233,1,0.5,'oz',14.2,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18233,2,1,'cracker, sandwich',7,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18234,1,0.5,'oz',14.2,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18234,2,1,'cracker, sandwich',7,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18235,1,1,'serving',28,'g',1,'1998-01-15','2010-03-24');
INSERT INTO `cndb_wght` VALUES (18235,2,6,'crackers, Triscuits, regular size',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18235,3,1,'cracker',4.6,'g',1,'1997-08-29','2010-03-24');
INSERT INTO `cndb_wght` VALUES (18235,4,0.5,'oz',14.2,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18235,5,1,'cup, crushed',94,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18235,6,10,'Triscuit Bits',10,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18236,1,1,'oz',28.35,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18236,2,1,'cup',115,'g',1,'1997-08-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18237,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18237,2,1,'eclair (5" x 2" x 1-3/4")',48,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18237,3,1,'cream puff shell',66,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18239,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18239,2,1,'croissant, mini',28,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18239,3,1,'croissant, small',42,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18239,4,1,'croissant, medium',57,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18239,5,1,'croissant, large',67,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18240,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18240,2,1,'croissant, medium',57,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18241,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18241,2,1,'croissant, small',42,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18241,3,1,'croissant, medium',57,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18241,4,1,'croissant, large',67,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18242,1,0.5,'oz',14.2,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18242,2,1,'cup',30,'g',1,'1997-08-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18243,1,0.5,'oz',14.2,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18243,2,1,'cup',40,'g',1,'1997-08-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18243,3,1,'package, fast food',10,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18243,4,4,'cubes',1,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18244,1,1,'oz',28.35,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18244,2,1,'large (approx 7" dia)',142,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18244,3,1,'small or frozen (approx 3" dia)',35,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18244,4,1,'pastry (4-1/4" dia)',65,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18244,5,1,'Toaster Strudel',53,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18244,6,1,'piece (1/8 of 15 oz ring)',53,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18245,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18245,2,1,'pastry',71,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18246,1,1,'oz',28.35,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18246,2,1,'large (approx 7" dia)',142,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18246,3,1,'small or frozen (approx 3" dia)',35,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18246,4,1,'pastry (4-1/4" dia)',71,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18246,5,1,'Toaster Strudel',53,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18246,6,1,'piece (1/8 of 15 oz ring)',53,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18248,1,1,'donut',40,'g',1,'1997-08-29','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18248,2,1,'oz',28.35,'g',1,'1994-09-29','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18248,3,1,'doughnut stick',52,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18248,4,1,'doughnut, long type (twist) (4-1/2" long)',52,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18248,5,1,'doughnut medium (3-1/4" dia)',54,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18248,6,1,'doughnut, mini (1-1/2" dia) or doughnut hole',14,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18248,7,1,'doughnut, large (4" dia)',71,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (18249,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18249,2,1,'donettes (2" dia)',18,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18249,3,1,'doughnut, medium (approx 3" dia)',43,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18249,4,1,'doughnut large (approx 3-1/2" dia)',67,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18250,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18250,2,1,'doughnut, medium (approx 3" dia)',45,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18251,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18251,2,1,'doughnut (3-3/4" dia)',60,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18251,3,1,'doughnut, medium (approx 3" dia)',42,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18253,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18253,2,1,'cruller (3" dia)',41,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18254,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18254,2,1,'doughnut oval (3-1/2" x 2-1/2")',85,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18255,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18255,2,1,'doughnut hole',13,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18255,3,1,'doughnut stick',56,'g',1,'1995-06-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18255,4,1,'extra large (approx 5" dia)',122,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18255,5,1,'jumbo (approx 6" dia)',157,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18255,6,1,'doughnut, large (approx 4-1/4" dia)',75,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18255,7,1,'doughnut, long type (twist) approx 5-1/4" x 2-1/2" x 1-1/2" high)',90,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18255,8,1,'doughnut medium (approx 3-3/4" dia)',64,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18255,9,1,'doughnut, small (approx 3" dia)',31,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18255,10,1,'doughnut (approx 1-1/2 oz)',42,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18255,11,1,'doughnut (3-3/4" dia)',60,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18255,12,1,'honeybun (4" x 3")',65,'g',1,'2007-11-28','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18255,13,1,'honeybun (4-1/2" x 3-1/2")',78,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18255,14,1,'honeybun (5" x 3-1/2")',85,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18255,15,1,'doughnut, medium (approx 3-3/4" dia)',60,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18255,16,1,'doughnut',63,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18256,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18256,2,1,'doughnut oval (3-1/2" x 2-1/2")',85,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18258,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18258,2,1,'muffin',57,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18259,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18259,2,1,'muffin',52,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18260,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18260,2,1,'muffin',66,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18262,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18262,2,1,'muffin',57,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18263,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18263,2,1,'muffin',52,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18264,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18264,2,1,'muffin',57,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18266,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18266,2,1,'muffin',66,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18268,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18268,2,1,'piece',59,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18269,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18269,2,1,'slice',65,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18270,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18270,2,1,'cup',152,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18270,3,1,'hush puppy',22,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18271,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18271,2,1,'cone',4,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18271,3,1,'large waffle cone',29,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18272,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18272,2,1,'cone',10,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18273,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18273,2,1,'muffin',57,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18274,1,1,'oz',28.35,'g',1,'1997-08-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18274,2,1,'mini (1-1/4" dia)',17,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18274,3,1,'small (2-3/4" dia x 2")',66,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18274,4,1,'medium',113,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18274,5,1,'large (3-1/4" dia x 2-3/4")',139,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18274,6,1,'extra large',168,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18274,7,1,'muffin',31,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18275,1,1,'serving',43,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18275,2,1,'package, mix + drained berries',356,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18275,3,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18277,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18277,2,1,'muffin, toaster',33,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18278,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18278,2,1,'muffin',57,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18279,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18279,2,1,'mini',17,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18279,3,1,'small',66,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18279,4,1,'medium',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18279,5,1,'large',139,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18279,6,1,'extra large',168,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18280,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18281,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18281,2,1,'muffin, toaster',33,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18282,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18282,2,1,'muffin (2-3/4" dia x 2")',57,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18283,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18283,2,1,'mini',17,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18283,3,1,'small',66,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18283,4,1,'medium',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18283,5,1,'large',139,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18283,6,1,'extra large',168,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18284,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18284,2,1,'package (7 oz)',198,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18288,1,1,'oz',28.35,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18288,2,1,'pancake',41,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18288,3,1,'pancake (6" dia)',73,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18288,4,1,'mini pancake',10.1,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18288,5,1,'pancake',40,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18289,1,0.333,'cup',52,'g',1,'2013-12-23','2016-03-09');
INSERT INTO `cndb_wght` VALUES (18289,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18289,3,1,'cup, poured from box',130,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18290,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18290,2,1,'pancake (4" dia)',38,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18290,3,1,'pancake (6" dia)',77,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18291,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18291,2,1,'cup, poured from box',112,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18292,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18292,2,1,'pancake (4" dia)',38,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18292,3,1,'pancake (6" dia)',77,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18293,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18293,2,1,'pancake (4" dia)',38,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18293,3,1,'pancake (6" dia)',77,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18294,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18294,2,1,'pancake (4" dia)',38,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18294,3,1,'pancake (6" dia)',77,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18295,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18295,2,1,'cup, poured from box',122,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18297,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18297,2,1,'package (8 oz)',227,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18299,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18299,2,1,'cup, poured from box',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18300,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18300,2,1,'pancake (4" dia)',44,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18300,3,1,'pancake (6" dia)',129,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18301,1,1,'oz',28.35,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18301,2,1,'piece (1/8 of 9" dia)',125,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18301,3,1,'piece (1/6 of 8" pie)',117,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18302,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18302,2,1,'piece (1/8 of 9" dia)',155,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18303,1,1,'oz',28.35,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18303,2,1,'piece (1/8 of 9" dia)',92,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18303,3,1,'piece (1/6 of 8" pie)',123,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18304,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18304,2,1,'pie (9" dia)',1186,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18304,3,1,'piece (1/8 of 9" dia)',144,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18305,1,1,'oz',28.35,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18305,2,1,'piece (1/8 of 9" dia)',125,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18305,3,1,'piece (1/6 of 8" pie)',117,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18306,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18306,2,1,'piece (1/8 of 9" dia)',147,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18308,1,1,'oz',28.35,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18308,2,1,'piece (1/8 of 9" dia)',125,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18308,3,1,'piece (1/6 of 8" pie)',117,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18309,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18309,2,1,'piece (1/8 of 9" dia)',180,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18310,1,1,'serving .167 pie',120,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18310,2,1,'oz',28.35,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18310,3,1,'piece (1/4 of 6" pie)',99,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18310,4,1,'piece (1/6 of 8" pie)',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18312,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18312,2,1,'piece (1/8 of 9" dia)',95,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18313,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18313,2,1,'piece (1/6 of 7" pie)',64,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18313,3,1,'piece (1/8 of 7" pie)',48,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18314,1,1,'oz',28.35,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18314,2,1,'piece (1/8 of 9" dia)',94,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18316,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18316,2,1,'piece (1/6 of 8" pie)',104,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18317,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18317,2,1,'piece (1/6 of 8" pie)',105,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18319,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18319,2,1,'pie (5" x 3-3/4")',128,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18320,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18320,2,1,'piece (1/6 of 8" pie)',113,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18321,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18321,2,1,'piece (1/8 of 9" dia)',127,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18322,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18322,2,1,'piece (1/8 of 9" dia)',165,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18323,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18323,2,1,'piece (1/6 of 8" pie)',117,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18324,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18324,2,1,'slice',133,'g',1,'1994-01-31','2009-02-11');
INSERT INTO `cndb_wght` VALUES (18324,3,1,'pie',833,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18325,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18325,2,1,'piece (1/8 of 9" dia)',122,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18326,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18326,2,1,'slice',133,'g',1,'1994-01-31','2009-02-11');
INSERT INTO `cndb_wght` VALUES (18326,3,1,'pie',995,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18327,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18327,2,1,'piece (1/8 of 9" dia)',155,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18328,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18328,2,1,'piece (1/8 of 9" dia)',126,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18332,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18332,2,1,'package (10 oz)',284,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18333,1,1,'piece (1/8 of 9" crust)',20,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18333,2,1,'crust, single 9"',160,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18334,1,1,'piece (1/8 of 9" crust)',18,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18334,2,1,'pie crust (average weight of 1 frozen crust)',173,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18335,1,1,'pie crust (average weight of 1 baked crust)',154,'g',1,'1994-01-31','2009-02-11');
INSERT INTO `cndb_wght` VALUES (18336,1,1,'piece (1/8 of 9" crust)',23,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18336,2,1,'crust, single 9"',180,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18337,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18337,2,1,'shell',47,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18338,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18338,2,1,'sheet dough',19,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18339,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18339,2,1,'package (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18342,1,1,'roll (1 oz)',28,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18342,2,1,'each (pan, dinner, or small roll) (2" square, 2" high)',25,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18342,3,1,'roll (hamburger, frankfurter, onion roll, bun, large roll)',43,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18342,4,1,'roll (foot long frankfurter roll)',86,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18344,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18344,2,1,'roll (2-1/2" dia)',35,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18345,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18345,2,1,'roll',33,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18346,1,1,'large (approx 3-1/2" to 4" dia)',43,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18346,2,1,'medium',36,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18346,3,1,'small (2-3/8" dia)',28,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18347,1,1,'roll (1 oz)',28,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18348,1,1,'roll (1 oz)',28,'g',1,'1994-09-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18348,2,1,'roll (hamburger, frankfurter roll)',43,'g',1,'1999-03-22','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18348,3,1,'roll, large submarine, hoagie',135,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18348,4,1,'medium (2-1/2" dia)',36,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18348,5,1,'roll medium submarine, hoagie',94,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18348,6,1,'roll (small submarine, hoagie roll)',65,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18349,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18349,2,1,'roll',38,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18350,1,1,'roll 1 serving',44,'g',1,'1997-08-29','2016-02-06');
INSERT INTO `cndb_wght` VALUES (18350,2,1,'oz',28.35,'g',1,'1994-01-31','2016-02-06');
INSERT INTO `cndb_wght` VALUES (18351,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18351,2,1,'roll',43,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18353,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18353,2,1,'roll (3-1/2" dia)',57,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18354,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18354,2,1,'piece',71,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18355,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18355,2,1,'roll',66,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18356,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18356,2,1,'large',83,'g',1,'1995-06-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18356,3,1,'roll (2-3/4" square)',60,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18357,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18357,2,1,'roll',30,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18358,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18358,2,1,'roll',30,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18360,1,1,'shell',12.9,'g',1,'1997-08-29','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18360,2,1,'taco',12.7,'g',1,'1994-09-29','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18360,3,1,'medium (approx 5" dia)',13.3,'g',1,'2002-09-06','2015-06-19');
INSERT INTO `cndb_wght` VALUES (18360,4,1,'large (6-1/2" dia)',21,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18360,5,1,'miniature (3" dia)',5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18360,6,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18362,1,1,'oz',28.35,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18362,2,1,'pastry',54,'g',1,'1997-08-29','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18363,1,1,'oz',28.35,'g',1,'1997-08-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18363,2,1,'enchilada',19,'g',1,'1994-09-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18363,3,1,'tortilla',24,'g',1,'1998-01-15','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18364,1,1,'tortilla',48,'g',1,'1997-08-29','2016-03-09');
INSERT INTO `cndb_wght` VALUES (18364,2,1,'oz',28.35,'g',1,'1994-01-31','2012-03-02');
INSERT INTO `cndb_wght` VALUES (18364,3,1,'tortilla medium (approx 6" dia)',30,'g',1,'2002-09-06','2012-03-02');
INSERT INTO `cndb_wght` VALUES (18364,4,1,'package',407,'g',1,'2002-09-06','2012-03-02');
INSERT INTO `cndb_wght` VALUES (18364,5,1,'tortilla (approx 10" dia)',72,'g',1,'2002-09-06','2012-03-02');
INSERT INTO `cndb_wght` VALUES (18364,6,1,'tortilla (approx 12" dia)',117,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18364,7,1,'tortilla (approx 7-8" dia)',49,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18365,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18365,2,1,'waffle, square (4" square) (include frozen)',35,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (18367,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18367,2,1,'waffle, round (7" dia)',75,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18368,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18368,2,1,'wrapper, eggroll (7" square)',32,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18368,3,1,'wrapper, wonton (3-1/2" square)',8,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18369,1,1,'tsp',4.6,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18369,2,0.5,'tsp',2.3,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (18370,1,1,'tsp',4.6,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18370,2,0.5,'tsp',2.3,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (18371,1,1,'tsp',5,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18371,2,0.5,'tsp',2.5,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (18372,1,1,'tsp',4.6,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18372,2,0.5,'tsp',2.3,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (18373,1,1,'tsp',3,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18373,2,0.5,'tsp',1.5,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (18374,1,1,'cake (0.6 oz)',17,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18375,1,1,'tsp',4,'g',1,'1999-03-22','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18375,2,1,'tbsp',12,'g',1,'1995-06-19','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18375,3,1,'packet',7.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18376,1,1,'oz',28.35,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18376,2,1,'cup',120,'g',1,'1997-08-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18377,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18377,2,1,'cookie (2-5/8" dia)',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18378,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18378,2,1,'cookie, medium (2-1/4" dia)',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18383,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18383,2,1,'slice',17,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18384,1,1,'oz',28.35,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18384,2,1,'slice',25,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18386,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18386,2,1,'muffin, toaster',31,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18388,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18388,2,1,'muffin, toaster',34,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18390,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18390,2,1,'pancake (4" dia)',38,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18390,3,1,'pancake (6" dia)',77,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18396,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18396,2,1,'large roll or bun (3-1/2" dia)',43,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18396,3,1,'roll (2-1/2" dia)',35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18399,1,1,'piece (1/8 of 9" crust)',30,'g',1,'1994-11-17','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18399,2,1,'crust, single 9"',244,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18400,1,0.5,'oz',14.2,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18400,2,1,'matzo',28,'g',1,'1997-08-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18401,1,1,'CUP',129,'g',1,'1994-11-02','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18401,2,1,'crust, single 9"',176,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18401,3,1,'piece (1/8 of 9" crust)',22,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18402,1,1,'piece (1/8 of 9" crust)',24,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18402,2,1,'crust, single 9"',194,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18403,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18403,2,1,'waffle, round (4" dia)',33,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18403,3,1,'waffle, square (4" square)',33,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18406,1,1,'oz',28.35,'g',1,'1997-08-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18406,2,1,'mini bagel (2-1/2" dia)',26,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18406,3,1,'small bagel (3" dia)',69,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18406,4,1,'medium bagel (3-1/2" to 4" dia)',105,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18406,5,1,'large bagel (4-1/2" dia)',131,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18407,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18407,2,1,'mini bagel (2-1/2" dia)',26,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18407,3,1,'small bagel (3" dia)',69,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18407,4,1,'medium bagel (3-1/2" to 4")',105,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18407,5,1,'large bagel (4-1/2" dia)',131,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18408,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18408,2,1,'mini bagel (2-1/2" dia)',26,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18408,3,1,'small bagel (3" dia)',69,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18408,4,1,'medium bagel (3-1/2" to 4" dia)',105,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18408,5,1,'large bagel (4-1/2" dia)',131,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18412,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18412,2,1,'package (8.5 oz)',241,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18413,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18413,2,1,'pita, large (6-1/2" dia)',60,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18414,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18414,2,1,'slice, large',32,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18414,3,1,'slice',26,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18414,4,1,'slice, thin',23,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18416,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18416,2,1,'cup, crumbs',45,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18416,3,1,'cup, cubes',35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18416,4,1,'slice, large',30,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18416,5,1,'slice',25,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18416,6,1,'slice, thin',20,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18417,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18417,2,1,'individual cake',57,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18417,3,1,'piece (1/9 of 20 oz cake)',63,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18418,1,1,'piece (1/10 of 10.6 oz cake)',30,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18418,2,1,'piece (1/12 of 12 oz cake)',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18418,3,1,'snack cake (2.5 oz)',71,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18419,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18419,2,1,'package (18.50 oz)',524,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18420,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18420,2,1,'package (18.50 oz)',524,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18421,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18421,2,1,'cookie',5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18422,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18422,2,1,'cookie, medium (2-1/4" dia)',10,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18422,3,1,'cookie, bite size (include Mini Chips Ahoy!)',2.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18423,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18423,2,1,'anisette sponge (4" x 1-1/8" x 7/8")',13,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18423,3,1,'breakfast treat (approx 4" x 2" x 7/8")',24,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18423,4,1,'ladyfinger',11,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18424,1,0.5,'oz',14.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18424,2,1,'cup, crushed',70,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18424,3,1,'cup pieces',30,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18424,4,1,'cup, rounds',33,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18424,5,1,'melba round',3,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18424,6,1,'piece (3-3/4" x 1-3/4" x 1/8")',5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18424,7,1,'toast',5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18425,1,0.5,'oz',14.2,'g',1,'1994-09-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18425,2,1,'cup oyster crackers',45,'g',1,'1997-08-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18425,3,1,'cracker',3,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18425,4,1,'cracker, round large',10,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18425,5,1,'cracker, oyster',1,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18425,6,1,'cracker, rectangle',6,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18426,1,0.5,'oz',14.2,'g',1,'1994-01-31','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18426,2,1,'cracker',3,'g',1,'1997-08-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18427,1,0.5,'oz',14.2,'g',1,'1994-09-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18427,2,1,'cup, bite size',62,'g',1,'1998-01-15','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18427,3,1,'cup, crushed',72,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18427,4,1,'cracker, rectangular',4,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18427,5,1,'cracker, oval',3,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18427,6,1,'cracker, round',3,'g',1,'2002-09-06','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18428,1,0.5,'oz',14.2,'g',1,'1997-08-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18428,2,1,'cup, crushed',83,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18428,3,1,'cracker',2,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18428,4,1,'cracker, thin square',2,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18429,1,0.5,'oz',14.2,'g',1,'1994-09-29','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18429,2,1,'cup, crushed',94,'g',1,'1998-01-15','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18429,3,1,'cracker',4,'g',1,'1999-03-22','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18429,4,1,'cracker, square',4,'g',1,'2002-09-06','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18429,5,10,'Triscuit Bits',10,'g',1,'2004-07-15','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18430,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18430,2,1,'large (approx 7" dia)',142,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18430,3,1,'small or frozen (approx 3" dia)',35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18430,4,1,'pastry (4-1/4" dia)',65,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18430,5,1,'Toaster Strudel',53,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18430,6,1,'piece (1/8 of 15 oz ring)',53,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18431,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18431,2,1,'container (3 oz)',142,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18431,3,1,'small or frozen (approx 3" dia)',35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18431,4,1,'pastry (4-1/4" dia)',71,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18431,5,1,'Toaster Strudel',53,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18431,6,1,'piece (1/8 of 15 oz ring)',53,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18432,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18432,2,1,'slice',23,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18433,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18433,2,1,'pastry',71,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18434,1,0.5,'oz',14.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18434,2,1,'cup Cheez-its',62,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18434,3,1,'cup, crushed',72,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18434,4,1,'gold fish',0.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18434,5,1,'cracker (1" square)',1,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18435,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18435,2,1,'pastry (4-1/4" dia)',71,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18436,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18436,2,1,'doughnut, medium (3-1/4" dia)',60,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18437,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18437,2,1,'muffin',57,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18438,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18438,2,1,'muffin',57,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18439,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18439,2,1,'muffin',57,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18443,1,1,'oz',28.35,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18443,2,1,'piece (1/8 of 9" dia)',125,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18443,3,1,'piece (1/6 of 8" pie)',117,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18444,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18444,2,1,'pie (5" x 3-3/4")',128,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18445,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18445,2,1,'pie (5" x 3-3/4")',128,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18446,1,1,'crust, single 9"',142,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18446,2,1,'piece (1/8 of 9" crust)',16,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18447,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18447,2,1,'package (6 oz)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18448,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18448,2,1,'medium (approx 5" dia)',13,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18448,3,1,'miniature (3" dia)',5,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18449,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18449,2,1,'tortilla, medium (approx 6" dia)',26,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18450,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18450,2,1,'tortilla, medium (approx 6" dia)',32,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18450,3,1,'tortilla (approx 10" dia)',72,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18450,4,1,'tortilla (approx 12" dia)',117,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18450,5,1,'tortilla (approx 7-8" dia)',49,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18451,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18451,2,1,'cake',340,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18453,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18453,2,1,'package (18.50 oz)',524,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18457,1,3,'saltines',15,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (18457,2,6,'saltines',30,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (18459,1,1,'tart',52,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18566,1,1,'muffin',31,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18927,1,6,'cracker 1 cracker = 6.5g',39,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18927,2,1,'sandwich',6.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18932,1,1,'waffle, square',39,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18932,2,1,'waffle, round',38,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18933,1,1,'oz',28,'g',1,'2006-02-23','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18933,2,1,'waffle round (4" dia)',33,'g',1,'2006-02-23','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18934,1,1,'waffle',35,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (18935,1,1,'waffle, round (4"dia)',32,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18936,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18936,2,1,'pancake',38,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18936,3,1,'serving (3 pancakes)',144,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18938,1,1,'piece',53,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18938,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18939,1,1,'pastry',51,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18940,1,1,'muffin small',71,'g',1,'2007-12-03','2007-12-03');
INSERT INTO `cndb_wght` VALUES (18940,2,1,'oz',28.35,'g',1,'2007-12-03','2007-12-03');
INSERT INTO `cndb_wght` VALUES (18942,1,1,'oz',28.35,'g',1,'2009-01-25','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18942,2,1,'crust',183,'g',1,'2009-01-25','2013-12-26');
INSERT INTO `cndb_wght` VALUES (18943,1,1,'crust',182,'g',1,'2009-01-25','2009-01-25');
INSERT INTO `cndb_wght` VALUES (18944,1,0.125,'pie 1 pie (1/8 of 9" pie)',131,'g',1,'2009-01-25','2009-01-25');
INSERT INTO `cndb_wght` VALUES (18944,2,1,'slice',137,'g',1,'2009-01-25','2009-01-25');
INSERT INTO `cndb_wght` VALUES (18944,3,1,'pie',1137,'g',1,'2009-01-25','2009-01-25');
INSERT INTO `cndb_wght` VALUES (18944,4,1,'oz',28.35,'g',1,'2009-01-25','2009-01-25');
INSERT INTO `cndb_wght` VALUES (18945,1,1,'pie crust (average weight)',225,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18946,1,1,'pie crust',198,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18947,1,1,'pie crust (average weight)',202,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18948,1,1,'pie crust (average weight)',229,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18949,1,1,'serving',29,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (18949,2,1,'cracker',4.2,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (18949,3,6,'Triscuits, regular size',29,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (18950,1,1,'serving',29,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (18950,2,1,'cracker',1.8,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (18950,3,16,'crackers, Wheat Thins',29,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (18951,1,2,'waffles',70,'g',1,'2010-01-04','2015-01-07');
INSERT INTO `cndb_wght` VALUES (18952,1,1,'piece',12.3,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18952,2,3,'pieces (mean serving weight, aggregated over brands)',37,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18953,1,1,'serving (approximate serving size)',55,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (18953,2,1,'cake square (average weight of whole item)',399,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (18954,1,1,'serving',55,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18954,2,1,'cake square',622,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18955,1,1,'slice (average weight of 1 slice)',63,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18959,1,1,'piece',86,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (18963,1,1,'slice presliced',43,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (18963,2,1,'slice',59,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (18964,1,1,'bun',65,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (18965,1,1,'serving',30,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (18966,1,1,'serving',14,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (18967,1,1,'slice',28,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (18968,1,1,'bagel',98,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (18969,1,4,'oz',113,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (18970,1,1,'tortilla',49,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (18970,2,1,'package',484,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (18971,1,1,'slice',32,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (18972,1,1,'slice',48,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (18973,1,1,'piece',57,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (19002,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19002,2,1,'piece, large',20,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19003,1,1,'oz',28,'g',1,'1999-03-22','2015-06-19');
INSERT INTO `cndb_wght` VALUES (19003,2,1,'oz',28.35,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (19003,3,1,'bag (7 oz)',198,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (19004,1,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19004,2,1,'bag (7 oz)',198,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19005,1,1,'oz',28.35,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19007,1,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19007,2,2,'oz',57,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (19008,1,1,'oz crunchy (about 21 pieces)',28.35,'g',1,'1999-03-22','2019-02-13');
INSERT INTO `cndb_wght` VALUES (19008,2,1,'oz puffs (about 13 pieces)',28.35,'g',1,'1994-09-29','2019-02-13');
INSERT INTO `cndb_wght` VALUES (19010,1,1,'bar (1 oz)',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19013,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19013,2,1,'package',27,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19013,3,1,'packet (.75 oz)',21,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19014,1,1,'large',21,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19014,2,1,'small',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19015,1,1,'bar',21,'g',1,'1994-01-31','2012-03-02');
INSERT INTO `cndb_wght` VALUES (19015,2,1,'bar (1 oz)',28,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19015,3,1,'bar',25,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19016,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19016,2,1,'bar',24,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19017,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19017,2,1,'bar',24,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19018,1,1,'cup',334,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (19018,2,0.25,'cup',84,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (19020,1,1,'bar (1 oz)',28,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19021,1,1,'bar (1 oz)',28,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19022,1,1,'bar (1.5 oz)',43,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19022,2,1,'bar (1 oz)',28,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19024,1,1,'bar (1.25 oz)',35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19024,2,1,'bar (1 oz)',28,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19025,1,1,'serving',40,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (19026,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19026,2,1,'bar',37,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19027,1,1,'bar (1 oz)',28,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19030,1,1,'serving',20,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (19031,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19031,2,2,'oz',57,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19034,1,1,'CUP',8,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19034,2,1,'oz',28.35,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19035,1,1,'CUP',11,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19035,2,1,'oz',28.35,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19036,1,1,'cake',10,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19036,2,2,'cakes',20,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19038,1,1,'oz (approx 2/3 cup)',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19038,2,2,'oz',57,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19039,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19040,1,1,'cup',11,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19040,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19041,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19041,2,0.5,'oz',14.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19042,1,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19042,2,1,'bag (7 oz)',198,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19043,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19043,2,1,'bag (7 oz)',198,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19045,1,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19045,2,1,'can (6 oz)',170,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19046,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19046,2,1,'can (6.75 oz)',198,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19047,1,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19047,2,10,'twists',60,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19048,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19048,2,1,'pretzel',11,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19050,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19050,2,2,'oz',57,'g',1,'2007-11-27','2007-11-27');
INSERT INTO `cndb_wght` VALUES (19051,1,1,'cake',9,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19051,2,2,'cakes',18,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19052,1,1,'cake',9,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19052,2,2,'cakes',18,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19053,1,1,'cake',9,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19053,2,2,'cakes',18,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19056,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19056,2,1,'bag',213,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19057,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19058,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19058,2,1,'bag (7 oz)',198,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19059,1,1,'cup',150,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19059,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19059,3,1.5,'oz',42,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19061,1,1,'cup',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19061,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19061,3,1.5,'oz',42,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19062,1,1,'cup',146,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19062,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19062,3,1.5,'oz',42,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19063,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19063,2,1,'bag (8 oz)',227,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19070,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19070,2,3,'pieces',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19071,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19071,2,1,'bar (3 oz)',87,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19074,1,1,'package (2.5 oz)',71,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19074,2,1,'piece',10.1,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19076,1,1,'piece',6.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19076,2,1,'bar 2.25 oz',64,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19076,3,1,'serving 6 pieces',40,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19077,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19078,1,1,'oz square Bakers',29,'g',1,'1994-11-02','2013-12-26');
INSERT INTO `cndb_wght` VALUES (19078,2,1,'cup, grated',132,'g',1,'2002-09-06','2009-02-11');
INSERT INTO `cndb_wght` VALUES (19078,3,0.5,'oz Hersheys',14.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19079,1,1,'cup chips',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19080,1,1,'serving',14.5,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (19080,2,1,'cup large chips',182,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19080,3,1,'cup mini chips',173,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19080,4,1,'oz (approx 60 pcs)',28.35,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19080,5,1,'cup chips (6 oz package)',168,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19081,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19081,2,1,'bar (1.45 oz)',41,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19083,1,1,'patty, large',43,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19083,2,1,'patty, small',11,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19085,1,1,'cup chips',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19085,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19086,1,1,'cup chips',168,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19086,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19087,1,1,'bar (3 oz)',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19087,2,1,'tbsp',14,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19087,3,1,'cup chips',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19088,1,1,'serving 1/2 cup',76,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19089,1,0.5,'CUP',107,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19090,1,0.5,'cup (4 fl oz)',86,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19094,1,0.5,'cup',153,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19094,2,1,'recipe yield',1531,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19095,1,1,'serving 1/2 cup',66,'g',1,'1994-09-29','2009-02-11');
INSERT INTO `cndb_wght` VALUES (19096,1,1,'serving 1/2 cup',88,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19097,1,0.5,'cup (4 fl oz)',74,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19097,2,1,'bar (2.75 fl oz)',66,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19099,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19100,1,1,'piece',17,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19101,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19102,1,1,'piece',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19103,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19104,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19106,1,1,'cup gumdrops',182,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19106,2,10,'gumdrops',36,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19106,3,10,'gummy bears',22,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19106,4,10,'gummy dinosaurs',63,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19106,5,10,'gummy fish',50,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19106,6,10,'gummy worms',74,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19106,7,1,'spice stick',9.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19106,8,1,'spice drop',24,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19106,9,1,'gumdrop, small (1/2" dia)',3.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19106,10,1,'gumdrop, medium (3/4" dia)',4.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19106,11,1,'gumdrop, large (1" dia)',11.6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19106,12,1,'jelly ring (1-1/4" dia)',10,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19107,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19107,2,1,'piece',6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19107,3,1,'piece, small',3,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19108,1,10,'small',11,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19108,2,10,'large (1 oz)',28,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19113,1,1,'serving 1/4 cup',73,'g',1,'1994-01-31','2016-02-06');
INSERT INTO `cndb_wght` VALUES (19114,1,1,'serving',68,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19114,2,1,'unit',100,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (19116,1,1,'cup of miniature',50,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19116,2,10,'miniatures',7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19116,3,1,'regular',7.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19117,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19120,1,1,'bar, miniature',7,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19120,2,1,'bar (1.55 oz)',44,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19120,3,1,'cup chips',168,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19121,1,0.5,'cup From 19191',147,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19122,1,0.5,'cup From 19211',142,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19123,1,0.5,'cup From 19211',142,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19124,1,1,'tablet',20,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19125,1,1,'serving 2 TBSP',37,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19126,1,1,'cup',149,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19126,2,10,'pieces',40,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19127,2,1,'cup',180,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19127,3,10,'pieces',10,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19128,1,1,'serving 1/4 cup',73,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (19128,2,1,'TBSP',15,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19128,3,1,'oz',28.35,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19128,4,1,'cup',240,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19129,1,1,'CUP',314,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19129,2,1,'TBSP',20,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19132,1,1,'bar (1.45 oz)',41,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19132,2,1,'bar (1.55 oz)',44,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19134,1,1,'bar (1.4 oz)',40,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19134,2,1,'bar (1.45 oz)',45,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19134,3,1,'bar (1.65 oz)',47,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19134,4,1,'bar, miniature',10,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19134,5,1,'bar (1.55 oz)',44,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19137,1,2,'tbsp',42,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (19137,2,1,'serving',40,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (19137,3,1,'cup',340,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19138,1,1,'piece',12,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19138,2,1,'recipe yield, recipe makes 49     1 " x 1"     pieces',612,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19147,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19147,2,1,'bar (1.4 oz)',40,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19147,3,1,'bar (1.6 oz)',45,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19147,4,1,'bar (1.75 fl oz)',50,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19148,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19154,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19154,2,1,'piece',1.8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19154,3,20,'pieces',35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19163,1,1,'stick',3,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19163,2,10,'Chiclets',16,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19163,3,1,'block',8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19165,1,1,'CUP',86,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19165,2,1,'TBSP',5.4,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19166,1,1,'CUP',86,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19166,2,1,'TBSP',5.4,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19168,1,0.5,'cup',141,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19168,2,1,'recipe yield',563,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19169,1,1,'package (3 oz)',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19169,2,1,'portion, amount to make 1/2 cup',21,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19170,1,0.5,'cup',141,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19172,1,1,'package (3 oz)',85,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19172,2,1,'portion, amount to make 1/2 cup',21,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19173,1,0.5,'cup',135,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (19173,2,1,'serving',21,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (19173,3,1,'package 3 oz, yields 2 cups',540,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19175,1,1,'serving',6.4,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19176,1,0.5,'CUP',117,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19176,2,1,'package yield (2 cups)',469,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19177,1,1,'envelope (1 tbsp)',7,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19177,2,1,'package (1 oz)',28,'g',1,'1994-11-17','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19182,1,1,'recipe yield',808,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19182,2,0.5,'cup',202,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19183,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19183,2,1,'container refrigerated, 4 oz',108,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (19183,3,1,'container shelf stable, 3.5 oz',98,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (19184,1,1,'package (3.5 oz)',99,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19184,2,1,'portion, amount to make 1/2 cup',25,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19185,1,0.5,'CUP',147,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19185,2,1,'package yield (2 cups)',587,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19186,1,0.5,'cup',141,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19186,2,1,'recipe yield',844,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19188,1,1,'package (3.5 oz)',99,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19188,2,1,'portion, amount to make 1/2 cup',25,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19189,1,0.5,'CUP',142,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19189,2,1,'package yield (2 cups)',570,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19190,1,0.5,'cup',128,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19191,1,0.5,'CUP',147,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19191,2,1,'package yield (2 cups)',587,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19193,1,1,'serving 4 oz pudding cup',113,'g',1,'1997-08-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (19193,2,1,'oz',28.35,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (19193,3,1,'can (5 oz)',142,'g',1,'2007-11-28','2013-12-26');
INSERT INTO `cndb_wght` VALUES (19193,4,1,'cup',172,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19193,5,0.5,'cup',92,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19195,1,0.5,'cup',128,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19199,1,0.5,'cup',128,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19201,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19201,2,1,'container refrigerated 4 oz',110,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19201,3,1,'container shelf stable 3.5 oz',97,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19202,1,1,'package (3.5 oz)',99,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19202,2,1,'portion, amount to make 1/2 cup',25,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19203,1,0.5,'CUP',142,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19203,2,1,'package yield (2 cups)',569,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19204,1,1,'serving',8,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19204,2,1,'package',32,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19205,1,0.5,'cup',141,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19206,1,1,'package (3.12 oz)',88,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19206,2,1,'portion, amount to make 1/2 cup',22,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19207,1,0.5,'CUP',140,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19207,2,1,'package yield (2 cups)',559,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19208,1,0.5,'cup',128,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19209,1,0.5,'cup',128,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19212,1,0.5,'cup',128,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19213,1,0,'cup',142,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (19214,1,0,'cup',142,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (19216,1,1,'piece',39,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19216,2,1,'recipe yield',907,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19217,1,1,'bar',51,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19218,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19218,2,1,'container refrigerated 4 oz',110,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19218,3,1,'container',97,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (19219,1,0.5,'CUP',140,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19219,2,1,'package yield (2 cups)',559,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19220,1,1,'tbsp',9,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19220,2,1,'package (2 oz)',57,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19221,1,0,'cup',142,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (19225,1,1,'package (0.35 oz)',9.9,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19226,1,2,'tbsp creamy',41,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19227,1,0.083,'package',38,'g',1,'1994-01-31','2016-03-09');
INSERT INTO `cndb_wght` VALUES (19227,2,2,'tbsp',35,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (19227,3,1,'package (16 oz)',462,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19228,1,2,'tbsp creamy',33,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19228,2,2,'tbsp whipped',24,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19230,1,0.083,'package',38,'g',1,'1994-01-31','2016-03-09');
INSERT INTO `cndb_wght` VALUES (19230,2,2,'tbsp creamy',33,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (19230,3,1,'package (16 oz)',462,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19231,1,0,'cup',141,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (19232,1,0,'cup',141,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (19233,1,1,'serving 3.5 oz shelf stable',99,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19234,1,1,'container refrigerated 4 oz',112,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19235,1,1,'serving 4 oz',113,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19241,1,2,'tablespoon',33,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19247,1,1,'package yields',315,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19247,2,0.083,'package',26,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19260,1,1,'serving 1/2 cup',68,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19263,1,1,'bar (2.5 fl oz)',77,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19263,2,1,'bar (3 fl oz)',92,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19265,1,1,'serving 1/2 cup',72,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19268,1,1,'serving 28 pieces',40,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19270,1,1,'individual (3.5 fl oz)',58,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19270,2,0.5,'cup (4 fl oz)',66,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19271,1,1,'individual (3.5 fl oz)',58,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19271,2,0.5,'cup (4 fl oz)',66,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19274,1,1,'serving',21,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19274,2,1,'packet',14.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19279,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19280,1,0.5,'cup (4 fl oz)',99,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19283,1,1,'serving 1.75 fl oz pop',52,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19293,1,0.5,'CUP',72,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19294,1,1,'tbsp',17,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (19294,2,1,'serving',17,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (19294,3,1,'cup',282,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19296,1,1,'CUP',339,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19296,2,1,'TBSP',21,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19296,3,1,'packet (0.5 oz)',14,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19297,1,1,'TBSP',20,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19297,2,1,'packet (0.5 oz)',14,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19300,1,1,'serving 1 tbsp',21,'g',1,'1995-06-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19300,2,1,'packet (0.5 oz)',14,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19301,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19303,1,1,'tbsp',20,'g',1,'1994-09-29','2013-12-26');
INSERT INTO `cndb_wght` VALUES (19303,2,1,'package (0.5 oz)',14,'g',1,'1999-03-22','2013-12-26');
INSERT INTO `cndb_wght` VALUES (19303,3,1,'serving',20,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (19303,4,1,'cup',320,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19304,1,1,'CUP',337,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19304,2,1,'serving 1 tbsp',20,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19310,1,1,'package (1.75 oz)',50,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19312,1,0.125,'can',74,'g',1,'1994-01-31','2016-03-09');
INSERT INTO `cndb_wght` VALUES (19312,2,1,'serving',85,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (19312,3,1,'can (21 oz)',595,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19314,1,0.125,'can',74,'g',1,'1999-03-22','2016-03-09');
INSERT INTO `cndb_wght` VALUES (19314,2,1,'can (21 oz)',595,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (19318,1,1,'package (3.5 oz)',99,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19318,2,1,'portion, amount to make 1/2 cup',25,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19319,1,0.5,'cup',127,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19320,1,1,'package (3.12 oz)',88,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19320,2,1,'portion, amount to make 1/2 cup',22,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19321,1,0.5,'cup',127,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19322,1,1,'package (3.5 oz)',99,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19322,2,1,'portion, amount to make 1/2 cup',25,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19323,1,0.5,'CUP',147,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19323,2,1,'package yield (2 cups)',587,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19324,1,1,'package (3.12 oz)',88,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19324,2,1,'portion, amount to make 1/2 cup',25,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19325,1,0.5,'CUP',140,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19325,2,1,'package yield (2 cups)',559,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19330,1,1,'package (3.5 oz)',99,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19330,2,1,'portion, amount to make 1/2 cup',25,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19331,1,0.5,'CUP',147,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19331,2,1,'package yield (2 cups)',587,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19333,1,0.5,'cup',127,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19334,1,1,'tsp unpacked',3,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (19334,2,1,'cup packed',220,'g',1,'1998-01-15','2013-12-26');
INSERT INTO `cndb_wght` VALUES (19334,3,1,'cup unpacked',145,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (19334,4,1,'tsp packed',4.6,'g',1,'2002-09-06','2009-02-11');
INSERT INTO `cndb_wght` VALUES (19334,5,1,'tsp brownulated',3.2,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (19335,1,1,'serving packet',2.8,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19335,2,1,'tsp',4.2,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19335,3,1,'CUP',200,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19335,4,1,'serving 1 cube',2.3,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19336,1,1,'cup unsifted',120,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19336,2,1,'cup sifted',100,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (19336,3,1,'tbsp unsifted',8,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19336,4,1,'tsp',2.5,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19340,1,1,'tsp',3,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19340,2,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19340,3,1,'piece (1-3/4" x 1-1/4" x 1/2")',28,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19348,1,1,'CUP',304,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19348,2,2,'TBSP',38,'g',1,'1999-02-12','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19349,1,1,'CUP',328,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19349,2,1,'TBSP',20,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19350,1,1,'CUP',341,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19350,2,1,'tbsp',22,'g',1,'2002-09-06','2009-02-11');
INSERT INTO `cndb_wght` VALUES (19351,1,1,'CUP',310,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19351,2,1,'TBSP',19,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19352,1,1,'cup',332,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19352,2,1,'tbsp',21,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19353,1,1,'tbsp',20,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19353,2,1,'serving 1/4 cup',83,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (19353,3,1,'cup',315,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19355,1,1,'cup',330,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19355,2,1,'tbsp',21,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19360,1,1,'tbsp',20,'g',1,'1994-01-31','2013-12-26');
INSERT INTO `cndb_wght` VALUES (19360,2,1,'serving 1/4 cup',83,'g',1,'2002-09-06','2013-12-26');
INSERT INTO `cndb_wght` VALUES (19360,3,1,'cup',315,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19362,1,1,'CUP',316,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19362,2,1,'TBSP',20,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19364,1,2,'TBSP',41,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19365,1,1,'oz',28.35,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19365,2,1,'jar',198,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19366,1,1,'CUP',340,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19366,2,2,'TBSP',42,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19367,1,1,'CUP',328,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19367,2,2,'TBSP',41,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19371,1,2,'tablespoon',33,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19372,1,2,'tablespoon',33,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19375,1,1,'recipe yield',327,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19379,1,1,'piece',20,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19379,2,1,'recipe yield (60 pieces)',1229,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19382,1,1,'piece',15,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19383,1,1,'piece',12,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19384,1,1,'piece',11,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19387,1,0.5,'cup (4 fl oz)',99,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19393,1,0.5,'cup (4 fl oz)',72,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19400,1,1,'oz',28.35,'g',1,'1995-06-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19400,2,3,'oz',85,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (19400,3,1.5,'oz',42,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (19401,1,1,'oz',28.35,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19401,2,2,'oz',57,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (19403,1,1,'bar (1 oz)',28,'g',1,'2012-03-02','2012-03-02');
INSERT INTO `cndb_wght` VALUES (19404,1,1,'bar (1.5 oz)',43,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19404,2,1,'bar (1 oz)',28,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19405,1,1,'bar (1 oz)',28,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19406,1,1,'bar (1 oz)',28,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19407,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19407,2,1,'stick',20,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19408,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19408,2,0.5,'oz',14.2,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19410,1,1,'oz',28,'g',1,'2015-01-06','2015-06-19');
INSERT INTO `cndb_wght` VALUES (19410,2,16,'chips',26,'g',1,'1994-09-29','2015-01-07');
INSERT INTO `cndb_wght` VALUES (19410,3,1,'oz',28.35,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (19410,4,1,'can (7 oz)',198,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (19411,1,1,'oz',28,'g',1,'2015-01-06','2015-06-19');
INSERT INTO `cndb_wght` VALUES (19411,2,22,'chips',28,'g',1,'1994-09-29','2015-01-07');
INSERT INTO `cndb_wght` VALUES (19411,3,1,'oz',28.35,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (19411,4,1,'bag (8 oz)',227,'g',1,'2015-01-06','2015-01-06');
INSERT INTO `cndb_wght` VALUES (19412,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19412,2,1,'can (6.25 oz)',191,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19413,1,1,'cake',9,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19413,2,2,'cakes',18,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19414,1,1,'cake',9,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19414,2,2,'cakes',18,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19415,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19415,2,0.5,'cup',18,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19416,1,1,'cake',9,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19416,2,2,'cakes',18,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19418,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19418,2,2,'oz',57,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19419,1,1,'cake',9,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (19419,2,2,'cakes',18,'g',1,'2010-01-04','2010-01-04');
INSERT INTO `cndb_wght` VALUES (19420,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19420,2,1,'bar',24,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19421,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19421,2,1,'bag (6 oz)',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19422,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19422,2,1,'bag (6 oz)',170,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19423,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19424,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19424,2,1,'bag (6 oz)',170,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19433,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19434,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19436,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19437,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19437,2,1,'bag (8 oz)',227,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19444,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19445,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19524,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19524,2,10,'chips',23,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19701,1,1,'cup chips (6 oz package)',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19701,2,1,'cup large chips',182,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19701,3,1,'cup mini chips',173,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19701,4,1,'oz (approx 60 pcs)',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19702,1,1,'package (3 oz)',85,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19702,2,1,'portion, amount to make 1/2 cup',21,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19703,1,1,'TBSP',9,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19703,2,1,'package (0.35 oz)',10,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19703,3,1,'portion, amount to make 1/2 cup',2.5,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19704,1,1,'TBSP',9,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19704,2,1,'package (0.35 oz)',10,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19704,3,1,'portion, amount to make 1/2 cup',2.5,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19705,1,1,'package (3.5 oz)',99,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19705,2,1,'portion, amount to make 1/2 cup',25,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19706,1,1,'package (3.12 oz)',88,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19706,2,1,'portion, amount to make 1/2 cup',22,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19708,1,1,'package (3 oz)',85,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19708,2,1,'portion, amount to make 1/2 cup',21,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19710,1,1,'package (3.12 oz)',88,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19710,2,1,'portion, amount to make 1/2 cup',22,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19719,1,1,'TBSP',20,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19719,2,1,'packet (0.5 oz)',14,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19720,1,1,'CUP',315,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19720,2,1,'TBSP',20,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19800,1,1,'cake',9,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19800,2,2,'cakes',18,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19802,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19802,2,1,'bag (8 oz)',227,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19804,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19806,1,1,'CUP',8,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19806,2,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19807,1,1,'CUP',11,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19807,2,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19809,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19809,2,1,'bag (8 oz)',227,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19810,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19810,2,1,'bag (8 oz)',227,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19811,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19811,2,1,'bag (8 oz)',227,'g',1,'1995-06-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19812,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19812,2,10,'twists',60,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19813,1,1,'oz',28.35,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19813,2,10,'twists',60,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19814,1,1,'oz',28.35,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19814,2,10,'twists',60,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (19816,1,1,'cake',9,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19816,2,2,'cakes',18,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19817,1,1,'cake',9,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19817,2,2,'cakes',18,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19818,1,1,'cake',9,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19818,2,2,'cakes',18,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19819,1,1,'cake',9,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19819,2,2,'cakes',18,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19820,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19820,2,2,'oz',57,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19821,1,1,'cup',150,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19821,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19821,3,1.5,'oz',42,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19822,1,1,'cup',146,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19822,2,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19822,3,1.5,'oz',42,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19823,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19833,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19857,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19858,1,1,'piece',3.5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19860,1,1,'tablespoon Ghirardelli label 2011',6,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19860,2,1,'tablespoon Hershey''s label 2011',5,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19860,3,1,'container Ghirardelli label 2011',283,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19866,1,3,'pieces',42,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19867,1,0.5,'cup',67,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19898,1,1,'individual (3.5 fl oz)',58,'g',1,'2007-12-03','2007-12-03');
INSERT INTO `cndb_wght` VALUES (19898,2,0.5,'cup (4 fl oz)',66,'g',1,'2007-12-03','2007-12-03');
INSERT INTO `cndb_wght` VALUES (19899,1,1,'individual (3.5 fl oz)',58,'g',1,'2007-12-03','2007-12-03');
INSERT INTO `cndb_wght` VALUES (19902,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19902,2,1,'bar',162,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19903,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19903,2,1,'bar',112,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19904,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19904,2,1,'bar',101,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19905,1,1,'oz',28.35,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19905,2,1,'bar',127,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19910,1,1,'serving 1.5 oz',42,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19912,1,1,'tsp',6.9,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (19912,2,0.25,'cup',55,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (19918,1,1,'package',1,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19919,1,1,'serving',44,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (19920,1,1,'tablespoon',19,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (19921,1,1,'serving',14,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (19922,1,1,'bar',47,'g',1,'2019-02-13','2019-02-13');
INSERT INTO `cndb_wght` VALUES (20001,1,1,'cup',193,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20003,1,1,'cup',128,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20004,1,1,'CUP',184,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20005,1,1,'CUP',200,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20006,1,1,'CUP',157,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20008,1,1,'CUP',170,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20009,1,1,'cup',164,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20010,1,1,'cup',168,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20011,1,1,'CUP',120,'g',1,'2007-11-28','2007-11-28');
INSERT INTO `cndb_wght` VALUES (20012,1,1,'CUP',140,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20013,1,1,'CUP',182,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20013,2,1,'TBSP',8.4,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20014,1,1,'cup',166,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20015,1,1,'cup',76,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20016,1,1,'CUP',117,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20017,1,1,'CUP',114,'g',1,'1998-01-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20018,1,1,'CUP',126,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20019,1,1,'cup',114,'g',1,'2011-01-18','2011-01-18');
INSERT INTO `cndb_wght` VALUES (20020,1,1,'CUP',122,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20022,1,1,'cup',157,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20023,1,1,'CUP',122,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20024,1,1,'CUP',170,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20025,1,1,'CUP',138,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20027,1,1,'CUP',128,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20028,1,1,'CUP',173,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20029,1,1,'cup, cooked',157,'g',1,'1995-06-19','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20029,2,1,'cup, dry, yields',528,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20029,3,1,'oz, dry, yields',86,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20030,1,1,'CUP',165,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20031,1,1,'cup',200,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20032,1,1,'cup',174,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20033,1,1,'CUP',94,'g',1,'1994-09-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20034,1,1,'CUP',219,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20035,1,1,'cup',170,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20036,1,1,'CUP',185,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20037,1,1,'CUP',202,'g',1,'1994-01-31','2016-03-09');
INSERT INTO `cndb_wght` VALUES (20038,1,1,'CUP',156,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20040,1,1,'CUP',190,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20041,1,1,'CUP',195,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20044,1,1,'CUP',185,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20045,1,1,'CUP',158,'g',1,'2004-07-15','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20046,1,1,'cup',185,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20047,1,1,'CUP',158,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20048,1,1,'CUP',95,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20049,1,1,'CUP',165,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20050,1,1,'CUP',195,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20051,1,1,'CUP',186,'g',1,'1994-11-17','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20052,1,1,'cup',200,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20053,1,1,'cup',186,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20054,1,1,'cup',185,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20055,1,1,'cup',174,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20060,1,1,'cup',118,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20061,1,1,'cup',158,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20062,1,1,'cup',169,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20063,1,1,'cup',128,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20064,1,1,'cup',102,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20065,1,1,'cup',102,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20066,1,1,'CUP',167,'g',1,'1996-09-30','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20067,1,1,'cup',192,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20068,1,1,'CUP',152,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20069,1,1,'cup',192,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20070,1,1,'cup',130,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20071,1,1,'cup',192,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20072,1,1,'cup',192,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20073,1,1,'cup',168,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20074,1,1,'cup',192,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20075,1,1,'cup',168,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20076,1,1,'cup',192,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20077,1,1,'cup',58,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20078,1,1,'CUP',115,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20080,1,1,'CUP',120,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20081,1,1,'CUP',125,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20082,1,1,'CUP',125,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20083,1,1,'CUP',137,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20084,1,1,'cup unsifted, dipped',137,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20086,1,1,'cup',111,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20087,1,1,'cup',108,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20088,1,1,'CUP',160,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20089,1,1,'CUP',164,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20090,1,1,'cup',158,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20091,1,1,'cup',105,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20091,2,2,'oz',57,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20092,1,1,'cup',140,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20093,1,4.5,'oz',128,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20094,1,2,'oz',128,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20095,1,4.5,'oz',128,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20096,1,2,'oz',57,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20097,1,2,'oz',57,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20098,1,2,'oz',57,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20105,1,1,'cup spiral shaped',84,'g',1,'1998-03-27','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20105,2,2,'oz',57,'g',1,'2002-09-06','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20106,1,1,'cup spiral shaped',134,'g',1,'1998-03-27','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20109,1,1,'CUP',38,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20109,2,2,'oz',57,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20110,1,1,'CUP',160,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20111,1,1,'CUP',38,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20111,2,2,'oz',57,'g',1,'1997-08-29','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20112,1,1,'CUP',160,'g',1,'1994-01-31','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20113,1,0.5,'cup dry',28,'g',1,'1994-01-31','2015-01-07');
INSERT INTO `cndb_wght` VALUES (20113,2,1.5,'oz',43,'g',1,'1999-03-22','2006-11-30');
INSERT INTO `cndb_wght` VALUES (20114,1,2,'oz',57,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20115,1,1,'cup',114,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20116,1,2,'oz',57,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20117,1,1,'cup',176,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20118,1,1,'cup',45,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (20120,1,1,'cup spaghetti',91,'g',1,'1999-03-22','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20120,2,2,'oz',57,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20120,3,1,'cup elbows',122,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20120,4,1,'cup penne',95,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20120,5,1,'cup farfalle',81,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20120,6,1,'cup rotini',96,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20120,7,1,'cup shells',64,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20120,8,1,'cup lasagna',90,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20121,1,1,'cup spaghetti not packed',124,'g',1,'1994-01-31','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20121,2,1,'cup spaghetti packed',151,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20121,3,1,'cup elbows not packed',120,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20121,4,1,'cup elbows packed',132,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20121,5,1,'cup penne',107,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20121,6,1,'cup farfalle',107,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20121,7,1,'cup rotini',107,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20121,8,1,'cup shells',105,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20121,9,1,'cup lasagne',116,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20124,1,1,'cup spaghetti',91,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20124,2,1,'cup elbows',122,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20124,3,1,'cup penne',95,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20124,4,1,'cup farfalle',81,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20124,5,1,'cup rotini',96,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20124,6,1,'cup shells',64,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20124,7,1,'cup lasagne',90,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20125,1,1,'cup spaghetti not packed',117,'g',1,'2013-12-23','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20125,2,1,'cup spaghetti packed',151,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20125,3,1,'cup elbows',117,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20125,4,1,'cup penne',97,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20125,5,1,'cup shells',105,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20125,6,1,'cup lasagne',116,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20125,7,1,'cup rotini',107,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20125,8,1,'cup farfalle',107,'g',1,'2016-02-06','2016-02-06');
INSERT INTO `cndb_wght` VALUES (20126,1,2,'oz',57,'g',1,'2013-12-23','2013-12-23');
INSERT INTO `cndb_wght` VALUES (2